/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public abstract class RefinementStrategy {
    private final StatInt differentNontrivialInterpolants = new StatInt(StatKind.SUM, "Different non-trivial interpolants along paths");
    private final StatInt equalNontrivialInterpolants = new StatInt(StatKind.SUM, "Equal non-trivial interpolants along paths");
    private final StatInt truePathPrefixStates = new StatInt(StatKind.SUM, "Length (states) of path with itp 'true'");
    private final StatInt nonTrivialPathStates = new StatInt(StatKind.SUM, "Length (states) of path with itp non-trivial itp");
    private final StatInt falsePathSuffixStates = new StatInt(StatKind.SUM, "Length (states) of path with itp 'false'");
    private final StatInt equalPrecisionsOnPaths = new StatInt(StatKind.SUM, "Equal precisions along paths");
    private final StatInt differentPrecisionsOnPaths = new StatInt(StatKind.SUM, "Different precisions along paths");
    private final StatInt numberOfAffectedStates = new StatInt(StatKind.SUM, "Number of affected states");
    private final StatInt totalPathLengthToInfeasibility = new StatInt(StatKind.AVG, "Length of refined path (in blocks)");
    protected AbstractStatistics basicRefinementStatistics = new AbstractStatistics(){

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            StatisticsWriter.writingStatisticsTo(out).put(RefinementStrategy.this.totalPathLengthToInfeasibility).put(RefinementStrategy.this.numberOfAffectedStates).put(RefinementStrategy.this.truePathPrefixStates).put(RefinementStrategy.this.nonTrivialPathStates).put(RefinementStrategy.this.falsePathSuffixStates).put(RefinementStrategy.this.differentNontrivialInterpolants).put(RefinementStrategy.this.equalNontrivialInterpolants).put(RefinementStrategy.this.differentPrecisionsOnPaths).put(RefinementStrategy.this.equalPrecisionsOnPaths);
        }
    };
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;

    public RefinementStrategy(Solver pSolver) {
        this.solver = pSolver;
        this.bfmgr = this.solver.getFormulaManager().getBooleanFormulaManager();
    }

    public boolean needsInterpolants() {
        return true;
    }

    protected void analyzePathPrecisions(ARGReachedSet argReached, List<ARGState> path) {
        int equalPrecisions = 0;
        int differentPrecisions = 0;
        UnmodifiableReachedSet reached = argReached.asReachedSet();
        PredicatePrecision lastPaPrec = null;
        for (ARGState state : path) {
            Precision prec = reached.getPrecision(state);
            PredicatePrecision paPrec = Precisions.extractPrecisionByType(prec, PredicatePrecision.class);
            if (lastPaPrec != null) {
                if (lastPaPrec.equals(paPrec)) {
                    ++equalPrecisions;
                } else {
                    ++differentPrecisions;
                }
            }
            lastPaPrec = paPrec;
        }
        this.equalPrecisionsOnPaths.setNextValue(equalPrecisions);
        this.differentPrecisionsOnPaths.setNextValue(differentPrecisions);
    }

    public void performRefinement(ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        this.startRefinementOfPath();
        ARGState lastElement = abstractionStatesTrace.get(abstractionStatesTrace.size() - 1);
        assert (lastElement.isTarget());
        abstractionStatesTrace = abstractionStatesTrace.subList(0, abstractionStatesTrace.size() - 1);
        assert (pInterpolants.size() == abstractionStatesTrace.size());
        ArrayList<ARGState> changedElements = new ArrayList<ARGState>();
        ARGState infeasiblePartOfART = lastElement;
        boolean previousItpWasTrue = true;
        int truePrefixStates = 0;
        int nonTrivialStates = 0;
        int falseSuffixStates = 0;
        int differentNontrivialItps = 0;
        int equalNontrivialItps = 0;
        int pathLengthToInfeasibility = 0;
        BooleanFormula lastItp = null;
        for (Pair interpolationPoint : Pair.zipList(pInterpolants, abstractionStatesTrace)) {
            ++pathLengthToInfeasibility;
            BooleanFormula itp = (BooleanFormula)interpolationPoint.getFirst();
            ARGState w = (ARGState)interpolationPoint.getSecond();
            if (this.bfmgr.isTrue(itp)) {
                ++truePrefixStates;
                previousItpWasTrue = true;
                continue;
            }
            if (this.bfmgr.isFalse(itp)) {
                ++falseSuffixStates;
                infeasiblePartOfART = w;
                if (!previousItpWasTrue) break;
                PredicateAbstractState s = PredicateAbstractState.getPredicateState(w);
                BooleanFormula blockFormula = s.getAbstractionFormula().getBlockFormula().getFormula();
                this.solver.addUnsatisfiableFormulaToCache(blockFormula);
                break;
            }
            if (lastItp != null) {
                if (lastItp.equals(itp)) {
                    ++equalNontrivialItps;
                } else {
                    ++differentNontrivialItps;
                }
            }
            lastItp = itp;
            ++nonTrivialStates;
            previousItpWasTrue = false;
            if (this.performRefinementForState(itp, w)) continue;
            changedElements.add(w);
        }
        this.numberOfAffectedStates.setNextValue(changedElements.size());
        if (infeasiblePartOfART == lastElement) {
            ++pathLengthToInfeasibility;
            if (changedElements.isEmpty()) {
                throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null);
            }
        }
        this.finishRefinementOfPath(infeasiblePartOfART, changedElements, pReached, pRepeatedCounterexample);
        this.truePathPrefixStates.setNextValue(truePrefixStates);
        this.nonTrivialPathStates.setNextValue(nonTrivialStates);
        this.falsePathSuffixStates.setNextValue(falseSuffixStates);
        this.differentNontrivialInterpolants.setNextValue(differentNontrivialItps);
        this.equalNontrivialInterpolants.setNextValue(equalNontrivialItps);
        this.totalPathLengthToInfeasibility.setNextValue(pathLengthToInfeasibility);
        assert (!pReached.asReachedSet().contains(lastElement));
    }

    protected abstract void startRefinementOfPath();

    protected abstract boolean performRefinementForState(BooleanFormula var1, ARGState var2) throws InterruptedException, SolverException;

    protected abstract void finishRefinementOfPath(ARGState var1, List<ARGState> var2, ARGReachedSet var3, boolean var4) throws CPAException, InterruptedException;

    public abstract Statistics getStatistics();
}

