/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.counterexamples;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.counterexamples.AbstractNegatedPathCounterexampleFilter;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;

public class InterpolantPredicatesCounterexampleFilter
extends AbstractNegatedPathCounterexampleFilter<ImmutableSet<AbstractionPredicate>> {
    private final LogManager logger;
    private final Solver solver;
    private final PredicateAbstractionManager predAbsMgr;

    public InterpolantPredicatesCounterexampleFilter(Configuration pConfig, LogManager pLogger, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pCpa);
        this.logger = pLogger;
        PredicateCPA predicateCpa = CPAs.retrieveCPA(pCpa, PredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(InterpolantPredicatesCounterexampleFilter.class.getSimpleName() + " needs a PredicateCPA");
        }
        this.solver = predicateCpa.getSolver();
        this.predAbsMgr = predicateCpa.getPredicateManager();
    }

    @Override
    protected Optional<ImmutableSet<AbstractionPredicate>> getCounterexampleRepresentation(List<BooleanFormula> pFormulas) throws InterruptedException {
        return this.getCounterexampleRepresentation0(pFormulas);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Optional<ImmutableSet<AbstractionPredicate>> getCounterexampleRepresentation0(List<BooleanFormula> formulas) throws InterruptedException {
        try (InterpolatingProverEnvironment<?> itpProver = this.solver.newProverEnvironmentWithInterpolation();){
            ArrayList itpGroupIds = new ArrayList(formulas.size());
            for (BooleanFormula f : formulas) {
                itpGroupIds.add(itpProver.push(f));
            }
            if (!itpProver.isUnsat()) {
                Optional i$ = Optional.absent();
                return i$;
            }
            HashSet<AbstractionPredicate> predicates = new HashSet<AbstractionPredicate>();
            for (int i = 1; i < itpGroupIds.size(); ++i) {
                BooleanFormula itp = itpProver.getInterpolant(itpGroupIds.subList(0, i));
                predicates.addAll(this.predAbsMgr.extractPredicates(itp));
            }
            Optional optional = Optional.of((Object)ImmutableSet.copyOf(predicates));
            return optional;
        }
        catch (SolverException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Interpolation failed on counterexample path, cannot filter this counterexample");
            return Optional.absent();
        }
    }
}

