/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.counterexamples;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.counterexamples.AbstractNegatedPathCounterexampleFilter;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;

public class UnsatCoreCounterexampleFilter
extends AbstractNegatedPathCounterexampleFilter<ImmutableList<BooleanFormula>> {
    private final LogManager logger;
    private final Solver solver;

    public UnsatCoreCounterexampleFilter(Configuration pConfig, LogManager pLogger, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pCpa);
        this.logger = pLogger;
        PredicateCPA predicateCpa = CPAs.retrieveCPA(pCpa, PredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(UnsatCoreCounterexampleFilter.class.getSimpleName() + " needs a PredicateCPA");
        }
        this.solver = predicateCpa.getSolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<ImmutableList<BooleanFormula>> getCounterexampleRepresentation(List<BooleanFormula> formulas) throws InterruptedException {
        try (ProverEnvironment thmProver = this.solver.newProverEnvironmentWithUnsatCoreGeneration();){
            Optional optional;
            for (BooleanFormula f : formulas) {
                thmProver.push(f);
            }
            if (!thmProver.isUnsat()) {
                optional = Optional.absent();
                return optional;
            }
            optional = Optional.of((Object)ImmutableList.copyOf(thmProver.getUnsatCore()));
            return optional;
        }
        catch (SolverException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Solving failed on counterexample path, cannot filter this counterexample");
            return Optional.absent();
        }
    }
}

