/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class LoopInvariantsWriter {
    private final CFA cfa;
    private final LogManager logger;
    private final AbstractionManager absmgr;
    private final FormulaManagerView fmgr;
    private final RegionManager rmgr;

    public LoopInvariantsWriter(CFA pCfa, LogManager pLogger, AbstractionManager pAbsMgr, FormulaManagerView pFmMgr, RegionManager pRegMgr) {
        this.cfa = pCfa;
        this.logger = pLogger;
        this.absmgr = pAbsMgr;
        this.fmgr = pFmMgr;
        this.rmgr = pRegMgr;
    }

    private Map<CFANode, Region> getLoopHeadInvariants(ReachedSet reached) {
        HashMap regions = Maps.newHashMap();
        for (AbstractState state : reached) {
            CFANode loc = AbstractStates.extractLocation(state);
            if (!((ImmutableSet)this.cfa.getAllLoopHeads().get()).contains((Object)loc)) continue;
            PredicateAbstractState predicateState = PredicateAbstractState.getPredicateState(state);
            if (!predicateState.isAbstractionState()) {
                this.logger.log(Level.WARNING, new Object[]{"Cannot dump loop invariants because a non-abstraction state was found for a loop-head location."});
                return null;
            }
            Region region = (Region)MoreObjects.firstNonNull(regions.get(loc), (Object)this.rmgr.makeFalse());
            region = this.rmgr.makeOr(region, predicateState.getAbstractionFormula().asRegion());
            regions.put(loc, region);
        }
        return regions;
    }

    public void exportLoopInvariants(Path invariantsFile, ReachedSet reached) {
        Map<CFANode, Region> regions = this.getLoopHeadInvariants(reached);
        if (regions == null) {
            return;
        }
        try (Writer writer = Files.openOutputFile((Path)invariantsFile, (FileWriteMode[])new FileWriteMode[0]);){
            for (CFANode loc : FluentIterable.from((Iterable)((Iterable)this.cfa.getAllLoopHeads().get())).toSortedSet(CFAUtils.NODE_NUMBER_COMPARATOR)) {
                Region region = (Region)MoreObjects.firstNonNull((Object)regions.get(loc), (Object)this.rmgr.makeFalse());
                BooleanFormula formula = this.absmgr.toConcrete(region);
                writer.append("loop__");
                writer.append(loc.getFunctionName());
                writer.append("__");
                writer.append("" + (loc.getNumLeavingEdges() == 0 ? 0 : loc.getLeavingEdge(0).getLineNumber()));
                writer.append(":\n");
                this.fmgr.dumpFormula(formula).appendTo((Appendable)writer);
                writer.append('\n');
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write loop invariants to file");
        }
    }

    public void exportLoopInvariantsAsPrecision(Path invariantPrecisionsFile, ReachedSet reached) {
        Map<CFANode, Region> regions = this.getLoopHeadInvariants(reached);
        if (regions == null) {
            return;
        }
        HashSet<String> uniqueDefs = new HashSet<String>();
        StringBuilder asserts = new StringBuilder();
        try (Writer writer = Files.openOutputFile((Path)invariantPrecisionsFile, (FileWriteMode[])new FileWriteMode[0]);){
            for (CFANode loc : FluentIterable.from((Iterable)((Iterable)this.cfa.getAllLoopHeads().get())).toSortedSet(CFAUtils.NODE_NUMBER_COMPARATOR)) {
                Region region = (Region)MoreObjects.firstNonNull((Object)regions.get(loc), (Object)this.rmgr.makeFalse());
                BooleanFormula formula = this.absmgr.toConcrete(region);
                Pair<String, List<String>> locInvariant = PredicatePersistenceUtils.splitFormula(this.fmgr, formula);
                for (String def : (List)locInvariant.getSecond()) {
                    if (!uniqueDefs.add(def)) continue;
                    writer.append(def);
                    writer.append("\n");
                }
                asserts.append(loc.getFunctionName());
                asserts.append(" ");
                asserts.append(loc.toString());
                asserts.append(":\n");
                asserts.append((String)locInvariant.getFirst());
                asserts.append("\n\n");
            }
            writer.append("\n");
            writer.append(asserts);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write loop invariants to file");
        }
    }
}

