/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class PredicateAbstractionsStorage {
    private static final Pattern NODE_DECLARATION_PATTERN = Pattern.compile("^[0-9]+[ ]*\\(([0-9]+[,]*)*\\)[ ]*(@[0-9]+)$");
    private final Path abstractionsFile;
    private final FormulaManagerView fmgr;
    protected final LogManager logger;
    private Integer rootAbstractionId = null;
    private ImmutableMap<Integer, AbstractionNode> abstractions = ImmutableMap.of();
    private ImmutableMultimap<Integer, Integer> abstractionTree = ImmutableMultimap.of();
    private Set<Integer> reusedAbstractions = Sets.newTreeSet();

    public PredicateAbstractionsStorage(Path pFile, LogManager pLogger, FormulaManagerView pFmgr) throws PredicatePersistenceUtils.PredicateParsingFailedException, InvalidConfigurationException {
        this.fmgr = pFmgr;
        this.logger = pLogger;
        this.abstractionsFile = pFile;
        if (pFile != null) {
            try {
                Files.checkReadableFile((Path)pFile);
                this.parseAbstractionTree();
            }
            catch (IOException e) {
                throw new PredicatePersistenceUtils.PredicateParsingFailedException(e, "Init", 0);
            }
        }
    }

    private void parseAbstractionTree() throws IOException, PredicatePersistenceUtils.PredicateParsingFailedException {
        LinkedHashMultimap resultTree = LinkedHashMultimap.create();
        TreeMap resultAbstractions = Maps.newTreeMap();
        TreeSet abstractionsWithParents = Sets.newTreeSet();
        String source = this.abstractionsFile.getName();
        try (BufferedReader reader = this.abstractionsFile.asCharSource(StandardCharsets.US_ASCII).openBufferedStream();){
            String currentLine;
            Pair<Integer, String> defParsingResult = PredicatePersistenceUtils.parseCommonDefinitions(reader, this.abstractionsFile.toString());
            int lineNo = (Integer)defParsingResult.getFirst();
            String commonDefinitions = (String)defParsingResult.getSecond();
            int currentAbstractionId = -1;
            Optional currentLocationId = Optional.absent();
            TreeSet currentSuccessors = Sets.newTreeSet();
            AbstractionsParserState parserState = AbstractionsParserState.EXPECT_NODE_DECLARATION;
            while ((currentLine = reader.readLine()) != null) {
                BooleanFormula f;
                ++lineNo;
                if ((currentLine = currentLine.trim()).isEmpty() || currentLine.startsWith("//")) continue;
                if (parserState == AbstractionsParserState.EXPECT_NODE_DECLARATION) {
                    if (!currentLine.endsWith(":")) {
                        throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid abstraction header", source, lineNo);
                    }
                    if ((currentLine = currentLine.substring(0, currentLine.length() - 1).trim()).isEmpty()) {
                        throw new PredicatePersistenceUtils.PredicateParsingFailedException("empty header is not allowed", source, lineNo);
                    }
                    if (!NODE_DECLARATION_PATTERN.matcher(currentLine).matches()) {
                        throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid abstraction header", source, lineNo);
                    }
                    currentLocationId = null;
                    StringTokenizer declarationTokenizer = new StringTokenizer(currentLine, " (,):");
                    currentAbstractionId = Integer.parseInt(declarationTokenizer.nextToken());
                    while (declarationTokenizer.hasMoreTokens()) {
                        String token = declarationTokenizer.nextToken().trim();
                        if (token.length() <= 0) continue;
                        if (token.startsWith("@")) {
                            currentLocationId = Optional.of((Object)Integer.parseInt(token.substring(1)));
                            continue;
                        }
                        int successorId = Integer.parseInt(token);
                        currentSuccessors.add(successorId);
                    }
                    parserState = AbstractionsParserState.EXPECT_NODE_ABSTRACTION;
                    continue;
                }
                if (parserState != AbstractionsParserState.EXPECT_NODE_ABSTRACTION) continue;
                if (!currentLine.startsWith("(assert ") && currentLine.endsWith(")")) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException("unexpected line " + currentLine, source, lineNo);
                }
                try {
                    f = this.fmgr.parse(commonDefinitions + currentLine);
                }
                catch (IllegalArgumentException e) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException(e, "Formula parsing", lineNo);
                }
                AbstractionNode abstractionNode = new AbstractionNode(currentAbstractionId, f, (Optional<Integer>)currentLocationId);
                resultAbstractions.put(currentAbstractionId, abstractionNode);
                resultTree.putAll((Object)currentAbstractionId, (Iterable)currentSuccessors);
                abstractionsWithParents.addAll(currentSuccessors);
                currentAbstractionId = -1;
                currentSuccessors.clear();
                parserState = AbstractionsParserState.EXPECT_NODE_DECLARATION;
            }
        }
        Sets.SetView nodesWithNoParents = Sets.difference(resultAbstractions.keySet(), (Set)abstractionsWithParents);
        assert (nodesWithNoParents.size() <= 1);
        this.rootAbstractionId = !nodesWithNoParents.isEmpty() ? (Integer)nodesWithNoParents.iterator().next() : null;
        this.abstractions = ImmutableMap.copyOf((Map)resultAbstractions);
        this.abstractionTree = ImmutableMultimap.copyOf((Multimap)resultTree);
    }

    public AbstractionNode getAbstractionNode(int abstractionId) {
        return (AbstractionNode)this.abstractions.get((Object)abstractionId);
    }

    public ImmutableMultimap<Integer, Integer> getAbstractionTree() {
        return this.abstractionTree;
    }

    public Integer getRootAbstractionId() {
        return this.rootAbstractionId;
    }

    public Set<AbstractionNode> getSuccessorAbstractions(Integer ofAbstractionWithId) {
        HashSet result = Sets.newHashSet();
        if (this.abstractionTree != null) {
            for (Integer successorId : this.abstractionTree.get((Object)ofAbstractionWithId)) {
                AbstractionNode successor;
                if (successorId == null || (successor = (AbstractionNode)this.abstractions.get((Object)successorId)) == null) continue;
                result.add(successor);
            }
        }
        return result;
    }

    public void markAbstractionBeingReused(Integer abstractionId) {
        Preconditions.checkNotNull((Object)abstractionId);
        this.reusedAbstractions.add(abstractionId);
    }

    public boolean wasAbstractionReused(Integer abstractionId) {
        Preconditions.checkNotNull((Object)abstractionId);
        return this.reusedAbstractions.contains(abstractionId);
    }

    public ImmutableMap<Integer, AbstractionNode> getAbstractions() {
        return this.abstractions;
    }

    private static enum AbstractionsParserState {
        EXPECT_OF_COMMON_DEFINITIONS,
        EXPECT_NODE_DECLARATION,
        EXPECT_NODE_ABSTRACTION;

    }

    public static class AbstractionNode {
        private final int id;
        private final Optional<Integer> locationId;
        private final BooleanFormula formula;

        public AbstractionNode(int pId, BooleanFormula pFormula, Optional<Integer> pLocationId) {
            this.id = pId;
            this.formula = pFormula;
            this.locationId = pLocationId;
        }

        public BooleanFormula getFormula() {
            return this.formula;
        }

        public int getId() {
            return this.id;
        }

        public Optional<Integer> getLocationId() {
            return this.locationId;
        }

        public String toString() {
            return Integer.toString(this.getId());
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

