/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class PredicateAbstractionsWriter {
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private static final Predicate<AbstractState> IS_ABSTRACTION_STATE = new Predicate<AbstractState>(){

        public boolean apply(AbstractState pArg0) {
            PredicateAbstractState e = AbstractStates.extractStateByType(pArg0, PredicateAbstractState.class);
            return e.isAbstractionState();
        }
    };

    public PredicateAbstractionsWriter(LogManager pLogger, FormulaManagerView pFmMgr) {
        this.logger = pLogger;
        this.fmgr = pFmMgr;
    }

    private int getAbstractionId(ARGState state) {
        PredicateAbstractState paState = AbstractStates.extractStateByType(state, PredicateAbstractState.class);
        return paState.getAbstractionFormula().getId();
    }

    public void writeAbstractions(Path abstractionsFile, ReachedSet reached) {
        LinkedHashSet definitions = Sets.newLinkedHashSet();
        HashMap stateToAssert = Maps.newHashMap();
        ARGState rootState = AbstractStates.extractStateByType(reached.getFirstState(), ARGState.class);
        SetMultimap<ARGState, ARGState> successors = ARGUtils.projectARG(rootState, ARGUtils.CHILDREN_OF_STATE, IS_ABSTRACTION_STATE);
        HashSet done = Sets.newHashSet();
        ArrayDeque worklist = Queues.newArrayDeque();
        worklist.add(rootState);
        try (Writer writer = Files.openOutputFile((Path)abstractionsFile, (FileWriteMode[])new FileWriteMode[0]);){
            while (!worklist.isEmpty()) {
                ARGState state = (ARGState)worklist.pop();
                if (done.contains(state)) continue;
                for (ARGState successor : successors.get((Object)state)) {
                    worklist.add(successor);
                }
                PredicateAbstractState predicateState = (PredicateAbstractState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(state, PredicateAbstractState.class));
                BooleanFormula formula = predicateState.getAbstractionFormula().asFormula();
                Pair<String, List<String>> p = PredicatePersistenceUtils.splitFormula(this.fmgr, formula);
                String formulaString = (String)p.getFirst();
                definitions.addAll((Collection)p.getSecond());
                stateToAssert.put(state, formulaString);
                done.add(state);
            }
            PredicatePersistenceUtils.LINE_JOINER.appendTo((Appendable)writer, (Iterable)definitions);
            writer.append("\n\n");
            for (Map.Entry entry : stateToAssert.entrySet()) {
                ARGState state = (ARGState)entry.getKey();
                StringBuilder stateSuccessorsSb = new StringBuilder();
                for (ARGState successor : successors.get((Object)state)) {
                    if (stateSuccessorsSb.length() > 0) {
                        stateSuccessorsSb.append(",");
                    }
                    stateSuccessorsSb.append(this.getAbstractionId(successor));
                }
                writer.append(String.format("%d (%s) @%d:", this.getAbstractionId(state), stateSuccessorsSb.toString(), AbstractStates.extractLocation(state).getNodeNumber()));
                writer.append("\n");
                writer.append((CharSequence)entry.getValue());
                writer.append("\n\n");
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write abstractions to file");
        }
    }
}

