/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="cpa.predicate.abstraction.initialPredicates")
public class PredicateMapParser {
    private static final String FUNCTION_NAME_REGEX = "([_a-zA-Z][_a-zA-Z0-9]*)";
    private static final String CFA_NODE_REGEX = "N([0-9][0-9]*)";
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("^([_a-zA-Z][_a-zA-Z0-9]*)$");
    private static final Pattern CFA_NODE_PATTERN = Pattern.compile("^([_a-zA-Z][_a-zA-Z0-9]*) N([0-9][0-9]*)$");
    @Option(secure=true, description="Apply location-specific predicates to all locations in their function")
    private boolean applyFunctionWide = false;
    @Option(secure=true, description="Apply location- and function-specific predicates globally (to all locations in the program)")
    private boolean applyGlobally = false;
    private final CFA cfa;
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private final AbstractionManager amgr;
    private final Map<Integer, CFANode> idToNodeMap = Maps.newHashMap();

    public PredicateMapParser(Configuration config, CFA pCfa, LogManager pLogger, FormulaManagerView pFmgr, AbstractionManager pAmgr) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cfa = pCfa;
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.amgr = pAmgr;
    }

    public PredicatePrecision parsePredicates(Path file) throws IOException, PredicatePersistenceUtils.PredicateParsingFailedException {
        Files.checkReadableFile((Path)file);
        try (BufferedReader reader = file.asCharSource(StandardCharsets.US_ASCII).openBufferedStream();){
            PredicatePrecision predicatePrecision = this.parsePredicates(reader, file.getName());
            return predicatePrecision;
        }
    }

    PredicatePrecision parsePredicates(BufferedReader reader, String source) throws IOException, PredicatePersistenceUtils.PredicateParsingFailedException {
        String currentLine;
        Pair<Integer, String> defParsingResult = PredicatePersistenceUtils.parseCommonDefinitions(reader, source);
        int lineNo = (Integer)defParsingResult.getFirst();
        String commonDefinitions = (String)defParsingResult.getSecond();
        HashSet globalPredicates = Sets.newHashSet();
        HashMultimap functionPredicates = HashMultimap.create();
        HashMultimap localPredicates = HashMultimap.create();
        HashSet currentSet = null;
        while ((currentLine = reader.readLine()) != null) {
            ++lineNo;
            if ((currentLine = currentLine.trim()).isEmpty()) {
                currentSet = null;
                continue;
            }
            if (currentLine.startsWith("//")) continue;
            if (currentSet == null) {
                if (!currentLine.endsWith(":")) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid section header", source, lineNo);
                }
                if ((currentLine = currentLine.substring(0, currentLine.length() - 1).trim()).isEmpty()) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException("empty key is not allowed", source, lineNo);
                }
                if (currentLine.equals("*") || this.applyGlobally) {
                    currentSet = globalPredicates;
                    continue;
                }
                if (FUNCTION_NAME_PATTERN.matcher(currentLine).matches()) {
                    if (!this.cfa.getAllFunctionNames().contains(currentLine)) {
                        this.logger.log(Level.WARNING, new Object[]{"Cannot use predicates for function", currentLine + ", this function does not exist."});
                        currentSet = new HashSet();
                        continue;
                    }
                    currentSet = functionPredicates.get((Object)currentLine);
                    continue;
                }
                Matcher matcher = CFA_NODE_PATTERN.matcher(currentLine);
                if (matcher.matches()) {
                    String function = matcher.group(1);
                    int nodeId = Integer.parseInt(matcher.group(2));
                    if (this.applyFunctionWide) {
                        if (!this.cfa.getAllFunctionNames().contains(function)) {
                            this.logger.log(Level.WARNING, new Object[]{"Cannot use predicates for function", function + ", this function does not exist."});
                            currentSet = new HashSet();
                            continue;
                        }
                        currentSet = functionPredicates.get((Object)function);
                        continue;
                    }
                    CFANode node = this.getCFANodeWithId(nodeId);
                    if (node == null) {
                        this.logger.log(Level.WARNING, new Object[]{"Cannot use predicates for CFANode", nodeId + ", this node does not exist."});
                        currentSet = new HashSet();
                        continue;
                    }
                    currentSet = localPredicates.get((Object)node);
                    continue;
                }
                throw new PredicatePersistenceUtils.PredicateParsingFailedException(currentLine + " is not a valid key", source, lineNo);
            }
            if (currentLine.startsWith("(assert ") && currentLine.endsWith(")")) {
                BooleanFormula f;
                try {
                    f = this.fmgr.parse(commonDefinitions + currentLine);
                }
                catch (IllegalArgumentException e) {
                    throw new PredicatePersistenceUtils.PredicateParsingFailedException(e, source, lineNo);
                }
                currentSet.add(this.amgr.makePredicate(f));
                continue;
            }
            throw new PredicatePersistenceUtils.PredicateParsingFailedException("unexpected line " + currentLine, source, lineNo);
        }
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)localPredicates, (Multimap<String, AbstractionPredicate>)functionPredicates, globalPredicates);
    }

    private CFANode getCFANodeWithId(int id) {
        if (this.idToNodeMap.isEmpty()) {
            for (CFANode n : this.cfa.getAllNodes()) {
                this.idToNodeMap.put(n.getNodeNumber(), n);
            }
        }
        return this.idToNodeMap.get(id);
    }
}

