/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="cpa.predicate")
public class PredicateMapWriter {
    @Option(secure=true, name="predmap.predicateFormat", description="Format for exporting predicates from precisions.")
    private PredicatePersistenceUtils.PredicateDumpFormat format = PredicatePersistenceUtils.PredicateDumpFormat.SMTLIB2;
    private final FormulaManagerView fmgr;

    public PredicateMapWriter(Configuration config, FormulaManagerView pFmgr) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.fmgr = pFmgr;
    }

    public void writePredicateMap(SetMultimap<Pair<CFANode, Integer>, AbstractionPredicate> locationInstancePredicates, SetMultimap<CFANode, AbstractionPredicate> localPredicates, SetMultimap<String, AbstractionPredicate> functionPredicates, Set<AbstractionPredicate> globalPredicates, Collection<AbstractionPredicate> allPredicates, Appendable sb) throws IOException {
        LinkedHashSet definitions = Sets.newLinkedHashSet();
        HashMap predToString = Maps.newHashMap();
        for (AbstractionPredicate abstractionPredicate : allPredicates) {
            String predString;
            if (this.format == PredicatePersistenceUtils.PredicateDumpFormat.SMTLIB2) {
                Pair<String, List<String>> p = PredicatePersistenceUtils.splitFormula(this.fmgr, abstractionPredicate.getSymbolicAtom());
                predString = (String)p.getFirst();
                definitions.addAll((Collection)p.getSecond());
            } else {
                predString = abstractionPredicate.getSymbolicAtom().toString();
            }
            predToString.put(abstractionPredicate, predString);
        }
        PredicatePersistenceUtils.LINE_JOINER.appendTo(sb, (Iterable)definitions);
        sb.append("\n\n");
        this.writeSetOfPredicates(sb, "*", globalPredicates, predToString);
        for (Map.Entry entry : functionPredicates.asMap().entrySet()) {
            this.writeSetOfPredicates(sb, (String)entry.getKey(), (Collection)entry.getValue(), predToString);
        }
        for (Map.Entry entry : localPredicates.asMap().entrySet()) {
            String key = ((CFANode)entry.getKey()).getFunctionName() + " " + ((CFANode)entry.getKey()).toString();
            this.writeSetOfPredicates(sb, key, (Collection)entry.getValue(), predToString);
        }
        for (Map.Entry entry : locationInstancePredicates.asMap().entrySet()) {
            CFANode loc = (CFANode)((Pair)entry.getKey()).getFirst();
            String key = loc.getFunctionName() + " " + loc.toString() + "@" + ((Pair)entry.getKey()).getSecond();
            this.writeSetOfPredicates(sb, key, (Collection)entry.getValue(), predToString);
        }
    }

    private void writeSetOfPredicates(Appendable sb, String key, Collection<AbstractionPredicate> predicates, Map<AbstractionPredicate, String> predToString) throws IOException {
        if (!predicates.isEmpty()) {
            sb.append(key);
            sb.append(":\n");
            for (AbstractionPredicate pred : predicates) {
                sb.append((CharSequence)Preconditions.checkNotNull((Object)predToString.get(pred)));
                sb.append('\n');
            }
            sb.append('\n');
        }
    }
}

