/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class PredicatePersistenceUtils {
    public static final Splitter LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();
    public static final Joiner LINE_JOINER = Joiner.on((char)'\n');

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<String, List<String>> splitFormula(FormulaManagerView fmgr, BooleanFormula f) {
        String formulaString;
        StringBuilder fullString = new StringBuilder();
        Appenders.appendTo((StringBuilder)fullString, (Appender)fmgr.dumpFormula(f));
        List lines = LINE_SPLITTER.splitToList((CharSequence)fullString);
        if (lines.isEmpty()) {
            if (!fmgr.getBooleanFormulaManager().isTrue(f)) throw new AssertionError();
            List list = Collections.emptyList();
            formulaString = "(assert true)";
        } else {
            List list = lines.subList(0, lines.size() - 1);
            formulaString = (String)Iterables.getLast((Iterable)lines);
        }
        if ($assertionsDisabled || formulaString.startsWith("(assert ") && formulaString.endsWith(")")) void var5_6;
        return Pair.of((Object)formulaString, (Object)var5_6);
        throw new AssertionError((Object)("Unexpected formula format: " + formulaString));
    }

    static void writeSetOfPredicates(Appendable sb, String key, Collection<AbstractionPredicate> predicates, Map<AbstractionPredicate, String> predToString) throws IOException {
        if (!predicates.isEmpty()) {
            sb.append(key);
            sb.append(":\n");
            for (AbstractionPredicate pred : predicates) {
                sb.append((CharSequence)Preconditions.checkNotNull((Object)predToString.get(pred)));
                sb.append('\n');
            }
            sb.append('\n');
        }
    }

    static Pair<Integer, String> parseCommonDefinitions(BufferedReader reader, String sourceIdentifier) throws PredicateParsingFailedException, IOException {
        String currentLine;
        StringBuilder functionDefinitionsBuffer = new StringBuilder();
        int lineNo = 0;
        while ((currentLine = reader.readLine()) != null) {
            currentLine = currentLine.trim();
            ++lineNo;
            if (currentLine.isEmpty()) break;
            if (currentLine.startsWith("//")) continue;
            if (currentLine.startsWith("(") && currentLine.endsWith(")")) {
                functionDefinitionsBuffer.append(currentLine);
                functionDefinitionsBuffer.append('\n');
                continue;
            }
            throw new PredicateParsingFailedException(currentLine + " is not a valid SMTLIB2 definition", sourceIdentifier, lineNo);
        }
        return Pair.of((Object)lineNo, (Object)functionDefinitionsBuffer.toString());
    }

    public static class PredicateParsingFailedException
    extends CPAException {
        private static final long serialVersionUID = 5034288100943314517L;

        public PredicateParsingFailedException(String msg, String source, int lineNo) {
            super("Parsing failed in line " + lineNo + " of " + source + ": " + msg);
        }

        public PredicateParsingFailedException(Throwable cause, String source, int lineNo) {
            this(cause.getMessage(), source, lineNo);
            this.initCause(cause);
        }
    }

    public static enum PredicateDumpFormat {
        PLAIN,
        SMTLIB2;

    }
}

