/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public abstract class AbstractRelevantPredicatesComputer<T>
implements RelevantPredicatesComputer {
    private final FormulaManagerView fmgr;
    protected final Map<Pair<T, AbstractionPredicate>, Boolean> relevantPredicates = Maps.newHashMap();

    protected AbstractRelevantPredicatesComputer(FormulaManagerView pFmgr) {
        this.fmgr = pFmgr;
    }

    @Override
    public Set<AbstractionPredicate> getRelevantPredicates(Block context, Collection<AbstractionPredicate> predicates) {
        HashSet<AbstractionPredicate> result = new HashSet<AbstractionPredicate>(predicates.size());
        T precomputeResult = this.precompute(context, predicates);
        for (AbstractionPredicate predicate : predicates) {
            if (!this.isRelevant0(precomputeResult, predicate)) continue;
            result.add(predicate);
        }
        return result;
    }

    private boolean isRelevant0(T pPrecomputeResult, AbstractionPredicate pPredicate) {
        String predicateString;
        Pair key = Pair.of(pPrecomputeResult, (Object)pPredicate);
        Boolean cacheResult = this.relevantPredicates.get(key);
        if (cacheResult != null) {
            return cacheResult;
        }
        boolean result = this.fmgr.getBooleanFormulaManager().isFalse(pPredicate.getSymbolicAtom()) || this.fmgr.extractVariableNames(pPredicate.getSymbolicAtom()).isEmpty() ? true : ((predicateString = pPredicate.getSymbolicAtom().toString()).contains("false") || predicateString.contains("retval") || predicateString.contains("nondet") ? true : this.isRelevant(pPrecomputeResult, pPredicate));
        this.relevantPredicates.put(key, result);
        return result;
    }

    protected abstract boolean isRelevant(T var1, AbstractionPredicate var2);

    protected abstract T precompute(Block var1, Collection<AbstractionPredicate> var2);

    @Override
    public Set<AbstractionPredicate> getIrrelevantPredicates(Block context, Collection<AbstractionPredicate> predicates) {
        HashSet<AbstractionPredicate> result = new HashSet<AbstractionPredicate>(predicates);
        result.removeAll(this.getRelevantPredicates(context, predicates));
        return result;
    }
}

