/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.AbstractRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class AuxiliaryComputer
extends AbstractRelevantPredicatesComputer<Collection<String>> {
    public AuxiliaryComputer(FormulaManagerView pFmgr) {
        super(pFmgr);
    }

    @Override
    protected Collection<String> precompute(Block pContext, Collection<AbstractionPredicate> pPredicates) {
        ArrayDeque<ReferencedVariable> waitlist = new ArrayDeque<ReferencedVariable>();
        for (ReferencedVariable var : pContext.getReferencedVariables()) {
            if (var.occursInCondition()) {
                waitlist.add(var);
                continue;
            }
            if (var.getInfluencingVariables().isEmpty() || !this.occursInPredicate(var, pPredicates)) continue;
            waitlist.add(var);
        }
        HashSet<String> relevantVars = new HashSet<String>();
        while (!waitlist.isEmpty()) {
            ReferencedVariable var;
            var = (ReferencedVariable)waitlist.pop();
            if (!relevantVars.add(var.getName())) continue;
            waitlist.addAll(var.getInfluencingVariables());
        }
        return relevantVars;
    }

    private boolean occursInPredicate(ReferencedVariable pVar, Collection<AbstractionPredicate> pPredicates) {
        for (AbstractionPredicate predicate : pPredicates) {
            if (!predicate.getSymbolicAtom().toString().contains(pVar.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isRelevant(Collection<String> relevantVariables, AbstractionPredicate predicate) {
        String predicateString = predicate.getSymbolicAtom().toString();
        for (String var : relevantVariables) {
            if (!predicateString.contains(var)) continue;
            return true;
        }
        return false;
    }
}

