/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.CachingRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.OccurrenceComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RefineableRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class RefineableOccurrenceComputer
extends OccurrenceComputer
implements RefineableRelevantPredicatesComputer {
    private final SetMultimap<Block, AbstractionPredicate> definitelyRelevantPredicates = HashMultimap.create();

    public RefineableOccurrenceComputer(FormulaManagerView pFmgr) {
        super(pFmgr);
    }

    @Override
    protected boolean isRelevant(Block context, AbstractionPredicate predicate) {
        Set relevantPredicates = this.definitelyRelevantPredicates.get((Object)context);
        if (relevantPredicates != null && relevantPredicates.contains(predicate)) {
            return true;
        }
        return super.isRelevant(context, predicate);
    }

    @Override
    public void considerPredicateAsRelevant(Block pBlock, AbstractionPredicate pPredicate) {
        this.definitelyRelevantPredicates.put((Object)pBlock, (Object)pPredicate);
        CachingRelevantPredicatesComputer.removeCacheEntriesForBlock(pBlock, this.relevantPredicates);
    }
}

