/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.programcounter;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.SingleLoopHead;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.programcounter.ProgramCounterState;
import org.sosy_lab.cpachecker.cpa.programcounter.ProgramCounterTransferRelation;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class ProgramCounterCPA
extends AbstractCPA
implements ConfigurableProgramAnalysis {
    private final CFA cfa;

    public ProgramCounterCPA(CFA pCFA) {
        super("sep", "sep", DelegateAbstractDomain.getInstance(), ProgramCounterTransferRelation.INSTANCE);
        this.cfa = pCFA;
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ProgramCounterCPA.class);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        FluentIterable potentialValues;
        CFANode loopHead;
        LoopStructure.Loop singleLoop;
        LoopStructure loopStructure;
        SingleLoopHead singleLoopHead = null;
        if (pNode instanceof SingleLoopHead) {
            singleLoopHead = (SingleLoopHead)pNode;
        } else if (this.cfa.getLoopStructure().isPresent() && (loopStructure = (LoopStructure)this.cfa.getLoopStructure().get()).getCount() == 1 && (singleLoop = (LoopStructure.Loop)Iterables.getOnlyElement(loopStructure.getAllLoops())).getLoopHeads().size() == 1 && (loopHead = (CFANode)Iterables.getOnlyElement(singleLoop.getLoopHeads())) instanceof SingleLoopHead) {
            singleLoopHead = (SingleLoopHead)loopHead;
        }
        if (singleLoopHead != null && !(potentialValues = FluentIterable.from(singleLoopHead.getProgramCounterValues()).transform((Function)new Function<Integer, BigInteger>(){

            public BigInteger apply(Integer pArg0) {
                return BigInteger.valueOf(pArg0.intValue());
            }
        })).isEmpty()) {
            return ProgramCounterState.getStateForValues((Iterable<BigInteger>)potentialValues);
        }
        return ProgramCounterState.getTopState();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }
}

