/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.programcounter;

import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.Set;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;

public class ProgramCounterState
implements AbstractState,
LatticeAbstractState<ProgramCounterState> {
    private static final ProgramCounterState TOP = new ProgramCounterState();
    private final Set<BigInteger> values;

    private ProgramCounterState() {
        this(null);
    }

    private ProgramCounterState(ImmutableSet<BigInteger> pValues) {
        assert (pValues != null || TOP == null);
        this.values = pValues;
    }

    public boolean isTop() {
        assert (this.values != null || this == TOP);
        return this.values == null;
    }

    public boolean isBottom() {
        return !this.isTop() && this.values.isEmpty();
    }

    public boolean containsValue(BigInteger pValue) {
        return this.isTop() || this.values.contains(pValue);
    }

    @Override
    public boolean isLessOrEqual(ProgramCounterState other) {
        return other.containsAll(this);
    }

    public boolean containsAll(ProgramCounterState pOther) {
        if (pOther.isTop()) {
            return this.isTop();
        }
        if (this.isTop() || this == pOther) {
            return true;
        }
        return this.values.containsAll(pOther.values);
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof ProgramCounterState) {
            ProgramCounterState other = (ProgramCounterState)pO;
            return this.values == other.values || this.values != null && this.values.equals(other.values);
        }
        return false;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return this.isTop() ? "TOP" : this.values.toString();
    }

    public ProgramCounterState insert(BigInteger pValue) {
        if (this.containsValue(pValue)) {
            return this;
        }
        return new ProgramCounterState((ImmutableSet<BigInteger>)ImmutableSet.builder().addAll(this.values).add((Object)pValue).build());
    }

    @Override
    public ProgramCounterState join(ProgramCounterState pOther) {
        if (this.isTop() || pOther.isTop()) {
            return TOP;
        }
        ImmutableSet.Builder builder = null;
        for (BigInteger value : pOther.values) {
            if (this.containsValue(value)) continue;
            if (builder == null) {
                builder = ImmutableSet.builder();
                builder.addAll(this.values);
            }
            builder.add((Object)value);
        }
        if (builder == null) {
            return this;
        }
        return new ProgramCounterState((ImmutableSet<BigInteger>)builder.build());
    }

    public ProgramCounterState remove(BigInteger pValue) {
        if (this.isTop() || !this.containsValue(pValue)) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BigInteger value : this.values) {
            if (value.equals(pValue)) continue;
            builder.add((Object)value);
        }
        return new ProgramCounterState((ImmutableSet<BigInteger>)builder.build());
    }

    public static ProgramCounterState getTopState() {
        return TOP;
    }

    public static ProgramCounterState getStateForValue(BigInteger pPCValue) {
        return new ProgramCounterState((ImmutableSet<BigInteger>)ImmutableSet.of((Object)pPCValue));
    }

    public static AbstractState getStateForValues(Iterable<BigInteger> pValues) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BigInteger value : pValues) {
            builder.add((Object)value);
        }
        return new ProgramCounterState((ImmutableSet<BigInteger>)builder.build());
    }
}

