/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.programcounter;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssignmentEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssumeEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.programcounter.ProgramCounterState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class ProgramCounterTransferRelation
extends SingleEdgeTransferRelation {
    static final TransferRelation INSTANCE = new ProgramCounterTransferRelation();

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        ProgramCounterState state = (ProgramCounterState)pState;
        switch (pCfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                AExpression expression;
                AVariableDeclaration declaration;
                ADeclarationEdge edge;
                if (!(pCfaEdge instanceof ADeclarationEdge) || !((edge = (ADeclarationEdge)pCfaEdge).getDeclaration() instanceof AVariableDeclaration) || !(declaration = (AVariableDeclaration)edge.getDeclaration()).getQualifiedName().equals("___pc") || !(declaration.getInitializer() instanceof AInitializerExpression) || !((expression = ((AInitializerExpression)declaration.getInitializer()).getExpression()) instanceof AIntegerLiteralExpression)) break;
                BigInteger pcValue = ((AIntegerLiteralExpression)expression).getValue();
                state = ProgramCounterState.getStateForValue(pcValue);
                break;
            }
            case AssumeEdge: {
                if (!(pCfaEdge instanceof ProgramCounterValueAssumeEdge)) break;
                ProgramCounterValueAssumeEdge edge = (ProgramCounterValueAssumeEdge)pCfaEdge;
                BigInteger value = BigInteger.valueOf(edge.getProgramCounterValue());
                if (edge.getTruthAssumption()) {
                    if (state.containsValue(value)) {
                        state = ProgramCounterState.getStateForValue(value);
                        break;
                    }
                    return Collections.emptySet();
                }
                if (!(state = state.remove(value)).isBottom()) break;
                return Collections.emptySet();
            }
            case StatementEdge: {
                if (!(pCfaEdge instanceof ProgramCounterValueAssignmentEdge)) break;
                ProgramCounterValueAssignmentEdge edge = (ProgramCounterValueAssignmentEdge)pCfaEdge;
                state = ProgramCounterState.getStateForValue(BigInteger.valueOf(edge.getProgramCounterValue()));
                break;
            }
        }
        if (state == null || state.isBottom()) {
            return Collections.emptySet();
        }
        return Collections.singleton(state);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }
}

