/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.reachdef;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.reachdef.MergeIgnoringCallstack;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefTransferRelation;
import org.sosy_lab.cpachecker.cpa.reachdef.StopIgnoringCallstack;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefUtils;

@Options(prefix="cpa.reachdef")
public class ReachingDefCPA
implements ConfigurableProgramAnalysis {
    private LogManager logger;
    private AbstractDomain domain;
    private ReachingDefTransferRelation transfer;
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN", "IGNORECALLSTACK"}, description="which merge operator to use for ReachingDefCPA")
    private String mergeType = "JOIN";
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "JOIN", "IGNORECALLSTACK"}, description="which stop operator to use for ReachingDefCPA")
    private String stopType = "SEP";
    private StopOperator stop;
    private MergeOperator merge;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ReachingDefCPA.class);
    }

    private ReachingDefCPA(LogManager logger, Configuration config, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
        this.domain = DelegateAbstractDomain.getInstance();
        this.transfer = new ReachingDefTransferRelation(logger, shutdownNotifier);
        this.stop = this.stopType.equals("SEP") ? new StopSepOperator(this.domain) : (this.mergeType.equals("JOIN") ? new StopJoinOperator(this.domain) : new StopIgnoringCallstack());
        this.merge = this.mergeType.equals("SEP") ? MergeSepOperator.getInstance() : (this.mergeType.equals("JOIN") ? new MergeJoinOperator(this.domain) : new MergeIgnoringCallstack());
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        this.logger.log(Level.FINE, new Object[]{"Start extracting all declared variables in program.", "Distinguish between local and global variables."});
        Pair<Set<String>, Map<FunctionEntryNode, Set<String>>> result = ReachingDefUtils.getAllVariables(pNode);
        this.logger.log(Level.FINE, new Object[]{"Extracted all declared variables.", "Create initial state."});
        this.transfer.provideLocalVariablesOfFunctions((Map)result.getSecond());
        this.transfer.setMainFunctionNode(pNode);
        return new ReachingDefState((Set)result.getFirst());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }
}

