/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.reachdef;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefinitionStorage;

public class ReachingDefState
implements AbstractState,
Serializable,
LatticeAbstractState<ReachingDefState>,
Graphable {
    private static final long serialVersionUID = -7715698130795640052L;
    private static final SerialProxyReach proxy = new SerialProxyReach();
    public static final ReachingDefState topElement = new ReachingDefState();
    private ReachingDefState stateOnLastFunctionCall;
    private transient Map<String, Set<DefinitionPoint>> localReachDefs;
    private transient Map<String, Set<DefinitionPoint>> globalReachDefs;

    private ReachingDefState() {
    }

    public ReachingDefState(Set<String> globalVariableNames) {
        this.stateOnLastFunctionCall = null;
        this.localReachDefs = new HashMap<String, Set<DefinitionPoint>>();
        this.globalReachDefs = new HashMap<String, Set<DefinitionPoint>>();
        this.addVariables(this.globalReachDefs, globalVariableNames, UninitializedDefinitionPoint.getInstance());
    }

    public ReachingDefState(Map<String, Set<DefinitionPoint>> pLocalReachDefs, Map<String, Set<DefinitionPoint>> pGlobalReachDefs, ReachingDefState stateLastFuncCall) {
        this.stateOnLastFunctionCall = stateLastFuncCall;
        this.localReachDefs = pLocalReachDefs;
        this.globalReachDefs = pGlobalReachDefs;
    }

    public ReachingDefState addLocalReachDef(String variableName, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint definition = new ProgramDefinitionPoint(pEntry, pExit);
        return new ReachingDefState(this.replaceReachDef(this.localReachDefs, variableName, definition), this.globalReachDefs, this.stateOnLastFunctionCall);
    }

    public ReachingDefState addGlobalReachDef(String variableName, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint definition = new ProgramDefinitionPoint(pEntry, pExit);
        return new ReachingDefState(this.localReachDefs, this.replaceReachDef(this.globalReachDefs, variableName, definition), this.stateOnLastFunctionCall);
    }

    private Map<String, Set<DefinitionPoint>> replaceReachDef(Map<String, Set<DefinitionPoint>> toChange, String variableName, ProgramDefinitionPoint definition) {
        HashMap<String, Set<DefinitionPoint>> changed = new HashMap<String, Set<DefinitionPoint>>(toChange);
        ImmutableSet insert = ImmutableSet.of((Object)definition);
        changed.put(variableName, (Set<DefinitionPoint>)insert);
        return changed;
    }

    public ReachingDefState initVariables(Set<String> uninitVariableNames, Set<String> parameters, CFANode pEntry, CFANode pExit) {
        ProgramDefinitionPoint definition = new ProgramDefinitionPoint(pEntry, pExit);
        HashMap<String, Set<DefinitionPoint>> localVarsDef = new HashMap<String, Set<DefinitionPoint>>();
        this.addVariables(localVarsDef, uninitVariableNames, UninitializedDefinitionPoint.getInstance());
        this.addVariables(localVarsDef, parameters, definition);
        return new ReachingDefState(localVarsDef, this.globalReachDefs, this);
    }

    private void addVariables(Map<String, Set<DefinitionPoint>> addTo, Set<String> variableNames, DefinitionPoint definition) {
        ImmutableSet insert = ImmutableSet.of((Object)definition);
        for (String name : variableNames) {
            addTo.put(name, (Set<DefinitionPoint>)insert);
        }
    }

    public ReachingDefState pop() {
        return new ReachingDefState(this.stateOnLastFunctionCall.localReachDefs, this.globalReachDefs, this.stateOnLastFunctionCall.stateOnLastFunctionCall);
    }

    public Map<String, Set<DefinitionPoint>> getLocalReachingDefinitions() {
        return this == topElement ? null : this.localReachDefs;
    }

    public Map<String, Set<DefinitionPoint>> getGlobalReachingDefinitions() {
        return this == topElement ? null : this.globalReachDefs;
    }

    @Override
    public boolean isLessOrEqual(ReachingDefState superset) {
        if (superset == this || superset == topElement) {
            return true;
        }
        if (this.stateOnLastFunctionCall != superset.stateOnLastFunctionCall && !this.compareStackStates(this.stateOnLastFunctionCall, superset.stateOnLastFunctionCall)) {
            return false;
        }
        boolean isLocalSubset = this.isSubsetOf(this.localReachDefs, superset.localReachDefs);
        return isLocalSubset && this.isSubsetOf(this.globalReachDefs, superset.globalReachDefs);
    }

    private boolean compareStackStates(ReachingDefState sub, ReachingDefState sup) {
        boolean result;
        do {
            if (sub == null || sup == null) {
                return false;
            }
            result = this.isSubsetOf(sub.getLocalReachingDefinitions(), sup.getLocalReachingDefinitions());
            result = result && this.isSubsetOf(sub.getGlobalReachingDefinitions(), sup.getGlobalReachingDefinitions());
        } while ((sub = sub.stateOnLastFunctionCall) != (sup = sup.stateOnLastFunctionCall) && result);
        return result;
    }

    private boolean isSubsetOf(Map<String, Set<DefinitionPoint>> subset, Map<String, Set<DefinitionPoint>> superset) {
        if (subset == superset) {
            return true;
        }
        for (Map.Entry<String, Set<DefinitionPoint>> entry : subset.entrySet()) {
            Set<DefinitionPoint> setSuper;
            Set<DefinitionPoint> setSub = entry.getValue();
            if (setSub == (setSuper = superset.get(entry.getKey())) || setSuper != null && Sets.intersection(setSub, setSuper).size() == setSub.size()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReachingDefState join(ReachingDefState toJoin) {
        ReachingDefState lastFunctionCall;
        Map<String, Set<DefinitionPoint>> newLocal = null;
        boolean changed = false;
        if (toJoin == this) {
            return this;
        }
        if (toJoin == topElement || this == topElement) {
            return topElement;
        }
        if (this.stateOnLastFunctionCall != toJoin.stateOnLastFunctionCall) {
            lastFunctionCall = this.mergeStackStates(this.stateOnLastFunctionCall, toJoin.stateOnLastFunctionCall);
            if (lastFunctionCall == topElement) {
                return topElement;
            }
            if (lastFunctionCall != this.stateOnLastFunctionCall) {
                changed = true;
            } else {
                lastFunctionCall = toJoin.stateOnLastFunctionCall;
            }
        } else {
            lastFunctionCall = toJoin.stateOnLastFunctionCall;
        }
        Map<String, Set<DefinitionPoint>> resultOfMapUnion = this.unionMaps(this.localReachDefs, toJoin.localReachDefs);
        if (resultOfMapUnion == this.localReachDefs) {
            newLocal = toJoin.localReachDefs;
        } else {
            changed = true;
            newLocal = resultOfMapUnion;
        }
        resultOfMapUnion = this.unionMaps(this.globalReachDefs, toJoin.globalReachDefs);
        if (resultOfMapUnion == this.globalReachDefs) {
            resultOfMapUnion = toJoin.globalReachDefs;
        } else {
            changed = true;
        }
        if (changed) {
            assert (newLocal != null);
            return new ReachingDefState(newLocal, resultOfMapUnion, lastFunctionCall);
        }
        return toJoin;
    }

    private ReachingDefState mergeStackStates(ReachingDefState e1, ReachingDefState e2) {
        Vector<ReachingDefState> statesToMerge = new Vector<ReachingDefState>();
        do {
            if (e1.stateOnLastFunctionCall == null || e2.stateOnLastFunctionCall == null) {
                return topElement;
            }
            statesToMerge.add(e1);
            statesToMerge.add(e2);
        } while ((e1 = e1.stateOnLastFunctionCall) != (e2 = e2.stateOnLastFunctionCall));
        boolean changed = false;
        ReachingDefState newStateOnLastFunctionCall = e1;
        for (int i = statesToMerge.size() - 1; i >= 0; i -= 2) {
            Map<String, Set<DefinitionPoint>> newLocal;
            Map<String, Set<DefinitionPoint>> resultOfMapUnion = this.unionMaps(((ReachingDefState)statesToMerge.get((int)(i - 1))).localReachDefs, ((ReachingDefState)statesToMerge.get((int)i)).localReachDefs);
            if (resultOfMapUnion != ((ReachingDefState)statesToMerge.get((int)(i - 1))).localReachDefs) {
                changed = true;
                newLocal = resultOfMapUnion;
            } else {
                newLocal = ((ReachingDefState)statesToMerge.get((int)i)).localReachDefs;
            }
            resultOfMapUnion = this.unionMaps(((ReachingDefState)statesToMerge.get((int)(i - 1))).globalReachDefs, ((ReachingDefState)statesToMerge.get((int)i)).globalReachDefs);
            if (resultOfMapUnion != ((ReachingDefState)statesToMerge.get((int)(i - 1))).globalReachDefs) {
                changed = true;
            } else {
                resultOfMapUnion = ((ReachingDefState)statesToMerge.get((int)i)).globalReachDefs;
            }
            if (!this.isSubsetOf(((ReachingDefState)statesToMerge.get((int)i)).globalReachDefs, resultOfMapUnion)) {
                this.isSubsetOf(((ReachingDefState)statesToMerge.get((int)i)).globalReachDefs, resultOfMapUnion);
            }
            newStateOnLastFunctionCall = new ReachingDefState(newLocal, resultOfMapUnion, newStateOnLastFunctionCall);
        }
        if (changed) {
            return newStateOnLastFunctionCall;
        }
        return (ReachingDefState)statesToMerge.get(0);
    }

    private Map<String, Set<DefinitionPoint>> unionMaps(Map<String, Set<DefinitionPoint>> map1, Map<String, Set<DefinitionPoint>> map2) {
        HashMap<String, Set<DefinitionPoint>> newMap = new HashMap<String, Set<DefinitionPoint>>();
        assert (map1.keySet().equals(map2.keySet()));
        if (map1 == map2) {
            return map1;
        }
        boolean changed = false;
        for (Map.Entry<String, Set<DefinitionPoint>> entry : map1.entrySet()) {
            String var = entry.getKey();
            if (entry.getValue() == map2.get(var)) {
                newMap.put(var, map2.get(var));
                continue;
            }
            Set<DefinitionPoint> unionResult = this.unionSets(entry.getValue(), map2.get(var));
            if (unionResult.size() != map2.get(var).size()) {
                changed = true;
            }
            newMap.put(var, unionResult);
        }
        assert (map1.keySet().equals(newMap.keySet()));
        if (changed) {
            return newMap;
        }
        return map1;
    }

    private Set<DefinitionPoint> unionSets(Set<DefinitionPoint> set1, Set<DefinitionPoint> set2) {
        HashSet<DefinitionPoint> result = new HashSet<DefinitionPoint>();
        for (DefinitionPoint p : set1) {
            result.add(p);
        }
        for (DefinitionPoint p : set2) {
            result.add(p);
        }
        return result;
    }

    private Object writeReplace() throws ObjectStreamException {
        if (this == topElement) {
            return proxy;
        }
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(ReachingDefinitionStorage.getInstance().saveMap(this.localReachDefs));
        out.writeInt(ReachingDefinitionStorage.getInstance().saveMap(this.globalReachDefs));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int id = in.readInt();
        this.localReachDefs = ReachingDefinitionStorage.getInstance().getMap(id);
        id = in.readInt();
        this.globalReachDefs = ReachingDefinitionStorage.getInstance().getMap(id);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\\n");
        sb.append(System.identityHashCode(this));
        sb.append("\\n");
        sb.append("global:");
        sb.append(this.createStringOfMap(this.globalReachDefs));
        sb.append("\\n");
        sb.append("local:");
        sb.append(this.createStringOfMap(this.localReachDefs));
        sb.append("\\n");
        sb.append(System.identityHashCode(this.stateOnLastFunctionCall));
        sb.append("\\n");
        sb.append("}");
        return sb.toString();
    }

    private String createStringOfMap(Map<String, Set<DefinitionPoint>> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        boolean first = true;
        for (Map.Entry<String, Set<DefinitionPoint>> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(" (");
            sb.append(entry.getKey());
            sb.append(": [");
            Joiner.on((String)"; ").appendTo(sb, (Iterable)entry.getValue());
            sb.append("])");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    public static class ProgramDefinitionPoint
    implements DefinitionPoint,
    Serializable {
        private static final long serialVersionUID = -7601382286840053882L;
        private transient CFANode entry;
        private transient CFANode exit;

        public ProgramDefinitionPoint(CFANode pEntry, CFANode pExit) {
            this.entry = pEntry;
            this.exit = pExit;
        }

        public CFANode getDefinitionEntryLocation() {
            return this.entry;
        }

        public CFANode getDefinitionExitLocation() {
            return this.exit;
        }

        public String toString() {
            return "(N" + this.entry.getNodeNumber() + ",N" + this.exit.getNodeNumber() + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
            result = 31 * result + (this.exit == null ? 0 : this.exit.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramDefinitionPoint other = (ProgramDefinitionPoint)obj;
            if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
                return false;
            }
            return !(this.exit == null ? other.exit != null : !this.exit.equals(other.exit));
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(this.entry.getNodeNumber());
            out.writeInt(this.exit.getNodeNumber());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int nodeNumber = in.readInt();
            CFAInfo cfaInfo = (CFAInfo)GlobalInfo.getInstance().getCFAInfo().get();
            this.entry = cfaInfo.getNodeByNodeNumber(nodeNumber);
            nodeNumber = in.readInt();
            this.exit = cfaInfo.getNodeByNodeNumber(nodeNumber);
        }
    }

    public static class UninitializedDefinitionPoint
    implements DefinitionPoint,
    Serializable {
        private static final long serialVersionUID = 6987753908487106524L;
        private static UninitializedDefinitionPoint instance = new UninitializedDefinitionPoint();
        private static final SerialProxy writeReplace = new SerialProxy();

        private UninitializedDefinitionPoint() {
        }

        public static UninitializedDefinitionPoint getInstance() {
            return instance;
        }

        public String toString() {
            return "?";
        }

        private Object writeReplace() throws ObjectStreamException {
            return writeReplace;
        }

        private static class SerialProxy
        implements Serializable {
            private static final long serialVersionUID = 2843708585446089623L;

            private Object readResolve() throws ObjectStreamException {
                return instance;
            }
        }
    }

    public static interface DefinitionPoint {
    }

    private static class SerialProxyReach
    implements Serializable {
        private static final long serialVersionUID = 2843708585446089623L;

        private Object readResolve() throws ObjectStreamException {
            return topElement;
        }
    }
}

