/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.reachdef;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefUtils;

public class ReachingDefTransferRelation
implements TransferRelation {
    private Map<FunctionEntryNode, Set<String>> localVariablesPerFunction;
    private CFANode main;
    private LogManager logger;
    private final ShutdownNotifier shutdownNotifier;

    public ReachingDefTransferRelation(LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public void provideLocalVariablesOfFunctions(Map<FunctionEntryNode, Set<String>> localVars) {
        this.localVariablesPerFunction = localVars;
    }

    public void setMainFunctionNode(CFANode pMain) {
        this.main = pMain;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        List<CFANode> nodes = ReachingDefUtils.getAllNodesFromCFA();
        if (nodes == null) {
            throw new CPATransferException("CPA not properly initialized.");
        }
        Vector<AbstractState> successors = new Vector<AbstractState>();
        Vector<CFAEdge> definitions = new Vector<CFAEdge>();
        for (CFANode node : nodes) {
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                this.shutdownNotifier.shutdownIfNecessary();
                CFAEdge cfaedge = node.getLeavingEdge(i);
                if (cfaedge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) continue;
                if (cfaedge.getEdgeType() == CFAEdgeType.StatementEdge || cfaedge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
                    definitions.add(node.getLeavingEdge(i));
                    continue;
                }
                successors.addAll(this.getAbstractSuccessors0(pState, pPrecision, node.getLeavingEdge(i)));
            }
        }
        for (CFAEdge edge : definitions) {
            successors.addAll(this.getAbstractSuccessors0(pState, pPrecision, edge));
        }
        return successors;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)pCfaEdge);
        return this.getAbstractSuccessors0(pState, pPrecision, pCfaEdge);
    }

    private Collection<? extends AbstractState> getAbstractSuccessors0(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        ReachingDefState result;
        this.logger.log(Level.INFO, new Object[]{"Compute succesor for ", pState, "along edge", pCfaEdge});
        if (this.localVariablesPerFunction == null) {
            throw new CPATransferException("Incorrect initialization of reaching definition transfer relation.");
        }
        if (!(pState instanceof ReachingDefState)) {
            throw new CPATransferException("Unexpected type of abstract state. The transfer relation is not defined for this type");
        }
        if (pCfaEdge == null) {
            throw new CPATransferException("Expected an edge along which the successors should be computed");
        }
        if (pState == ReachingDefState.topElement) {
            return Collections.singleton(pState);
        }
        switch (pCfaEdge.getEdgeType()) {
            case StatementEdge: {
                result = this.handleStatementEdge((ReachingDefState)pState, (CStatementEdge)pCfaEdge);
                break;
            }
            case DeclarationEdge: {
                result = this.handleDeclarationEdge((ReachingDefState)pState, (CDeclarationEdge)pCfaEdge);
                break;
            }
            case FunctionCallEdge: {
                result = this.handleCallEdge((ReachingDefState)pState, (CFunctionCallEdge)pCfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                result = this.handleReturnEdge((ReachingDefState)pState, (CFunctionReturnEdge)pCfaEdge);
                break;
            }
            case MultiEdge: {
                result = this.handleMultiEdge((ReachingDefState)pState, (MultiEdge)pCfaEdge);
                break;
            }
            case BlankEdge: {
                this.logger.log(Level.FINE, new Object[]{"Start of main function. ", "Add undefined position for local variables of main function. ", "Add definition of parameters of main function."});
                if (pCfaEdge.getPredecessor() == this.main && ((ReachingDefState)pState).getLocalReachingDefinitions().size() == 0) {
                    result = ((ReachingDefState)pState).initVariables(this.localVariablesPerFunction.get(pCfaEdge.getPredecessor()), (Set<String>)ImmutableSet.copyOf(((FunctionEntryNode)pCfaEdge.getPredecessor()).getFunctionParameterNames()), pCfaEdge.getPredecessor(), pCfaEdge.getSuccessor());
                    break;
                }
            }
            case AssumeEdge: 
            case CallToReturnEdge: 
            case ReturnStatementEdge: {
                this.logger.log(Level.FINE, new Object[]{"Reaching definition not affected by edge. ", "Keep reaching definition unchanged."});
                result = (ReachingDefState)pState;
                break;
            }
            default: {
                throw new CPATransferException("Unknown CFA edge type.");
            }
        }
        return Collections.singleton(result);
    }

    private ReachingDefState handleStatementEdge(ReachingDefState pState, CStatementEdge edge) throws CPATransferException {
        CLeftHandSide left;
        CStatement statement = edge.getStatement();
        if (statement instanceof CExpressionAssignmentStatement) {
            left = ((CExpressionAssignmentStatement)statement).getLeftHandSide();
        } else if (statement instanceof CFunctionCallAssignmentStatement) {
            left = ((CFunctionCallAssignmentStatement)statement).getLeftHandSide();
            this.logger.log(Level.WARNING, new Object[]{"Analysis may be unsound if external method redefines global variables", "or considers extra global variables."});
        } else {
            return pState;
        }
        ReachingDefUtils.VariableExtractor varExtractor = new ReachingDefUtils.VariableExtractor(edge);
        varExtractor.resetWarning();
        String var = left.accept(varExtractor);
        if (varExtractor.getWarning() != null) {
            this.logger.log(Level.WARNING, new Object[]{varExtractor.getWarning()});
        }
        if (var == null) {
            return pState;
        }
        this.logger.log(Level.FINE, new Object[]{"Edge provided a new definition of variable ", var, ". Update reaching definition."});
        if (pState.getGlobalReachingDefinitions().containsKey(var)) {
            return pState.addGlobalReachDef(var, edge.getPredecessor(), edge.getSuccessor());
        }
        assert (pState.getLocalReachingDefinitions().containsKey(var));
        return pState.addLocalReachDef(var, edge.getPredecessor(), edge.getSuccessor());
    }

    private ReachingDefState handleDeclarationEdge(ReachingDefState pState, CDeclarationEdge edge) {
        CVariableDeclaration dec;
        if (edge.getDeclaration() instanceof CVariableDeclaration && (dec = (CVariableDeclaration)edge.getDeclaration()).getInitializer() != null) {
            if (dec.isGlobal()) {
                return pState.addGlobalReachDef(dec.getName(), edge.getPredecessor(), edge.getSuccessor());
            }
            return pState.addLocalReachDef(dec.getName(), edge.getPredecessor(), edge.getSuccessor());
        }
        return pState;
    }

    private ReachingDefState handleCallEdge(ReachingDefState pState, CFunctionCallEdge pCfaEdge) {
        this.logger.log(Level.FINE, new Object[]{"New internal function called. ", "Add undefined position for local variables. ", "Add definition of parameters."});
        return pState.initVariables(this.localVariablesPerFunction.get(pCfaEdge.getSuccessor()), (Set<String>)ImmutableSet.copyOf(pCfaEdge.getSuccessor().getFunctionParameterNames()), pCfaEdge.getPredecessor(), pCfaEdge.getSuccessor());
    }

    private ReachingDefState handleReturnEdge(ReachingDefState pState, CFunctionReturnEdge pCfaEdge) {
        this.logger.log(Level.FINE, new Object[]{"Return from internal function call. ", "Remove local variables and parameters of function from reaching definition."});
        return pState.pop();
    }

    private ReachingDefState handleMultiEdge(ReachingDefState pState, MultiEdge edge) throws CPATransferException {
        block5: for (CFAEdge simpleEdge : edge.getEdges()) {
            switch (simpleEdge.getEdgeType()) {
                case StatementEdge: {
                    pState = this.handleStatementEdge(pState, (CStatementEdge)simpleEdge);
                    continue block5;
                }
                case DeclarationEdge: {
                    pState = this.handleDeclarationEdge(pState, (CDeclarationEdge)simpleEdge);
                    continue block5;
                }
                case BlankEdge: {
                    continue block5;
                }
            }
            throw new CPATransferException("Unknown CFA edge type incorporated in MultiEdge.");
        }
        return pState;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }
}

