/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.rtt;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.rtt.RTTCPAStatistics;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.cpa.rtt.RTTTransferRelation;

public class RTTCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider {
    private Precision precision;
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private TransferRelation transferRelation;
    private PrecisionAdjustment precisionAdjustment;
    private final RTTCPAStatistics statistics;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(RTTCPA.class);
    }

    public RTTCPA(Configuration pConfig, LogManager logger, CFA cfa) throws InvalidConfigurationException {
        this.logger = logger;
        this.mergeOperator = new MergeSepOperator();
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.precision = SingletonPrecision.getInstance();
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        this.transferRelation = new RTTTransferRelation();
        this.statistics = new RTTCPAStatistics();
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new RTTState();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    public RTTCPAStatistics getStats() {
        return this.statistics;
    }

    public LogManager getLogger() {
        return this.logger;
    }
}

