/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.rtt;

import java.io.PrintStream;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class RTTCPAStatistics
implements Statistics {
    @Override
    public String getName() {
        return "RTTCPA";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        int maxNumberOfVariables = 0;
        int maxNumberOfGlobalVariables = 0;
        long totalNumberOfVariables = 0L;
        long totalNumberOfGlobalVariables = 0L;
        for (AbstractState currentAbstractState : reached) {
            RTTState currentState = AbstractStates.extractStateByType(currentAbstractState, RTTState.class);
            int numberOfVariables = currentState.getConstantsMap().size();
            int numberOfGlobalVariables = this.getNumberOfGlobalVariables(currentState);
            totalNumberOfVariables = totalNumberOfGlobalVariables + (long)numberOfVariables;
            totalNumberOfGlobalVariables += (long)numberOfGlobalVariables;
            maxNumberOfVariables = Math.max(maxNumberOfVariables, numberOfVariables);
            maxNumberOfGlobalVariables = Math.max(maxNumberOfGlobalVariables, numberOfGlobalVariables);
        }
        out.println("Max. number of variables: " + maxNumberOfVariables);
        out.println("Max. number of globals variables: " + maxNumberOfGlobalVariables);
        out.println("Avg. number of variables: " + (double)totalNumberOfVariables * 10000.0 / (double)reached.size() / 10000.0);
        out.println("Avg. number of global variables: " + (double)totalNumberOfGlobalVariables * 10000.0 / (double)reached.size() / 10000.0);
    }

    private int getNumberOfGlobalVariables(RTTState state) {
        int numberOfGlobalVariables = 0;
        for (String variableName : state.getConstantsMap().keySet()) {
            if (!variableName.contains("::")) continue;
            ++numberOfGlobalVariables;
        }
        return numberOfGlobalVariables;
    }
}

