/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.rtt;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.DefaultJExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JAssignment;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodOrConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JObjectReferenceReturn;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSuperConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.rtt.NameProvider;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class RTTTransferRelation
extends SingleEdgeTransferRelation {
    private static final String NOT_IN_OBJECT_SCOPE = "null";
    private static final int RETURN_EDGE = 0;
    private static final String TEMP_VAR_NAME = "___cpa_temp_result_var_";
    private static final String JAVA_ENUM_OBJECT_NAME = "java.lang.Enum";
    private static int nextFreeId = 0;

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        RTTState successor;
        RTTState rttState = (RTTState)element;
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                JExpression exp = (JExpression)assumeEdge.getExpression();
                successor = this.handleAssumption(RTTState.copyOf(rttState), exp, cfaEdge, assumeEdge.getTruthAssumption());
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(rttState, functionCallEdge);
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)cfaEdge;
                successor = this.handleFunctionReturn(rttState, functionReturnEdge);
                successor.dropFrame(functionReturnEdge.getPredecessor().getFunctionName());
                break;
            }
            default: {
                successor = RTTState.copyOf(rttState);
                this.handleSimpleEdge(successor, cfaEdge);
            }
        }
        if (successor == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(successor);
    }

    private void handleSimpleEdge(RTTState element, CFAEdge cfaEdge) throws UnrecognizedCFAEdgeException, UnrecognizedCodeException {
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                AStatementEdge statementEdge = (AStatementEdge)cfaEdge;
                this.handleStatement(element, (JStatement)statementEdge.getStatement(), cfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                JReturnStatementEdge returnEdge = (JReturnStatementEdge)cfaEdge;
                if (!returnEdge.getExpression().isPresent()) break;
                JExpression exp = (JExpression)returnEdge.getExpression().get();
                this.handleExitFromFunction(element, exp, returnEdge);
                break;
            }
            case DeclarationEdge: {
                ADeclarationEdge declarationEdge = (ADeclarationEdge)cfaEdge;
                this.handleDeclaration(element, declarationEdge);
                break;
            }
            case BlankEdge: {
                break;
            }
            case MultiEdge: {
                for (CFAEdge edge : (MultiEdge)cfaEdge) {
                    this.handleSimpleEdge(element, edge);
                }
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
    }

    private void handleDeclaration(RTTState newElement, ADeclarationEdge declarationEdge) throws UnrecognizedCodeException {
        AInitializer init;
        if (!(declarationEdge.getDeclaration() instanceof JVariableDeclaration)) {
            return;
        }
        JVariableDeclaration decl = (JVariableDeclaration)declarationEdge.getDeclaration();
        if (decl.getType() instanceof JSimpleType) {
            JBasicType simpleType = ((JSimpleType)decl.getType()).getType();
            switch (simpleType) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case FLOAT: 
                case DOUBLE: 
                case INT: 
                case LONG: 
                case SHORT: 
                case UNSPECIFIED: {
                    return;
                }
            }
        }
        String methodName = declarationEdge.getPredecessor().getFunctionName();
        String initialValue = NOT_IN_OBJECT_SCOPE;
        if (decl instanceof JFieldDeclaration) {
            JFieldDeclaration fieldVariable = (JFieldDeclaration)decl;
            newElement.addFieldVariable(fieldVariable);
        }
        if ((init = decl.getInitializer()) instanceof JInitializerExpression) {
            JExpression exp = ((JInitializerExpression)init).getExpression();
            initialValue = this.getExpressionValue(newElement, exp, methodName, declarationEdge);
        }
        String scopedVarName = NameProvider.getInstance().getScopedVariableName(decl, methodName, newElement.getClassObjectScope());
        if (initialValue == null) {
            newElement.forget(scopedVarName);
        } else {
            newElement.assignObject(scopedVarName, initialValue);
        }
    }

    private String getExpressionValue(RTTState element, JExpression expression, String methodName, CFAEdge edge) throws UnrecognizedCodeException {
        return expression.accept(new ExpressionValueVisitor(edge, element, methodName));
    }

    private void handleExitFromFunction(RTTState newElement, JExpression expression, JReturnStatementEdge returnEdge) throws UnrecognizedCodeException {
        String methodName = returnEdge.getPredecessor().getFunctionName();
        if (returnEdge.getRawAST().get() instanceof JObjectReferenceReturn) {
            this.handleAssignmentToVariable(TEMP_VAR_NAME, expression, newElement.getClassObjectScope(), newElement, methodName);
        } else {
            this.handleAssignmentToVariable(TEMP_VAR_NAME, expression, new ExpressionValueVisitor(returnEdge, newElement, methodName));
        }
    }

    private void handleAssignmentToVariable(String lParam, JExpression exp, String value, RTTState newElement, String functionName) {
        String assignedVar = NameProvider.getInstance().getScopedVariableName(lParam, functionName, newElement.getClassObjectScope(), newElement);
        if (value == null) {
            newElement.forget(assignedVar);
        } else {
            newElement.assignObject(assignedVar, value);
        }
    }

    private void handleAssignmentToVariable(String lParam, JExpression exp, ExpressionValueVisitor visitor) throws UnrecognizedCodeException {
        String value = exp.accept(visitor);
        RTTState newElement = visitor.state;
        this.handleAssignmentToVariable(lParam, exp, value, newElement, visitor.functionName);
    }

    private void handleStatement(RTTState newElement, JStatement expression, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        if (expression instanceof JAssignment) {
            this.handleAssignment(newElement, (JAssignment)expression, cfaEdge);
        } else if (!(expression instanceof JMethodOrConstructorInvocation) && !(expression instanceof JExpressionStatement)) {
            throw new UnrecognizedCodeException("unknown statement", cfaEdge, expression);
        }
    }

    private void handleAssignment(RTTState newElement, JAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        JLeftHandSide op1 = assignExpression.getLeftHandSide();
        JRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof JIdExpression) {
            String methodName = cfaEdge.getPredecessor().getFunctionName();
            JSimpleDeclaration declaration = ((JIdExpression)op1).getDeclaration();
            if (declaration == null) {
                String scopedName = NameProvider.getInstance().getScopedVariableName(((JIdExpression)op1).getName(), methodName, newElement.getClassObjectScope(), newElement);
                newElement.forget(scopedName);
                return;
            }
            this.handleAssignmentToVariable((JIdExpression)op1, op2, new ExpressionValueVisitor(cfaEdge, newElement, methodName));
        }
    }

    private void handleAssignmentToVariable(JIdExpression lParam, JRightHandSide exp, ExpressionValueVisitor visitor) throws UnrecognizedCCodeException {
        NameProvider nameProvider = NameProvider.getInstance();
        String lParamObjectScope = nameProvider.getObjectScope(visitor.state, visitor.functionName, lParam);
        String value = exp.accept(visitor);
        RTTState newElement = visitor.state;
        if (!newElement.isKnownAsStatic(lParam.getName()) && lParamObjectScope == null) {
            return;
        }
        String assignedVar = nameProvider.getScopedVariableName(lParam.getDeclaration(), visitor.functionName, lParamObjectScope);
        if (value != null && lParam.getExpressionType() instanceof JReferenceType) {
            newElement.assignObject(assignedVar, value);
        } else {
            newElement.forget(assignedVar);
        }
    }

    private RTTState handleFunctionReturn(RTTState element, FunctionReturnEdge functionReturnEdge) throws UnrecognizedCodeException {
        FunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
        JMethodOrConstructorInvocation exprOnSummary = (JMethodOrConstructorInvocation)summaryEdge.getExpression();
        RTTState newElement = RTTState.copyOf(element);
        String callerFunctionName = functionReturnEdge.getSuccessor().getFunctionName();
        String calledFunctionName = functionReturnEdge.getPredecessor().getFunctionName();
        NameProvider nameProvider = NameProvider.getInstance();
        if (exprOnSummary instanceof JMethodInvocationAssignmentStatement) {
            JMethodInvocationAssignmentStatement assignExp = (JMethodInvocationAssignmentStatement)exprOnSummary;
            JLeftHandSide op1 = assignExp.getLeftHandSide();
            if (op1 instanceof JIdExpression) {
                String returnVarName = nameProvider.getScopedVariableName(TEMP_VAR_NAME, calledFunctionName, newElement.getClassObjectScope(), newElement);
                String assignedVarName = nameProvider.getScopedVariableName(((JIdExpression)op1).getDeclaration(), callerFunctionName, newElement.getClassObjectStack().peek());
                JSimpleDeclaration decl = ((JIdExpression)op1).getDeclaration();
                if (element.contains(returnVarName) && decl.getType() instanceof JReferenceType) {
                    newElement.assignObject(assignedVarName, element.getUniqueObjectFor(returnVarName));
                } else {
                    newElement.forget(assignedVarName);
                }
            } else {
                if (op1 instanceof JArraySubscriptExpression) {
                    return newElement;
                }
                throw new UnrecognizedCodeException("on function return", summaryEdge, op1);
            }
        }
        return newElement;
    }

    private RTTState handleFunctionCall(RTTState element, FunctionCallEdge callEdge) throws UnrecognizedCCodeException {
        RTTState newElement = RTTState.copyOf(element);
        FunctionEntryNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<? extends AExpression> arguments = callEdge.getArguments();
        if (!callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) assert (paramNames.size() == arguments.size());
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(callEdge, element, callerFunctionName);
        for (int i = 0; i < paramNames.size(); ++i) {
            String value = null;
            JExpression exp = (JExpression)arguments.get(i);
            value = exp.accept(visitor);
            String formalParamName = NameProvider.getInstance().getScopedVariableName(paramNames.get(i), calledFunctionName, newElement.getClassObjectScope(), newElement);
            if (value == null || !(exp.getExpressionType() instanceof JReferenceType)) {
                newElement.forget(formalParamName);
                continue;
            }
            newElement.assignObject(formalParamName, value);
        }
        JMethodInvocationExpression functionCall = (JMethodInvocationExpression)callEdge.getSummaryEdge().getExpression().getFunctionCallExpression();
        if (functionCall instanceof JSuperConstructorInvocation) {
            newElement.assignThisAndNewObjectScope(element.getUniqueObjectFor("this"));
        } else if (functionCall instanceof JClassInstanceCreation) {
            JReturnStatementEdge returnEdge = (JReturnStatementEdge)functionEntryNode.getExitNode().getEnteringEdge(0);
            String uniqueObject = ((JExpression)returnEdge.getExpression().get()).accept(new FunctionExitValueVisitor(returnEdge, newElement, calledFunctionName));
            newElement.assignThisAndNewObjectScope(uniqueObject);
        } else if (functionCall instanceof JReferencedMethodInvocationExpression) {
            JReferencedMethodInvocationExpression objectMethodInvocation = (JReferencedMethodInvocationExpression)functionCall;
            JSimpleDeclaration variableReference = objectMethodInvocation.getReferencedVariable().getDeclaration();
            String variableName = NameProvider.getInstance().getScopedVariableName(variableReference, callerFunctionName, newElement.getClassObjectScope());
            if (newElement.contains(variableName)) {
                newElement.assignThisAndNewObjectScope(newElement.getUniqueObjectFor(variableName));
            } else {
                newElement.assignThisAndNewObjectScope(NOT_IN_OBJECT_SCOPE);
            }
        } else {
            JMethodDeclaration decl = functionCall.getDeclaration();
            if (decl.isStatic()) {
                newElement.assignThisAndNewObjectScope(NOT_IN_OBJECT_SCOPE);
            } else {
                newElement.assignThisAndNewObjectScope(newElement.getUniqueObjectFor("this"));
            }
        }
        return newElement;
    }

    private RTTState handleAssumption(RTTState element, JExpression expression, CFAEdge cfaEdge, boolean truthAssumption) throws UnrecognizedCodeException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        String valueString = this.getExpressionValue(element, expression, functionName, cfaEdge);
        boolean value = Boolean.parseBoolean(valueString);
        if (valueString == null) {
            AssigningValueVisitor visitor = new AssigningValueVisitor(element, truthAssumption, functionName);
            expression.accept(visitor);
            return element;
        }
        if (truthAssumption && value || !truthAssumption && !value) {
            return element;
        }
        return null;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> elements, CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        return null;
    }

    public static int nextId() {
        return ++nextFreeId;
    }

    private static class ExpressionValueVisitor
    extends DefaultJExpressionVisitor<String, UnrecognizedCCodeException>
    implements JRightHandSideVisitor<String, UnrecognizedCCodeException> {
        protected final CFAEdge edge;
        protected final RTTState state;
        protected final String functionName;

        public ExpressionValueVisitor(CFAEdge pEdge, RTTState pElement, String pFunctionName) {
            this.edge = pEdge;
            this.state = pElement;
            this.functionName = pFunctionName;
        }

        @Override
        protected String visitDefault(JExpression pE) {
            return null;
        }

        @Override
        public String visit(JCastExpression pE) throws UnrecognizedCCodeException {
            return pE.getOperand().accept(this);
        }

        @Override
        public String visit(JCharLiteralExpression pPaCharLiteralExpression) throws UnrecognizedCCodeException {
            return "Character";
        }

        @Override
        public String visit(JStringLiteralExpression pPaStringLiteralExpression) throws UnrecognizedCCodeException {
            return "String";
        }

        @Override
        public String visit(JBinaryExpression binaryExpression) throws UnrecognizedCCodeException {
            JExpression leftOperand = binaryExpression.getOperand1();
            JExpression rightOperand = binaryExpression.getOperand2();
            if (this.isObjectComparison(binaryExpression)) {
                if (this.isEnum((JClassType)leftOperand.getExpressionType()) || this.isEnum((JClassType)rightOperand.getExpressionType())) {
                    return this.handleEnumComparison(leftOperand, rightOperand, binaryExpression.getOperator());
                }
                return this.handleObjectComparison(leftOperand, rightOperand, binaryExpression.getOperator());
            }
            return null;
        }

        private boolean isObjectComparison(JBinaryExpression pExpression) {
            JBinaryExpression.BinaryOperator operator = pExpression.getOperator();
            boolean isComparison = operator == JBinaryExpression.BinaryOperator.EQUALS || operator == JBinaryExpression.BinaryOperator.NOT_EQUALS;
            JExpression leftOperand = pExpression.getOperand1();
            JExpression rightOperand = pExpression.getOperand2();
            boolean isObject = leftOperand.getExpressionType() instanceof JClassType && rightOperand.getExpressionType() instanceof JClassType;
            return isComparison && isObject;
        }

        private boolean isEnum(JClassType pClassType) {
            List<JClassOrInterfaceType> superTypes = pClassType.getAllSuperTypesOfType();
            for (JClassOrInterfaceType currentType : superTypes) {
                if (!currentType.getName().equals(RTTTransferRelation.JAVA_ENUM_OBJECT_NAME)) continue;
                return false;
            }
            return true;
        }

        private String handleEnumComparison(JExpression operand1, JExpression operand2, JBinaryExpression.BinaryOperator operator) throws UnrecognizedCCodeException {
            String value1 = operand1.accept(this);
            String value2 = operand2.accept(this);
            if (this.state.getConstantsMap().containsValue(value1)) {
                value1 = this.state.getRunTimeClassOfUniqueObject(value1);
            }
            if (this.state.getConstantsMap().containsValue(value2)) {
                value2 = this.state.getRunTimeClassOfUniqueObject(value2);
            }
            if (value1 == null || value2 == null) {
                return null;
            }
            boolean result = value1.equals(value2);
            switch (operator) {
                case EQUALS: {
                    break;
                }
                case NOT_EQUALS: {
                    result = !result;
                    break;
                }
                default: {
                    throw new UnrecognizedCCodeException("unexpected enum comparison", this.edge);
                }
            }
            return Boolean.toString(result);
        }

        private String handleObjectComparison(JExpression pLeftOperand, JExpression pRightOperand, JBinaryExpression.BinaryOperator pOperator) throws UnrecognizedCCodeException {
            String value1 = pLeftOperand.accept(this);
            String value2 = pRightOperand.accept(this);
            boolean result = pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS ^ value1.equals(value2);
            return Boolean.toString(result);
        }

        @Override
        public String visit(JArrayCreationExpression pJArrayCreationExpression) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public String visit(JArraySubscriptExpression pAArraySubscriptExpression) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public String visit(JVariableRunTimeType vrtT) throws UnrecognizedCCodeException {
            JIdExpression expr = vrtT.getReferencedVariable();
            String uniqueObject = expr.accept(this);
            String runTimeClass = this.state.getRunTimeClassOfUniqueObject(uniqueObject);
            if (runTimeClass == null) {
                return null;
            }
            return runTimeClass;
        }

        @Override
        public String visit(JIdExpression idExpression) throws UnrecognizedCCodeException {
            if (idExpression.getDeclaration() == null) {
                return null;
            }
            NameProvider nameProvider = NameProvider.getInstance();
            JSimpleDeclaration declaration = idExpression.getDeclaration();
            if (idExpression instanceof JFieldAccess) {
                JFieldAccess fiExpr = (JFieldAccess)idExpression;
                JType type = fiExpr.getExpressionType();
                JIdExpression qualifier = fiExpr.getReferencedVariable();
                String uniqueQualifierObject = qualifier.accept(this);
                String variableName = nameProvider.getScopedVariableName(declaration, this.functionName, uniqueQualifierObject);
                if (type instanceof JClassOrInterfaceType && this.state.contains(variableName)) {
                    return this.state.getUniqueObjectFor(variableName);
                }
                return null;
            }
            JType type = idExpression.getExpressionType();
            String variableName = nameProvider.getScopedVariableName(declaration, this.functionName, this.state.getClassObjectScope());
            if (type instanceof JClassOrInterfaceType && this.state.contains(variableName)) {
                return this.state.getUniqueObjectFor(variableName);
            }
            return null;
        }

        @Override
        public String visit(JRunTimeTypeEqualsType jRunTimeTypeEqualsType) throws UnrecognizedCCodeException {
            String jrunTimeType = jRunTimeTypeEqualsType.getRunTimeTypeExpression().accept(this);
            if (jrunTimeType == null) {
                return null;
            }
            return Boolean.toString(jRunTimeTypeEqualsType.getTypeDef().getName().equals(jrunTimeType));
        }

        @Override
        public String visit(JClassInstanceCreation jClassInstanzeCreation) throws UnrecognizedCCodeException {
            return jClassInstanzeCreation.getExpressionType().getName();
        }

        @Override
        public String visit(JMethodInvocationExpression pAFunctionCallExpression) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public String visit(JThisExpression thisExpression) throws UnrecognizedCCodeException {
            if (this.state.contains("this")) {
                return this.state.getUniqueObjectFor("this");
            }
            return null;
        }

        @Override
        public String visit(JNullLiteralExpression pJNullLiteralExpression) throws UnrecognizedCCodeException {
            return RTTTransferRelation.NOT_IN_OBJECT_SCOPE;
        }

        @Override
        public String visit(JEnumConstantExpression e) throws UnrecognizedCCodeException {
            return e.getConstantName();
        }
    }

    private static class AssigningValueVisitor
    extends DefaultJExpressionVisitor<String, UnrecognizedCCodeException> {
        private final boolean truthAssumption;
        private final RTTState newState;
        private final String methodName;

        public AssigningValueVisitor(RTTState pNewState, boolean pTruthAssumption, String pMethodName) {
            this.truthAssumption = pTruthAssumption;
            this.newState = pNewState;
            this.methodName = pMethodName;
        }

        @Override
        public String visit(JVariableRunTimeType pE) throws UnrecognizedCCodeException {
            return NameProvider.getInstance().getScopedVariableName(pE.getReferencedVariable().getDeclaration(), this.methodName, this.newState.getKeywordThisUniqueObject());
        }

        @Override
        protected String visitDefault(JExpression pE) {
            return null;
        }

        @Override
        public String visit(JThisExpression thisExpression) throws UnrecognizedCCodeException {
            return "this";
        }

        @Override
        public String visit(JRunTimeTypeEqualsType pE) throws UnrecognizedCCodeException {
            JClassOrInterfaceType assignableType = pE.getTypeDef();
            String reference = pE.getRunTimeTypeExpression().accept(this);
            if (reference == null) {
                return null;
            }
            if (this.truthAssumption) {
                this.newState.assignAssumptionType(reference, assignableType);
            }
            return null;
        }
    }

    private static class FunctionExitValueVisitor
    extends ExpressionValueVisitor {
        public FunctionExitValueVisitor(CFAEdge pEdge, RTTState pElement, String pFunctionName) {
            super(pEdge, pElement, pFunctionName);
        }

        @Override
        public String visit(JThisExpression thisExp) throws UnrecognizedCCodeException {
            return thisExp.getExpressionType().getName();
        }
    }
}

