/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.seplogic;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.seplogic.interfaces.Handle;
import org.sosy_lab.cpachecker.cpa.seplogic.interfaces.PartingstarInterface;

public class SeplogicState
implements AbstractState,
Cloneable,
Targetable {
    private Handle heap;
    private boolean breakFlag;
    private Deque<String> namespaces = new ArrayDeque<String>();
    private Exception causeForError = null;
    private static int freshVarIndex = 0;

    public SeplogicState(Handle pHeap, Handle pMissing, Deque<String> namespaces) {
        this.heap = pHeap;
        this.namespaces = namespaces;
    }

    public SeplogicState(Handle pHeap) {
        this.heap = pHeap;
    }

    public SeplogicState(Handle pHeap, Deque<String> namespaces) {
        this.heap = pHeap;
        this.namespaces = namespaces;
    }

    public SeplogicState(Handle pHeap, Deque<String> pNamespaces, Exception pE) {
        this.heap = pHeap;
        this.namespaces = pNamespaces;
        this.causeForError = pE;
        this.breakFlag = true;
    }

    public Handle getHeap() {
        return this.heap;
    }

    public boolean entails(SeplogicState pOtherElement) {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return psInt.entails(this.heap, pOtherElement.heap);
    }

    public SeplogicState abstract_() {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        List<Handle> handles = psInt.abstract_(this.heap);
        if (handles.size() != 1) {
            throw new RuntimeException("Internal error, not exactly one abstraction result");
        }
        return new SeplogicState(handles.get(0), this.namespaces);
    }

    public SeplogicState performSpecificationAssignment(Handle pPre, Handle pPost, String ident) throws SeplogicQueryUnsuccessful {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return new SeplogicState(psInt.specAss(this.heap, pPre, pPost, ident), this.namespaces);
    }

    public Long extractExplicitValue(String varName) {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return psInt.extractExplicitValue(this.heap, varName);
    }

    public String toString() {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return psInt.repr(this.heap);
    }

    public SeplogicState freshenVariable(String pLeftVarName) {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return new SeplogicState(psInt.renameIdent(this.heap, pLeftVarName, this.makeFreshVar()), this.namespaces);
    }

    private String makeFreshVar() {
        return "_FRESH_" + freshVarIndex++;
    }

    public boolean doBreak() {
        return this.breakFlag;
    }

    public boolean isFalse() {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return this.causeForError != null || psInt.entails(this.heap, psInt.makeFalse());
    }

    public String getNamespace() {
        String namespace = this.namespaces.peek();
        if (namespace == null) {
            throw new NullPointerException();
        }
        return namespace;
    }

    public SeplogicState pushNamespace(String pString) {
        ArrayDeque<String> newNamespaces = new ArrayDeque<String>(this.namespaces);
        newNamespaces.push(pString);
        return new SeplogicState(this.heap, newNamespaces);
    }

    public SeplogicState popNamespace() {
        ArrayDeque<String> newNamespaces = new ArrayDeque<String>(this.namespaces);
        newNamespaces.pop();
        return new SeplogicState(this.heap, newNamespaces);
    }

    public Iterable<String> getNamespaces() {
        return this.namespaces;
    }

    public SeplogicState makeExceptionState(Exception e) {
        PartingstarInterface psInt = PartingstarInterface.getInstance();
        return new SeplogicState(psInt.makeEmp(), this.namespaces, e);
    }

    @Override
    public boolean isTarget() {
        return this.causeForError != null;
    }

    @Override
    public String getViolatedPropertyDescription() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isTarget());
        return "";
    }

    public static class SeplogicQueryUnsuccessful
    extends RuntimeException {
        private static final long serialVersionUID = 8201481945509804089L;
        private Boolean isPureGuard = null;

        public Boolean isPureGuard() {
            return this.isPureGuard;
        }

        public void setIsPureGuard(boolean pg) {
            this.isPureGuard = pg;
        }

        public SeplogicQueryUnsuccessful(String pString) {
            super(pString);
        }
    }
}

