/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.seplogic;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.seplogic.SeplogicCPA;
import org.sosy_lab.cpachecker.cpa.seplogic.SeplogicState;
import org.sosy_lab.cpachecker.cpa.seplogic.interfaces.Handle;
import org.sosy_lab.cpachecker.cpa.seplogic.interfaces.PartingstarInterface;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

public class SeplogicTransferRelation
extends SingleEdgeTransferRelation {
    boolean entryFunctionProcessed = false;
    long existentialVarIndex = 0L;
    private long namespaceCounter = 0L;
    private PartingstarInterface psInterface;
    static final String RETVAR = "$RET";
    private final LogManager logger;

    public SeplogicTransferRelation(SeplogicCPA cpa, LogManager pLogger) {
        this.psInterface = cpa.getPartingstarInterface();
        this.logger = pLogger;
    }

    private Handle makeFreshExistential() {
        return this.psInterface.makeVar(this.psInterface.loadString("_v" + this.existentialVarIndex++));
    }

    public Collection<SeplogicState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        SeplogicState successor;
        SeplogicState currentElement = (SeplogicState)element;
        try {
            switch (cfaEdge.getEdgeType()) {
                case DeclarationEdge: {
                    CDeclarationEdge declEdge = (CDeclarationEdge)cfaEdge;
                    successor = this.handleDeclaration(currentElement, cfaEdge, declEdge.getDeclaration().getName(), declEdge.getDeclaration().getType());
                    break;
                }
                case StatementEdge: {
                    successor = this.handleStatement(currentElement, ((CStatementEdge)cfaEdge).getStatement(), (CStatementEdge)cfaEdge);
                    break;
                }
                case ReturnStatementEdge: {
                    Optional<CExpression> expression = ((CReturnStatementEdge)cfaEdge).getExpression();
                    if (expression.isPresent()) {
                        successor = this.handleAssignment(currentElement, RETVAR, false, (CRightHandSide)expression.get(), cfaEdge);
                        break;
                    }
                    successor = currentElement;
                    break;
                }
                case AssumeEdge: {
                    AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                    successor = this.handleAssume(currentElement, (CExpression)assumeEdge.getExpression(), assumeEdge.getTruthAssumption(), assumeEdge);
                    break;
                }
                case FunctionCallEdge: {
                    successor = this.handleFunctionCall(currentElement, cfaEdge);
                    break;
                }
                case FunctionReturnEdge: {
                    FunctionReturnEdge returnEdge = (FunctionReturnEdge)cfaEdge;
                    FunctionSummaryEdge ctrEdge = returnEdge.getSuccessor().getEnteringSummaryEdge();
                    successor = this.handleReturnFromFunction(currentElement, (CFunctionCall)ctrEdge.getExpression(), ctrEdge);
                    break;
                }
                case BlankEdge: {
                    successor = currentElement;
                    break;
                }
                default: {
                    throw new UnrecognizedCFAEdgeException(cfaEdge);
                }
            }
        }
        catch (SeplogicState.SeplogicQueryUnsuccessful e) {
            if (e.isPureGuard() != null && e.isPureGuard().booleanValue()) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Pure guard failed (-> false) in CFA Edge: N" + cfaEdge.getPredecessor().getNodeNumber() + " -> N" + cfaEdge.getSuccessor().getNodeNumber());
                return Collections.emptySet();
            }
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Must be a null-dereference in CFA Edge: N" + cfaEdge.getPredecessor().getNodeNumber() + " -> N" + cfaEdge.getSuccessor().getNodeNumber());
            return Collections.singleton(currentElement.makeExceptionState(e));
        }
        if (successor.isFalse()) {
            this.logger.log(Level.WARNING, new Object[]{"Successor implies false in CFA Edge: N" + cfaEdge.getPredecessor().getNodeNumber() + " -> N" + cfaEdge.getSuccessor().getNodeNumber()});
            return Collections.emptySet();
        }
        if (!successor.doBreak()) {
            if (!cfaEdge.getSuccessor().isLoopStart()) {
                // empty if block
            }
            successor = successor.abstract_();
        }
        return Collections.singleton(successor);
    }

    private SeplogicState handleDeclaration(SeplogicState element, CFAEdge edge, String name, CType specifier) throws CPATransferException {
        if (name == null && (specifier instanceof CElaboratedType || specifier instanceof CCompositeType)) {
            return element;
        }
        if (name == null) {
            throw new UnrecognizedCCodeException("not expected in CIL", edge);
        }
        if (specifier instanceof CFunctionType) {
            return element;
        }
        if (specifier instanceof CCompositeType || specifier instanceof CElaboratedType || specifier instanceof CEnumType) {
            return element;
        }
        return element;
    }

    private SeplogicState handleAssume(SeplogicState element, CExpression expression, boolean isTrueBranch, AssumeEdge assumeEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        Handle a2;
        Handle a1;
        String varName;
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binaryExpression = (CBinaryExpression)expression;
            if (binaryExpression.getOperator() == CBinaryExpression.BinaryOperator.EQUALS) {
                return this.handleBinaryAssume(element, binaryExpression, isTrueBranch, assumeEdge);
            }
            if (binaryExpression.getOperator() == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
                return this.handleBinaryAssume(element, binaryExpression, !isTrueBranch, assumeEdge);
            }
            return element;
        }
        if (expression instanceof CUnaryExpression) {
            throw new UnrecognizedCCodeException("not expected in CIL", (CFAEdge)assumeEdge, expression);
        }
        if (expression instanceof CIdExpression) {
            varName = ((CIdExpression)expression).getName();
            a1 = this.makeVarArg(varName, element);
            a2 = this.makeIntegerConstant(0L);
        } else {
            if (expression instanceof CCastExpression) {
                return this.handleAssume(element, ((CCastExpression)expression).getOperand(), isTrueBranch, assumeEdge);
            }
            if (expression instanceof CPointerExpression) {
                varName = expression.toASTString();
                if (!isTrueBranch) {
                    return element;
                }
                a1 = this.makeVarArg(varName, element);
                a2 = this.makeIntegerConstant(0L);
                isTrueBranch = !isTrueBranch;
            } else {
                throw new UnrecognizedCCodeException("unsupported", assumeEdge);
            }
        }
        Handle f = isTrueBranch ? this.psInterface.makeEq(a1, a2) : this.psInterface.makeIneq(a1, a2);
        try {
            return element.performSpecificationAssignment(this.psInterface.makeEmp(), f, null);
        }
        catch (SeplogicState.SeplogicQueryUnsuccessful e) {
            e.setIsPureGuard(true);
            throw e;
        }
    }

    private String quoteVar(String varName, SeplogicState element) {
        return this.quoteVar(varName, element.getNamespace());
    }

    private String quoteVar(String varName, String localNamespace) {
        varName = localNamespace + "$" + varName;
        return varName.charAt(0) == '_' ? "ZZZ" + varName : varName;
    }

    private Handle makeVarArg(String varName, SeplogicState element) {
        return this.makeVarArg(varName, element.getNamespace());
    }

    private Handle makeVarArg(String varName, String localNamespace) {
        return this.psInterface.makeVar(this.psInterface.loadString(this.quoteVar(varName, localNamespace)));
    }

    private SeplogicState handleBinaryAssume(SeplogicState element, CBinaryExpression expression, boolean isTrueBranch, AssumeEdge assumeEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        CExpression leftOp = expression.getOperand1();
        CExpression rightOp = expression.getOperand2();
        Handle a1 = this.convertOperandToArgument(leftOp, element);
        Handle a2 = this.convertOperandToArgument(rightOp, element);
        Handle f = isTrueBranch ? this.psInterface.makeEq(a1, a2) : this.psInterface.makeIneq(a1, a2);
        try {
            return element.performSpecificationAssignment(this.psInterface.makeEmp(), f, null);
        }
        catch (SeplogicState.SeplogicQueryUnsuccessful e) {
            e.setIsPureGuard(true);
            throw e;
        }
    }

    private Handle convertOperandToArgument(CExpression pLeftOp, SeplogicState element) throws UnrecognizedCCodeException {
        if (pLeftOp instanceof CIntegerLiteralExpression) {
            return this.makeIntegerConstant(((CIntegerLiteralExpression)pLeftOp).getValue().longValue());
        }
        if (pLeftOp instanceof CIdExpression) {
            return this.makeVarArg(pLeftOp.toASTString(), element);
        }
        throw new UnrecognizedCCodeException("unsupported expression type", null, pLeftOp);
    }

    private SeplogicState handleFunctionCall(SeplogicState element, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        CFunctionEntryNode funcDefNode = (CFunctionEntryNode)cfaEdge.getSuccessor();
        String funcName = funcDefNode.getFunctionName();
        String nsName = funcName + this.namespaceCounter++;
        List<String> formalParameters = funcDefNode.getFunctionParameterNames();
        List<CExpression> actualParameters = ((CFunctionCallEdge)cfaEdge).getArguments();
        if (formalParameters != null && formalParameters.size() > 0 && !actualParameters.isEmpty()) {
            assert (formalParameters.size() == actualParameters.size());
            for (int i = 0; i < actualParameters.size(); ++i) {
                CExpression parameter = actualParameters.get(i);
                String formalParameter = formalParameters.get(i);
                element = this.handleAssignment(element, formalParameter, false, parameter, cfaEdge, nsName);
            }
        }
        return element.pushNamespace(nsName);
    }

    private SeplogicState handleReturnFromFunction(SeplogicState element, CFunctionCall expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        element = element.popNamespace();
        if (expression instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignExpression = (CFunctionCallAssignmentStatement)expression;
            CLeftHandSide leftOperand = assignExpression.getLeftHandSide();
            if (leftOperand instanceof CIdExpression) {
                throw new UnrecognizedCCodeException("unsupported", cfaEdge);
            }
            throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, assignExpression);
        }
        if (expression instanceof CFunctionCallStatement) {
            return element;
        }
        throw new UnrecognizedCCodeException("Unrecognized", cfaEdge);
    }

    private SeplogicState handleStatement(SeplogicState element, CStatement expression, CStatementEdge cfaEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        if (expression instanceof CFunctionCallStatement) {
            CFunctionCallExpression funcExpression = ((CFunctionCallStatement)expression).getFunctionCallExpression();
            String functionName = funcExpression.getFunctionNameExpression().toASTString();
            if (functionName.equals("free")) {
                return this.handleFree(element, funcExpression, cfaEdge);
            }
            if (functionName.equals("malloc")) {
                return element;
            }
            return element;
        }
        if (expression instanceof CAssignment) {
            return this.handleAssignmentStatement(element, (CAssignment)expression, cfaEdge);
        }
        throw new UnrecognizedCCodeException(expression.toASTString(), cfaEdge);
    }

    private SeplogicState handleFree(SeplogicState element, CFunctionCallExpression expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        List<CExpression> parameters = expression.getParameterExpressions();
        if (parameters.size() != 1) {
            throw new UnrecognizedCCodeException("Wrong number of arguments for free", cfaEdge, expression);
        }
        CExpression parameter = parameters.get(0);
        if (parameter instanceof CIdExpression) {
            String ident = ((CIdExpression)parameter).getName();
            return element.performSpecificationAssignment(this.makePointsTo(this.makeVarArg(ident, element), this.makeFreshExistential()), this.psInterface.makeEmp(), null);
        }
        throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, parameter);
    }

    private Handle makePointsTo(Handle pA1, Handle pA2) {
        return this.psInterface.makeSpatialPredicate(this.psInterface.loadString("NodeLL"), pA1, pA2);
    }

    private SeplogicState handleAssignmentStatement(SeplogicState element, CAssignment expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        boolean leftDereference;
        CExpression leftExpression = expression.getLeftHandSide();
        String leftVarName = null;
        if (leftExpression instanceof CIdExpression) {
            leftDereference = false;
            leftVarName = ((CIdExpression)leftExpression).getName();
        } else if (leftExpression instanceof CPointerExpression) {
            CPointerExpression ptrExpression = (CPointerExpression)leftExpression;
            leftDereference = true;
            leftExpression = ptrExpression.getOperand();
            if (leftExpression instanceof CCastExpression) {
                leftExpression = ((CCastExpression)leftExpression).getOperand();
            }
            if (!(leftExpression instanceof CIdExpression)) {
                throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, leftExpression);
            }
            leftVarName = leftExpression.toASTString();
        } else {
            throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, leftExpression);
        }
        CRightHandSide op2 = expression.getRightHandSide();
        return this.handleAssignment(element, leftVarName, leftDereference, op2, cfaEdge);
    }

    private SeplogicState handleAssignment(SeplogicState element, String leftVarName, boolean leftDereference, CRightHandSide expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        return this.handleAssignment(element, leftVarName, leftDereference, expression, cfaEdge, element.getNamespace());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SeplogicState handleAssignment(SeplogicState element, String leftVarName, boolean leftDereference, CRightHandSide expression, CFAEdge cfaEdge, String leftNamespace) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        Handle fPost;
        Handle fPre;
        String sVarName = null;
        boolean isPureGuard = false;
        if (expression instanceof CStringLiteralExpression) {
            if (leftDereference) {
                throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, expression);
            }
            fPre = this.psInterface.makeEmp();
            fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), this.makeFreshExistential());
            sVarName = leftVarName;
            isPureGuard = true;
        } else if (expression instanceof CLiteralExpression) {
            if (!(expression instanceof CIntegerLiteralExpression)) {
                throw new UnrecognizedCCodeException("unsupported literal", cfaEdge, expression);
            }
            long value = ((CIntegerLiteralExpression)expression).getValue().longValue();
            Handle rhsArg = this.makeIntegerConstant(value);
            if (leftDereference) {
                fPre = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), this.makeFreshExistential());
                fPost = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), rhsArg);
            } else {
                fPre = this.psInterface.makeEmp();
                fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), rhsArg);
                sVarName = leftVarName;
                isPureGuard = true;
            }
        } else if (expression instanceof CCastExpression) {
            CExpression operand = ((CCastExpression)expression).getOperand();
            Handle rhsArg = "0".equals(operand.toASTString()) ? this.psInterface.makeNil() : this.makeVarArg(operand.toASTString(), element);
            if (leftDereference) {
                fPre = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), this.makeFreshExistential());
                fPost = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), rhsArg);
            } else {
                fPre = this.psInterface.makeEmp();
                fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), rhsArg);
                sVarName = leftVarName;
                isPureGuard = true;
            }
        } else if (expression instanceof CFunctionCallExpression) {
            CFunctionCallExpression funcExpression = (CFunctionCallExpression)expression;
            String functionName = funcExpression.getFunctionNameExpression().toASTString();
            if (functionName.equals("malloc")) {
                return this.handleMalloc(element, leftVarName, leftDereference, funcExpression, cfaEdge);
            }
            fPre = this.psInterface.makeEmp();
            fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), this.makeFreshExistential());
            sVarName = leftVarName;
        } else if (expression instanceof CBinaryExpression) {
            CBinaryExpression binExpression = (CBinaryExpression)expression;
            CBinaryExpression.BinaryOperator typeOfOperator = binExpression.getOperator();
            CExpression op1 = binExpression.getOperand1();
            CExpression op2 = binExpression.getOperand2();
            if (op1 instanceof CCastExpression) {
                op1 = ((CCastExpression)op1).getOperand();
            }
            if (!(op1 instanceof CIdExpression)) throw new UnrecognizedCCodeException("unsupported", cfaEdge, expression);
            String rightName = ((CIdExpression)op1).getName();
            if (typeOfOperator != CBinaryExpression.BinaryOperator.PLUS && typeOfOperator != CBinaryExpression.BinaryOperator.MINUS) {
                throw new UnrecognizedCCodeException(binExpression.toASTString(), cfaEdge);
            }
            if (!(op2 instanceof CLiteralExpression)) {
                if (!(op2 instanceof CIdExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, op2);
                throw new UnrecognizedCCodeException("unsupported variable addition", cfaEdge, op2);
            }
            long offset = ((CIntegerLiteralExpression)op2).asLong();
            if (typeOfOperator == CBinaryExpression.BinaryOperator.MINUS) {
                offset = -offset;
            }
            fPre = this.psInterface.makeEmp();
            fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), this.psInterface.makePlus(this.makeVarArg(rightName, element), this.makeIntegerConstant(offset)));
            sVarName = leftVarName;
            isPureGuard = true;
        } else if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExpression = (CUnaryExpression)expression;
            CUnaryExpression.UnaryOperator op = unaryExpression.getOperator();
            if (op != CUnaryExpression.UnaryOperator.AMPER) {
                if (op != CUnaryExpression.UnaryOperator.MINUS) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, unaryExpression);
                throw new UnrecognizedCCodeException("unsupported", cfaEdge, expression);
            }
            Handle rhsArg = this.makeVarArg(unaryExpression.getOperand().toASTString(), element);
            if (leftDereference) {
                fPre = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), this.makeFreshExistential());
                fPost = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), rhsArg);
            } else {
                fPre = this.psInterface.makeEmp();
                fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), rhsArg);
                sVarName = leftVarName;
                isPureGuard = true;
            }
        } else if (expression instanceof CPointerExpression) {
            CPointerExpression ptrExpression = (CPointerExpression)expression;
            if ((expression = ptrExpression.getOperand()) instanceof CCastExpression) {
                expression = ((CCastExpression)expression).getOperand();
            }
            if (!(expression instanceof CIdExpression)) {
                throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, expression);
            }
            if (leftDereference) {
                throw new UnrecognizedCCodeException("unsupported", cfaEdge, expression);
            }
            Handle rhsArg = this.makeFreshExistential();
            fPre = this.makePointsTo(this.makeVarArg(expression.toASTString(), element), rhsArg);
            fPost = this.psInterface.makeStar(fPre, this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), rhsArg));
            sVarName = leftVarName;
        } else {
            if (!(expression instanceof CIdExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, expression);
            String rightName = ((CIdExpression)expression).getName();
            Handle lhsArg = this.makeVarArg(rightName, element);
            if (leftDereference) {
                fPre = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), this.makeFreshExistential());
                fPost = this.makePointsTo(this.makeVarArg(leftVarName, leftNamespace), lhsArg);
            } else {
                fPre = this.psInterface.makeEmp();
                fPost = this.psInterface.makeEq(this.psInterface.makeVar(this.psInterface.loadString(RETVAR)), lhsArg);
                sVarName = leftVarName;
                isPureGuard = true;
            }
        }
        try {
            String string;
            if (sVarName == null) {
                string = null;
                return element.performSpecificationAssignment(fPre, fPost, string);
            }
            string = this.quoteVar(sVarName, leftNamespace);
            return element.performSpecificationAssignment(fPre, fPost, string);
        }
        catch (SeplogicState.SeplogicQueryUnsuccessful e) {
            e.setIsPureGuard(isPureGuard);
            throw e;
        }
    }

    private SeplogicState handleMalloc(SeplogicState element, String pLeftVarName, boolean leftDereference, CFunctionCallExpression expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, SeplogicState.SeplogicQueryUnsuccessful {
        long size;
        List<CExpression> parameters = expression.getParameterExpressions();
        if (parameters.size() != 1) {
            throw new UnrecognizedCCodeException("Wrong number of arguments for malloc", cfaEdge, expression);
        }
        CExpression parameter = parameters.get(0);
        if (leftDereference) {
            throw new UnrecognizedCCodeException("unsupported", cfaEdge, expression);
        }
        if (parameter instanceof CLiteralExpression) {
            if (!(parameter instanceof CIntegerLiteralExpression)) {
                throw new UnrecognizedCCodeException("non-integers not supported", cfaEdge, parameter);
            }
            size = ((CIntegerLiteralExpression)parameter).asLong();
            if (size < 0L) {
                throw new UnrecognizedCCodeException("malloc with size < 0, but malloc takes unsigned parameter", cfaEdge, parameter);
            }
            if (size > Integer.MAX_VALUE) {
                throw new UnrecognizedCCodeException("Malloc too large", cfaEdge, expression);
            }
        } else if (parameter instanceof CIdExpression) {
            String varName = this.quoteVar(((CIdExpression)parameter).getName(), element);
            Long sizeLong = element.extractExplicitValue(varName);
            if (sizeLong == null) {
                throw new UnrecognizedCCodeException("Could not extract malloc size (no equalities found)", cfaEdge, expression);
            }
            size = sizeLong;
        } else {
            throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, parameter);
        }
        SeplogicState curElem = element.freshenVariable(this.quoteVar(pLeftVarName, element)).performSpecificationAssignment(this.psInterface.makeEmp(), this.makePointsTo(this.makeVarArg(pLeftVarName, element), this.makeFreshExistential()), null);
        int i = 8;
        while ((long)i < size) {
            curElem = curElem.performSpecificationAssignment(this.psInterface.makeEmp(), this.makePointsTo(this.psInterface.makePlus(this.makeVarArg(pLeftVarName, element), this.makeIntegerConstant(i)), this.makeFreshExistential()), null);
            i += 8;
        }
        return curElem;
    }

    private Handle makeIntegerConstant(long pL) {
        return this.psInterface.makeInt(this.psInterface.loadString("" + pL));
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> elements, CFAEdge cfaEdge, Precision precision) throws CPATransferException {
        return null;
    }
}

