/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.seplogic.interfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cpa.seplogic.SeplogicState;
import org.sosy_lab.cpachecker.cpa.seplogic.interfaces.Handle;

@Options(prefix="cpa.seplogic.partingstar")
public class PartingstarInterface {
    private Process psProcess;
    private LogManager logger;
    private static PartingstarInterface singleton = null;
    private Object syncSentinel = new Object();
    public static final String RETVAR = "$ret_1";
    private static final String LOAD_RULES = "LOAD_RULES";
    private static final String ENTAILS = "ENTAILS";
    private static final String FRAME = "FRAME";
    private static final String ABSTRACT = "ABSTRACT";
    private static final String STRING = "STRING";
    private static final String DEL = "DEL";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String STAR = "STAR";
    private static final String VAR = "VAR";
    private static final String INEQ = "INEQ";
    private static final String EQ = "EQ";
    private static final String SPRED = "SPRED";
    private static final String FALSE = "FALSE";
    private static final String EMP = "EMP";
    private static final String RENAMEIDENT = "RENAMEIDENT";
    private static final String EXTRACTVALUE = "EXTRACTVALUE";
    private static final String REPR = "REPR";
    private static final String INT = "INT";
    private static final String PLUS = "PLUS";
    private static final String MINUS = "MINUS";
    private static final String EXTRACTEQS = "EXTRACTEQS";
    private static final String NIL = "NIL";
    private static final String SPECASS = "SPECASS";
    private Timer creationTimer = new Timer();
    private Timer impTimer = new Timer();
    private Timer frameTimer = new Timer();
    private Timer specAssTimer = new Timer();
    private Timer abstractionTimer = new Timer();
    @Option(secure=true, name="pspath", required=true, description="path to partingstar command")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path psPath = null;
    @Option(secure=true, name="logicsfile", required=true, description="path to a file with logic rules")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path logicsFile = null;
    @Option(secure=true, name="abstractionfile", required=true, description="path to a file with abstraction rules")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path abstractionFile = null;

    public Timer getCreationTimer() {
        return this.creationTimer;
    }

    public Timer getImpTimer() {
        return this.impTimer;
    }

    public Timer getFrameTimer() {
        return this.frameTimer;
    }

    public Timer getSpecAssTimer() {
        return this.specAssTimer;
    }

    public Timer getAbstractionTimer() {
        return this.abstractionTimer;
    }

    private RuntimeException generateExc(String msg, Throwable e) {
        byte[] buffer = new byte[262144];
        try {
            this.psProcess.getErrorStream().read(buffer);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return new RuntimeException(msg + "\n\nDetail:\n" + new String(buffer), e);
    }

    private PartingstarInterface(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        config.inject((Object)this, PartingstarInterface.class);
        try {
            this.psProcess = this.createProcess();
            this.loadRules(this.logicsFile.toAbsolutePath().getPath(), false);
            this.loadRules(this.abstractionFile.toAbsolutePath().getPath(), true);
        }
        catch (IOException e) {
            throw this.generateExc("Could not start Partingstar process", e);
        }
    }

    private Process createProcess() throws IOException {
        return Runtime.getRuntime().exec(new String[]{this.psPath.toAbsolutePath().getPath()});
    }

    public void loadRules(String filename, boolean isAbs) throws IOException {
        this.singleCommand(LOAD_RULES, this.loadString(filename), this.loadString("" + (isAbs ? 1 : 0)));
    }

    public Handle makeAnd(Handle in1, Handle in2) {
        return this.safeSingleCommand(AND, in1, in2);
    }

    public Handle makeOr(Handle in1, Handle in2) {
        return this.safeSingleCommand(OR, in1, in2);
    }

    public Handle makeStar(Handle in1, Handle in2) {
        return this.safeSingleCommand(STAR, in1, in2);
    }

    public Handle makeVar(Handle in1) {
        return this.safeSingleCommand(VAR, in1);
    }

    public Handle makeInt(Handle in1) {
        return this.safeSingleCommand(INT, in1);
    }

    public Handle makeIneq(Handle in1, Handle in2) {
        return this.safeSingleCommand(INEQ, in1, in2);
    }

    public Handle makeEq(Handle in1, Handle in2) {
        return this.safeSingleCommand(EQ, in1, in2);
    }

    public Handle makePlus(Handle in1, Handle in2) {
        return this.safeSingleCommand(PLUS, in1, in2);
    }

    public Handle makeMinus(Handle in1, Handle in2) {
        return this.safeSingleCommand(MINUS, in1, in2);
    }

    public Handle makeNil() {
        return this.safeSingleCommand(NIL, new Handle[0]);
    }

    public Handle makeSpatialPredicate(Handle predName, Handle ... arguments) {
        Handle[] myArguments = new Handle[1 + arguments.length];
        myArguments[0] = predName;
        System.arraycopy(arguments, 0, myArguments, 1, arguments.length);
        return this.safeSingleCommand(SPRED, myArguments);
    }

    public Handle renameIdent(Handle h, String from, String to) {
        try {
            return this.singleCommand(RENAMEIDENT, h, this.loadString(from), this.loadString(to));
        }
        catch (IOException e) {
            throw this.generateExc("Error when renaming ident", e);
        }
    }

    public Long extractExplicitValue(Handle h, String pVarName) {
        try {
            return Long.parseLong(this.repr(this.singleCommand(EXTRACTVALUE, h, this.loadString(pVarName))));
        }
        catch (IOException e) {
            throw this.generateExc("Error when extracting explicit value", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String repr(Handle pHeap) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(REPR);
            sb.append(' ');
            sb.append(pHeap.toString());
            sb.append('\n');
            Object object = this.syncSentinel;
            synchronized (object) {
                this.writeToProcess(sb.toString().getBytes());
                return this.readUntilEnter();
            }
        }
        catch (IOException e) {
            throw this.generateExc("Error when fetching repr", e);
        }
    }

    public Handle makeEmp() {
        return this.safeSingleCommand(EMP, new Handle[0]);
    }

    public Handle makeFalse() {
        return this.safeSingleCommand(FALSE, new Handle[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle loadString(String str) {
        String ret;
        if (str == null) {
            return new PartingstarHandle(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(STRING);
        sb.append(' ');
        sb.append(str);
        sb.append('\n');
        try {
            Object object = this.syncSentinel;
            synchronized (object) {
                this.writeToProcess(sb.toString().getBytes());
                ret = this.readUntilEnter();
            }
        }
        catch (IOException e) {
            throw this.generateExc("Error when loading string", e);
        }
        return new PartingstarHandle(Integer.parseInt(ret));
    }

    public Handle extractEqs(Handle pHeap) {
        return this.safeSingleCommand(EXTRACTEQS, pHeap);
    }

    private Handle safeSingleCommand(String cmd, Handle ... arguments) {
        try {
            return this.singleCommand(cmd, arguments);
        }
        catch (IOException e) {
            throw this.generateExc("Error when performing command " + cmd, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handle singleCommand(String cmd, Handle ... arguments) throws IOException {
        String ret;
        StringBuilder sb = new StringBuilder();
        sb.append(cmd);
        sb.append(' ');
        for (Handle arg : arguments) {
            sb.append(arg.toString());
            sb.append(' ');
        }
        sb.append('\n');
        Object object = this.syncSentinel;
        synchronized (object) {
            this.writeToProcess(sb.toString().getBytes());
            ret = this.readUntilEnter();
        }
        return new PartingstarHandle(Integer.parseInt(ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Handle> listCommand(String cmd, Handle ... arguments) throws IOException {
        String[] strings;
        String ret;
        StringBuilder sb = new StringBuilder();
        sb.append(cmd);
        sb.append(' ');
        for (Handle arg : arguments) {
            sb.append(arg.toString());
            sb.append(' ');
        }
        sb.append('\n');
        Object len$ = this.syncSentinel;
        synchronized (len$) {
            this.writeToProcess(sb.toString().getBytes());
            ret = this.readUntilEnter();
        }
        ArrayList<Handle> retvals = new ArrayList<Handle>();
        if ("".equals(ret)) {
            return retvals;
        }
        for (String string : strings = ret.split(" ")) {
            retvals.add(new PartingstarHandle(Integer.parseInt(string)));
        }
        return retvals;
    }

    public static PartingstarInterface getInstance() {
        if (singleton == null) {
            throw new IllegalStateException("Partingstar Interface was not initialized correctly.");
        }
        return singleton;
    }

    public static void prepare(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        singleton = new PartingstarInterface(config, pLogger);
    }

    private void writeToProcess(byte[] data) throws IOException {
        this.logger.log(Level.FINER, new Object[]{"Query:\n", new String(data)});
        this.psProcess.getOutputStream().write(data);
        this.psProcess.getOutputStream().flush();
    }

    private int readFromProcess() throws IOException {
        int read = this.psProcess.getInputStream().read();
        if (read == -1) {
            throw new IOException("EOF?");
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entails(Handle formula1, Handle formula2) {
        Timer t = new Timer();
        this.impTimer.start();
        try {
            Handle holds;
            t.start();
            try {
                holds = this.singleCommand(ENTAILS, formula1, formula2);
            }
            catch (IOException e) {
                throw this.generateExc("I/O with partingstar failed", e);
            }
            t.stop();
            this.logger.log(Level.FINER, new Object[]{"Reply: " + (holds.isNonZero() ? "HOLDS" : "DOESNOTHOLD")});
            boolean bl = holds.isNonZero();
            return bl;
        }
        finally {
            this.impTimer.stop();
        }
    }

    public List<Handle> frame(Handle formula1, Handle formula2) {
        this.frameTimer.start();
        try {
            List<Handle> list = this.listCommand(FRAME, formula1, formula2);
            return list;
        }
        catch (IOException e) {
            throw this.generateExc("I/O with partingstar failed", e);
        }
        finally {
            this.frameTimer.stop();
        }
    }

    private List<String> readMultiple() throws IOException {
        ArrayList<String> retval = new ArrayList<String>();
        String read = "42";
        while (!read.trim().equals("END")) {
            read = this.readUntilEnter();
            retval.add(read);
        }
        retval.remove(retval.size() - 1);
        this.logger.log(Level.FINER, new Object[]{"Reply:\n", retval});
        return retval;
    }

    private String readUntilEnter() throws IOException {
        StringBuilder retval = new StringBuilder();
        int lastRead = 0;
        while ((lastRead = this.readFromProcess()) != 10) {
            retval.append((char)lastRead);
        }
        return retval.toString();
    }

    public List<Handle> abstract_(Handle formula1) {
        this.abstractionTimer.start();
        try {
            List<Handle> list = this.listCommand(ABSTRACT, formula1);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O with corestar failed", e);
        }
        finally {
            this.abstractionTimer.stop();
        }
    }

    public Handle specAss(Handle pHeap, Handle pPre, Handle pPost, String pIdent) {
        this.specAssTimer.start();
        try {
            Handle retval = this.singleCommand(SPECASS, pHeap, pPre, pPost, this.loadString(pIdent));
            if (!retval.isNonZero()) {
                throw new SeplogicState.SeplogicQueryUnsuccessful("Could not frame in spec ass");
            }
            Handle handle = retval;
            return handle;
        }
        catch (IOException e) {
            throw this.generateExc("I/O with partingstar failed", e);
        }
        finally {
            this.specAssTimer.stop();
        }
    }

    private class PartingstarHandle
    implements Handle {
        int handle;

        private PartingstarHandle(int handle) {
            this.handle = handle;
        }

        public String toString() {
            return this.handle + "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            String ret;
            StringBuilder sb = new StringBuilder();
            sb.append(PartingstarInterface.DEL);
            sb.append(' ');
            sb.append(this.handle);
            sb.append('\n');
            Object object = PartingstarInterface.this.syncSentinel;
            synchronized (object) {
                PartingstarInterface.this.writeToProcess(sb.toString().getBytes());
                ret = PartingstarInterface.this.readUntilEnter();
            }
            if (!"".equals(ret)) {
                throw PartingstarInterface.this.generateExc("Finalizer run into error: " + ret, null);
            }
        }

        @Override
        public boolean isNonZero() {
            return this.handle != 0;
        }
    }
}

