/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.sign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;

public enum SIGN implements Serializable
{
    EMPTY(0),
    PLUS(1),
    MINUS(2),
    ZERO(4),
    PLUSMINUS(3),
    PLUS0(5),
    MINUS0(6),
    ALL(7);

    private int numVal;
    private static final ImmutableMap<Integer, SIGN> VALUE_MAP;

    private SIGN(int numVal) {
        this.numVal = numVal;
    }

    public boolean isAll() {
        return this == ALL;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public SIGN combineWith(SIGN sign) {
        return (SIGN)VALUE_MAP.get((Object)(sign.numVal | this.numVal));
    }

    public boolean covers(SIGN sign) {
        return (sign.numVal | this.numVal) == this.numVal;
    }

    public boolean intersects(SIGN sign) {
        return (sign.numVal & this.numVal) != 0;
    }

    public static SIGN min(SIGN sign0, SIGN sign1) {
        if (sign0.isSubsetOf(sign1)) {
            return sign0;
        }
        return sign1;
    }

    public boolean isSubsetOf(SIGN sign) {
        if (sign.isAll()) {
            return true;
        }
        return sign.split().containsAll(this.split());
    }

    public ImmutableSet<SIGN> split() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SIGN s : ImmutableList.of((Object)PLUS, (Object)MINUS, (Object)ZERO)) {
            if ((s.numVal & this.numVal) <= 0) continue;
            builder.add((Object)s);
        }
        return builder.build();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SIGN s : SIGN.values()) {
            builder.put((Object)s.numVal, (Object)s);
        }
        VALUE_MAP = builder.build();
    }
}

