/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.sign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.cpa.sign.SignTransferRelation;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;

public class SignCExpressionVisitor
extends DefaultCExpressionVisitor<SIGN, UnrecognizedCodeException>
implements CRightHandSideVisitor<SIGN, UnrecognizedCodeException> {
    private CFAEdge edgeOfExpr;
    private SignState state;
    private SignTransferRelation transferRel;

    public SignCExpressionVisitor(CFAEdge pEdgeOfExpr, SignState pState, SignTransferRelation pTransferRel) {
        this.edgeOfExpr = pEdgeOfExpr;
        this.state = pState;
        this.transferRel = pTransferRel;
    }

    @Override
    public SIGN visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCodeException {
        if (pIastFunctionCallExpression.getExpressionType() instanceof CSimpleType || pIastFunctionCallExpression.getExpressionType() instanceof CTypedefType) {
            return SIGN.ALL;
        }
        return null;
    }

    @Override
    protected SIGN visitDefault(CExpression pExp) throws UnrecognizedCodeException {
        throw new UnrecognizedCodeException("unsupported code found", this.edgeOfExpr);
    }

    @Override
    public SIGN visit(CCastExpression e) throws UnrecognizedCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public SIGN visit(CFieldReference e) throws UnrecognizedCodeException {
        return this.state.getSignForVariable(this.transferRel.getScopedVariableName(e));
    }

    @Override
    public SIGN visit(CArraySubscriptExpression e) throws UnrecognizedCodeException {
        return SIGN.ALL;
    }

    @Override
    public SIGN visit(CIdExpression pIastIdExpression) throws UnrecognizedCodeException {
        return this.state.getSignForVariable(this.transferRel.getScopedVariableName(pIastIdExpression));
    }

    @Override
    public SIGN visit(CBinaryExpression pIastBinaryExpression) throws UnrecognizedCodeException {
        SIGN left = pIastBinaryExpression.getOperand1().accept(this);
        SIGN right = pIastBinaryExpression.getOperand2().accept(this);
        ImmutableSet<SIGN> leftAtomSigns = left.split();
        ImmutableSet<SIGN> rightAtomSigns = right.split();
        SIGN result = SIGN.EMPTY;
        for (List signCombi : Sets.cartesianProduct((List)ImmutableList.of(leftAtomSigns, rightAtomSigns))) {
            result = result.combineWith(this.evaluateExpression((SIGN)signCombi.get(0), pIastBinaryExpression, (SIGN)signCombi.get(1)));
        }
        return result;
    }

    private SIGN evaluateExpression(SIGN pLeft, CBinaryExpression pExp, SIGN pRight) throws UnsupportedCCodeException {
        SIGN result = SIGN.EMPTY;
        switch (pExp.getOperator()) {
            case PLUS: {
                result = this.evaluatePlusOperator(pLeft, pExp.getOperand1(), pRight, pExp.getOperand2());
                break;
            }
            case MINUS: {
                result = this.evaluateMinusOperator(pLeft, pRight, pExp.getOperand2());
                break;
            }
            case MULTIPLY: {
                result = this.evaluateMulOperator(pLeft, pRight);
                break;
            }
            case DIVIDE: {
                result = this.evaluateDivideOperator(pLeft, pRight);
                break;
            }
            case MODULO: {
                result = this.evaluateModuloOperator(pLeft, pRight);
                break;
            }
            case BINARY_AND: {
                result = this.evaluateAndOperator(pLeft, pRight);
                break;
            }
            default: {
                throw new UnsupportedCCodeException("Not supported", this.edgeOfExpr);
            }
        }
        return result;
    }

    @Override
    public SIGN visit(CFloatLiteralExpression pIastFloatLiteralExpression) throws UnrecognizedCodeException {
        BigDecimal value = pIastFloatLiteralExpression.getValue();
        int cResult = value.compareTo(BigDecimal.ZERO);
        if (cResult == 1) {
            return SIGN.PLUS;
        }
        if (cResult == -1) {
            return SIGN.MINUS;
        }
        return SIGN.ZERO;
    }

    @Override
    public SIGN visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) throws UnrecognizedCodeException {
        BigInteger value = pIastIntegerLiteralExpression.getValue();
        int cResult = value.compareTo(BigInteger.ZERO);
        if (cResult == 1) {
            return SIGN.PLUS;
        }
        if (cResult == -1) {
            return SIGN.MINUS;
        }
        return SIGN.ZERO;
    }

    @Override
    public SIGN visit(CStringLiteralExpression e) throws UnrecognizedCodeException {
        return SIGN.ALL;
    }

    @Override
    public SIGN visit(CCharLiteralExpression e) throws UnrecognizedCodeException {
        return SIGN.ALL;
    }

    @Override
    public SIGN visit(CUnaryExpression pIastUnaryExpression) throws UnrecognizedCodeException {
        switch (pIastUnaryExpression.getOperator()) {
            case MINUS: {
                SIGN result = SIGN.EMPTY;
                SIGN operandSign = pIastUnaryExpression.getOperand().accept(this);
                for (SIGN atomSign : operandSign.split()) {
                    result = result.combineWith(SignCExpressionVisitor.evaluateUnaryExpression(pIastUnaryExpression.getOperator(), atomSign));
                }
                return result;
            }
        }
        throw new UnsupportedCCodeException("Not supported", this.edgeOfExpr, pIastUnaryExpression);
    }

    private static SIGN evaluateUnaryExpression(CUnaryExpression.UnaryOperator operator, SIGN operand) {
        if (operand == SIGN.ZERO) {
            return SIGN.ZERO;
        }
        if (operator == CUnaryExpression.UnaryOperator.MINUS && operand == SIGN.PLUS) {
            return SIGN.MINUS;
        }
        return SIGN.PLUS;
    }

    private SIGN evaluatePlusOperator(SIGN pLeft, CExpression pLeftExp, SIGN pRight, CExpression pRightExp) {
        if (pLeft == SIGN.MINUS && pRightExp instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pRightExp).getValue().equals(BigInteger.ONE) || pLeftExp instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pLeftExp).getValue().equals(BigInteger.ONE) && pRight == SIGN.MINUS) {
            return SIGN.MINUS0;
        }
        if (pLeft == SIGN.PLUS0 && pRightExp instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pRightExp).getValue().equals(BigInteger.ONE) || pLeftExp instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pLeftExp).getValue().equals(BigInteger.ONE) && pRight == SIGN.PLUS0) {
            return SIGN.PLUS;
        }
        SIGN leftToRightResult = this.evaluateNonCommutativePlusOperator(pLeft, pRight);
        SIGN rightToLeftResult = this.evaluateNonCommutativePlusOperator(pRight, pLeft);
        return leftToRightResult.combineWith(rightToLeftResult);
    }

    private SIGN evaluateNonCommutativePlusOperator(SIGN pLeft, SIGN pRight) {
        if (pRight == SIGN.ZERO) {
            return pLeft;
        }
        if (pLeft == SIGN.PLUS && pRight == SIGN.MINUS) {
            return SIGN.ALL;
        }
        if (pLeft == SIGN.MINUS && pRight == SIGN.MINUS) {
            return SIGN.MINUS;
        }
        if (pLeft == SIGN.PLUS && pRight == SIGN.PLUS) {
            return SIGN.PLUS;
        }
        return SIGN.EMPTY;
    }

    private SIGN evaluateMinusOperator(SIGN pLeft, SIGN pRight, CExpression pRightExp) {
        if (pLeft == SIGN.PLUS && pRightExp instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pRightExp).getValue().equals(BigInteger.ONE)) {
            return SIGN.PLUS0;
        }
        if (pLeft == SIGN.MINUS0 && pRightExp instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pRightExp).getValue().equals(BigInteger.ONE)) {
            return SIGN.MINUS;
        }
        if (pRight == SIGN.ZERO) {
            return pLeft;
        }
        if (pLeft == SIGN.PLUS && pRight == SIGN.MINUS) {
            return SIGN.PLUS;
        }
        if (pLeft == SIGN.MINUS && pRight == SIGN.PLUS) {
            return SIGN.MINUS;
        }
        return SIGN.ALL;
    }

    private SIGN evaluateMulOperator(SIGN pLeft, SIGN pRight) {
        SIGN leftToRightResult = this.evaluateNonCommutativeMulOperator(pLeft, pRight);
        SIGN rightToLeftResult = this.evaluateNonCommutativeMulOperator(pRight, pLeft);
        return leftToRightResult.combineWith(rightToLeftResult);
    }

    private SIGN evaluateNonCommutativeMulOperator(SIGN left, SIGN right) {
        if (right == SIGN.ZERO) {
            return SIGN.ZERO;
        }
        if (left == SIGN.PLUS && right == SIGN.MINUS) {
            return SIGN.MINUS;
        }
        if (left == SIGN.PLUS && right == SIGN.PLUS || left == SIGN.MINUS && right == SIGN.MINUS) {
            return SIGN.PLUS;
        }
        return SIGN.EMPTY;
    }

    private SIGN evaluateDivideOperator(SIGN left, SIGN right) throws UnsupportedCCodeException {
        if (right == SIGN.ZERO) {
            this.transferRel.logger.log(Level.WARNING, new Object[]{"Possibly dividing by zero", this.edgeOfExpr});
            return SIGN.ALL;
        }
        return this.evaluateMulOperator(left, right);
    }

    private SIGN evaluateModuloOperator(SIGN pLeft, SIGN pRight) {
        if (pLeft == SIGN.ZERO) {
            return SIGN.ZERO;
        }
        if (pLeft == SIGN.PLUS && (pRight == SIGN.PLUS || pRight == SIGN.MINUS)) {
            return SIGN.PLUS0;
        }
        if (pLeft == SIGN.MINUS && (pRight == SIGN.MINUS || pRight == SIGN.PLUS)) {
            return SIGN.MINUS0;
        }
        return SIGN.ALL;
    }

    private SIGN evaluateAndOperator(SIGN left, SIGN right) {
        if (left == SIGN.ZERO || right == SIGN.ZERO) {
            return SIGN.ZERO;
        }
        if (left == SIGN.PLUS || right == SIGN.PLUS) {
            return SIGN.PLUS0;
        }
        if (left == SIGN.MINUS && right == SIGN.MINUS) {
            return SIGN.MINUS0;
        }
        return SIGN.EMPTY;
    }
}

