/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.sign;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CheckTypesOfStringsUtil;

public class SignState
implements Serializable,
LatticeAbstractState<SignState>,
AbstractQueryableState,
Graphable {
    private static final long serialVersionUID = -2507059869178203119L;
    private static final boolean DEBUG = false;
    private static final Splitter propertySplitter = Splitter.on((String)"<=").trimResults();
    private PersistentMap<String, SIGN> signMap;
    public static final SignState TOP = new SignState();
    private static final SerialProxySign proxy = new SerialProxySign();

    private SignState(PersistentMap<String, SIGN> pSignMap) {
        this.signMap = pSignMap;
    }

    private SignState() {
        this.signMap = PathCopyingPersistentTreeMap.of();
    }

    @Override
    public SignState join(SignState pToJoin) {
        if (pToJoin.equals(this)) {
            return pToJoin;
        }
        if (this.equals(TOP) || pToJoin.equals(TOP)) {
            return TOP;
        }
        if (this.isLessOrEqual(pToJoin)) {
            return pToJoin;
        }
        SignState result = TOP;
        PersistentSortedMap newMap = PathCopyingPersistentTreeMap.of();
        for (String varIdent : pToJoin.signMap.keySet()) {
            SIGN combined;
            if (!this.signMap.containsKey((Object)varIdent) || (combined = this.getSignForVariable(varIdent).combineWith(pToJoin.getSignForVariable(varIdent))).isAll()) continue;
            newMap = newMap.putAndCopy((Object)varIdent, (Object)combined);
        }
        return newMap.size() > 0 ? new SignState((PersistentMap<String, SIGN>)newMap) : result;
    }

    @Override
    public boolean isLessOrEqual(SignState pSuperset) {
        if (pSuperset.equals(this) || pSuperset.equals(TOP)) {
            return true;
        }
        if (this.signMap.size() < pSuperset.signMap.size()) {
            return false;
        }
        for (String varIdent : pSuperset.signMap.keySet()) {
            if (this.getSignForVariable(varIdent).isSubsetOf(pSuperset.getSignForVariable(varIdent))) continue;
            return false;
        }
        return true;
    }

    public SignState enterFunction(ImmutableMap<String, SIGN> pArguments) {
        PersistentMap newMap = this.signMap;
        for (String var : pArguments.keySet()) {
            if (((SIGN)pArguments.get((Object)var)).equals(SIGN.ALL)) continue;
            newMap = newMap.putAndCopy((Object)var, pArguments.get((Object)var));
        }
        return this.signMap == newMap ? this : new SignState(newMap);
    }

    public SignState leaveFunction(String pFunctionName) {
        PersistentMap newMap = this.signMap;
        for (String var : this.signMap.keySet()) {
            if (!var.startsWith(pFunctionName + "::")) continue;
            newMap = newMap.removeAndCopy((Object)var);
        }
        return newMap == this.signMap ? this : new SignState(newMap);
    }

    public SignState assignSignToVariable(String pVarIdent, SIGN sign) {
        if (sign.isAll()) {
            return this.signMap.containsKey((Object)pVarIdent) ? new SignState((PersistentMap<String, SIGN>)this.signMap.removeAndCopy((Object)pVarIdent)) : this;
        }
        return this.signMap.containsKey((Object)pVarIdent) && this.getSignForVariable(pVarIdent).equals(sign) ? this : new SignState((PersistentMap<String, SIGN>)this.signMap.putAndCopy((Object)pVarIdent, (Object)sign));
    }

    public SignState removeSignAssumptionOfVariable(String pVarIdent) {
        return this.assignSignToVariable(pVarIdent, SIGN.ALL);
    }

    public SIGN getSignForVariable(String pVarIdent) {
        return this.signMap.containsKey((Object)pVarIdent) ? (SIGN)this.signMap.get((Object)pVarIdent) : SIGN.ALL;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String delim = ", ";
        builder.append("[");
        String loopDelim = "";
        for (String key : this.signMap.keySet()) {
            if (key.matches("\\w*::__CPAchecker_TMP_\\w*") || key.endsWith("__func_ret__")) continue;
            builder.append(loopDelim);
            builder.append(key + "->" + this.getSignForVariable(key));
            loopDelim = delim;
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof SignState)) {
            return false;
        }
        return ((SignState)pObj).signMap.equals(this.signMap);
    }

    public int hashCode() {
        return this.signMap.hashCode();
    }

    private Object writeReplace() throws ObjectStreamException {
        if (this == TOP) {
            return proxy;
        }
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public String getCPAName() {
        return "SignAnalysis";
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        List parts = propertySplitter.splitToList((CharSequence)pProperty);
        if (parts.size() == 2) {
            if (CheckTypesOfStringsUtil.isSIGN((String)parts.get(0))) {
                SIGN value = SIGN.valueOf((String)parts.get(0));
                SIGN varName = this.getSignForVariable((String)parts.get(1));
                return varName.covers(value);
            }
            if (CheckTypesOfStringsUtil.isSIGN((String)parts.get(1))) {
                SIGN varName = this.getSignForVariable((String)parts.get(0));
                SIGN value = SIGN.valueOf((String)parts.get(1));
                return value.covers(varName);
            }
            SIGN varName1 = this.getSignForVariable((String)parts.get(0));
            SIGN varName2 = this.getSignForVariable((String)parts.get(1));
            return varName2.covers(varName1);
        }
        return false;
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("The modifying query " + pModification + " is an unsupported operation in " + this.getCPAName() + "!");
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(sb, this.signMap);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    private static class SerialProxySign
    implements Serializable {
        private static final long serialVersionUID = 2843708585446089623L;

        private Object readResolve() throws ObjectStreamException {
            return TOP;
        }
    }
}

