/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.sign;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.cpa.sign.SignCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class SignTransferRelation
extends ForwardingTransferRelation<SignState, SignState, SingletonPrecision> {
    LogManager logger;
    public static final String FUNC_RET_VAR = "__func_ret__";

    public SignTransferRelation(LogManager pLogger) {
        this.logger = pLogger;
    }

    public String getScopedVariableName(AExpression pVariableName) {
        return this.getScopedVariableName(pVariableName, this.functionName);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }

    @Override
    protected SignState handleReturnStatementEdge(CReturnStatementEdge pCfaEdge) throws CPATransferException {
        CExpression expression = (CExpression)pCfaEdge.getExpression().or((Object)CIntegerLiteralExpression.ZERO);
        String assignedVar = this.getScopedVariableNameForNonGlobalVariable(FUNC_RET_VAR, this.functionName);
        return this.handleAssignmentToVariable((SignState)this.state, assignedVar, expression);
    }

    @Override
    protected SignState handleFunctionCallEdge(FunctionCallEdge pCfaEdge, List<? extends AExpression> pArguments, List<? extends AParameterDeclaration> pParameters, String pCalledFunctionName) throws CPATransferException {
        if (!pCfaEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) assert (pParameters.size() == pArguments.size());
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (int i = 0; i < pParameters.size(); ++i) {
            AExpression exp = pArguments.get(i);
            if (!(exp instanceof CRightHandSide)) {
                throw new UnrecognizedCodeException("Unsupported code found", pCfaEdge);
            }
            String scopedVarId = this.getScopedVariableNameForNonGlobalVariable(pParameters.get(i).getName(), pCalledFunctionName);
            mapBuilder.put((Object)scopedVarId, (Object)((CRightHandSide)((Object)exp)).accept(new SignCExpressionVisitor(this.edge, (SignState)this.state, this)));
        }
        ImmutableMap argumentMap = mapBuilder.build();
        this.logger.log(Level.FINE, new Object[]{"Entering function " + pCalledFunctionName + " with arguments " + argumentMap});
        return ((SignState)this.state).enterFunction((ImmutableMap<String, SIGN>)argumentMap);
    }

    @Override
    protected SignState handleFunctionReturnEdge(FunctionReturnEdge pCfaEdge, FunctionSummaryEdge pFnkCall, AFunctionCall pSummaryExpr, String pCallerFunctionName) throws CPATransferException {
        if (pSummaryExpr instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement assignStmt = (AFunctionCallAssignmentStatement)pSummaryExpr;
            ALeftHandSide leftSide = assignStmt.getLeftHandSide();
            if (!(leftSide instanceof AIdExpression)) {
                throw new UnrecognizedCodeException("Unsupported code found", pCfaEdge);
            }
            String returnVarName = this.getScopedVariableNameForNonGlobalVariable(FUNC_RET_VAR, this.functionName);
            String assignedVarName = this.getScopedVariableName(leftSide, pCallerFunctionName);
            this.logger.log(Level.FINE, new Object[]{"Leave function " + this.functionName + " with return assignment: " + assignedVarName + " = " + ((SignState)this.state).getSignForVariable(returnVarName)});
            SignState result = ((SignState)this.state).leaveFunction(this.functionName).assignSignToVariable(assignedVarName, ((SignState)this.state).getSignForVariable(returnVarName));
            return result;
        }
        if (pSummaryExpr instanceof AFunctionCallStatement) {
            this.logger.log(Level.FINE, new Object[]{"Leave function " + this.functionName});
            return ((SignState)this.state).removeSignAssumptionOfVariable(this.getScopedVariableNameForNonGlobalVariable(FUNC_RET_VAR, this.functionName)).leaveFunction(this.functionName);
        }
        throw new UnrecognizedCodeException("Unsupported code found", pCfaEdge);
    }

    private CBinaryExpression.BinaryOperator negateComparisonOperator(CBinaryExpression.BinaryOperator pOp) {
        switch (pOp) {
            case LESS_THAN: {
                return CBinaryExpression.BinaryOperator.GREATER_EQUAL;
            }
            case LESS_EQUAL: {
                return CBinaryExpression.BinaryOperator.GREATER_THAN;
            }
            case GREATER_THAN: {
                return CBinaryExpression.BinaryOperator.LESS_EQUAL;
            }
            case GREATER_EQUAL: {
                return CBinaryExpression.BinaryOperator.LESS_THAN;
            }
            case EQUALS: {
                return CBinaryExpression.BinaryOperator.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return CBinaryExpression.BinaryOperator.EQUALS;
            }
        }
        throw new IllegalArgumentException("Cannot negate given operator");
    }

    private Optional<IdentifierValuePair> evaluateAssumption(CBinaryExpression pAssumeExp, boolean truthAssumption, CFAEdge pCFAEdge) {
        SIGN resultSign;
        Optional<CExpression> optStrongestId = this.getStrongestIdentifier(pAssumeExp, pCFAEdge);
        if (!optStrongestId.isPresent()) {
            return Optional.absent();
        }
        CExpression strongestId = (CExpression)optStrongestId.get();
        this.logger.log(Level.FINER, new Object[]{"Filtered strongest identifier " + strongestId + " from assume expression" + pAssumeExp});
        CExpression refinementExpression = this.getRefinementExpression(strongestId, pAssumeExp);
        CBinaryExpression.BinaryOperator resultOp = !truthAssumption ? this.negateComparisonOperator(pAssumeExp.getOperator()) : pAssumeExp.getOperator();
        try {
            resultSign = refinementExpression.accept(new SignCExpressionVisitor(pCFAEdge, (SignState)this.state, this));
        }
        catch (UnrecognizedCodeException e) {
            return Optional.absent();
        }
        return this.evaluateAssumption(strongestId, resultOp, resultSign, this.isLeftOperand(strongestId, pAssumeExp));
    }

    private boolean isLeftOperand(CExpression pExp, CBinaryExpression pBinExp) {
        if (pExp == pBinExp.getOperand1()) {
            return true;
        }
        if (pExp == pBinExp.getOperand2()) {
            return false;
        }
        throw new IllegalArgumentException("Argument pExp is not part of pBinExp");
    }

    private Optional<IdentifierValuePair> evaluateAssumption(CExpression pIdExp, CBinaryExpression.BinaryOperator pOp, SIGN pResultSign, boolean pIdentIsLeft) {
        boolean equalZero = false;
        switch (pOp) {
            case GREATER_EQUAL: {
                equalZero = pResultSign.covers(SIGN.ZERO);
            }
            case GREATER_THAN: {
                if (pIdentIsLeft) {
                    if (!SIGN.PLUS0.covers(pResultSign)) break;
                    return Optional.of((Object)new IdentifierValuePair(pIdExp, equalZero ? SIGN.PLUS0 : SIGN.PLUS));
                }
                if (!SIGN.MINUS0.covers(pResultSign)) break;
                return Optional.of((Object)new IdentifierValuePair(pIdExp, equalZero ? SIGN.MINUS0 : SIGN.MINUS));
            }
            case LESS_EQUAL: {
                equalZero = pResultSign.covers(SIGN.ZERO);
            }
            case LESS_THAN: {
                if (pIdentIsLeft) {
                    if (!SIGN.MINUS0.covers(pResultSign)) break;
                    return Optional.of((Object)new IdentifierValuePair(pIdExp, equalZero ? SIGN.MINUS0 : SIGN.MINUS));
                }
                if (!SIGN.PLUS0.covers(pResultSign)) break;
                return Optional.of((Object)new IdentifierValuePair(pIdExp, equalZero ? SIGN.PLUS0 : SIGN.PLUS));
            }
            case EQUALS: {
                return Optional.of((Object)new IdentifierValuePair(pIdExp, pResultSign));
            }
            case NOT_EQUALS: {
                if (pResultSign != SIGN.ZERO) break;
                return Optional.of((Object)new IdentifierValuePair(pIdExp, SIGN.PLUSMINUS));
            }
        }
        return Optional.absent();
    }

    private CExpression getRefinementExpression(CExpression pStrongestIdent, CBinaryExpression pBinExp) {
        if (pStrongestIdent == pBinExp.getOperand1()) {
            return pBinExp.getOperand2();
        }
        if (pStrongestIdent == pBinExp.getOperand2()) {
            return pBinExp.getOperand1();
        }
        throw new IllegalArgumentException("Strongest identifier is not part of binary expression");
    }

    private List<CExpression> filterIdentifier(CBinaryExpression pAssumeExp) {
        ArrayList<CExpression> result = new ArrayList<CExpression>();
        if (pAssumeExp.getOperand1() instanceof CIdExpression || pAssumeExp.getOperand1() instanceof CFieldReference) {
            result.add(pAssumeExp.getOperand1());
        }
        if (pAssumeExp.getOperand2() instanceof CIdExpression || pAssumeExp.getOperand2() instanceof CFieldReference) {
            result.add(pAssumeExp.getOperand2());
        }
        return result;
    }

    private Optional<CExpression> getStrongestIdentifier(CBinaryExpression pAssumeExp, CFAEdge pCFAEdge) {
        List<CExpression> result = this.filterIdentifier(pAssumeExp);
        if (result.isEmpty()) {
            return Optional.absent();
        }
        if (result.size() == 1) {
            return Optional.of((Object)result.get(0));
        }
        try {
            SIGN leftResultSign = result.get(0).accept(new SignCExpressionVisitor(pCFAEdge, (SignState)this.state, this));
            SIGN rightResultSign = result.get(1).accept(new SignCExpressionVisitor(pCFAEdge, (SignState)this.state, this));
            if (leftResultSign.covers(rightResultSign)) {
                return Optional.of((Object)result.get(0));
            }
            return Optional.of((Object)result.get(1));
        }
        catch (UnrecognizedCodeException ex) {
            return Optional.absent();
        }
    }

    @Override
    protected SignState handleAssumption(CAssumeEdge pCfaEdge, CExpression pExpression, boolean pTruthAssumption) throws CPATransferException {
        if (!(pExpression instanceof CBinaryExpression)) {
            return (SignState)this.state;
        }
        Optional<IdentifierValuePair> result = this.evaluateAssumption((CBinaryExpression)pExpression, pTruthAssumption, pCfaEdge);
        if (result.isPresent()) {
            this.logger.log(Level.FINE, new Object[]{"Assumption: " + (pTruthAssumption ? pExpression : "!(" + pExpression + ")") + " --> " + ((IdentifierValuePair)result.get()).identifier + " = " + ((IdentifierValuePair)result.get()).value});
            if (((SignState)this.state).getSignForVariable(this.getScopedVariableName(((IdentifierValuePair)result.get()).identifier)).covers(((IdentifierValuePair)result.get()).value)) {
                return ((SignState)this.state).assignSignToVariable(this.getScopedVariableName(((IdentifierValuePair)result.get()).identifier), ((IdentifierValuePair)result.get()).value);
            }
            if (!((IdentifierValuePair)result.get()).value.intersects(((SignState)this.state).getSignForVariable(this.getScopedVariableName(((IdentifierValuePair)result.get()).identifier)))) {
                return null;
            }
        }
        return (SignState)this.state;
    }

    @Override
    protected SignState handleDeclarationEdge(ADeclarationEdge pCfaEdge, ADeclaration pDecl) throws CPATransferException {
        if (!(pDecl instanceof AVariableDeclaration)) {
            return (SignState)this.state;
        }
        AVariableDeclaration decl = (AVariableDeclaration)pDecl;
        String scopedId = decl.isGlobal() ? decl.getName() : this.getScopedVariableNameForNonGlobalVariable(decl.getName(), this.functionName);
        AInitializer init = decl.getInitializer();
        this.logger.log(Level.FINE, new Object[]{"Declaration: " + scopedId});
        if (init instanceof AInitializerExpression) {
            return this.handleAssignmentToVariable((SignState)this.state, scopedId, ((AInitializerExpression)init).getExpression());
        }
        return ((SignState)this.state).assignSignToVariable(scopedId, SIGN.ALL);
    }

    @Override
    protected SignState handleStatementEdge(AStatementEdge pCfaEdge, AStatement pStatement) throws CPATransferException {
        if (pStatement instanceof AAssignment) {
            return this.handleAssignment((AAssignment)((Object)pStatement));
        }
        if (pStatement instanceof AExpressionStatement) {
            return (SignState)this.state;
        }
        if (pStatement instanceof AFunctionCallStatement) {
            return (SignState)this.state;
        }
        throw new UnrecognizedCodeException("only assignments are supported at this time", this.edge);
    }

    private SignState handleAssignment(AAssignment pAssignExpr) throws CPATransferException {
        ALeftHandSide left = pAssignExpr.getLeftHandSide();
        if (left instanceof AIdExpression) {
            if (!(left.getExpressionType() instanceof CSimpleType) && !(left.getExpressionType() instanceof CTypedefType)) {
                return (SignState)this.state;
            }
            String scopedId = this.getScopedVariableName(left, this.functionName);
            return this.handleAssignmentToVariable((SignState)this.state, scopedId, pAssignExpr.getRightHandSide());
        }
        if (left instanceof CFieldReference) {
            String scopedId = this.getScopedVariableName(left, this.functionName);
            return this.handleAssignmentToVariable((SignState)this.state, scopedId, pAssignExpr.getRightHandSide());
        }
        throw new UnrecognizedCodeException("left operand has to be an id expression", this.edge);
    }

    private SignState handleAssignmentToVariable(SignState pState, String pVarIdent, ARightHandSide pRightExpr) throws CPATransferException {
        if (pRightExpr instanceof CRightHandSide) {
            CRightHandSide right = (CRightHandSide)pRightExpr;
            SIGN result = right.accept(new SignCExpressionVisitor(this.edge, pState, this));
            this.logger.log(Level.FINE, new Object[]{"Assignment: " + pVarIdent + " = " + result});
            return pState.assignSignToVariable(pVarIdent, result);
        }
        throw new UnrecognizedCodeException("unhandled righthandside expression", this.edge);
    }

    private String getScopedVariableName(AExpression pVariableName, String pCalledFunctionName) {
        if (SignTransferRelation.isGlobal(pVariableName)) {
            return pVariableName.toASTString();
        }
        return pCalledFunctionName + "::" + pVariableName.toASTString();
    }

    private String getScopedVariableNameForNonGlobalVariable(String pVariableName, String pCallFunctionName) {
        return pCallFunctionName + "::" + pVariableName;
    }

    private static class IdentifierValuePair {
        CExpression identifier;
        SIGN value;

        public IdentifierValuePair(CExpression pIdentifier, SIGN pValue) {
            this.identifier = pIdentifier;
            this.value = pValue;
        }
    }
}

