/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

class CLangSMGConsistencyVerifier {
    private CLangSMGConsistencyVerifier() {
    }

    private static boolean verifyCLangSMGProperty(boolean pResult, LogManager pLogger, String pMessage) {
        pLogger.log(Level.FINEST, new Object[]{pMessage, ":", pResult});
        return pResult;
    }

    private static boolean verifyDisjunctHeapAndGlobal(LogManager pLogger, CLangSMG pSmg) {
        Map<String, SMGRegion> globals = pSmg.getGlobalObjects();
        Set<SMGObject> heap = pSmg.getHeapObjects();
        boolean toReturn = Collections.disjoint(globals.values(), heap);
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent, heap and global objects are not disjoint"});
        }
        return toReturn;
    }

    private static boolean verifyDisjunctHeapAndStack(LogManager pLogger, CLangSMG pSmg) {
        ArrayDeque<CLangStackFrame> stack_frames = pSmg.getStackFrames();
        HashSet<SMGObject> stack = new HashSet<SMGObject>();
        for (CLangStackFrame frame : stack_frames) {
            stack.addAll(frame.getAllObjects());
        }
        Set<SMGObject> heap = pSmg.getHeapObjects();
        boolean toReturn = Collections.disjoint(stack, heap);
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent, heap and stack objects are not disjoint: " + Sets.intersection(stack, heap)});
        }
        return toReturn;
    }

    private static boolean verifyDisjunctGlobalAndStack(LogManager pLogger, CLangSMG pSmg) {
        ArrayDeque<CLangStackFrame> stack_frames = pSmg.getStackFrames();
        HashSet<SMGObject> stack = new HashSet<SMGObject>();
        for (CLangStackFrame frame : stack_frames) {
            stack.addAll(frame.getAllObjects());
        }
        Map<String, SMGRegion> globals = pSmg.getGlobalObjects();
        boolean toReturn = Collections.disjoint(stack, globals.values());
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent, global and stack objects are not disjoint"});
        }
        return toReturn;
    }

    private static boolean verifyStackGlobalHeapUnion(LogManager pLogger, CLangSMG pSmg) {
        boolean toReturn;
        HashSet<SMGObject> object_union = new HashSet<SMGObject>();
        object_union.addAll(pSmg.getHeapObjects());
        object_union.addAll(pSmg.getGlobalObjects().values());
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            object_union.addAll(frame.getAllObjects());
        }
        boolean bl = toReturn = object_union.containsAll(pSmg.getObjects()) && pSmg.getObjects().containsAll(object_union);
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: union of stack, heap and global object is not the same set as the set of SMG objects"});
        }
        return toReturn;
    }

    private static boolean verifyNullObjectCLangProperties(LogManager pLogger, CLangSMG pSmg) {
        for (SMGObject sMGObject : pSmg.getGlobalObjects().values()) {
            if (sMGObject.notNull()) continue;
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: null object in global object set [" + sMGObject + "]"});
            return false;
        }
        SMGObject firstNull = null;
        for (SMGObject obj : pSmg.getHeapObjects()) {
            if (obj.notNull()) continue;
            if (firstNull != null) {
                pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: second null object in heap object set [first=" + firstNull + ", second=" + obj + "]"});
                return false;
            }
            firstNull = obj;
        }
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            for (SMGObject obj : frame.getAllObjects()) {
                if (obj.notNull()) continue;
                pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: null object in stack object set [" + obj + "]"});
                return false;
            }
        }
        if (firstNull == null) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: no null object"});
            return false;
        }
        return true;
    }

    private static boolean verifyGlobalNamespace(LogManager pLogger, CLangSMG pSmg) {
        Map<String, SMGRegion> globals = pSmg.getGlobalObjects();
        for (String label : pSmg.getGlobalObjects().keySet()) {
            String globalLabel = globals.get(label).getLabel();
            if (globalLabel.equals(label)) continue;
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: label [" + label + "] points to an object with label [" + pSmg.getGlobalObjects().get(label).getLabel() + "]"});
            return false;
        }
        return true;
    }

    private static boolean verifyStackNamespaces(LogManager pLogger, CLangSMG pSmg) {
        HashSet<SMGObject> stack_objects = new HashSet<SMGObject>();
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            for (SMGObject object : frame.getAllObjects()) {
                if (stack_objects.contains(object)) {
                    pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: object [" + object + "] present multiple times in the stack"});
                    return false;
                }
                stack_objects.add(object);
            }
        }
        return true;
    }

    public static boolean verifyCLangSMG(LogManager pLogger, CLangSMG pSmg) {
        boolean toReturn = SMGConsistencyVerifier.verifySMG(pLogger, pSmg);
        pLogger.log(Level.FINEST, new Object[]{"Starting constistency check of a CLangSMG"});
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctHeapAndGlobal(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: heap and global object sets are disjunt");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctHeapAndStack(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: heap and stack objects are disjunct");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctGlobalAndStack(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: global and stack objects are disjunct");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyStackGlobalHeapUnion(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: global, stack and heap object union contains all objects in SMG");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyNullObjectCLangProperties(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: null object invariants hold");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyGlobalNamespace(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: global namespace problem");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyStackNamespaces(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: stack namespace");
        pLogger.log(Level.FINEST, new Object[]{"Ending consistency check of a CLangSMG"});
        return toReturn;
    }
}

