/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class CLangSMGTest {
    private static final CFunctionType functionType = CFunctionType.functionTypeWithReturnType(CNumericTypes.UNSIGNED_LONG_INT);
    private static final CFunctionDeclaration functionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "foo", (List<CParameterDeclaration>)ImmutableList.of());
    private CLangStackFrame sf;
    private static final LogManager logger = TestLogManager.getInstance();
    private static final CIdExpression id_expression = new CIdExpression(FileLocation.DUMMY, null, "label", null);

    private static CLangSMG getNewCLangSMG64() {
        return new CLangSMG(MachineModel.LINUX64);
    }

    @Before
    public void setUp() {
        this.sf = new CLangStackFrame(functionDeclaration, MachineModel.LINUX64);
        CLangSMG.setPerformChecks(true, logger);
    }

    @Test
    public void CLangSMGConstructorTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Assert.assertEquals((long)0L, (long)smg.getStackFrames().size());
        Assert.assertEquals((long)1L, (long)smg.getHeapObjects().size());
        Assert.assertEquals((long)0L, (long)smg.getGlobalObjects().size());
        SMGRegion obj1 = new SMGRegion(8, "obj1");
        SMGRegion obj2 = new SMGRegion(8, "obj2");
        Integer val1 = 1;
        Integer val2 = 2;
        SMGEdgePointsTo pt = new SMGEdgePointsTo(val1, obj1, 0);
        SMGEdgeHasValue hv = new SMGEdgeHasValue(CNumericTypes.UNSIGNED_LONG_INT, 0, (SMGObject)obj2, (int)val2);
        smg.addValue(val1);
        smg.addValue(val2);
        smg.addHeapObject(obj1);
        smg.addGlobalObject(obj2);
        smg.addPointsToEdge(pt);
        smg.addHasValueEdge(hv);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        CLangSMG smg_copy = new CLangSMG(smg);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg_copy));
        Assert.assertEquals((long)0L, (long)smg_copy.getStackFrames().size());
        Assert.assertEquals((long)2L, (long)smg_copy.getHeapObjects().size());
        Assert.assertEquals((long)1L, (long)smg_copy.getGlobalObjects().size());
        Assert.assertEquals((Object)obj1, (Object)smg_copy.getObjectPointedBy(val1));
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(obj2);
        Assert.assertEquals((Object)hv, (Object)Iterables.getOnlyElement(smg_copy.getHVEdges(filter)));
    }

    @Test
    public void CLangSMGaddHeapObjectTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion obj2 = new SMGRegion(8, "label");
        smg.addHeapObject(obj1);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        Set<SMGObject> heap_objs = smg.getHeapObjects();
        Assert.assertTrue((boolean)heap_objs.contains(obj1));
        Assert.assertFalse((boolean)heap_objs.contains(obj2));
        Assert.assertTrue((heap_objs.size() == 2 ? 1 : 0) != 0);
        smg.addHeapObject(obj2);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        heap_objs = smg.getHeapObjects();
        Assert.assertTrue((boolean)heap_objs.contains(obj1));
        Assert.assertTrue((boolean)heap_objs.contains(obj2));
        Assert.assertEquals((long)heap_objs.size(), (long)3L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddHeapObjectTwiceTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(8, "label");
        smg.addHeapObject(obj);
        smg.addHeapObject(obj);
    }

    @Test
    public void CLangSMGaddHeapObjectTwiceWithoutChecksTest() {
        CLangSMG.setPerformChecks(false, logger);
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(8, "label");
        smg.addHeapObject(obj);
        smg.addHeapObject(obj);
        Assert.assertTrue((String)"Asserting the test finished without exception", (boolean)true);
    }

    @Test
    public void CLangSMGaddGlobalObjectTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion obj2 = new SMGRegion(8, "another_label");
        smg.addGlobalObject(obj1);
        Map<String, SMGRegion> global_objects = smg.getGlobalObjects();
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        Assert.assertEquals((long)global_objects.size(), (long)1L);
        Assert.assertTrue((boolean)global_objects.values().contains(obj1));
        smg.addGlobalObject(obj2);
        global_objects = smg.getGlobalObjects();
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        Assert.assertEquals((long)global_objects.size(), (long)2L);
        Assert.assertTrue((boolean)global_objects.values().contains(obj1));
        Assert.assertTrue((boolean)global_objects.values().contains(obj2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddGlobalObjectTwiceTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(8, "label");
        smg.addGlobalObject(obj);
        smg.addGlobalObject(obj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddGlobalObjectWithSameLabelTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion obj2 = new SMGRegion(16, "label");
        smg.addGlobalObject(obj1);
        smg.addGlobalObject(obj2);
    }

    @Test
    public void CLangSMGaddStackObjectTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion diffobj1 = new SMGRegion(8, "difflabel");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        CLangStackFrame current_frame = smg.getStackFrames().peek();
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        Assert.assertEquals((Object)current_frame.getVariable("label"), (Object)obj1);
        Assert.assertEquals((long)current_frame.getVariables().size(), (long)1L);
        smg.addStackObject(diffobj1);
        current_frame = smg.getStackFrames().peek();
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        Assert.assertEquals((Object)current_frame.getVariable("label"), (Object)obj1);
        Assert.assertEquals((Object)current_frame.getVariable("difflabel"), (Object)diffobj1);
        Assert.assertEquals((long)current_frame.getVariables().size(), (long)2L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddStackObjectTwiceTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        smg.addStackObject(obj1);
    }

    @Test
    public void CLangSMGgetObjectForVisibleVariableTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion obj2 = new SMGRegion(16, "label");
        SMGRegion obj3 = new SMGRegion(32, "label");
        Assert.assertNull((Object)smg.getObjectForVisibleVariable(id_expression.getName()));
        smg.addGlobalObject(obj3);
        Assert.assertEquals((Object)smg.getObjectForVisibleVariable(id_expression.getName()), (Object)obj3);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        Assert.assertEquals((Object)smg.getObjectForVisibleVariable(id_expression.getName()), (Object)obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj2);
        Assert.assertEquals((Object)smg.getObjectForVisibleVariable(id_expression.getName()), (Object)obj2);
        Assert.assertNotEquals((Object)smg.getObjectForVisibleVariable(id_expression.getName()), (Object)obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Assert.assertEquals((Object)smg.getObjectForVisibleVariable(id_expression.getName()), (Object)obj3);
        Assert.assertNotEquals((Object)smg.getObjectForVisibleVariable(id_expression.getName()), (Object)obj2);
    }

    @Test
    public void CLangSMGgetStackFramesTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Assert.assertEquals((long)smg.getStackFrames().size(), (long)0L);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(new SMGRegion(8, "frame1_1"));
        smg.addStackObject(new SMGRegion(8, "frame1_2"));
        smg.addStackObject(new SMGRegion(8, "frame1_3"));
        Assert.assertEquals((long)smg.getStackFrames().size(), (long)1L);
        Assert.assertEquals((long)smg.getStackFrames().peek().getVariables().size(), (long)3L);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(new SMGRegion(8, "frame2_1"));
        smg.addStackObject(new SMGRegion(8, "frame2_2"));
        Assert.assertEquals((long)smg.getStackFrames().size(), (long)2L);
        Assert.assertEquals((long)smg.getStackFrames().peek().getVariables().size(), (long)2L);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(new SMGRegion(8, "frame3_1"));
        Assert.assertEquals((long)smg.getStackFrames().size(), (long)3L);
        Assert.assertEquals((long)smg.getStackFrames().peek().getVariables().size(), (long)1L);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Assert.assertEquals((long)smg.getStackFrames().size(), (long)4L);
        Assert.assertEquals((long)smg.getStackFrames().peek().getVariables().size(), (long)0L);
    }

    @Test
    public void CLangSMGgetHeapObjectsTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Assert.assertEquals((long)smg.getHeapObjects().size(), (long)1L);
        smg.addHeapObject(new SMGRegion(8, "heap1"));
        Assert.assertEquals((long)smg.getHeapObjects().size(), (long)2L);
        smg.addHeapObject(new SMGRegion(8, "heap2"));
        smg.addHeapObject(new SMGRegion(8, "heap3"));
        Assert.assertEquals((long)smg.getHeapObjects().size(), (long)4L);
    }

    @Test
    public void CLangSMGgetGlobalObjectsTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Assert.assertEquals((long)smg.getGlobalObjects().size(), (long)0L);
        smg.addGlobalObject(new SMGRegion(8, "heap1"));
        Assert.assertEquals((long)smg.getGlobalObjects().size(), (long)1L);
        smg.addGlobalObject(new SMGRegion(8, "heap2"));
        smg.addGlobalObject(new SMGRegion(8, "heap3"));
        Assert.assertEquals((long)smg.getGlobalObjects().size(), (long)3L);
    }

    @Test
    public void CLangSMGmemoryLeaksTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Assert.assertFalse((boolean)smg.hasMemoryLeaks());
        smg.setMemoryLeak();
        Assert.assertTrue((boolean)smg.hasMemoryLeaks());
    }

    @Test
    public void consistencyViolationDisjunctnessTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(8, "label");
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addHeapObject(obj);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addGlobalObject(obj);
        Assert.assertFalse((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg = CLangSMGTest.getNewCLangSMG64();
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addHeapObject(obj);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addStackObject(obj);
        Assert.assertFalse((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg = CLangSMGTest.getNewCLangSMG64();
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addGlobalObject(obj);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addStackObject(obj);
        Assert.assertFalse((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
    }

    @Test
    public void consistencyViolationUnionTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        SMGRegion stack_obj = new SMGRegion(8, "stack_variable");
        SMGRegion heap_obj = new SMGRegion(8, "heap_object");
        SMGRegion global_obj = new SMGRegion(8, "global_variable");
        SMGRegion dummy_obj = new SMGRegion(8, "dummy_object");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addStackObject(stack_obj);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addGlobalObject(global_obj);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addHeapObject(heap_obj);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addObject(dummy_obj);
        Assert.assertFalse((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
    }

    @Test
    public void consistencyViolationNullTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        smg = CLangSMGTest.getNewCLangSMG64();
        SMGObject null_object = smg.getHeapObjects().iterator().next();
        Integer some_value = 5;
        SMGEdgeHasValue edge = new SMGEdgeHasValue((CType)Mockito.mock(CType.class), 0, null_object, (int)some_value);
        smg.addValue(some_value);
        smg.addHasValueEdge(edge);
        Assert.assertFalse((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
    }

    @Test
    public void consistencyViolationStackNamespaceTest1() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        Assert.assertFalse((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
    }

    @Test
    public void consistencyViolationStackNamespaceTest2() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion obj2 = new SMGRegion(16, "label");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj2);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
    }

    @Test
    public void consistencyViolationStackNamespaceTest3() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(8, "label");
        SMGRegion obj2 = new SMGRegion(16, "label");
        smg.addGlobalObject(obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj2);
        Assert.assertTrue((boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg));
    }
}

