/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public final class CLangStackFrame {
    static final String RETVAL_LABEL = "___cpa_temp_result_var_";
    private final CFunctionDeclaration stack_function;
    final HashMap<String, SMGRegion> stack_variables = new HashMap();
    final SMGRegion returnValueObject;

    public CLangStackFrame(CFunctionDeclaration pDeclaration, MachineModel pMachineModel) {
        this.stack_function = pDeclaration;
        CType returnType = pDeclaration.getType().getReturnType().getCanonicalType();
        if (returnType instanceof CVoidType) {
            this.returnValueObject = null;
        } else {
            int return_value_size = pMachineModel.getSizeof(returnType);
            this.returnValueObject = new SMGRegion(return_value_size, RETVAL_LABEL);
        }
    }

    public CLangStackFrame(CLangStackFrame pFrame) {
        this.stack_function = pFrame.stack_function;
        this.stack_variables.putAll(pFrame.stack_variables);
        this.returnValueObject = pFrame.returnValueObject;
    }

    public void addStackVariable(String pVariableName, SMGRegion pObject) {
        if (this.stack_variables.containsKey(pVariableName)) {
            throw new IllegalArgumentException("Stack frame for function '" + this.stack_function.toASTString() + "' already contains a variable '" + pVariableName + "'");
        }
        this.stack_variables.put(pVariableName, pObject);
    }

    public String toString() {
        StringBuilder to_return = new StringBuilder("<");
        for (String key : this.stack_variables.keySet()) {
            to_return.append(" ").append(this.stack_variables.get(key));
        }
        to_return.append(" >");
        return to_return.toString();
    }

    public SMGRegion getVariable(String pName) {
        SMGRegion to_return = this.stack_variables.get(pName);
        if (to_return == null) {
            throw new NoSuchElementException("No variable with name '" + pName + "' in stack frame for function '" + this.stack_function.toASTString() + "'");
        }
        return to_return;
    }

    public boolean containsVariable(String pName) {
        return this.stack_variables.containsKey(pName);
    }

    public CFunctionDeclaration getFunctionDeclaration() {
        return this.stack_function;
    }

    public Map<String, SMGRegion> getVariables() {
        return Collections.unmodifiableMap(this.stack_variables);
    }

    public Set<SMGObject> getAllObjects() {
        HashSet<SMGRegion> retset = new HashSet<SMGRegion>();
        retset.addAll(this.stack_variables.values());
        if (this.returnValueObject != null) {
            retset.add(this.returnValueObject);
        }
        return Collections.unmodifiableSet(retset);
    }

    public SMGRegion getReturnObject() {
        return this.returnValueObject;
    }
}

