/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.NeqRelation;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;

public class SMG {
    private final HashSet<SMGObject> objects = new HashSet();
    private final HashSet<Integer> values = new HashSet();
    private final HashSet<SMGEdgeHasValue> hv_edges = new HashSet();
    private final HashMap<Integer, SMGEdgePointsTo> pt_edges = new HashMap();
    private final HashMap<SMGObject, Boolean> object_validity = new HashMap();
    private final NeqRelation neq = new NeqRelation();
    private final MachineModel machine_model;
    private static final SMGObject nullObject = SMGObject.getNullObject();
    private static final int nullAddress = 0;

    public SMG(MachineModel pMachineModel) {
        SMGEdgePointsTo nullPointer = new SMGEdgePointsTo(0, nullObject, 0);
        this.addObject(nullObject);
        this.object_validity.put(nullObject, false);
        this.addValue(0);
        this.addPointsToEdge(nullPointer);
        this.machine_model = pMachineModel;
    }

    public SMG(SMG pHeap) {
        this.objects.addAll(pHeap.objects);
        this.values.addAll(pHeap.values);
        this.hv_edges.addAll(pHeap.hv_edges);
        this.pt_edges.putAll(pHeap.pt_edges);
        this.object_validity.putAll(pHeap.object_validity);
        this.machine_model = pHeap.machine_model;
        this.neq.putAll(pHeap.neq);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hv_edges == null ? 0 : this.hv_edges.hashCode());
        result = 31 * result + (this.machine_model == null ? 0 : this.machine_model.hashCode());
        result = 31 * result + (this.neq == null ? 0 : this.neq.hashCode());
        result = 31 * result + (this.object_validity == null ? 0 : this.object_validity.hashCode());
        result = 31 * result + (this.objects == null ? 0 : this.objects.hashCode());
        result = 31 * result + (this.pt_edges == null ? 0 : this.pt_edges.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SMG other = (SMG)obj;
        if (this.hv_edges == null ? other.hv_edges != null : !this.hv_edges.equals(other.hv_edges)) {
            return false;
        }
        if (this.machine_model != other.machine_model) {
            return false;
        }
        if (this.neq == null ? other.neq != null : !this.neq.equals(other.neq)) {
            return false;
        }
        if (this.object_validity == null ? other.object_validity != null : !this.object_validity.equals(other.object_validity)) {
            return false;
        }
        if (this.objects == null ? other.objects != null : !this.objects.equals(other.objects)) {
            return false;
        }
        if (this.pt_edges == null ? other.pt_edges != null : !this.pt_edges.equals(other.pt_edges)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public final void addObject(SMGObject pObj) {
        this.addObject(pObj, true);
    }

    public final void removeValue(Integer pValue) {
        this.values.remove(pValue);
        this.neq.removeValue(pValue);
    }

    public final void removeObject(SMGObject pObj) {
        this.objects.remove(pObj);
        this.object_validity.remove(pObj);
    }

    public final void removeObjectAndEdges(SMGObject pObj) {
        this.removeObject(pObj);
        Iterator<SMGEdgeHasValue> hv_iter = this.hv_edges.iterator();
        Iterator<SMGEdgePointsTo> pt_iter = this.pt_edges.values().iterator();
        while (hv_iter.hasNext()) {
            if (hv_iter.next().getObject() != pObj) continue;
            hv_iter.remove();
        }
        while (pt_iter.hasNext()) {
            if (pt_iter.next().getObject() != pObj) continue;
            pt_iter.remove();
        }
    }

    public final void addObject(SMGObject pObj, boolean pValidity) {
        this.objects.add(pObj);
        this.object_validity.put(pObj, pValidity);
    }

    public final void addValue(Integer pValue) {
        this.values.add(pValue);
    }

    public final void addPointsToEdge(SMGEdgePointsTo pEdge) {
        this.pt_edges.put(pEdge.getValue(), pEdge);
    }

    public final void addHasValueEdge(SMGEdgeHasValue pEdge) {
        this.hv_edges.add(pEdge);
    }

    public final void removeHasValueEdge(SMGEdgeHasValue pEdge) {
        this.hv_edges.remove(pEdge);
    }

    public final void removePointsToEdge(int pValue) {
        this.pt_edges.remove(pValue);
    }

    public void setValidity(SMGObject pObject, boolean pValidity) {
        if (!this.objects.contains(pObject)) {
            throw new IllegalArgumentException("Object [" + pObject + "] not in SMG");
        }
        this.object_validity.put(pObject, pValidity);
    }

    public void replaceHVSet(Set<SMGEdgeHasValue> pNewHV) {
        this.hv_edges.clear();
        this.hv_edges.addAll(pNewHV);
    }

    public void addNeqRelation(Integer pV1, Integer pV2) {
        this.neq.add_relation(pV1, pV2);
    }

    public final SMGObject getNullObject() {
        return nullObject;
    }

    public final int getNullValue() {
        return 0;
    }

    public final String valuesToString() {
        return "values=" + this.values.toString();
    }

    public final String hvToString() {
        return "hasValue=" + this.hv_edges.toString();
    }

    public final String ptToString() {
        return "pointsTo=" + this.pt_edges.toString();
    }

    public final Set<Integer> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public final Set<SMGObject> getObjects() {
        return Collections.unmodifiableSet(this.objects);
    }

    public final Set<SMGEdgeHasValue> getHVEdges() {
        return Collections.unmodifiableSet(this.hv_edges);
    }

    public final Set<SMGEdgeHasValue> getHVEdges(SMGEdgeHasValueFilter pFilter) {
        return Collections.unmodifiableSet(pFilter.filterSet(this.hv_edges));
    }

    public final Map<Integer, SMGEdgePointsTo> getPTEdges() {
        return Collections.unmodifiableMap(this.pt_edges);
    }

    public final SMGObject getObjectPointedBy(Integer pValue) {
        if (!this.values.contains(pValue)) {
            throw new IllegalArgumentException("Value [" + pValue + "] not in SMG");
        }
        if (this.pt_edges.containsKey(pValue)) {
            return this.pt_edges.get(pValue).getObject();
        }
        return null;
    }

    public final boolean isObjectValid(SMGObject pObject) {
        if (!this.objects.contains(pObject)) {
            throw new IllegalArgumentException("Object [" + pObject + "] not in SMG");
        }
        return this.object_validity.get(pObject);
    }

    public final MachineModel getMachineModel() {
        return this.machine_model;
    }

    public BitSet getNullBytesForObject(SMGObject pObj) {
        BitSet bs = new BitSet(pObj.getSize());
        bs.clear();
        SMGEdgeHasValueFilter objectFilter = SMGEdgeHasValueFilter.objectFilter(pObj).filterHavingValue(this.getNullValue());
        for (SMGEdgeHasValue edge : this.getHVEdges(objectFilter)) {
            bs.set(edge.getOffset(), edge.getOffset() + edge.getSizeInBytes(this.machine_model));
        }
        return bs;
    }

    public boolean isPointer(Integer value) {
        return this.pt_edges.containsKey(value);
    }

    public SMGEdgePointsTo getPointer(Integer value) {
        return this.pt_edges.get(value);
    }

    public boolean isCoveredByNullifiedBlocks(SMGEdgeHasValue pEdge) {
        return this.isCoveredByNullifiedBlocks(pEdge.getObject(), pEdge.getOffset(), pEdge.getSizeInBytes(this.machine_model));
    }

    public boolean isCoveredByNullifiedBlocks(SMGObject pObject, int pOffset, CType pType) {
        return this.isCoveredByNullifiedBlocks(pObject, pOffset, this.machine_model.getSizeof(pType));
    }

    private boolean isCoveredByNullifiedBlocks(SMGObject pObject, int pOffset, int size) {
        BitSet objectNullBytes = this.getNullBytesForObject(pObject);
        int expectedMinClear = pOffset + size;
        return objectNullBytes.nextClearBit(pOffset) >= expectedMinClear;
    }

    public void mergeValues(int pV1, int pV2) {
        if (pV1 == pV2) {
            return;
        }
        if (pV2 == 0) {
            int tmp = pV1;
            pV1 = pV2;
            pV2 = tmp;
        }
        this.neq.mergeValues(pV1, pV2);
        this.removeValue(pV2);
        HashSet<SMGEdgeHasValue> new_hv_edges = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValue hv : this.hv_edges) {
            if (hv.getValue() != pV2) {
                new_hv_edges.add(hv);
                continue;
            }
            new_hv_edges.add(new SMGEdgeHasValue(hv.getType(), hv.getOffset(), hv.getObject(), pV1));
        }
        this.hv_edges.clear();
        this.hv_edges.addAll(new_hv_edges);
    }

    public boolean haveNeqRelation(Integer pV1, Integer pV2) {
        return this.neq.neq_exists(pV1, pV2);
    }

    public Set<Integer> getNeqsForValue(Integer pV) {
        return this.neq.getNeqsForValue(pV);
    }
}

