/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class SMGAbstractionManagerTest {
    private CLangSMG smg;

    @Before
    public void setUp() {
        this.smg = new CLangSMG(MachineModel.LINUX64);
        SMGRegion globalVar = new SMGRegion(8, "pointer");
        SMGRegion next = null;
        for (int i = 0; i < 20; ++i) {
            SMGEdgeHasValue hv;
            SMGRegion node = new SMGRegion(16, "node " + i);
            this.smg.addHeapObject(node);
            if (next != null) {
                int address = SMGValueFactory.getNewValue();
                SMGEdgePointsTo pt = new SMGEdgePointsTo(address, next, 0);
                hv = new SMGEdgeHasValue(CPointerType.POINTER_TO_VOID, 8, (SMGObject)node, address);
                this.smg.addValue(address);
                this.smg.addPointsToEdge(pt);
            } else {
                hv = new SMGEdgeHasValue(16, 0, (SMGObject)node, 0);
            }
            this.smg.addHasValueEdge(hv);
            next = node;
        }
        int address = SMGValueFactory.getNewValue();
        SMGEdgeHasValue hv = new SMGEdgeHasValue(CPointerType.POINTER_TO_VOID, 8, (SMGObject)globalVar, address);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(address, next, 0);
        this.smg.addGlobalObject(globalVar);
        this.smg.addValue(address);
        this.smg.addPointsToEdge(pt);
        this.smg.addHasValueEdge(hv);
    }

    @Test
    public void testExecute() {
        SMGAbstractionManager manager = new SMGAbstractionManager(this.smg);
        CLangSMG afterAbstraction = manager.execute();
        SMGRegion globalVar = afterAbstraction.getObjectForVisibleVariable("pointer");
        Set<SMGEdgeHasValue> hvs = afterAbstraction.getHVEdges(SMGEdgeHasValueFilter.objectFilter(globalVar));
        Assert.assertEquals((long)1L, (long)hvs.size());
        SMGEdgeHasValue hv = (SMGEdgeHasValue)Iterables.getOnlyElement(hvs);
        SMGEdgePointsTo pt = afterAbstraction.getPointer(hv.getValue());
        SMGObject segment = pt.getObject();
        Assert.assertTrue((boolean)segment.isAbstract());
        Set<SMGObject> heap = afterAbstraction.getHeapObjects();
        Assert.assertEquals((long)2L, (long)heap.size());
    }
}

