/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableListIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class SMGConcreteErrorPathAllocator {
    private final LogManager logger;
    private MemoryName memoryName = new MemoryName(){

        @Override
        public String getMemoryName(CRightHandSide pExp, Address pAddress) {
            return "SMG_Analysis_Heap";
        }
    };

    public SMGConcreteErrorPathAllocator(LogManager pLogger) {
        this.logger = pLogger;
    }

    public ConcreteStatePath allocateAssignmentsToPath(ARGPath pPath) {
        ArrayList<Pair<SMGState, CFAEdge>> path = new ArrayList<Pair<SMGState, CFAEdge>>(pPath.size());
        ARGPath.PathIterator it = pPath.pathIterator();
        while (it.hasNext()) {
            it.advance();
            SMGState state = AbstractStates.extractStateByType(it.getAbstractState(), SMGState.class);
            CFAEdge edge = it.getIncomingEdge();
            if (state == null) {
                return null;
            }
            path.add((Pair<SMGState, CFAEdge>)Pair.of((Object)state, (Object)edge));
        }
        return this.createConcreteStatePath(path);
    }

    public Model allocateAssignmentsToPath(List<Pair<SMGState, CFAEdge>> pPath, MachineModel pMachineModel) throws InterruptedException {
        pPath.remove(pPath.size() - 1);
        ConcreteStatePath concreteStatePath = this.createConcreteStatePath(pPath);
        CFAPathWithAssumptions pathWithAssignments = CFAPathWithAssumptions.of(concreteStatePath, this.logger, pMachineModel);
        Model model = Model.empty();
        return model.withAssignmentInformation(pathWithAssignments);
    }

    private ConcreteStatePath createConcreteStatePath(List<Pair<SMGState, CFAEdge>> pPath) {
        ArrayList<ConcreteStatePath.ConcerteStatePathNode> result = new ArrayList<ConcreteStatePath.ConcerteStatePathNode>(pPath.size());
        SMGObjectAddressMap variableAddresses = new SMGObjectAddressMap();
        for (Pair<SMGState, CFAEdge> edgeStatePair : pPath) {
            ConcreteStatePath.ConcerteStatePathNode node;
            SMGState pSMGState = (SMGState)edgeStatePair.getFirst();
            CFAEdge edge = (CFAEdge)edgeStatePair.getSecond();
            if (edge.getEdgeType() == CFAEdgeType.MultiEdge) {
                node = this.createMultiEdge(pSMGState, (MultiEdge)edge, variableAddresses);
            } else {
                ConcreteState concreteState = this.createConcreteState(pSMGState, variableAddresses);
                node = ConcreteStatePath.valueOfPathNode(concreteState, edge);
            }
            result.add(node);
        }
        return new ConcreteStatePath(result);
    }

    private ConcreteStatePath.ConcerteStatePathNode createMultiEdge(SMGState pSMGState, MultiEdge multiEdge, SMGObjectAddressMap pVariableAddresses) {
        int size = multiEdge.getEdges().size();
        ConcreteState[] singleConcreteStates = new ConcreteState[size];
        UnmodifiableListIterator iterator = multiEdge.getEdges().listIterator(size);
        HashSet<CLeftHandSide> alreadyAssigned = new HashSet<CLeftHandSide>();
        int index = size - 1;
        while (iterator.hasPrevious()) {
            CFAEdge cfaEdge = (CFAEdge)iterator.previous();
            ConcreteState state = this.allValuesForLeftHandSideKnown(cfaEdge, alreadyAssigned) ? this.createConcreteState(pSMGState, pVariableAddresses) : ConcreteState.empty();
            singleConcreteStates[index] = state;
            this.addLeftHandSide(cfaEdge, alreadyAssigned);
            --index;
        }
        return ConcreteStatePath.valueOfPathNode(Arrays.asList(singleConcreteStates), multiEdge);
    }

    private boolean allValuesForLeftHandSideKnown(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        if (pCfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.isDeclarationValueKnown((CDeclarationEdge)pCfaEdge, pAlreadyAssigned);
        }
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
            return this.isStatementValueKnown((CStatementEdge)pCfaEdge, pAlreadyAssigned);
        }
        return false;
    }

    private void addLeftHandSide(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt;
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge && (stmt = ((CStatementEdge)pCfaEdge).getStatement()) instanceof CAssignment) {
            CLeftHandSide lhs = ((CAssignment)stmt).getLeftHandSide();
            pAlreadyAssigned.add(lhs);
        }
    }

    private boolean isStatementValueKnown(CStatementEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt = pCfaEdge.getStatement();
        if (stmt instanceof CAssignment) {
            CLeftHandSide leftHandSide = ((CAssignment)stmt).getLeftHandSide();
            return this.isLeftHandSideValueKnown(leftHandSide, pAlreadyAssigned);
        }
        return false;
    }

    private boolean isLeftHandSideValueKnown(CLeftHandSide pLHS, Set<CLeftHandSide> pAlreadyAssigned) {
        ValueKnownVisitor v = new ValueKnownVisitor(pAlreadyAssigned);
        return pLHS.accept(v);
    }

    private boolean isDeclarationValueKnown(CDeclarationEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CDeclaration dcl = pCfaEdge.getDeclaration();
        if (dcl instanceof CVariableDeclaration) {
            CIdExpression idExp = new CIdExpression(dcl.getFileLocation(), dcl);
            return this.isLeftHandSideValueKnown(idExp, pAlreadyAssigned);
        }
        return false;
    }

    private ConcreteState createConcreteState(SMGState pSMGState, SMGObjectAddressMap pAdresses) {
        ImmutableMap variables = ImmutableMap.of();
        Map<String, Memory> allocatedMemory = this.allocateAddresses(pSMGState, pAdresses);
        return new ConcreteState((Map<LeftHandSide, Object>)variables, allocatedMemory, pAdresses.getAddressMap(), this.memoryName);
    }

    private Map<String, Memory> allocateAddresses(SMGState pSMGState, SMGObjectAddressMap pAdresses) {
        Map<Address, Object> values = this.createHeapValues(pSMGState, pAdresses);
        Memory heap = new Memory(this.memoryName.getMemoryName(null, null), values);
        HashMap<String, Memory> result = new HashMap<String, Memory>();
        result.put(heap.getName(), heap);
        return result;
    }

    private Map<Address, Object> createHeapValues(SMGState pSMGState, SMGObjectAddressMap pAdresses) {
        Set<SMGEdgeHasValue> symbolicValues = pSMGState.getHVEdges();
        HashMap<Address, Object> result = new HashMap<Address, Object>();
        for (SMGEdgeHasValue hvEdge : symbolicValues) {
            int symbolicValue = hvEdge.getValue();
            BigInteger value = null;
            if (symbolicValue == 0) {
                value = BigInteger.ZERO;
            } else if (pSMGState.isPointer(symbolicValue)) {
                SMGEdgePointsTo pointer;
                try {
                    pointer = pSMGState.getPointerFromValue(symbolicValue);
                }
                catch (SMGInconsistentException e) {
                    throw new AssertionError();
                }
                value = pAdresses.calculateAddress(pointer.getObject(), pointer.getOffset(), pSMGState).getAddressValue();
            } else {
                if (!pSMGState.isExplicit(symbolicValue)) continue;
                value = BigInteger.valueOf(pSMGState.getExplicit(symbolicValue).getAsLong());
            }
            Address address = pAdresses.calculateAddress(hvEdge.getObject(), hvEdge.getOffset(), pSMGState);
            result.put(address, value);
        }
        return result;
    }

    private static class SMGObjectAddressMap {
        private Map<SMGObject, Address> objectAddressMap = new HashMap<SMGObject, Address>();
        private Address nextAlloc = Address.valueOf(BigInteger.valueOf(100L));
        private Map<LeftHandSide, Address> variableAddressMap = new HashMap<LeftHandSide, Address>();

        private SMGObjectAddressMap() {
        }

        public Address calculateAddress(SMGObject pObject, int pOffset, SMGState pSMGState) {
            if (!this.objectAddressMap.containsKey(pObject)) {
                this.objectAddressMap.put(pObject, this.nextAlloc);
                IDExpression lhs = pSMGState.createIDExpression(pObject);
                if (lhs != null) {
                    this.variableAddressMap.put(lhs, this.nextAlloc);
                }
                BigInteger objectSize = BigInteger.valueOf(pObject.getSize());
                BigInteger nextAllocOffset = this.nextAlloc.getAddressValue().add(objectSize).add(BigInteger.ONE);
                this.nextAlloc = this.nextAlloc.addOffset(nextAllocOffset);
            }
            return this.objectAddressMap.get(pObject).addOffset(BigInteger.valueOf(pOffset));
        }

        public Map<LeftHandSide, Address> getAddressMap() {
            return ImmutableMap.copyOf(this.variableAddressMap);
        }
    }

    private static class ValueKnownVisitor
    extends DefaultCExpressionVisitor<Boolean, RuntimeException> {
        private final Set<CLeftHandSide> alreadyAssigned;

        public ValueKnownVisitor(Set<CLeftHandSide> pAlreadyAssigned) {
            this.alreadyAssigned = pAlreadyAssigned;
        }

        @Override
        protected Boolean visitDefault(CExpression pExp) {
            return true;
        }

        @Override
        public Boolean visit(CArraySubscriptExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CBinaryExpression pE) {
            return pE.getOperand1().accept(this) != false && pE.getOperand2().accept(this) != false;
        }

        @Override
        public Boolean visit(CCastExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CFieldReference pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CIdExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CPointerExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CUnaryExpression pE) {
            return pE.getOperand().accept(this);
        }
    }
}

