/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class SMGEdgeHasValueTest {
    CType mockType = AnonymousTypes.createTypeWithLength(4L);
    CType mockType12b = AnonymousTypes.createTypeWithLength(12L);

    @Test
    public void testSMGEdgeHasValue() {
        SMGRegion obj = new SMGRegion(8, "object");
        Integer val = 666;
        SMGEdgeHasValue hv = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)obj, (int)val);
        Assert.assertEquals((Object)obj, (Object)hv.getObject());
        Assert.assertEquals((long)4L, (long)hv.getOffset());
        Assert.assertEquals((Object)this.mockType, (Object)hv.getType());
        Assert.assertEquals((long)4L, (long)hv.getSizeInBytes(MachineModel.LINUX64));
    }

    @Test
    public void testIsConsistentWith() {
        SMGRegion obj1 = new SMGRegion(8, "object");
        SMGRegion obj2 = new SMGRegion(8, "different object");
        Integer val1 = 666;
        Integer val2 = 777;
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)obj1, (int)val1);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)obj1, (int)val2);
        SMGEdgeHasValue hv3 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)obj1, (int)val1);
        SMGEdgeHasValue hv4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)obj2, (int)val1);
        Assert.assertTrue((boolean)hv1.isConsistentWith(hv1));
        Assert.assertTrue((boolean)hv1.isConsistentWith(hv2));
        Assert.assertTrue((boolean)hv1.isConsistentWith(hv3));
        Assert.assertFalse((boolean)hv2.isConsistentWith(hv3));
        Assert.assertTrue((boolean)hv2.isConsistentWith(hv4));
    }

    @Test
    public void testOverlapsWith() {
        SMGRegion object = new SMGRegion(12, "object");
        Integer value = 666;
        SMGEdgeHasValue at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object, (int)value);
        SMGEdgeHasValue at2 = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)object, (int)value);
        SMGEdgeHasValue at4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object, (int)value);
        SMGEdgeHasValue at6 = new SMGEdgeHasValue(this.mockType, 6, (SMGObject)object, (int)value);
        Assert.assertTrue((boolean)at0.overlapsWith(at2, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at2.overlapsWith(at0, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at2.overlapsWith(at4, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at4.overlapsWith(at2, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at4.overlapsWith(at6, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at6.overlapsWith(at4, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at0.overlapsWith(at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)at0.overlapsWith(at4, MachineModel.LINUX64));
        Assert.assertFalse((boolean)at0.overlapsWith(at6, MachineModel.LINUX64));
        Assert.assertFalse((boolean)at2.overlapsWith(at6, MachineModel.LINUX64));
        Assert.assertFalse((boolean)at4.overlapsWith(at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)at6.overlapsWith(at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)at6.overlapsWith(at2, MachineModel.LINUX64));
        SMGEdgeHasValue whole = new SMGEdgeHasValue(this.mockType12b, 0, (SMGObject)object, (int)value);
        Assert.assertTrue((boolean)whole.overlapsWith(at4, MachineModel.LINUX64));
        Assert.assertTrue((boolean)at4.overlapsWith(whole, MachineModel.LINUX64));
    }

    @Test
    public void testIsCompatibleField() {
        SMGRegion object1 = new SMGRegion(12, "object-1");
        SMGRegion object2 = new SMGRegion(12, "object-2");
        Integer value = 666;
        SMGEdgeHasValue obj1_at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj1_at2 = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj1_at4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj1_12at0 = new SMGEdgeHasValue(this.mockType12b, 0, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj2_at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object2, (int)value);
        SMGEdgeHasValue obj2_at2 = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)object2, (int)value);
        SMGEdgeHasValue obj2_at4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object2, (int)value);
        SMGEdgeHasValue obj2_12at0 = new SMGEdgeHasValue(this.mockType12b, 0, (SMGObject)object2, (int)value);
        Assert.assertTrue((boolean)obj1_at0.isCompatibleField(obj1_at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleField(obj1_at2, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleField(obj1_at4, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleField(obj1_12at0, MachineModel.LINUX64));
        Assert.assertTrue((boolean)obj1_at0.isCompatibleField(obj2_at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleField(obj2_at2, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleField(obj2_at4, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleField(obj2_12at0, MachineModel.LINUX64));
    }

    @Test
    public void testIsCompatibleFieldOnSameObject() {
        SMGRegion object1 = new SMGRegion(12, "object-1");
        SMGRegion object2 = new SMGRegion(12, "object-2");
        Integer value = 666;
        SMGEdgeHasValue obj1_at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj1_at2 = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj1_at4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj1_12at0 = new SMGEdgeHasValue(this.mockType12b, 0, (SMGObject)object1, (int)value);
        SMGEdgeHasValue obj2_at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object2, (int)value);
        SMGEdgeHasValue obj2_at2 = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)object2, (int)value);
        SMGEdgeHasValue obj2_at4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object2, (int)value);
        SMGEdgeHasValue obj2_12at0 = new SMGEdgeHasValue(this.mockType12b, 0, (SMGObject)object2, (int)value);
        Assert.assertTrue((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj1_at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj1_at2, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj1_at4, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj1_12at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj2_at0, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj2_at2, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj2_at4, MachineModel.LINUX64));
        Assert.assertFalse((boolean)obj1_at0.isCompatibleFieldOnSameObject(obj2_12at0, MachineModel.LINUX64));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalOverlapsWith() {
        SMGRegion object1 = new SMGRegion(12, "object1");
        SMGRegion object2 = new SMGRegion(12, "object2");
        Integer value = 666;
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)object2, (int)value);
        hv1.overlapsWith(hv2, MachineModel.LINUX64);
    }

    @Test
    public void testFilterOnObject() {
        SMGRegion object1 = new SMGRegion(8, "object1");
        SMGRegion object2 = new SMGRegion(8, "Object2");
        Integer value1 = 1;
        Integer value2 = 2;
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value1);
        SMGEdgeHasValue hv12at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value2);
        SMGEdgeHasValue hv21at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object2, (int)value1);
        SMGEdgeHasValue hv22at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object2, (int)value2);
        HashSet<SMGEdgeHasValue> allEdges = new HashSet<SMGEdgeHasValue>();
        allEdges.add(hv11at0);
        allEdges.add(hv12at0);
        allEdges.add(hv21at0);
        allEdges.add(hv22at0);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        Assert.assertTrue((boolean)filter.holdsFor(hv11at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv12at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv21at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv22at0));
        filter.filterByObject(object1);
        Assert.assertTrue((boolean)filter.holdsFor(hv11at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv12at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv21at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv22at0));
        Set<SMGEdgeHasValue> filteredSet = filter.filterSet(allEdges);
        Assert.assertEquals((long)2L, (long)filteredSet.size());
        Assert.assertTrue((boolean)filteredSet.contains(hv11at0));
        Assert.assertTrue((boolean)filteredSet.contains(hv12at0));
    }

    @Test
    public void testFilterAtOffset() {
        SMGRegion object1 = new SMGRegion(8, "object1");
        SMGRegion object2 = new SMGRegion(8, "Object2");
        Integer value1 = 1;
        Integer value2 = 2;
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value1);
        SMGEdgeHasValue hv12at0 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object1, (int)value2);
        SMGEdgeHasValue hv21at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object2, (int)value1);
        SMGEdgeHasValue hv22at0 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object2, (int)value2);
        HashSet<SMGEdgeHasValue> allEdges = new HashSet<SMGEdgeHasValue>();
        allEdges.add(hv11at0);
        allEdges.add(hv12at0);
        allEdges.add(hv21at0);
        allEdges.add(hv22at0);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        filter.filterAtOffset(0);
        Assert.assertTrue((boolean)filter.holdsFor(hv11at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv12at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv21at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv22at0));
        Set<SMGEdgeHasValue> filteredSet = filter.filterSet(allEdges);
        Assert.assertEquals((long)2L, (long)filteredSet.size());
        Assert.assertTrue((boolean)filteredSet.contains(hv11at0));
        Assert.assertTrue((boolean)filteredSet.contains(hv21at0));
    }

    @Test
    public void testFilterOnValue() {
        SMGRegion object1 = new SMGRegion(8, "object1");
        SMGRegion object2 = new SMGRegion(8, "Object2");
        Integer value1 = 1;
        Integer value2 = 2;
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object1, (int)value1);
        SMGEdgeHasValue hv12at0 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object1, (int)value2);
        SMGEdgeHasValue hv21at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object2, (int)value1);
        SMGEdgeHasValue hv22at0 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object2, (int)value2);
        HashSet<SMGEdgeHasValue> allEdges = new HashSet<SMGEdgeHasValue>();
        allEdges.add(hv11at0);
        allEdges.add(hv12at0);
        allEdges.add(hv21at0);
        allEdges.add(hv22at0);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        filter.filterHavingValue(value1);
        Assert.assertTrue((boolean)filter.holdsFor(hv11at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv12at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv21at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv22at0));
        Set<SMGEdgeHasValue> filteredSet = filter.filterSet(allEdges);
        Assert.assertEquals((long)2L, (long)filteredSet.size());
        Assert.assertTrue((boolean)filteredSet.contains(hv11at0));
        Assert.assertTrue((boolean)filteredSet.contains(hv21at0));
        filter.filterNotHavingValue(value1);
        Assert.assertFalse((boolean)filter.holdsFor(hv11at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv12at0));
        Assert.assertFalse((boolean)filter.holdsFor(hv21at0));
        Assert.assertTrue((boolean)filter.holdsFor(hv22at0));
        filteredSet = filter.filterSet(allEdges);
        Assert.assertEquals((long)2L, (long)filteredSet.size());
        Assert.assertTrue((boolean)filteredSet.contains(hv22at0));
        Assert.assertTrue((boolean)filteredSet.contains(hv12at0));
    }
}

