/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public final class SMGExplicitPlotter {
    private final HashMap<Location, String> locationIndex = new HashMap();
    private int offset = 0;
    private final ValueAnalysisState explicitState;
    private final SMGState smgState;

    public SMGExplicitPlotter(ValueAnalysisState pExplicitState, SMGState pSmgState) {
        this.explicitState = pExplicitState;
        this.smgState = pSmgState;
    }

    public String smgAsDot(CLangSMG smg, String name, String location) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph gr_" + name.replace('-', '_') + "{\n");
        this.offset += 2;
        sb.append(this.newLineWithOffset("label = \"Location: " + location.replace("\"", "") + "\";"));
        this.addStackSubgraph(smg, sb);
        for (SMGObject heapObject : smg.getHeapObjects()) {
            sb.append(this.newLineWithOffset(SMGExplicitPlotter.smgObjectAsDot(heapObject, smg)));
            this.locationIndex.put(Location.valueOf(heapObject), heapObject.getLabel());
        }
        this.addGlobalObjectSubgraph(smg, sb);
        HashMap<Integer, ValueAnalysisState.MemoryLocation> coveredBySMG = new HashMap<Integer, ValueAnalysisState.MemoryLocation>();
        HashSet<ValueAnalysisState.MemoryLocation> coveredMemloc = new HashSet<ValueAnalysisState.MemoryLocation>();
        for (SMGEdgeHasValue edge : smg.getHVEdges()) {
            SMGObject sMGObject = edge.getObject();
            String functionName = smg.getFunctionName(sMGObject);
            ValueAnalysisState.MemoryLocation memloc = this.smgState.resolveMemLoc(SMGTransferRelation.SMGAddress.valueOf(sMGObject, edge.getOffset()), functionName);
            if (!this.explicitState.contains(memloc)) continue;
            coveredBySMG.put(edge.getValue(), memloc);
            coveredMemloc.add(memloc);
        }
        Iterator<Object> i$ = smg.getValues().iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            sb.append(this.newLineWithOffset(this.smgValueAsDot(value, coveredBySMG)));
        }
        HashSet<ValueAnalysisState.MemoryLocation> notCoveredBySMG = new HashSet<ValueAnalysisState.MemoryLocation>();
        for (ValueAnalysisState.MemoryLocation memoryLocation : this.explicitState.getTrackedMemoryLocations()) {
            if (coveredMemloc.contains(memoryLocation) || memoryLocation.getAsSimpleString().contains("->")) continue;
            sb.append(this.newLineWithOffset(this.explicitValueAsDot(memoryLocation)));
            notCoveredBySMG.add(memoryLocation);
        }
        for (SMGEdgeHasValue sMGEdgeHasValue : smg.getHVEdges()) {
            sb.append(this.newLineWithOffset(this.smgHVEdgeAsDot(sMGEdgeHasValue, smg)));
        }
        for (ValueAnalysisState.MemoryLocation memoryLocation : notCoveredBySMG) {
            sb.append(this.newLineWithOffset(this.memlocAsDot(memoryLocation)));
        }
        for (SMGEdgePointsTo sMGEdgePointsTo : smg.getPTEdges().values()) {
            sb.append(this.newLineWithOffset(this.smgPTEdgeAsDot(sMGEdgePointsTo, smg)));
        }
        sb.append("}");
        return sb.toString();
    }

    private String memlocAsDot(ValueAnalysisState.MemoryLocation pMemloc) {
        return this.locationIndex.get(Location.valueOf(pMemloc)) + " -> expValue_" + this.explicitState.getValueFor(pMemloc) + "[label=\"[" + pMemloc.getOffset() + "]\"];";
    }

    private String explicitValueAsDot(ValueAnalysisState.MemoryLocation pMemloc) {
        Value value = this.explicitState.getValueFor(pMemloc);
        return "expValue_" + value.toString() + "[label=\"" + value.toString() + "\"];";
    }

    private void addStackSubgraph(CLangSMG pSmg, StringBuilder pSb) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack {"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("label=\"Stack\";"));
        int i = 0;
        for (CLangStackFrame stack_item : pSmg.getStackFrames()) {
            this.addStackItemSubgraph(stack_item, pSb, i);
            ++i;
        }
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private void addStackItemSubgraph(CLangStackFrame pStackFrame, StringBuilder pSb, int pIndex) {
        String functionName = pStackFrame.getFunctionDeclaration().getName();
        pSb.append(this.newLineWithOffset("subgraph cluster_stack_" + functionName + "{"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("fontcolor=blue;"));
        pSb.append(this.newLineWithOffset("label=\"" + pStackFrame.getFunctionDeclaration().toASTString() + "\";"));
        pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(pStackFrame.getVariables(), String.valueOf(pIndex), functionName)));
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    @Nullable
    private String smgScopeFrameAsDot(Map<String, SMGRegion> pNamespace, String pStructId, String pFunctionName) {
        StringBuilder sb = new StringBuilder();
        sb.append("struct" + pStructId + "[shape=record,label=\" ");
        ArrayList<String> nodes = new ArrayList<String>();
        for (Map.Entry<String, SMGRegion> entry : pNamespace.entrySet()) {
            String key = entry.getKey();
            SMGObject obj = entry.getValue();
            if (key.equals("node")) {
                key = "node1";
            }
            nodes.add("<" + key + "> " + obj.toString());
            Location location = Location.valueOf(obj, pFunctionName);
            this.locationIndex.put(location, "struct" + pStructId + ":" + key);
        }
        Set<ValueAnalysisState.MemoryLocation> memoryLocations = pFunctionName == null ? this.explicitState.getGlobalMemoryLocations() : this.explicitState.getMemoryLocationsOnStack(pFunctionName);
        for (ValueAnalysisState.MemoryLocation memloc : memoryLocations) {
            Location location = Location.valueOf(memloc);
            if (this.locationIndex.containsKey(location) || location.location.contains("->")) continue;
            nodes.add("<" + memloc.getIdentifier() + "> " + memloc.getIdentifier());
            this.locationIndex.put(location, "struct" + pStructId + ":" + memloc.getIdentifier());
        }
        sb.append(Joiner.on((String)" | ").join(nodes));
        sb.append("\"];\n");
        return sb.toString();
    }

    private void addGlobalObjectSubgraph(CLangSMG pSmg, StringBuilder pSb) {
        pSb.append(this.newLineWithOffset("subgraph cluster_global{"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("label=\"Global objects\";"));
        pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(pSmg.getGlobalObjects(), "global", null)));
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private String smgHVEdgeAsDot(SMGEdgeHasValue pEdge, CLangSMG smg) {
        SMGObject obj = pEdge.getObject();
        Location location = Location.valueOf(obj, smg.getFunctionName(obj));
        return this.locationIndex.get(location) + " -> value_" + pEdge.getValue() + "[label=\"[" + pEdge.getOffset() + "]\"];";
    }

    private String smgPTEdgeAsDot(SMGEdgePointsTo pEdge, CLangSMG smg) {
        SMGObject obj = pEdge.getObject();
        Location location = Location.valueOf(obj, smg.getFunctionName(obj));
        return "value_" + pEdge.getValue() + " -> " + this.locationIndex.get(location) + "[label=\"+" + pEdge.getOffset() + "b\"];";
    }

    private static String smgObjectAsDot(SMGObject pObject, CLangSMG pSmg) {
        String valid = pSmg.isObjectValid(pObject) ? "" : " : invalid ";
        return pObject.getLabel() + " [ shape=rectangle, label = \"" + pObject.toString() + valid + "\"];";
    }

    private String smgValueAsDot(int value, Map<Integer, ValueAnalysisState.MemoryLocation> pCoveredBySMG) {
        if (pCoveredBySMG.containsKey(value)) {
            return "value_" + value + "[label=\"#" + value + " : " + this.explicitState.getValueFor(pCoveredBySMG.get(value)) + "\"];";
        }
        return "value_" + value + "[label=\"#" + value + "\"];";
    }

    private String newLineWithOffset(String pLine) {
        return Strings.repeat((String)" ", (int)this.offset) + pLine + "\n";
    }

    private static final class Location {
        private final String location;

        private Location(SMGObject pSmgObject, String functionName) {
            this.location = functionName + "::" + pSmgObject.getLabel();
        }

        public static Location valueOf(ValueAnalysisState.MemoryLocation pMemloc) {
            return new Location(pMemloc);
        }

        @Nullable
        public static Location valueOf(SMGObject pObj, String pFunctionName) {
            if (pFunctionName == null) {
                return new Location(pObj);
            }
            return new Location(pObj, pFunctionName);
        }

        public static Location valueOf(SMGObject pHeapObject) {
            return new Location(pHeapObject);
        }

        private Location(SMGObject pSmgObject) {
            this.location = pSmgObject.getLabel();
        }

        private Location(ValueAnalysisState.MemoryLocation pMemloc) {
            this.location = pMemloc.getAsSimpleString();
        }

        public boolean equals(Object pObj) {
            if (pObj instanceof Location) {
                return this.location.equals(((Location)pObj).location);
            }
            return false;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public String toString() {
            return this.location;
        }
    }
}

