/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class SMGExpressionEvaluator {
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;

    public SMGExpressionEvaluator(LogManagerWithoutDuplicates pLogger, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
    }

    public int getSizeof(CFAEdge edge, CType pType) throws UnrecognizedCCodeException {
        try {
            return this.machineModel.getSizeof(pType);
        }
        catch (IllegalArgumentException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCCodeException("Could not resolve type.", edge);
        }
    }

    private SMGAddressAndState getAddressOfField(SMGState pSmgState, CFAEdge cfaEdge, CFieldReference fieldReference) throws CPATransferException {
        CExpression fieldOwner = fieldReference.getFieldOwner();
        CType ownerType = this.getRealExpressionType(fieldOwner);
        SMGAddressValueAndState fieldOwnerAddressAndState = this.evaluateAddress(pSmgState, cfaEdge, fieldOwner);
        SMGTransferRelation.SMGAddressValue fieldOwnerAddress = fieldOwnerAddressAndState.getValue();
        SMGState newState = fieldOwnerAddressAndState.getSmgState();
        if (fieldOwnerAddress.isUnknown()) {
            return SMGAddressAndState.of(newState);
        }
        String fieldName = fieldReference.getFieldName();
        SMGTransferRelation.SMGField field = this.getField(cfaEdge, ownerType, fieldName);
        if (field.isUnknown()) {
            return SMGAddressAndState.of(newState);
        }
        SMGTransferRelation.SMGAddress addressOfFieldOwner = fieldOwnerAddress.getAddress();
        SMGTransferRelation.SMGExplicitValue fieldOffset = addressOfFieldOwner.add(field.getOffset()).getOffset();
        SMGObject fieldObject = addressOfFieldOwner.getObject();
        SMGTransferRelation.SMGAddress address = SMGTransferRelation.SMGAddress.valueOf(fieldObject, fieldOffset);
        return SMGAddressAndState.of(newState, address);
    }

    public SMGValueAndState readValue(SMGState pSmgState, SMGObject pObject, SMGTransferRelation.SMGExplicitValue pOffset, CType pType, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        boolean doesNotFitIntoObject;
        if (pOffset.isUnknown() || pObject == null) {
            return SMGValueAndState.of(pSmgState);
        }
        int fieldOffset = pOffset.getAsInt();
        boolean bl = doesNotFitIntoObject = fieldOffset < 0 || fieldOffset + this.getSizeof(pEdge, pType) > pObject.getSize();
        if (doesNotFitIntoObject) {
            this.logger.log(Level.WARNING, new Object[]{pEdge.getFileLocation() + ":", "Field (" + fieldOffset + ", " + pType.toASTString("") + ")" + " does not fit object " + pObject.toString() + "."});
            return SMGValueAndState.of(pSmgState);
        }
        SMGTransferRelation.SMGSymbolicValue value = pSmgState.readValue(pObject, fieldOffset, pType).getValue();
        return SMGValueAndState.of(pSmgState, value);
    }

    private SMGTransferRelation.SMGField getField(CFAEdge edge, CType ownerType, String fieldName) throws UnrecognizedCCodeException {
        if (ownerType instanceof CElaboratedType) {
            CComplexType realType = ((CElaboratedType)ownerType).getRealType();
            if (realType == null) {
                return SMGTransferRelation.SMGField.getUnknownInstance();
            }
            return this.getField(edge, realType, fieldName);
        }
        if (ownerType instanceof CCompositeType) {
            return this.getField(edge, (CCompositeType)ownerType, fieldName);
        }
        if (ownerType instanceof CPointerType) {
            CType type = ((CPointerType)ownerType).getType();
            type = this.getRealExpressionType(type);
            return this.getField(edge, type, fieldName);
        }
        throw new AssertionError();
    }

    private SMGTransferRelation.SMGField getField(CFAEdge pEdge, CCompositeType ownerType, String fieldName) throws UnrecognizedCCodeException {
        List<CCompositeType.CCompositeTypeMemberDeclaration> membersOfType = ownerType.getMembers();
        int offset = 0;
        for (CCompositeType.CCompositeTypeMemberDeclaration typeMember : membersOfType) {
            String memberName = typeMember.getName();
            if (memberName.equals(fieldName)) {
                return new SMGTransferRelation.SMGField(SMGTransferRelation.SMGKnownExpValue.valueOf(offset), this.getRealExpressionType(typeMember.getType()));
            }
            if (ownerType.getKind() == CComplexType.ComplexTypeKind.UNION) continue;
            offset += this.getSizeof(pEdge, this.getRealExpressionType(typeMember.getType()));
        }
        return new SMGTransferRelation.SMGField(SMGTransferRelation.SMGUnknownValue.getInstance(), ownerType);
    }

    boolean isStructOrUnionType(CType rValueType) {
        if (rValueType instanceof CElaboratedType) {
            CElaboratedType type = (CElaboratedType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        if (rValueType instanceof CCompositeType) {
            CCompositeType type = (CCompositeType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        return false;
    }

    public SMGTransferRelation.SMGExplicitValue evaluateExplicitValueV2(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        return this.evaluateExplicitValue(smgState, cfaEdge, rValue).getValue();
    }

    protected SMGExplicitValueAndState evaluateExplicitValue(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        ExplicitValueVisitor visitor = new ExplicitValueVisitor(smgState, null, this.machineModel, this.logger, cfaEdge);
        Value value = rValue.accept(visitor);
        SMGState newState = visitor.getNewState();
        if (!value.isExplicitlyKnown() || !value.isNumericValue()) {
            SMGValueAndState symbolicValueAndState = this.evaluateExpressionValue(newState, cfaEdge, rValue);
            SMGTransferRelation.SMGSymbolicValue symbolicValue = symbolicValueAndState.getValue();
            newState = symbolicValueAndState.getSmgState();
            if (!symbolicValue.isUnknown()) {
                SMGTransferRelation.SMGAddressValue address;
                if (symbolicValue == SMGTransferRelation.SMGKnownSymValue.ZERO) {
                    return SMGExplicitValueAndState.of(newState, SMGTransferRelation.SMGKnownExpValue.ZERO);
                }
                if (symbolicValue instanceof SMGTransferRelation.SMGAddressValue && (address = (SMGTransferRelation.SMGAddressValue)symbolicValue).getObject() == SMGObject.getNullObject()) {
                    return SMGExplicitValueAndState.of(newState, SMGTransferRelation.SMGKnownExpValue.valueOf(address.getOffset().getAsLong()));
                }
            }
            return SMGExplicitValueAndState.of(newState);
        }
        Long longValue = value.asNumericValue().longValue();
        if (longValue != null) {
            return SMGExplicitValueAndState.of(newState, SMGTransferRelation.SMGKnownExpValue.valueOf(longValue));
        }
        return SMGExplicitValueAndState.of(newState);
    }

    public SMGTransferRelation.SMGSymbolicValue evaluateExpressionValueV2(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        return this.evaluateExpressionValue(smgState, cfaEdge, rValue).getValue();
    }

    protected SMGValueAndState evaluateExpressionValue(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        CType expressionType = this.getRealExpressionType(rValue);
        if (expressionType instanceof CPointerType || expressionType instanceof CArrayType || this.isStructOrUnionType(expressionType) || expressionType instanceof CFunctionType) {
            return this.evaluateAddress(smgState, cfaEdge, rValue);
        }
        return this.evaluateNonAddressValue(smgState, cfaEdge, rValue);
    }

    private SMGValueAndState evaluateNonAddressValue(SMGState newState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        ExpressionValueVisitor visitor = this.getExpressionValueVisitor(cfaEdge, newState);
        SMGValueAndState symbolicValue = rValue.accept(visitor);
        return symbolicValue;
    }

    protected SMGValueAndState evaluateAssumptionValue(SMGState newState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
        AssumeVisitor visitor = this.getAssumeVisitor(cfaEdge, newState);
        return rValue.accept(visitor);
    }

    public SMGTransferRelation.SMGSymbolicValue evaluateAssumptionValueV2(SMGState newState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
        return this.evaluateAssumptionValue(newState, cfaEdge, rValue).getValue();
    }

    protected SMGAddressValueAndState evaluateAddress(SMGState pState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        CType expressionType = this.getRealExpressionType(rValue);
        if (expressionType instanceof CFunctionType) {
            return SMGAddressValueAndState.of(pState, SMGTransferRelation.SMGUnknownValue.getInstance());
        }
        if (expressionType instanceof CPointerType) {
            PointerVisitor visitor = this.getPointerVisitor(cfaEdge, pState);
            SMGValueAndState addressAndState = rValue.accept(visitor);
            return this.getAddressFromSymbolicValue(addressAndState);
        }
        if (this.isStructOrUnionType(expressionType)) {
            StructAndUnionVisitor visitor = this.getStructAndUnionVisitor(cfaEdge, pState);
            SMGAddressAndState structAddressAndState = rValue.accept(visitor);
            SMGState newState = structAddressAndState.getSmgState();
            SMGTransferRelation.SMGAddress structAddress = structAddressAndState.getAddress();
            return this.createAddress(newState, structAddress);
        }
        if (expressionType instanceof CArrayType) {
            ArrayVisitor visitor = this.getArrayVisitor(cfaEdge, pState);
            SMGAddressAndState arrayAddressAndState = rValue.accept(visitor);
            SMGTransferRelation.SMGAddress arrayAddress = arrayAddressAndState.getAddress();
            SMGState newState = arrayAddressAndState.getSmgState();
            return this.createAddress(newState, arrayAddress);
        }
        throw new AssertionError((Object)("The method evaluateAddress may not be calledwith the type " + expressionType.toASTString("")));
    }

    public SMGTransferRelation.SMGAddressValue evaluateAddressV2(SMGState newState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        return this.evaluateAddress(newState, cfaEdge, rValue).getValue();
    }

    public CType getRealExpressionType(CType type) {
        return type.getCanonicalType();
    }

    public CType getRealExpressionType(CSimpleDeclaration decl) {
        return this.getRealExpressionType(decl.getType());
    }

    public CType getRealExpressionType(CRightHandSide exp) {
        return this.getRealExpressionType(exp.getExpressionType());
    }

    private SMGAddressValueAndState handlePointerArithmetic(SMGState initialSmgState, CFAEdge cfaEdge, CExpression address, CExpression pointerOffset, CType typeOfPointer, boolean lVarIsAddress, CBinaryExpression binaryExp) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = binaryExp.getOperator();
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: {
                SMGAddressValueAndState addressValueAndState = this.evaluateAddress(initialSmgState, cfaEdge, address);
                SMGTransferRelation.SMGAddressValue addressValue = addressValueAndState.getValue();
                SMGState newState = addressValueAndState.getSmgState();
                SMGExplicitValueAndState offsetValueAndState = this.evaluateExplicitValue(newState, cfaEdge, pointerOffset);
                SMGTransferRelation.SMGExplicitValue offsetValue = offsetValueAndState.getValue();
                newState = offsetValueAndState.getSmgState();
                if (addressValue.isUnknown() || offsetValue.isUnknown()) {
                    return SMGAddressValueAndState.of(newState);
                }
                SMGTransferRelation.SMGKnownExpValue typeSize = SMGTransferRelation.SMGKnownExpValue.valueOf(this.getSizeof(cfaEdge, typeOfPointer));
                SMGTransferRelation.SMGExplicitValue pointerOffsetValue = offsetValue.multiply(typeSize);
                SMGObject target = addressValue.getObject();
                SMGTransferRelation.SMGExplicitValue addressOffset = addressValue.getOffset();
                switch (binaryOperator) {
                    case PLUS: {
                        return this.createAddress(newState, target, addressOffset.add(pointerOffsetValue));
                    }
                    case MINUS: {
                        if (lVarIsAddress) {
                            return this.createAddress(newState, target, addressOffset.subtract(pointerOffsetValue));
                        }
                        throw new UnrecognizedCCodeException("Expected pointer arithmetic  with + or - but found " + binaryExp.toASTString(), binaryExp);
                    }
                }
                throw new AssertionError();
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                throw new UnrecognizedCCodeException("Misinterpreted the expression type of " + binaryExp + " as pointer type", cfaEdge, binaryExp);
            }
            case DIVIDE: 
            case MULTIPLY: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new UnrecognizedCCodeException("The operands of binary Expression " + binaryExp.toASTString() + " must have arithmetic types. " + address.toASTString() + " has a non arithmetic type", cfaEdge, binaryExp);
            }
        }
        return SMGAddressValueAndState.of(initialSmgState);
    }

    private SMGAddressAndState evaluateArraySubscriptAddress(SMGState initialSmgState, CFAEdge cfaEdge, CArraySubscriptExpression exp) throws CPATransferException {
        SMGAddressValueAndState arrayAddressAndState = this.evaluateAddress(initialSmgState, cfaEdge, exp.getArrayExpression());
        SMGTransferRelation.SMGAddressValue arrayAddress = arrayAddressAndState.getValue();
        SMGState newState = arrayAddressAndState.getSmgState();
        if (arrayAddress.isUnknown()) {
            newState = this.handleUnknownDereference(newState, cfaEdge).getSmgState();
            return SMGAddressAndState.of(newState);
        }
        SMGExplicitValueAndState subscriptValueAndState = this.evaluateExplicitValue(newState, cfaEdge, exp.getSubscriptExpression());
        SMGTransferRelation.SMGExplicitValue subscriptValue = subscriptValueAndState.getValue();
        newState = subscriptValueAndState.getSmgState();
        if (subscriptValue.isUnknown()) {
            newState = this.handleUnknownDereference(newState, cfaEdge).getSmgState();
            return SMGAddressAndState.of(newState);
        }
        SMGTransferRelation.SMGKnownExpValue typeSize = SMGTransferRelation.SMGKnownExpValue.valueOf(this.getSizeof(cfaEdge, exp.getExpressionType()));
        SMGTransferRelation.SMGExplicitValue subscriptOffset = subscriptValue.multiply(typeSize);
        return SMGAddressAndState.of(newState, arrayAddress.getAddress().add(subscriptOffset));
    }

    SMGAddressValueAndState createAddress(SMGTransferRelation.SMGEdgePointsToAndState pEdgeAndState) {
        SMGEdgePointsTo edge = pEdgeAndState.getValue();
        SMGState newState = pEdgeAndState.getSmgState();
        if (edge == null) {
            return SMGAddressValueAndState.of(newState);
        }
        SMGTransferRelation.SMGKnownAddVal addressVal = SMGTransferRelation.SMGKnownAddVal.valueOf(edge.getValue(), edge.getObject(), edge.getOffset());
        return SMGAddressValueAndState.of(newState, addressVal);
    }

    private SMGAddressValueAndState createAddress(SMGState pNewState, SMGTransferRelation.SMGAddress pAddress) throws SMGInconsistentException {
        if (pAddress.isUnknown()) {
            return SMGAddressValueAndState.of(pNewState);
        }
        return this.createAddress(pNewState, pAddress.getObject(), pAddress.getOffset());
    }

    SMGAddressValueAndState getAddressFromSymbolicValue(SMGValueAndState pAddressValueAndState) throws SMGInconsistentException {
        if (pAddressValueAndState instanceof SMGAddressValueAndState) {
            return (SMGAddressValueAndState)pAddressValueAndState;
        }
        SMGTransferRelation.SMGSymbolicValue pAddressValue = pAddressValueAndState.getValue();
        SMGState smgState = pAddressValueAndState.getSmgState();
        if (pAddressValue instanceof SMGTransferRelation.SMGAddressValue) {
            return SMGAddressValueAndState.of(smgState, (SMGTransferRelation.SMGAddressValue)pAddressValue);
        }
        if (pAddressValue.isUnknown()) {
            return SMGAddressValueAndState.of(smgState);
        }
        if (!smgState.isPointer(pAddressValue.getAsInt())) {
            return SMGAddressValueAndState.of(smgState);
        }
        SMGEdgePointsTo edge = smgState.getPointerFromValue(pAddressValue.getAsInt());
        return this.createAddress(SMGTransferRelation.SMGEdgePointsToAndState.of(smgState, edge));
    }

    SMGAddressValueAndState createAddress(SMGState pSmgState, SMGObject pTarget, SMGTransferRelation.SMGExplicitValue pOffset) throws SMGInconsistentException {
        SMGAddressValueAndState addressValueAndState = this.getAddress(pSmgState, pTarget, pOffset);
        if (addressValueAndState.getValue().isUnknown()) {
            SMGTransferRelation.SMGKnownSymValue value = SMGTransferRelation.SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
            SMGTransferRelation.SMGKnownAddVal addressValue = SMGTransferRelation.SMGKnownAddVal.valueOf(pTarget, (SMGTransferRelation.SMGKnownExpValue)pOffset, value);
            return SMGAddressValueAndState.of(addressValueAndState.getSmgState(), addressValue);
        }
        return addressValueAndState;
    }

    SMGAddressValueAndState getAddress(SMGState pSmgState, SMGObject pTarget, SMGTransferRelation.SMGExplicitValue pOffset) throws SMGInconsistentException {
        if (pTarget == null || pOffset.isUnknown()) {
            return SMGAddressValueAndState.of(pSmgState);
        }
        Integer address = pSmgState.getAddress(pTarget, pOffset.getAsInt());
        if (address == null) {
            return SMGAddressValueAndState.of(pSmgState);
        }
        SMGTransferRelation.SMGEdgePointsToAndState edgeAndState = SMGTransferRelation.SMGEdgePointsToAndState.of(pSmgState, pSmgState.getPointerFromValue(address));
        return this.createAddress(edgeAndState);
    }

    protected SMGValueAndState handleUnknownDereference(SMGState smgState, CFAEdge edge) {
        return SMGValueAndState.of(smgState);
    }

    protected StructAndUnionVisitor getStructAndUnionVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new StructAndUnionVisitor(pCfaEdge, pNewState);
    }

    protected ArrayVisitor getArrayVisitor(CFAEdge pCfaEdge, SMGState pSmgState) {
        return new ArrayVisitor(pCfaEdge, pSmgState);
    }

    protected PointerVisitor getPointerVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new PointerVisitor(pCfaEdge, pNewState);
    }

    protected AssumeVisitor getAssumeVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new AssumeVisitor(pCfaEdge, pNewState);
    }

    protected ExpressionValueVisitor getExpressionValueVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new ExpressionValueVisitor(pCfaEdge, pNewState);
    }

    public LValueAssignmentVisitor getLValueAssignmentVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new LValueAssignmentVisitor(pCfaEdge, pNewState);
    }

    public static class SMGExplicitValueAndState {
        private final SMGState smgState;
        private final SMGTransferRelation.SMGExplicitValue value;

        private SMGExplicitValueAndState(SMGState pState, SMGTransferRelation.SMGExplicitValue pValue) {
            this.smgState = pState;
            this.value = pValue;
        }

        public SMGExplicitValueAndState(SMGState pState) {
            this.smgState = pState;
            this.value = SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        public SMGTransferRelation.SMGExplicitValue getValue() {
            return this.value;
        }

        public static SMGExplicitValueAndState of(SMGState pState) {
            return new SMGExplicitValueAndState(pState);
        }

        public SMGState getSmgState() {
            return this.smgState;
        }

        public static SMGExplicitValueAndState of(SMGState pState, SMGTransferRelation.SMGExplicitValue pValue) {
            return new SMGExplicitValueAndState(pState, pValue);
        }

        public String toString() {
            return this.value.toString() + " StateId: " + this.smgState.getId();
        }
    }

    public static class SMGValueAndState {
        private final SMGState smgState;
        private final SMGTransferRelation.SMGSymbolicValue value;

        private SMGValueAndState(SMGState pState, SMGTransferRelation.SMGSymbolicValue pValue) {
            this.smgState = pState;
            this.value = pValue;
        }

        public SMGValueAndState(SMGState pState) {
            this.smgState = pState;
            this.value = SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        public SMGTransferRelation.SMGSymbolicValue getValue() {
            return this.value;
        }

        public static SMGValueAndState of(SMGState pState) {
            return new SMGValueAndState(pState);
        }

        public SMGState getSmgState() {
            return this.smgState;
        }

        public static SMGValueAndState of(SMGState pState, SMGTransferRelation.SMGSymbolicValue pValue) {
            return new SMGValueAndState(pState, pValue);
        }

        public String toString() {
            return this.value.toString() + " StateId: " + this.smgState.getId();
        }
    }

    public static class SMGAddressAndState {
        private final SMGState smgState;
        private final SMGTransferRelation.SMGAddress address;

        private SMGAddressAndState(SMGState pState, SMGTransferRelation.SMGAddress pAddress) {
            this.smgState = pState;
            this.address = pAddress;
        }

        private SMGAddressAndState(SMGState pState) {
            this.smgState = pState;
            this.address = SMGTransferRelation.SMGAddress.getUnknownInstance();
        }

        public SMGTransferRelation.SMGAddress getAddress() {
            return this.address;
        }

        public SMGState getSmgState() {
            return this.smgState;
        }

        public static SMGAddressAndState of(SMGState pState) {
            return new SMGAddressAndState(pState);
        }

        public static SMGAddressAndState of(SMGState pState, SMGTransferRelation.SMGAddress pAddress) {
            return new SMGAddressAndState(pState, pAddress);
        }

        public String toString() {
            return this.address.toString() + " StateId: " + this.smgState.getId();
        }
    }

    public static class SMGAddressValueAndState
    extends SMGValueAndState {
        private SMGAddressValueAndState(SMGState pState, SMGTransferRelation.SMGAddressValue pValue) {
            super(pState, pValue);
        }

        public SMGAddressAndState asSMGAddressAndState() {
            return SMGAddressAndState.of(this.getSmgState(), this.getValue().getAddress());
        }

        private SMGAddressValueAndState(SMGState pState) {
            super(pState);
        }

        @Override
        public SMGTransferRelation.SMGAddressValue getValue() {
            return (SMGTransferRelation.SMGAddressValue)super.getValue();
        }

        public static SMGAddressValueAndState of(SMGState pState, SMGTransferRelation.SMGAddressValue pValue) {
            return new SMGAddressValueAndState(pState, pValue);
        }

        public static SMGAddressValueAndState of(SMGState pState) {
            return new SMGAddressValueAndState(pState);
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    class ExplicitValueVisitor
    extends AbstractExpressionValueVisitor {
        private final CFAEdge edge;
        private SMGState smgState;

        public ExplicitValueVisitor(SMGState pSmgState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, CFAEdge pEdge) {
            super(pFunctionName, pMachineModel, pLogger);
            this.smgState = pSmgState;
            this.edge = pEdge;
        }

        public SMGState getNewState() {
            return this.smgState;
        }

        public CFAEdge getEdge() {
            return this.edge;
        }

        private SMGTransferRelation.SMGExplicitValue getExplicitValue(SMGTransferRelation.SMGSymbolicValue pValue) {
            if (pValue.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            SMGTransferRelation.SMGExplicitValue explicitValue = this.smgState.getExplicit((SMGTransferRelation.SMGKnownSymValue)pValue);
            return explicitValue;
        }

        protected void setSmgState(SMGState pSmgState) {
            this.smgState = pSmgState;
        }

        @Override
        public Value visit(CBinaryExpression binaryExp) throws UnrecognizedCCodeException {
            Value value = super.visit(binaryExp);
            if (value.isUnknown() && this.isPointerComparison(binaryExp)) {
                SMGValueAndState symValueAndState = null;
                try {
                    symValueAndState = SMGExpressionEvaluator.this.evaluateAssumptionValue(this.smgState, this.edge, binaryExp);
                }
                catch (CPATransferException e) {
                    UnrecognizedCCodeException e2 = new UnrecognizedCCodeException("SMG cannot be evaluated", binaryExp);
                    e2.initCause(e);
                    throw e2;
                }
                SMGTransferRelation.SMGSymbolicValue symValue = symValueAndState.getValue();
                this.smgState = symValueAndState.getSmgState();
                if (symValue.equals(SMGTransferRelation.SMGKnownSymValue.TRUE)) {
                    return new NumericValue(1);
                }
                if (symValue.equals(SMGTransferRelation.SMGKnownSymValue.FALSE)) {
                    return new NumericValue(0);
                }
            }
            return value;
        }

        private boolean isPointerComparison(CBinaryExpression pE) {
            switch (pE.getOperator()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected Value evaluateCPointerExpression(CPointerExpression pCPointerExpression) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pCPointerExpression);
        }

        private Value evaluateLeftHandSideExpression(CLeftHandSide leftHandSide) throws UnrecognizedCCodeException {
            SMGValueAndState valueAndState = null;
            try {
                valueAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(this.smgState, this.edge, leftHandSide);
            }
            catch (CPATransferException e) {
                UnrecognizedCCodeException e2 = new UnrecognizedCCodeException("SMG cannot be evaluated", leftHandSide);
                e2.initCause(e);
                throw e2;
            }
            SMGTransferRelation.SMGSymbolicValue value = valueAndState.getValue();
            this.smgState = valueAndState.getSmgState();
            SMGTransferRelation.SMGExplicitValue expValue = this.getExplicitValue(value);
            if (expValue.isUnknown()) {
                return Value.UnknownValue.getInstance();
            }
            return new NumericValue(expValue.getAsLong());
        }

        @Override
        protected Value evaluateCIdExpression(CIdExpression pCIdExpression) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pCIdExpression);
        }

        @Override
        protected Value evaluateJIdExpression(JIdExpression pVarName) {
            return null;
        }

        @Override
        protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pLValue);
        }

        @Override
        protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pLValue);
        }
    }

    class ExpressionValueVisitor
    extends DefaultCExpressionVisitor<SMGValueAndState, CPATransferException>
    implements CRightHandSideVisitor<SMGValueAndState, CPATransferException> {
        protected final CFAEdge cfaEdge;
        protected final SMGState initialSmgState;

        public ExpressionValueVisitor(CFAEdge pEdge, SMGState pSmgState) {
            this.cfaEdge = pEdge;
            this.initialSmgState = pSmgState;
        }

        @Override
        protected SMGValueAndState visitDefault(CExpression pExp) {
            return SMGValueAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGValueAndState visit(CArraySubscriptExpression exp) throws CPATransferException {
            SMGAddressAndState addressAndState = SMGExpressionEvaluator.this.evaluateArraySubscriptAddress(this.getInitialSmgState(), this.getCfaEdge(), exp);
            SMGTransferRelation.SMGAddress address = addressAndState.getAddress();
            SMGState newState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                return SMGValueAndState.of(newState);
            }
            return SMGExpressionEvaluator.this.readValue(newState, address.getObject(), address.getOffset(), SMGExpressionEvaluator.this.getRealExpressionType(exp), this.cfaEdge);
        }

        @Override
        public SMGValueAndState visit(CIntegerLiteralExpression exp) throws CPATransferException {
            BigInteger value = exp.getValue();
            boolean isZero = value.equals(BigInteger.ZERO);
            SMGTransferRelation.SMGSymbolicValue val = isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
            return SMGValueAndState.of(this.getInitialSmgState(), val);
        }

        @Override
        public SMGValueAndState visit(CCharLiteralExpression exp) throws CPATransferException {
            char value = exp.getCharacter();
            SMGTransferRelation.SMGSymbolicValue val = value == '\u0000' ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
            return SMGValueAndState.of(this.getInitialSmgState(), val);
        }

        @Override
        public SMGValueAndState visit(CFieldReference fieldReference) throws CPATransferException {
            SMGAddressAndState addressOfFieldAndState = SMGExpressionEvaluator.this.getAddressOfField(this.getInitialSmgState(), this.getCfaEdge(), fieldReference);
            SMGTransferRelation.SMGAddress addressOfField = addressOfFieldAndState.getAddress();
            SMGState newState = addressOfFieldAndState.getSmgState();
            if (addressOfField.isUnknown()) {
                return SMGValueAndState.of(newState);
            }
            CType fieldType = fieldReference.getExpressionType().getCanonicalType();
            return SMGExpressionEvaluator.this.readValue(newState, addressOfField.getObject(), addressOfField.getOffset(), fieldType, this.cfaEdge);
        }

        @Override
        public SMGValueAndState visit(CFloatLiteralExpression exp) throws CPATransferException {
            boolean isZero = exp.getValue().equals(BigDecimal.ZERO);
            SMGTransferRelation.SMGSymbolicValue val = isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
            return SMGValueAndState.of(this.getInitialSmgState(), val);
        }

        @Override
        public SMGValueAndState visit(CIdExpression idExpression) throws CPATransferException {
            CSimpleDeclaration decl = idExpression.getDeclaration();
            if (decl instanceof CEnumType.CEnumerator) {
                long enumValue = ((CEnumType.CEnumerator)decl).getValue();
                SMGTransferRelation.SMGSymbolicValue val = enumValue == 0L ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                return SMGValueAndState.of(this.getInitialSmgState(), val);
            }
            if (decl instanceof CVariableDeclaration || decl instanceof CParameterDeclaration) {
                SMGState smgState = this.getInitialSmgState();
                SMGObject variableObject = smgState.getObjectForVisibleVariable(idExpression.getName());
                return SMGExpressionEvaluator.this.readValue(smgState, variableObject, SMGTransferRelation.SMGKnownExpValue.ZERO, SMGExpressionEvaluator.this.getRealExpressionType(idExpression), this.cfaEdge);
            }
            return SMGValueAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGValueAndState visit(CUnaryExpression unaryExpression) throws CPATransferException {
            CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            CExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case AMPER: {
                    throw new UnrecognizedCCodeException("Can't use & of expression " + unaryOperand.toASTString(), this.cfaEdge, unaryExpression);
                }
                case MINUS: {
                    SMGValueAndState valueAndState = unaryOperand.accept(this);
                    SMGTransferRelation.SMGSymbolicValue value = valueAndState.getValue();
                    SMGTransferRelation.SMGSymbolicValue val = value.equals(SMGTransferRelation.SMGKnownSymValue.ZERO) ? value : SMGTransferRelation.SMGUnknownValue.getInstance();
                    return SMGValueAndState.of(valueAndState.getSmgState(), val);
                }
                case SIZEOF: {
                    int size = SMGExpressionEvaluator.this.getSizeof(this.cfaEdge, SMGExpressionEvaluator.this.getRealExpressionType(unaryOperand));
                    SMGTransferRelation.SMGSymbolicValue val = size == 0 ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                    return SMGValueAndState.of(this.getInitialSmgState(), val);
                }
            }
            return SMGValueAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGValueAndState visit(CPointerExpression pointerExpression) throws CPATransferException {
            CExpression operand = pointerExpression.getOperand();
            CType operandType = SMGExpressionEvaluator.this.getRealExpressionType(operand);
            CType expType = SMGExpressionEvaluator.this.getRealExpressionType(pointerExpression);
            if (operandType instanceof CPointerType) {
                return this.dereferencePointer(operand, expType);
            }
            if (operandType instanceof CArrayType) {
                return this.dereferenceArray(operand, expType);
            }
            throw new UnrecognizedCCodeException("on pointer expression", this.cfaEdge, pointerExpression);
        }

        @Override
        public SMGValueAndState visit(CTypeIdExpression typeIdExp) throws UnrecognizedCCodeException {
            CTypeIdExpression.TypeIdOperator typeOperator = typeIdExp.getOperator();
            CType type = typeIdExp.getType();
            switch (typeOperator) {
                case SIZEOF: {
                    SMGTransferRelation.SMGSymbolicValue val = SMGExpressionEvaluator.this.getSizeof(this.cfaEdge, type) == 0 ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                    return SMGValueAndState.of(this.getInitialSmgState(), val);
                }
            }
            return SMGValueAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGValueAndState visit(CBinaryExpression exp) throws CPATransferException {
            CBinaryExpression.BinaryOperator binaryOperator = exp.getOperator();
            CExpression lVarInBinaryExp = exp.getOperand1();
            CExpression rVarInBinaryExp = exp.getOperand2();
            switch (binaryOperator) {
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case MULTIPLY: 
                case MODULO: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: 
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    SMGValueAndState lValAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), lVarInBinaryExp);
                    SMGTransferRelation.SMGSymbolicValue lVal = lValAndState.getValue();
                    SMGState newState = lValAndState.getSmgState();
                    if (lVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGValueAndState.of(newState);
                    }
                    SMGValueAndState rValAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), rVarInBinaryExp);
                    SMGTransferRelation.SMGSymbolicValue rVal = rValAndState.getValue();
                    newState = rValAndState.getSmgState();
                    if (rVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGValueAndState.of(newState);
                    }
                    switch (binaryOperator) {
                        case PLUS: 
                        case SHIFT_LEFT: 
                        case SHIFT_RIGHT: 
                        case BINARY_OR: 
                        case BINARY_XOR: {
                            boolean isZero = lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO) && rVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO);
                            SMGTransferRelation.SMGSymbolicValue val = isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                            return SMGValueAndState.of(newState, val);
                        }
                        case MINUS: 
                        case MODULO: {
                            boolean isZero = lVal.equals(rVal);
                            SMGTransferRelation.SMGSymbolicValue val = isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                            return SMGValueAndState.of(newState, val);
                        }
                        case DIVIDE: {
                            if (rVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO)) {
                                return SMGValueAndState.of(newState);
                            }
                            boolean isZero = lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO);
                            SMGTransferRelation.SMGSymbolicValue val = isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                            return SMGValueAndState.of(newState, val);
                        }
                        case MULTIPLY: 
                        case BINARY_AND: {
                            boolean isZero = lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO) || rVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO);
                            SMGTransferRelation.SMGSymbolicValue val = isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                            return SMGValueAndState.of(newState, val);
                        }
                    }
                    throw new AssertionError();
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    SMGValueAndState lValAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), lVarInBinaryExp);
                    SMGTransferRelation.SMGSymbolicValue lVal = lValAndState.getValue();
                    SMGState newState = lValAndState.getSmgState();
                    if (lVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGValueAndState.of(newState);
                    }
                    SMGValueAndState rValAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), rVarInBinaryExp);
                    SMGTransferRelation.SMGSymbolicValue rVal = rValAndState.getValue();
                    newState = rValAndState.getSmgState();
                    if (rVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGValueAndState.of(newState);
                    }
                    AssumeVisitor v = SMGExpressionEvaluator.this.getAssumeVisitor(this.getCfaEdge(), newState);
                    SMGTransferRelation.SMGSymbolicValue assumptionVal = v.evaluateBinaryAssumption(newState, binaryOperator, lVal, rVal);
                    if (assumptionVal == SMGTransferRelation.SMGKnownSymValue.FALSE) {
                        return SMGValueAndState.of(newState, SMGTransferRelation.SMGKnownSymValue.ZERO);
                    }
                    return SMGValueAndState.of(newState);
                }
            }
            return SMGValueAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGValueAndState visit(CCastExpression cast) throws CPATransferException {
            return SMGExpressionEvaluator.this.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), cast.getOperand());
        }

        protected SMGValueAndState dereferenceArray(CExpression exp, CType derefType) throws CPATransferException {
            ArrayVisitor v = SMGExpressionEvaluator.this.getArrayVisitor(this.getCfaEdge(), this.getInitialSmgState());
            SMGAddressAndState addressAndState = exp.accept(v);
            SMGTransferRelation.SMGAddress address = addressAndState.getAddress();
            SMGState newState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                return SMGExpressionEvaluator.this.handleUnknownDereference(newState, this.cfaEdge);
            }
            if (derefType instanceof CArrayType) {
                return SMGExpressionEvaluator.this.createAddress(newState, address.getObject(), address.getOffset());
            }
            return SMGExpressionEvaluator.this.readValue(newState, address.getObject(), address.getOffset(), derefType, this.cfaEdge);
        }

        protected final SMGValueAndState dereferencePointer(CExpression exp, CType derefType) throws CPATransferException {
            SMGAddressValueAndState addressAndState = SMGExpressionEvaluator.this.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), exp);
            SMGTransferRelation.SMGAddressValue address = addressAndState.getValue();
            SMGState newState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                return SMGExpressionEvaluator.this.handleUnknownDereference(newState, this.getCfaEdge());
            }
            if (derefType instanceof CArrayType) {
                return SMGExpressionEvaluator.this.createAddress(newState, address.getObject(), address.getOffset());
            }
            return SMGExpressionEvaluator.this.readValue(newState, address.getObject(), address.getOffset(), derefType, this.cfaEdge);
        }

        @Override
        public SMGValueAndState visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            return SMGValueAndState.of(this.getInitialSmgState());
        }

        public SMGState getInitialSmgState() {
            return this.initialSmgState;
        }

        public CFAEdge getCfaEdge() {
            return this.cfaEdge;
        }
    }

    class StructAndUnionVisitor
    extends AddressVisitor
    implements CRightHandSideVisitor<SMGAddressAndState, CPATransferException> {
        public StructAndUnionVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            super(pCfaEdge, pNewState);
        }

        @Override
        public SMGAddressAndState visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            return SMGAddressAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGAddressAndState visit(CCastExpression cast) throws CPATransferException {
            CExpression op = cast.getOperand();
            if (SMGExpressionEvaluator.this.isStructOrUnionType(op.getExpressionType())) {
                return cast.getOperand().accept(this);
            }
            return SMGAddressAndState.of(this.getInitialSmgState());
        }
    }

    class AssumeVisitor
    extends ExpressionValueVisitor {
        private BinaryRelationEvaluator relation;

        public AssumeVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
            this.relation = null;
        }

        @Override
        public SMGValueAndState visit(CBinaryExpression pExp) throws CPATransferException {
            CBinaryExpression.BinaryOperator binaryOperator = pExp.getOperator();
            switch (binaryOperator) {
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    CExpression leftSideExpression = pExp.getOperand1();
                    CExpression rightSideExpression = pExp.getOperand2();
                    CFAEdge cfaEdge = this.getCfaEdge();
                    SMGValueAndState leftSideValAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(this.getInitialSmgState(), cfaEdge, leftSideExpression);
                    SMGTransferRelation.SMGSymbolicValue leftSideVal = leftSideValAndState.getValue();
                    SMGState newState = leftSideValAndState.getSmgState();
                    SMGValueAndState rightSideValAndState = SMGExpressionEvaluator.this.evaluateExpressionValue(newState, cfaEdge, rightSideExpression);
                    SMGTransferRelation.SMGSymbolicValue rightSideVal = rightSideValAndState.getValue();
                    newState = rightSideValAndState.getSmgState();
                    SMGTransferRelation.SMGSymbolicValue result = this.evaluateBinaryAssumption(newState, binaryOperator, leftSideVal, rightSideVal);
                    return SMGValueAndState.of(newState, result);
                }
            }
            return super.visit(pExp);
        }

        public SMGTransferRelation.SMGSymbolicValue evaluateBinaryAssumption(SMGState newState, CBinaryExpression.BinaryOperator pOp, SMGTransferRelation.SMGSymbolicValue v1, SMGTransferRelation.SMGSymbolicValue v2) throws SMGInconsistentException {
            this.relation = new BinaryRelationEvaluator(newState, pOp, v1, v2);
            if (this.relation.isFalse()) {
                return SMGTransferRelation.SMGKnownSymValue.FALSE;
            }
            if (this.relation.isTrue()) {
                return SMGTransferRelation.SMGKnownSymValue.TRUE;
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        public boolean impliesEqOn(boolean pTruth) {
            if (this.relation == null) {
                return false;
            }
            return this.relation.impliesEq(pTruth);
        }

        public boolean impliesNeqOn(boolean pTruth) {
            if (this.relation == null) {
                return false;
            }
            return this.relation.impliesNeq(pTruth);
        }

        public SMGTransferRelation.SMGSymbolicValue impliesVal1() {
            return this.relation.getVal1();
        }

        public SMGTransferRelation.SMGSymbolicValue impliesVal2() {
            return this.relation.getVal2();
        }

        private class BinaryRelationEvaluator {
            private boolean isTrue = false;
            private boolean isFalse = false;
            private boolean impliesEqWhenTrue = false;
            private boolean impliesNeqWhenTrue = false;
            private boolean impliesEqWhenFalse = false;
            private boolean impliesNeqWhenFalse = false;
            private final SMGTransferRelation.SMGSymbolicValue val1;
            private final SMGTransferRelation.SMGSymbolicValue val2;
            private final SMGState smgState;

            public BinaryRelationEvaluator(SMGState newState, CBinaryExpression.BinaryOperator pOp, SMGTransferRelation.SMGSymbolicValue pV1, SMGTransferRelation.SMGSymbolicValue pV2) throws SMGInconsistentException {
                int v2;
                this.smgState = newState;
                this.val1 = pV1;
                this.val2 = pV2;
                if (pV2.isUnknown() || pV1.isUnknown()) {
                    return;
                }
                boolean isPointerOp1 = this.isPointer(pV1);
                boolean isPointerOp2 = this.isPointer(pV2);
                int v1 = pV1.getAsInt();
                boolean areEqual = v1 == (v2 = pV2.getAsInt());
                boolean areNonEqual = this.isUnequal(pV1, pV2, isPointerOp1, isPointerOp2);
                block0 : switch (pOp) {
                    case NOT_EQUALS: {
                        this.isTrue = areNonEqual;
                        this.isFalse = areEqual;
                        this.impliesEqWhenFalse = true;
                        this.impliesNeqWhenTrue = true;
                        break;
                    }
                    case EQUALS: {
                        this.isTrue = areEqual;
                        this.isFalse = areNonEqual;
                        this.impliesEqWhenTrue = true;
                        this.impliesNeqWhenFalse = true;
                        break;
                    }
                    case GREATER_THAN: 
                    case GREATER_EQUAL: 
                    case LESS_THAN: 
                    case LESS_EQUAL: {
                        SMGObject object2;
                        switch (pOp) {
                            case GREATER_EQUAL: 
                            case LESS_EQUAL: {
                                if (areEqual) {
                                    this.isTrue = true;
                                    this.impliesEqWhenTrue = true;
                                    this.impliesNeqWhenFalse = true;
                                    break;
                                }
                                this.impliesNeqWhenFalse = true;
                                break;
                            }
                            case GREATER_THAN: 
                            case LESS_THAN: {
                                if (areEqual) {
                                    this.isFalse = true;
                                }
                                this.impliesNeqWhenTrue = true;
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)"Impossible case thrown");
                            }
                        }
                        if (!isPointerOp1 || !isPointerOp2) break;
                        SMGTransferRelation.SMGAddressValue pointer1 = this.getAddressOfPointer(pV1);
                        SMGTransferRelation.SMGAddressValue pointer2 = this.getAddressOfPointer(pV2);
                        SMGObject object1 = pointer1.getObject();
                        if (object1 != (object2 = pointer2.getObject())) break;
                        int offset1 = pointer1.getOffset().getAsInt();
                        int offset2 = pointer2.getOffset().getAsInt();
                        switch (pOp) {
                            case GREATER_EQUAL: {
                                this.isTrue = offset1 >= offset2;
                                this.isFalse = !this.isTrue;
                                break block0;
                            }
                            case GREATER_THAN: {
                                this.isTrue = offset1 > offset2;
                                this.isFalse = !this.isTrue;
                                break block0;
                            }
                            case LESS_EQUAL: {
                                this.isTrue = offset1 <= offset2;
                                this.isFalse = !this.isTrue;
                                break block0;
                            }
                            case LESS_THAN: {
                                this.isTrue = offset1 < offset2;
                                this.isFalse = !this.isTrue;
                                break block0;
                            }
                        }
                        throw new AssertionError((Object)"Impossible case thrown");
                    }
                    default: {
                        throw new AssertionError((Object)("Binary Relation with non-relational operator: " + pOp.toString()));
                    }
                }
            }

            private boolean isPointer(SMGTransferRelation.SMGSymbolicValue symVal) {
                if (symVal.isUnknown()) {
                    return false;
                }
                if (symVal instanceof SMGTransferRelation.SMGAddressValue) {
                    return true;
                }
                return this.smgState.isPointer(symVal.getAsInt());
            }

            private boolean isUnequal(SMGTransferRelation.SMGSymbolicValue pValue1, SMGTransferRelation.SMGSymbolicValue pValue2, boolean isPointerOp1, boolean isPointerOp2) throws SMGInconsistentException {
                int value1 = pValue1.getAsInt();
                int value2 = pValue2.getAsInt();
                if (isPointerOp1 && isPointerOp2) {
                    if (value1 != value2) {
                        SMGTransferRelation.SMGAddressValue pointerValue1 = this.getAddressOfPointer(pValue1);
                        SMGTransferRelation.SMGAddressValue pointerValue2 = this.getAddressOfPointer(pValue2);
                        return pointerValue1.getObject() != pointerValue2.getObject() || pointerValue1.getOffset() != pointerValue2.getOffset();
                    }
                    return false;
                }
                if (isPointerOp1 && value2 == 0 || isPointerOp2 && value1 == 0) {
                    return value1 != value2;
                }
                return this.smgState.isInNeq(pValue1, pValue2);
            }

            private SMGTransferRelation.SMGAddressValue getAddressOfPointer(SMGTransferRelation.SMGSymbolicValue pPointer) throws SMGInconsistentException {
                assert (!pPointer.isUnknown());
                if (pPointer instanceof SMGTransferRelation.SMGAddressValue) {
                    return (SMGTransferRelation.SMGAddressValue)pPointer;
                }
                SMGEdgePointsTo edge = this.smgState.getPointerFromValue(pPointer.getAsInt());
                return SMGTransferRelation.SMGKnownAddVal.valueOf(edge.getValue(), edge.getObject(), edge.getOffset());
            }

            public boolean isTrue() {
                return this.isTrue;
            }

            public boolean isFalse() {
                return this.isFalse;
            }

            public boolean impliesEq(boolean pTruth) {
                return pTruth ? this.impliesEqWhenTrue : this.impliesEqWhenFalse;
            }

            public boolean impliesNeq(boolean pTruth) {
                return pTruth ? this.impliesNeqWhenTrue : this.impliesNeqWhenFalse;
            }

            public SMGTransferRelation.SMGSymbolicValue getVal2() {
                return this.val2;
            }

            public SMGTransferRelation.SMGSymbolicValue getVal1() {
                return this.val1;
            }
        }
    }

    class ArrayVisitor
    extends AddressVisitor
    implements CRightHandSideVisitor<SMGAddressAndState, CPATransferException> {
        public ArrayVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
        }

        @Override
        protected SMGAddressAndState visitDefault(CExpression exp) {
            return SMGAddressAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGAddressAndState visit(CUnaryExpression unaryExpression) throws CPATransferException {
            throw new AssertionError((Object)"The result of any unary expression cannot be an array type.");
        }

        @Override
        public SMGAddressAndState visit(CBinaryExpression binaryExp) throws CPATransferException {
            CExpression lVarInBinaryExp = binaryExp.getOperand1();
            CExpression rVarInBinaryExp = binaryExp.getOperand2();
            CType lVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(lVarInBinaryExp);
            CType rVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(rVarInBinaryExp);
            boolean lVarIsAddress = lVarInBinaryExpType instanceof CArrayType;
            boolean rVarIsAddress = rVarInBinaryExpType instanceof CArrayType;
            CExpression address = null;
            CExpression arrayOffset = null;
            CType addressType = null;
            if (lVarIsAddress == rVarIsAddress) {
                return SMGAddressAndState.of(this.getInitialSmgState());
            }
            if (lVarIsAddress) {
                address = lVarInBinaryExp;
                arrayOffset = rVarInBinaryExp;
                addressType = lVarInBinaryExpType;
            } else if (rVarIsAddress) {
                address = rVarInBinaryExp;
                arrayOffset = lVarInBinaryExp;
                addressType = rVarInBinaryExpType;
            } else {
                throw new UnrecognizedCCodeException("Expected either " + lVarInBinaryExp.toASTString() + " or " + rVarInBinaryExp.toASTString() + "to be a pointer to an array.", binaryExp);
            }
            SMGAddressValueAndState result = SMGExpressionEvaluator.this.handlePointerArithmetic(this.getInitialSmgState(), this.getCfaEdge(), address, arrayOffset, addressType, lVarIsAddress, binaryExp);
            return result.asSMGAddressAndState();
        }

        @Override
        public SMGAddressAndState visit(CIdExpression pVariableName) throws CPATransferException {
            SMGAddressAndState addressAndState = super.visit(pVariableName);
            if (pVariableName.getDeclaration() instanceof CParameterDeclaration) {
                SMGTransferRelation.SMGAddress address = addressAndState.getAddress();
                SMGState newState = addressAndState.getSmgState();
                SMGValueAndState pointerAndState = SMGExpressionEvaluator.this.readValue(newState, address.getObject(), address.getOffset(), SMGExpressionEvaluator.this.getRealExpressionType(pVariableName), this.getCfaEdge());
                SMGAddressValueAndState trueAddressAndState = SMGExpressionEvaluator.this.getAddressFromSymbolicValue(pointerAndState);
                return trueAddressAndState.asSMGAddressAndState();
            }
            return addressAndState;
        }

        @Override
        public SMGAddressAndState visit(CCastExpression cast) throws CPATransferException {
            CExpression op = cast.getOperand();
            if (op.getExpressionType() instanceof CArrayType) {
                return cast.getOperand().accept(this);
            }
            return SMGAddressAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGAddressAndState visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            return SMGAddressAndState.of(this.getInitialSmgState());
        }
    }

    class PointerVisitor
    extends ExpressionValueVisitor {
        public PointerVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
        }

        @Override
        public SMGAddressValueAndState visit(CIntegerLiteralExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(exp));
        }

        @Override
        public SMGAddressValueAndState visit(CCharLiteralExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(exp));
        }

        @Override
        public SMGAddressValueAndState visit(CFloatLiteralExpression pExp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(pExp));
        }

        @Override
        public SMGAddressValueAndState visit(CIdExpression exp) throws CPATransferException {
            CType c = SMGExpressionEvaluator.this.getRealExpressionType(exp);
            if (c instanceof CArrayType) {
                return this.createAddressOfVariable(exp);
            }
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(exp));
        }

        @Override
        public SMGAddressValueAndState visit(CUnaryExpression unaryExpression) throws CPATransferException {
            CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            CExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case AMPER: {
                    return this.handleAmper(unaryOperand);
                }
                case SIZEOF: {
                    throw new UnrecognizedCCodeException("Misinterpreted the expression type of " + unaryOperand.toASTString() + " as pointer type", this.cfaEdge, unaryExpression);
                }
            }
            return SMGAddressValueAndState.of(this.getInitialSmgState());
        }

        private SMGAddressValueAndState handleAmper(CRightHandSide amperOperand) throws CPATransferException {
            if (amperOperand instanceof CIdExpression) {
                return this.createAddressOfVariable((CIdExpression)amperOperand);
            }
            if (amperOperand instanceof CPointerExpression) {
                CExpression rValue = ((CPointerExpression)amperOperand).getOperand();
                return SMGExpressionEvaluator.this.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), rValue);
            }
            if (amperOperand instanceof CFieldReference) {
                return this.createAddressOfField((CFieldReference)amperOperand);
            }
            if (amperOperand instanceof CArraySubscriptExpression) {
                return this.createAddressOfArraySubscript((CArraySubscriptExpression)amperOperand);
            }
            return SMGAddressValueAndState.of(this.getInitialSmgState());
        }

        private SMGAddressValueAndState createAddressOfArraySubscript(CArraySubscriptExpression lValue) throws CPATransferException {
            CExpression arrayExpression = lValue.getArrayExpression();
            SMGAddressValueAndState arrayAddressAndState = SMGExpressionEvaluator.this.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), arrayExpression);
            SMGTransferRelation.SMGAddressValue arrayAddress = arrayAddressAndState.getValue();
            SMGState newState = arrayAddressAndState.getSmgState();
            if (arrayAddress.isUnknown()) {
                return SMGAddressValueAndState.of(newState);
            }
            CExpression subscriptExpr = lValue.getSubscriptExpression();
            SMGExplicitValueAndState subscriptValueAndState = SMGExpressionEvaluator.this.evaluateExplicitValue(newState, this.getCfaEdge(), subscriptExpr);
            SMGTransferRelation.SMGExplicitValue subscriptValue = subscriptValueAndState.getValue();
            newState = subscriptValueAndState.getSmgState();
            if (subscriptValue.isUnknown()) {
                return SMGAddressValueAndState.of(newState);
            }
            SMGTransferRelation.SMGExplicitValue arrayOffset = arrayAddress.getOffset();
            int typeSize = SMGExpressionEvaluator.this.getSizeof(this.getCfaEdge(), SMGExpressionEvaluator.this.getRealExpressionType(lValue));
            SMGTransferRelation.SMGKnownExpValue sizeOfType = SMGTransferRelation.SMGKnownExpValue.valueOf(typeSize);
            SMGTransferRelation.SMGExplicitValue offset = arrayOffset.add(subscriptValue).multiply(sizeOfType);
            return SMGExpressionEvaluator.this.createAddress(newState, arrayAddress.getObject(), offset);
        }

        private SMGAddressValueAndState createAddressOfField(CFieldReference lValue) throws CPATransferException {
            SMGAddressAndState addressOfFieldAndState = SMGExpressionEvaluator.this.getAddressOfField(this.getInitialSmgState(), this.getCfaEdge(), lValue);
            SMGTransferRelation.SMGAddress addressOfField = addressOfFieldAndState.getAddress();
            SMGState newState = addressOfFieldAndState.getSmgState();
            if (addressOfField.isUnknown()) {
                return SMGAddressValueAndState.of(newState);
            }
            return SMGExpressionEvaluator.this.createAddress(addressOfFieldAndState.getSmgState(), addressOfField.getObject(), addressOfField.getOffset());
        }

        private SMGAddressValueAndState createAddressOfVariable(CIdExpression idExpression) throws SMGInconsistentException {
            SMGState state = this.getInitialSmgState();
            SMGObject variableObject = state.getObjectForVisibleVariable(idExpression.getName());
            if (variableObject == null) {
                return SMGAddressValueAndState.of(state);
            }
            return SMGExpressionEvaluator.this.createAddress(state, variableObject, SMGTransferRelation.SMGKnownExpValue.ZERO);
        }

        @Override
        public SMGAddressValueAndState visit(CPointerExpression pointerExpression) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(pointerExpression));
        }

        @Override
        public SMGAddressValueAndState visit(CBinaryExpression binaryExp) throws CPATransferException {
            CExpression lVarInBinaryExp = binaryExp.getOperand1();
            CExpression rVarInBinaryExp = binaryExp.getOperand2();
            CType lVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(lVarInBinaryExp);
            CType rVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(rVarInBinaryExp);
            boolean lVarIsAddress = lVarInBinaryExpType instanceof CPointerType;
            boolean rVarIsAddress = rVarInBinaryExpType instanceof CPointerType;
            CExpression address = null;
            CExpression pointerOffset = null;
            CPointerType addressType = null;
            if (lVarIsAddress == rVarIsAddress) {
                return SMGAddressValueAndState.of(this.getInitialSmgState());
            }
            if (lVarIsAddress) {
                address = lVarInBinaryExp;
                pointerOffset = rVarInBinaryExp;
                addressType = (CPointerType)lVarInBinaryExpType;
            } else if (rVarIsAddress) {
                address = rVarInBinaryExp;
                pointerOffset = lVarInBinaryExp;
                addressType = (CPointerType)rVarInBinaryExpType;
            } else {
                throw new UnrecognizedCCodeException("Expected either " + lVarInBinaryExp.toASTString() + " or " + rVarInBinaryExp.toASTString() + "to be a pointer.", binaryExp);
            }
            CType typeOfPointer = addressType.getType().getCanonicalType();
            return SMGExpressionEvaluator.this.handlePointerArithmetic(this.getInitialSmgState(), this.getCfaEdge(), address, pointerOffset, typeOfPointer, lVarIsAddress, binaryExp);
        }

        @Override
        public SMGAddressValueAndState visit(CArraySubscriptExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(exp));
        }

        @Override
        public SMGAddressValueAndState visit(CFieldReference exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(exp));
        }

        @Override
        public SMGAddressValueAndState visit(CCastExpression pCast) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(super.visit(pCast));
        }
    }

    private abstract class AddressVisitor
    extends DefaultCExpressionVisitor<SMGAddressAndState, CPATransferException>
    implements CRightHandSideVisitor<SMGAddressAndState, CPATransferException> {
        private final CFAEdge cfaEdge;
        private final SMGState initialSmgState;

        public AddressVisitor(CFAEdge pEdge, SMGState pSmgState) {
            this.cfaEdge = pEdge;
            this.initialSmgState = pSmgState;
        }

        @Override
        protected SMGAddressAndState visitDefault(CExpression pExp) throws CPATransferException {
            return SMGAddressAndState.of(this.getInitialSmgState());
        }

        @Override
        public SMGAddressAndState visit(CIdExpression variableName) throws CPATransferException {
            SMGObject object = this.getInitialSmgState().getObjectForVisibleVariable(variableName.getName());
            return SMGAddressAndState.of(this.getInitialSmgState(), SMGTransferRelation.SMGAddress.valueOf(object, SMGTransferRelation.SMGKnownExpValue.ZERO));
        }

        @Override
        public SMGAddressAndState visit(CArraySubscriptExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.evaluateArraySubscriptAddress(this.getInitialSmgState(), this.getCfaEdge(), exp);
        }

        @Override
        public SMGAddressAndState visit(CFieldReference pE) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressOfField(this.getInitialSmgState(), this.getCfaEdge(), pE);
        }

        @Override
        public SMGAddressAndState visit(CPointerExpression pointerExpression) throws CPATransferException {
            CExpression operand = pointerExpression.getOperand();
            assert (operand.getExpressionType().getCanonicalType() instanceof CPointerType || operand.getExpressionType().getCanonicalType() instanceof CArrayType);
            SMGAddressValueAndState addressValueAndState = SMGExpressionEvaluator.this.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), operand);
            SMGTransferRelation.SMGAddressValue addressValue = addressValueAndState.getValue();
            SMGState newState = addressValueAndState.getSmgState();
            if (addressValue.isUnknown()) {
                return SMGAddressAndState.of(newState);
            }
            return SMGAddressAndState.of(newState, addressValue.getAddress());
        }

        public final CFAEdge getCfaEdge() {
            return this.cfaEdge;
        }

        public final SMGState getInitialSmgState() {
            return this.initialSmgState;
        }
    }

    public class LValueAssignmentVisitor
    extends AddressVisitor {
        public LValueAssignmentVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
        }

        @Override
        public SMGAddressAndState visit(CUnaryExpression lValue) throws CPATransferException {
            throw new UnrecognizedCCodeException(lValue.toASTString() + " is not an lValue", this.getCfaEdge(), lValue);
        }

        @Override
        public SMGAddressAndState visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            throw new AssertionError((Object)"This expression is not a lValue expression.");
        }
    }
}

