/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGObjectNode;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObjectVisitor;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.objects.sll.SMGSingleLinkedList;

class SMGNodeDotVisitor
implements SMGObjectVisitor {
    private final CLangSMG smg;
    private SMGObjectNode node = null;

    public SMGNodeDotVisitor(CLangSMG pSmg) {
        this.smg = pSmg;
    }

    private String defaultDefinition(String pColor, String pShape, String pStyle, SMGObject pObject) {
        return "color=" + pColor + ", shape=" + pShape + ", style=" + pStyle + ", label =\"" + pObject.toString() + "\"";
    }

    @Override
    public void visit(SMGRegion pRegion) {
        String style;
        String color;
        String shape = "rectangle";
        if (this.smg.isObjectValid(pRegion)) {
            color = "black";
            style = "solid";
        } else {
            color = "red";
            style = "dotted";
        }
        this.node = new SMGObjectNode("region", this.defaultDefinition(color, shape, style, pRegion));
    }

    @Override
    public void visit(SMGSingleLinkedList pSll) {
        String shape = "rectangle";
        String color = "blue";
        if (!this.smg.isObjectValid(pSll)) {
            color = "red";
        }
        String style = "dashed";
        this.node = new SMGObjectNode("sll", this.defaultDefinition(color, shape, style, pSll));
    }

    @Override
    public void visit(SMGObject pObject) {
        if (pObject.notNull()) {
            pObject.accept(this);
        } else {
            this.node = new SMGObjectNode("NULL");
        }
    }

    public SMGObjectNode getNode() {
        return this.node;
    }
}

