/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGNodeDotVisitor;
import org.sosy_lab.cpachecker.cpa.smg.SMGObjectNode;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public final class SMGPlotter {
    private final HashMap<SMGObject, SMGObjectNode> objectIndex = new HashMap();
    private static int nulls = 0;
    private int offset = 0;

    public static final void debuggingPlot(CLangSMG pSmg, String pId, Map<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue> explicitValues) throws IOException {
        PathTemplate exportSMGFilePattern = PathTemplate.ofFormatString((String)"smg-debug-%s.dot");
        pId = pId.replace("\"", "");
        Path outputFile = exportSMGFilePattern.getPath(new Object[]{pId});
        SMGPlotter plotter = new SMGPlotter();
        Files.writeFile((Path)outputFile, (Object)plotter.smgAsDot(pSmg, pId, "debug plot", explicitValues));
    }

    public static String convertToValidDot(String original) {
        return original.replaceAll("[:]", "_");
    }

    public String smgAsDot(CLangSMG smg, String name, String location, Map<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue> explicitValues) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph gr_" + name.replace('-', '_') + "{\n");
        this.offset += 2;
        sb.append(this.newLineWithOffset("label = \"Location: " + location.replace("\"", "\\\"") + "\";"));
        this.addStackSubgraph(smg, sb);
        SMGNodeDotVisitor visitor = new SMGNodeDotVisitor(smg);
        for (SMGObject heapObject : smg.getHeapObjects()) {
            if (!this.objectIndex.containsKey(heapObject)) {
                visitor.visit(heapObject);
                this.objectIndex.put(heapObject, visitor.getNode());
            }
            if (!heapObject.notNull()) continue;
            sb.append(this.newLineWithOffset(this.objectIndex.get(heapObject).getDefinition()));
        }
        this.addGlobalObjectSubgraph(smg, sb);
        Iterator<Object> i$ = smg.getValues().iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            if (value == smg.getNullValue()) continue;
            sb.append(this.newLineWithOffset(SMGPlotter.smgValueAsDot(value, explicitValues)));
        }
        HashSet<Integer> processed = new HashSet<Integer>();
        for (Integer n : smg.getValues()) {
            if (n.intValue() == smg.getNullValue()) continue;
            for (Integer neqValue : smg.getNeqsForValue(n)) {
                if (processed.contains(neqValue)) continue;
                sb.append(this.newLineWithOffset(SMGPlotter.neqRelationAsDot(n, neqValue)));
            }
            processed.add(n);
        }
        for (SMGEdgeHasValue sMGEdgeHasValue : smg.getHVEdges()) {
            sb.append(this.newLineWithOffset(this.smgHVEdgeAsDot(sMGEdgeHasValue)));
        }
        for (SMGEdgePointsTo sMGEdgePointsTo : smg.getPTEdges().values()) {
            if (sMGEdgePointsTo.getValue() == smg.getNullValue()) continue;
            sb.append(this.newLineWithOffset(this.smgPTEdgeAsDot(sMGEdgePointsTo)));
        }
        sb.append("}");
        return sb.toString();
    }

    private void addStackSubgraph(CLangSMG pSmg, StringBuilder pSb) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack {"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("label=\"Stack\";"));
        int i = pSmg.getStackFrames().size();
        for (CLangStackFrame stack_item : pSmg.getStackFrames()) {
            this.addStackItemSubgraph(stack_item, pSb, i);
            --i;
        }
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private void addStackItemSubgraph(CLangStackFrame pStackFrame, StringBuilder pSb, int pIndex) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack_" + pStackFrame.getFunctionDeclaration().getName() + "{"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("fontcolor=blue;"));
        pSb.append(this.newLineWithOffset("label=\"#" + pIndex + ": " + pStackFrame.getFunctionDeclaration().toASTString() + "\";"));
        HashMap<String, SMGRegion> to_print = new HashMap<String, SMGRegion>();
        to_print.putAll(pStackFrame.getVariables());
        SMGRegion returnObject = pStackFrame.getReturnObject();
        if (returnObject != null) {
            to_print.put("___cpa_temp_result_var_", returnObject);
        }
        pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(to_print, String.valueOf(pIndex))));
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private String smgScopeFrameAsDot(Map<String, SMGRegion> pNamespace, String pStructId) {
        StringBuilder sb = new StringBuilder();
        sb.append("struct" + pStructId + "[shape=record,label=\" ");
        ArrayList<String> nodes = new ArrayList<String>();
        for (Map.Entry<String, SMGRegion> entry : pNamespace.entrySet()) {
            String key = entry.getKey();
            SMGObject obj = entry.getValue();
            if (key.equals("node")) {
                key = "node1";
            }
            nodes.add("<item_" + key + "> " + obj.toString());
            this.objectIndex.put(obj, new SMGObjectNode("struct" + pStructId + ":item_" + key));
        }
        sb.append(Joiner.on((String)" | ").join(nodes));
        sb.append("\"];\n");
        return sb.toString();
    }

    private void addGlobalObjectSubgraph(CLangSMG pSmg, StringBuilder pSb) {
        if (pSmg.getGlobalObjects().size() > 0) {
            pSb.append(this.newLineWithOffset("subgraph cluster_global{"));
            this.offset += 2;
            pSb.append(this.newLineWithOffset("label=\"Global objects\";"));
            pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(pSmg.getGlobalObjects(), "global")));
            this.offset -= 2;
            pSb.append(this.newLineWithOffset("}"));
        }
    }

    private static String newNullLabel() {
        return "value_null_" + ++nulls;
    }

    private String smgHVEdgeAsDot(SMGEdgeHasValue pEdge) {
        if (pEdge.getValue() == 0) {
            String newNull = SMGPlotter.newNullLabel();
            return newNull + "[shape=plaintext, label=\"NULL\"];" + this.objectIndex.get(pEdge.getObject()).getName() + " -> " + newNull + "[label=\"[" + pEdge.getOffset() + "]\"];";
        }
        return this.objectIndex.get(pEdge.getObject()).getName() + " -> value_" + pEdge.getValue() + "[label=\"[" + pEdge.getOffset() + "]\"];";
    }

    private String smgPTEdgeAsDot(SMGEdgePointsTo pEdge) {
        return "value_" + pEdge.getValue() + " -> " + this.objectIndex.get(pEdge.getObject()).getName() + "[label=\"+" + pEdge.getOffset() + "b\"];";
    }

    private static String smgValueAsDot(int value, Map<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue> explicitValues) {
        String explicitValue = "";
        SMGTransferRelation.SMGKnownSymValue symValue = SMGTransferRelation.SMGKnownSymValue.valueOf(value);
        if (explicitValues.containsKey(symValue)) {
            explicitValue = " : " + String.valueOf(explicitValues.get(symValue).getAsLong());
        }
        return "value_" + value + "[label=\"#" + value + explicitValue + "\"];";
    }

    private static String neqRelationAsDot(Integer v1, Integer v2) {
        String targetNode;
        String returnString = "";
        if (v2.equals(0)) {
            targetNode = SMGPlotter.newNullLabel();
            returnString = targetNode + "[shape=plaintext, label=\"NULL\", fontcolor=\"red\"];\n";
        } else {
            targetNode = "value_" + v2;
        }
        return returnString + "value_" + v1 + " -> " + targetNode + "[color=\"red\", fontcolor=\"red\", label=\"neq\"]";
    }

    private String newLineWithOffset(String pLine) {
        return Strings.repeat((String)" ", (int)this.offset) + pLine + "\n";
    }
}

