/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGExplicitPlotter;
import org.sosy_lab.cpachecker.cpa.smg.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGPlotter;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGIsLessOrEqual;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public class SMGState
implements AbstractQueryableState,
LatticeAbstractState<SMGState> {
    public static final String HAS_INVALID_FREES = "has-invalid-frees";
    public static final String HAS_INVALID_READS = "has-invalid-reads";
    public static final String HAS_INVALID_WRITES = "has-invalid-writes";
    public static final String HAS_LEAKS = "has-leaks";
    private final boolean memoryErrors;
    private final boolean unknownOnUndefined;
    private final AtomicInteger id_counter;
    private final Map<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue> explicitValues = new HashMap<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue>();
    private final CLangSMG heap;
    private final LogManager logger;
    private final int predecessorId;
    private final int id;
    private final SMGRuntimeCheck runtimeCheckLevel;
    private final boolean invalidWrite;
    private final boolean invalidRead;
    private final boolean invalidFree;

    private void issueMemoryLeakMessage() {
        this.issueMemoryError("Memory leak found", false);
    }

    private void issueInvalidReadMessage() {
        this.issueMemoryError("Invalid read found", true);
    }

    private void issueInvalidWriteMessage() {
        this.issueMemoryError("Invalid write found", true);
    }

    private void issueInvalidFreeMessage() {
        this.issueMemoryError("Invalid free found", true);
    }

    private void issueMemoryError(String pMessage, boolean pUndefinedBehavior) {
        if (this.memoryErrors) {
            this.logger.log(Level.WARNING, new Object[]{pMessage});
        } else if (pUndefinedBehavior) {
            this.logger.log(Level.WARNING, new Object[]{pMessage});
            this.logger.log(Level.WARNING, new Object[]{"Non-target undefined behavior detected. The verification result is unreliable."});
        }
    }

    public SMGState(LogManager pLogger, MachineModel pMachineModel, boolean pTargetMemoryErrors, boolean pUnknownOnUndefined, SMGRuntimeCheck pSMGRuntimeCheck) {
        this.heap = new CLangSMG(pMachineModel);
        this.logger = pLogger;
        this.id_counter = new AtomicInteger(0);
        this.predecessorId = this.id_counter.getAndIncrement();
        this.id = this.id_counter.getAndIncrement();
        this.memoryErrors = pTargetMemoryErrors;
        this.unknownOnUndefined = pUnknownOnUndefined;
        this.runtimeCheckLevel = pSMGRuntimeCheck;
        this.invalidFree = false;
        this.invalidRead = false;
        this.invalidWrite = false;
    }

    SMGState(SMGState pOriginalState, SMGRuntimeCheck pSMGRuntimeCheck) {
        this.heap = new CLangSMG(pOriginalState.heap);
        this.logger = pOriginalState.logger;
        this.predecessorId = pOriginalState.getId();
        this.id_counter = pOriginalState.id_counter;
        this.id = this.id_counter.getAndIncrement();
        this.explicitValues.putAll(pOriginalState.explicitValues);
        this.memoryErrors = pOriginalState.memoryErrors;
        this.unknownOnUndefined = pOriginalState.unknownOnUndefined;
        this.runtimeCheckLevel = pSMGRuntimeCheck;
        this.invalidFree = pOriginalState.invalidFree;
        this.invalidRead = pOriginalState.invalidRead;
        this.invalidWrite = pOriginalState.invalidWrite;
    }

    public SMGState(SMGState pOriginalState) {
        this.heap = new CLangSMG(pOriginalState.heap);
        this.logger = pOriginalState.logger;
        this.predecessorId = pOriginalState.getId();
        this.id_counter = pOriginalState.id_counter;
        this.id = this.id_counter.getAndIncrement();
        this.explicitValues.putAll(pOriginalState.explicitValues);
        this.memoryErrors = pOriginalState.memoryErrors;
        this.unknownOnUndefined = pOriginalState.unknownOnUndefined;
        this.runtimeCheckLevel = pOriginalState.runtimeCheckLevel;
        this.invalidFree = pOriginalState.invalidFree;
        this.invalidRead = pOriginalState.invalidRead;
        this.invalidWrite = pOriginalState.invalidWrite;
    }

    private SMGState(SMGState pOriginalState, Property pProperty) {
        this.heap = new CLangSMG(pOriginalState.heap);
        this.logger = pOriginalState.logger;
        this.predecessorId = pOriginalState.getId();
        this.id_counter = pOriginalState.id_counter;
        this.id = this.id_counter.getAndIncrement();
        this.explicitValues.putAll(pOriginalState.explicitValues);
        this.memoryErrors = pOriginalState.memoryErrors;
        this.unknownOnUndefined = pOriginalState.unknownOnUndefined;
        this.runtimeCheckLevel = pOriginalState.runtimeCheckLevel;
        boolean pInvalidFree = pOriginalState.invalidFree;
        boolean pInvalidRead = pOriginalState.invalidRead;
        boolean pInvalidWrite = pOriginalState.invalidWrite;
        switch (pProperty) {
            case INVALID_FREE: {
                pInvalidFree = true;
                break;
            }
            case INVALID_READ: {
                pInvalidRead = true;
                break;
            }
            case INVALID_WRITE: {
                pInvalidWrite = true;
                break;
            }
            case INVALID_HEAP: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.invalidFree = pInvalidFree;
        this.invalidRead = pInvalidRead;
        this.invalidWrite = pInvalidWrite;
    }

    public SMGObject addGlobalVariable(CType pType, String pVarName) throws SMGInconsistentException {
        int size = this.heap.getMachineModel().getSizeof(pType);
        SMGRegion new_object = new SMGRegion(size, pVarName);
        this.heap.addGlobalObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new_object;
    }

    public SMGObject addLocalVariable(CType pType, String pVarName) throws SMGInconsistentException {
        int size = this.heap.getMachineModel().getSizeof(pType);
        SMGRegion new_object = new SMGRegion(size, pVarName);
        this.heap.addStackObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new_object;
    }

    public SMGObject addLocalVariable(CType pType, String pVarName, SMGRegion smgObject) throws SMGInconsistentException {
        int size = this.heap.getMachineModel().getSizeof(pType);
        SMGRegion new_object2 = new SMGRegion(size, pVarName);
        assert (smgObject.getLabel().equals(new_object2.getLabel()));
        assert (smgObject.getSize() == size || smgObject.getSize() == this.heap.getMachineModel().getSizeofPtr());
        this.heap.addStackObject(smgObject);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return smgObject;
    }

    public void addStackFrame(CFunctionDeclaration pFunctionDefinition) throws SMGInconsistentException {
        this.heap.addStackFrame(pFunctionDefinition);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    public final int getId() {
        return this.id;
    }

    public final int getPredecessorId() {
        return this.predecessorId;
    }

    public final SMGObject getFunctionReturnObject() {
        return this.heap.getFunctionReturnObject();
    }

    public SMGObject getObjectForVisibleVariable(String pVariableName) {
        return this.heap.getObjectForVisibleVariable(pVariableName);
    }

    public final void performConsistencyCheck(SMGRuntimeCheck pLevel) throws SMGInconsistentException {
        if (this.runtimeCheckLevel.isFinerOrEqualThan(pLevel) && !CLangSMGConsistencyVerifier.verifyCLangSMG(this.logger, this.heap)) {
            throw new SMGInconsistentException("SMG was found inconsistent during a check");
        }
    }

    public String toDot(String pName, String pLocation) {
        SMGPlotter plotter = new SMGPlotter();
        return plotter.smgAsDot(this.heap, pName, pLocation, this.explicitValues);
    }

    public String toDot(String pName, String pLocation, ValueAnalysisState pExplicitState) {
        SMGExplicitPlotter plotter = new SMGExplicitPlotter(pExplicitState, this);
        return plotter.smgAsDot(this.heap, "Explicit_" + pName, pLocation);
    }

    public String toString() {
        if (this.getPredecessorId() != 0) {
            return "SMGState [" + this.getId() + "] <-- parent [" + this.getPredecessorId() + "]\n" + this.heap.toString();
        }
        return "SMGState [" + this.getId() + "] <-- no parent, initial state\n" + this.heap.toString();
    }

    public SMGEdgePointsTo getPointerFromValue(Integer pValue) throws SMGInconsistentException {
        if (this.heap.isPointer(pValue)) {
            return this.heap.getPointer(pValue);
        }
        throw new SMGInconsistentException("Asked for a Points-To edge for a non-pointer value");
    }

    public boolean isPointer(Integer pValue) {
        return this.heap.isPointer(pValue);
    }

    public SMGExpressionEvaluator.SMGValueAndState forceReadValue(SMGObject pObject, int pOffset, CType pType) throws SMGInconsistentException {
        SMGExpressionEvaluator.SMGValueAndState valueAndState = this.readValue(pObject, pOffset, pType);
        if (valueAndState.getValue().isUnknown() && !valueAndState.getSmgState().invalidRead) {
            Integer newValue = SMGValueFactory.getNewValue();
            SMGStateEdgePair stateAndNewEdge = this.writeValue(pObject, pOffset, pType, newValue);
            return SMGExpressionEvaluator.SMGValueAndState.of(stateAndNewEdge.getState(), SMGTransferRelation.SMGKnownSymValue.valueOf(stateAndNewEdge.getNewEdge().getValue()));
        }
        return valueAndState;
    }

    public SMGExpressionEvaluator.SMGValueAndState readValue(SMGObject pObject, int pOffset, CType pType) throws SMGInconsistentException {
        if (!this.heap.isObjectValid(pObject)) {
            SMGState newState = this.setInvalidRead();
            return SMGExpressionEvaluator.SMGValueAndState.of(newState);
        }
        SMGEdgeHasValue edge = new SMGEdgeHasValue(pType, pOffset, pObject, 0);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        filter.filterByObject(pObject);
        filter.filterAtOffset(pOffset);
        Set<SMGEdgeHasValue> edges = this.heap.getHVEdges(filter);
        for (SMGEdgeHasValue object_edge : edges) {
            if (!edge.isCompatibleFieldOnSameObject(object_edge, this.heap.getMachineModel())) continue;
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            SMGTransferRelation.SMGKnownSymValue value = SMGTransferRelation.SMGKnownSymValue.valueOf(object_edge.getValue());
            return SMGExpressionEvaluator.SMGValueAndState.of(this, value);
        }
        if (this.heap.isCoveredByNullifiedBlocks(edge)) {
            return SMGExpressionEvaluator.SMGValueAndState.of(this, SMGTransferRelation.SMGKnownSymValue.ZERO);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return SMGExpressionEvaluator.SMGValueAndState.of(this);
    }

    public SMGState setInvalidRead() {
        return new SMGState(this, Property.INVALID_READ);
    }

    public SMGStateEdgePair writeValue(SMGObject pObject, int pOffset, CType pType, SMGTransferRelation.SMGSymbolicValue pValue) throws SMGInconsistentException {
        SMGTransferRelation.SMGAddress address;
        int value = pValue.isUnknown() ? SMGValueFactory.getNewValue().intValue() : pValue.getAsInt();
        if (pValue instanceof SMGTransferRelation.SMGAddressValue && !this.containsValue(value) && !(address = ((SMGTransferRelation.SMGAddressValue)pValue).getAddress()).isUnknown()) {
            this.addPointsToEdge(address.getObject(), address.getOffset().getAsInt(), value);
        }
        return this.writeValue(pObject, pOffset, pType, value);
    }

    private void addPointsToEdge(SMGObject pObject, int pOffset, int pValue) {
        if (!this.containsValue(pValue)) {
            this.heap.addValue(pValue);
        }
        SMGEdgePointsTo pointsToEdge = new SMGEdgePointsTo(pValue, pObject, pOffset);
        this.heap.addPointsToEdge(pointsToEdge);
    }

    private SMGStateEdgePair writeValue(SMGObject pObject, int pOffset, CType pType, Integer pValue) throws SMGInconsistentException {
        if (!this.heap.isObjectValid(pObject)) {
            SMGState newState = this.setInvalidWrite();
            return new SMGStateEdgePair(newState);
        }
        SMGEdgeHasValue new_edge = new SMGEdgeHasValue(pType, pOffset, pObject, (int)pValue);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject);
        Set<SMGEdgeHasValue> edges = this.heap.getHVEdges(filter);
        if (edges.contains(new_edge)) {
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            return new SMGStateEdgePair(this, new_edge);
        }
        if (!this.heap.getValues().contains(pValue)) {
            this.heap.addValue(pValue);
        }
        HashSet<SMGEdgeHasValue> overlappingZeroEdges = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValue hv : edges) {
            boolean hvEdgeIsZero;
            boolean hvEdgeOverlaps = new_edge.overlapsWith(hv, this.heap.getMachineModel());
            boolean bl = hvEdgeIsZero = hv.getValue() == this.heap.getNullValue();
            if (!hvEdgeOverlaps) continue;
            if (hvEdgeIsZero) {
                overlappingZeroEdges.add(hv);
                continue;
            }
            this.heap.removeHasValueEdge(hv);
        }
        this.shrinkOverlappingZeroEdges(new_edge, overlappingZeroEdges);
        this.heap.addHasValueEdge(new_edge);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new SMGStateEdgePair(this, new_edge);
    }

    private void shrinkOverlappingZeroEdges(SMGEdgeHasValue pNew_edge, Set<SMGEdgeHasValue> pOverlappingZeroEdges) {
        SMGObject object = pNew_edge.getObject();
        int offset = pNew_edge.getOffset();
        boolean newEdgePointsToZero = pNew_edge.getValue() == 0;
        MachineModel maModel = this.heap.getMachineModel();
        int sizeOfType = pNew_edge.getSizeInBytes(maModel);
        for (SMGEdgeHasValue zeroEdge : pOverlappingZeroEdges) {
            SMGEdgeHasValue newZeroEdge;
            this.heap.removeHasValueEdge(zeroEdge);
            if (newEdgePointsToZero) continue;
            int zeroEdgeOffset = zeroEdge.getOffset();
            int offset2 = offset + sizeOfType;
            int zeroEdgeOffset2 = zeroEdgeOffset + zeroEdge.getSizeInBytes(maModel);
            if (zeroEdgeOffset < offset) {
                newZeroEdge = new SMGEdgeHasValue(offset - zeroEdgeOffset, zeroEdgeOffset, object, 0);
                this.heap.addHasValueEdge(newZeroEdge);
            }
            if (offset2 >= zeroEdgeOffset2) continue;
            newZeroEdge = new SMGEdgeHasValue(zeroEdgeOffset2 - offset2, offset2, object, 0);
            this.heap.addHasValueEdge(newZeroEdge);
        }
    }

    public SMGState setInvalidWrite() {
        return new SMGState(this, Property.INVALID_WRITE);
    }

    @Override
    public SMGState join(SMGState reachedState) {
        return null;
    }

    @Override
    public boolean isLessOrEqual(SMGState reachedState) throws SMGInconsistentException {
        return SMGIsLessOrEqual.isLessOrEqual(reachedState.heap, this.heap);
    }

    @Override
    public String getCPAName() {
        return "SMGCPA";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "has-leaks": {
                if (this.heap.hasMemoryLeaks()) {
                    this.issueMemoryLeakMessage();
                    return true;
                }
                return false;
            }
            case "has-invalid-writes": {
                if (this.invalidWrite) {
                    this.issueInvalidWriteMessage();
                    return true;
                }
                return false;
            }
            case "has-invalid-reads": {
                if (this.invalidRead) {
                    this.issueInvalidReadMessage();
                    return true;
                }
                return false;
            }
            case "has-invalid-frees": {
                if (this.invalidFree) {
                    this.issueInvalidFreeMessage();
                    return true;
                }
                return false;
            }
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
    }

    public void addGlobalObject(SMGRegion newObject) {
        this.heap.addGlobalObject(newObject);
    }

    public boolean isGlobal(String variable) {
        return this.heap.getGlobalObjects().containsValue(this.heap.getObjectForVisibleVariable(variable));
    }

    public boolean isGlobal(SMGObject object) {
        return this.heap.getGlobalObjects().containsValue(object);
    }

    public boolean isHeapObject(SMGObject object) {
        return this.heap.getHeapObjects().contains(object);
    }

    public SMGEdgePointsTo addNewHeapAllocation(int pSize, String pLabel) throws SMGInconsistentException {
        SMGRegion new_object = new SMGRegion(pSize, pLabel);
        int new_value = SMGValueFactory.getNewValue();
        SMGEdgePointsTo points_to = new SMGEdgePointsTo(new_value, new_object, 0);
        this.heap.addHeapObject(new_object);
        this.heap.addValue(new_value);
        this.heap.addPointsToEdge(points_to);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return points_to;
    }

    public SMGEdgePointsTo addNewAllocAllocation(int pSize, String pLabel) throws SMGInconsistentException {
        SMGRegion new_object = new SMGRegion(pSize, pLabel);
        int new_value = SMGValueFactory.getNewValue();
        SMGEdgePointsTo points_to = new SMGEdgePointsTo(new_value, new_object, 0);
        this.heap.addStackObject(new_object);
        this.heap.addValue(new_value);
        this.heap.addPointsToEdge(points_to);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return points_to;
    }

    public void setMemLeak() {
        this.heap.setMemoryLeak();
    }

    public boolean containsValue(int value) {
        return this.heap.getValues().contains(value);
    }

    @Nullable
    public Integer getAddress(SMGObject memory, int offset) {
        Map<Integer, SMGEdgePointsTo> pointsToEdges = this.heap.getPTEdges();
        for (SMGEdgePointsTo edge : pointsToEdges.values()) {
            if (!edge.getObject().equals(memory) || edge.getOffset() != offset) continue;
            return edge.getValue();
        }
        return null;
    }

    public SMGState free(Integer address, Integer offset, SMGObject smgObject) throws SMGInconsistentException {
        if (!this.heap.isHeapObject(smgObject)) {
            return this.setInvalidFree();
        }
        if (offset != 0) {
            return this.setInvalidFree();
        }
        if (!this.heap.isObjectValid(smgObject)) {
            return this.setInvalidFree();
        }
        this.heap.setValidity(smgObject, false);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(smgObject);
        ArrayList<SMGEdgeHasValue> to_remove = new ArrayList<SMGEdgeHasValue>();
        for (SMGEdgeHasValue edge : this.heap.getHVEdges(filter)) {
            to_remove.add(edge);
        }
        for (SMGEdgeHasValue edge : to_remove) {
            this.heap.removeHasValueEdge(edge);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return this;
    }

    public void dropStackFrame() throws SMGInconsistentException {
        this.heap.dropStackFrame();
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    public void pruneUnreachable() throws SMGInconsistentException {
        this.heap.pruneUnreachable();
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    public SMGState setInvalidFree() {
        return new SMGState(this, Property.INVALID_FREE);
    }

    public Set<SMGEdgeHasValue> getHVEdges(SMGEdgeHasValueFilter pFilter) {
        return this.heap.getHVEdges(pFilter);
    }

    Set<SMGEdgeHasValue> getHVEdges() {
        return this.heap.getHVEdges();
    }

    @Nullable
    public ValueAnalysisState.MemoryLocation resolveMemLoc(SMGTransferRelation.SMGAddress pValue, String pFunctionName) {
        SMGObject object = pValue.getObject();
        long offset = pValue.getOffset().getAsLong();
        if (this.isGlobal(object) || this.isHeapObject(object)) {
            return ValueAnalysisState.MemoryLocation.valueOf(object.getLabel(), offset);
        }
        return ValueAnalysisState.MemoryLocation.valueOf(pFunctionName, object.getLabel(), offset);
    }

    public SMGState copy(SMGObject pSource, SMGObject pTarget, int pSourceRangeOffset, int pSourceRangeSize, int pTargetRangeOffset) throws SMGInconsistentException {
        SMGState newSMGState = this;
        int copyRange = pSourceRangeSize - pSourceRangeOffset;
        assert (pSource.getSize() >= pSourceRangeSize);
        assert (pSourceRangeOffset >= 0);
        assert (pTargetRangeOffset >= 0);
        assert (copyRange >= 0);
        assert (copyRange <= pTarget.getSize());
        if (copyRange == 0) {
            return newSMGState;
        }
        int targetRangeSize = pTargetRangeOffset + copyRange;
        SMGEdgeHasValueFilter filterSource = new SMGEdgeHasValueFilter();
        filterSource.filterByObject(pSource);
        SMGEdgeHasValueFilter filterTarget = new SMGEdgeHasValueFilter();
        filterTarget.filterByObject(pTarget);
        Set<SMGEdgeHasValue> targetEdges = this.getHVEdges(filterTarget);
        for (SMGEdgeHasValue edge : targetEdges) {
            if (!edge.overlapsWith(pTargetRangeOffset, targetRangeSize, this.heap.getMachineModel())) continue;
            this.heap.removeHasValueEdge(edge);
        }
        Set<SMGEdgeHasValue> sourceEdges = this.getHVEdges(filterSource);
        int copyShift = pTargetRangeOffset - pSourceRangeOffset;
        for (SMGEdgeHasValue edge : sourceEdges) {
            if (!edge.overlapsWith(pSourceRangeOffset, pSourceRangeSize, this.heap.getMachineModel())) continue;
            int offset = edge.getOffset() + copyShift;
            newSMGState = this.writeValue(pTarget, offset, edge.getType(), edge.getValue()).getState();
        }
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
        this.heap.pruneUnreachable();
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
        return newSMGState;
    }

    public SMGState setUnknownDereference() {
        return new SMGState(this, Property.INVALID_WRITE);
    }

    public SMGObject getNullObject() {
        return this.heap.getNullObject();
    }

    public void identifyEqualValues(SMGTransferRelation.SMGKnownSymValue pKnownVal1, SMGTransferRelation.SMGKnownSymValue pKnownVal2) {
        assert (!this.isInNeq(pKnownVal1, pKnownVal2));
        this.heap.mergeValues(pKnownVal1.getAsInt(), pKnownVal2.getAsInt());
    }

    public void identifyNonEqualValues(SMGTransferRelation.SMGKnownSymValue pKnownVal1, SMGTransferRelation.SMGKnownSymValue pKnownVal2) {
        this.heap.addNeqRelation(pKnownVal1.getAsInt(), pKnownVal2.getAsInt());
    }

    public void putExplicit(SMGTransferRelation.SMGKnownSymValue pKey, SMGTransferRelation.SMGKnownExpValue pValue) {
        this.explicitValues.put(pKey, pValue);
    }

    public void clearExplicit(SMGTransferRelation.SMGKnownSymValue pKey) {
        this.explicitValues.remove(pKey);
    }

    boolean isExplicit(int value) {
        SMGTransferRelation.SMGKnownSymValue key = SMGTransferRelation.SMGKnownSymValue.valueOf(value);
        return this.explicitValues.containsKey(key);
    }

    SMGTransferRelation.SMGKnownExpValue getExplicit(int value) {
        SMGTransferRelation.SMGKnownSymValue key = SMGTransferRelation.SMGKnownSymValue.valueOf(value);
        assert (this.explicitValues.containsKey(key));
        return this.explicitValues.get(key);
    }

    public SMGTransferRelation.SMGExplicitValue getExplicit(SMGTransferRelation.SMGKnownSymValue pKey) {
        if (this.explicitValues.containsKey(pKey)) {
            return this.explicitValues.get(pKey);
        }
        return SMGTransferRelation.SMGUnknownValue.getInstance();
    }

    public boolean isInNeq(SMGTransferRelation.SMGSymbolicValue pValue1, SMGTransferRelation.SMGSymbolicValue pValue2) {
        if (pValue1.isUnknown() || pValue2.isUnknown()) {
            return false;
        }
        return this.heap.haveNeqRelation(pValue1.getAsInt(), pValue2.getAsInt());
    }

    IDExpression createIDExpression(SMGObject pObject) {
        return this.heap.createIDExpression(pObject);
    }

    private static enum Property {
        INVALID_READ,
        INVALID_WRITE,
        INVALID_FREE,
        INVALID_HEAP;

    }

    public static class SMGStateEdgePair {
        private final SMGState smgState;
        private final SMGEdgeHasValue edge;

        private SMGStateEdgePair(SMGState pState, SMGEdgeHasValue pEdge) {
            this.smgState = pState;
            this.edge = pEdge;
        }

        private SMGStateEdgePair(SMGState pNewState) {
            this.smgState = pNewState;
            this.edge = null;
        }

        public boolean smgStateHasNewEdge() {
            return this.edge != null;
        }

        public SMGEdgeHasValue getNewEdge() {
            return this.edge;
        }

        public SMGState getState() {
            return this.smgState;
        }
    }
}

