/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class SMGStateTest {
    private static final LogManager logger = TestLogManager.getInstance();
    private SMGState consistent_state;
    private SMGState inconsistent_state;
    private static final CType mockType16b = AnonymousTypes.createTypeWithLength(16L);
    private static final CType mockType8b = AnonymousTypes.createTypeWithLength(8L);

    @Before
    public void setUp() throws SMGInconsistentException {
        this.consistent_state = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.NONE);
        this.inconsistent_state = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.NONE);
        SMGEdgePointsTo pt = this.inconsistent_state.addNewHeapAllocation(8, "label");
        this.consistent_state.addGlobalObject((SMGRegion)pt.getObject());
        this.inconsistent_state.addGlobalObject((SMGRegion)pt.getObject());
    }

    @Test(expected=SMGInconsistentException.class)
    public void ConfigurableConsistencyInconsistentReported1Test() throws SMGInconsistentException {
        SMGState inconsistent_state = new SMGState(this.inconsistent_state, SMGRuntimeCheck.FULL);
        inconsistent_state.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    @Test(expected=SMGInconsistentException.class)
    public void ConfigurableConsistencyInconsistentReported2Test() throws SMGInconsistentException {
        SMGState inconsistent_state = new SMGState(this.inconsistent_state, SMGRuntimeCheck.FULL);
        inconsistent_state.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    @Test
    public void ConfigurableConsistencyInconsistentNotReportedTest() throws SMGInconsistentException {
        SMGState inconsistent_state = new SMGState(this.inconsistent_state, SMGRuntimeCheck.NONE);
        inconsistent_state.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    @Test
    public void ConfigurableConsistencyConsistent1Test() throws SMGInconsistentException {
        SMGState consistent_state = new SMGState(this.consistent_state, SMGRuntimeCheck.FULL);
        consistent_state.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    @Test
    public void ConfigurableConsistencyConsistent2Test() throws SMGInconsistentException {
        SMGState consistent_state = new SMGState(this.consistent_state, SMGRuntimeCheck.NONE);
        consistent_state.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    @Test
    public void PredecessorsTest() throws SMGInconsistentException {
        SMGState original = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.NONE);
        SMGState second = new SMGState(original);
        Assert.assertNotEquals((long)original.getId(), (long)second.getId());
        SMGState copy = new SMGState(original);
        Assert.assertNotEquals((long)copy.getId(), (long)original.getId());
        Assert.assertNotEquals((long)copy.getId(), (long)second.getId());
        Assert.assertSame((Object)second.getPredecessorId(), (Object)original.getId());
        Assert.assertSame((Object)copy.getPredecessorId(), (Object)original.getId());
    }

    @Test
    public void WriteReinterpretationTest() throws SMGInconsistentException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.NONE);
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGTransferRelation.SMGKnownSymValue new_value = SMGTransferRelation.SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
        SMGEdgeHasValue hv = state.writeValue(pt.getObject(), 0, mockType16b, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pt.getObject());
        Set<SMGEdgeHasValue> values_for_obj = state.getHVEdges(filter);
        Assert.assertEquals((long)1L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv));
        state.writeValue(pt.getObject(), 0, mockType16b, new_value);
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Assert.assertEquals((long)1L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv));
        SMGTransferRelation.SMGKnownSymValue newer_value = SMGTransferRelation.SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
        SMGEdgeHasValue new_hv = state.writeValue(pt.getObject(), 0, mockType16b, newer_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Assert.assertEquals((long)1L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(new_hv));
        Assert.assertFalse((boolean)values_for_obj.contains(hv));
        SMGEdgeHasValue hv8at0 = state.writeValue(pt.getObject(), 0, mockType8b, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Assert.assertEquals((long)1L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv8at0));
        SMGEdgeHasValue hv8at8 = state.writeValue(pt.getObject(), 8, mockType8b, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Assert.assertEquals((long)2L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv8at0));
        Assert.assertTrue((boolean)values_for_obj.contains(hv8at8));
        SMGEdgeHasValue hv8at4 = state.writeValue(pt.getObject(), 4, mockType8b, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Assert.assertEquals((long)1L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv8at4));
        Assert.assertFalse((boolean)values_for_obj.contains(hv8at0));
        Assert.assertFalse((boolean)values_for_obj.contains(hv8at8));
    }

    @Test
    public void WriteReinterpretationNullifiedTest() throws SMGInconsistentException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.FORCED);
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGEdgeHasValue hv = state.writeValue(pt.getObject(), 0, mockType16b, SMGTransferRelation.SMGKnownSymValue.ZERO).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        Set<SMGEdgeHasValue> values_for_obj = state.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pt.getObject()));
        Assert.assertEquals((long)1L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv));
        SMGEdgeHasValue hv8at4 = state.writeValue(pt.getObject(), 4, mockType8b, SMGTransferRelation.SMGUnknownValue.getInstance()).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pt.getObject()));
        Assert.assertEquals((long)3L, (long)values_for_obj.size());
        Assert.assertTrue((boolean)values_for_obj.contains(hv8at4));
        Assert.assertTrue((boolean)values_for_obj.contains(new SMGEdgeHasValue(4, 0, pt.getObject(), 0)));
        Assert.assertTrue((boolean)values_for_obj.contains(new SMGEdgeHasValue(4, 12, pt.getObject(), 0)));
        SMGEdgeHasValueFilter nullFilter = SMGEdgeHasValueFilter.objectFilter(pt.getObject()).filterHavingValue(0);
        Set<SMGEdgeHasValue> nulls_for_value = state.getHVEdges(nullFilter);
        Assert.assertEquals((long)2L, (long)nulls_for_value.size());
        Assert.assertEquals((long)1L, (long)state.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pt.getObject()).filterHavingValue(0).filterAtOffset(0)).size());
        Assert.assertEquals((long)1L, (long)state.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pt.getObject()).filterHavingValue(0).filterAtOffset(12)).size());
    }

    @Test
    public void getPointerFromValueTest() throws SMGInconsistentException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.NONE);
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        Integer pointer = pt.getValue();
        SMGEdgePointsTo pt_obtained = state.getPointerFromValue(pointer);
        Assert.assertEquals((Object)pt_obtained.getObject(), (Object)pt.getObject());
    }

    @Test(expected=SMGInconsistentException.class)
    public void getPointerFromValueNonPointerTest() throws SMGInconsistentException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, true, true, SMGRuntimeCheck.NONE);
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGTransferRelation.SMGKnownSymValue nonpointer = SMGTransferRelation.SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
        state.writeValue(pt.getObject(), 0, mockType16b, nonpointer);
        state.getPointerFromValue(nonpointer.getAsInt());
    }
}

