/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.smg.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisSMGCommunicator;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

@Options(prefix="cpa.smg")
public class SMGTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, name="exportSMG.file", description="Filename format for SMG graph dumps")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportSMGFilePattern = PathTemplate.ofFormatString((String)"smg-%s.dot");
    @Option(secure=true, description="with this option enabled, a check for unreachable memory occurs whenever a function returns, and not only at the end of the main function")
    private boolean checkForMemLeaksAtEveryFrameDrop = true;
    @Option(secure=true, description="with this option enabled, memory that is not freed before the end of main is reported as memleak even if it is reachable from local variables in main")
    private boolean handleNonFreedMemoryInMainAsMemLeak = false;
    @Option(secure=true, name="exportSMGwhen", description="Describes when SMG graphs should be dumped. One of: {never, leaf, interesting, every}")
    private String exportSMG = "never";
    @Option(secure=true, name="enableMallocFail", description="If this Option is enabled, failure of mallocis simulated")
    private boolean enableMallocFailure = true;
    @Option(secure=true, name="handleUnknownFunctions", description="Sets how unknown functions are handled. One of: {strict, assume_safe}")
    private String handleUnknownFunctions = "strict";
    @Option(secure=true, name="guessSizeOfUnknownMemorySize", description="Size of memory that cannot be calculated will be guessed.")
    private boolean guessSizeOfUnknownMemorySize = false;
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;
    private final AtomicInteger id_counter;
    private final SMGRightHandSideEvaluator expressionEvaluator;
    private boolean possibleMallocFail;
    private SMGState mallocFailState;
    private List<MissingInformation> missingInformationList;
    private SMGState oldState;
    public static final String FUNCTION_RETURN_VAR = "___cpa_temp_result_var_";
    private final SMGBuiltins builtins = new SMGBuiltins();
    private boolean hasChanged;

    private void plotWhenConfigured(String pConfig, String pName, SMGState pState, String pLocation) {
        if (pConfig.equals(this.exportSMG)) {
            this.builtins.dumpSMGPlot(pName, pState, pLocation);
        }
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        ImmutableSet results;
        if (cfaEdge instanceof MultiEdge) {
            MultiEdge multiEdge = (MultiEdge)cfaEdge;
            ArrayDeque<SMGState> processQueue = new ArrayDeque<SMGState>();
            ArrayDeque<SMGState> resultQueue = new ArrayDeque<SMGState>();
            processQueue.add((SMGState)state);
            for (CFAEdge edge : multiEdge) {
                while (!processQueue.isEmpty()) {
                    SMGState next = (SMGState)processQueue.poll();
                    Collection<? extends AbstractState> resultOfOneOp = this.getAbstractSuccessorsForEdge(next, precision, edge);
                    for (AbstractState abstractState : resultOfOneOp) {
                        resultQueue.add((SMGState)abstractState);
                    }
                }
                while (!resultQueue.isEmpty()) {
                    processQueue.add((SMGState)resultQueue.poll());
                }
            }
            results = ImmutableSet.copyOf(processQueue);
        } else {
            results = this.getAbstractSuccessorsForEdge((SMGState)state, precision, cfaEdge);
        }
        return results;
    }

    public SMGTransferRelation(Configuration config, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.machineModel = pMachineModel;
        this.expressionEvaluator = new SMGRightHandSideEvaluator(this.logger, this.machineModel);
        this.id_counter = new AtomicInteger(0);
    }

    private Collection<? extends AbstractState> getAbstractSuccessorsForEdge(SMGState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        ImmutableSet result;
        SMGState successor;
        this.logger.log(Level.FINEST, new Object[]{"SMG GetSuccessor >>"});
        this.logger.log(Level.FINEST, new Object[]{"Edge:", cfaEdge.getEdgeType()});
        this.logger.log(Level.FINEST, new Object[]{"Code:", cfaEdge.getCode()});
        SMGState smgState = state;
        this.setInfo(smgState);
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                successor = this.handleDeclaration(smgState, (CDeclarationEdge)cfaEdge);
                break;
            }
            case StatementEdge: {
                successor = this.handleStatement(smgState, (CStatementEdge)cfaEdge);
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)cfaEdge;
                successor = this.handleAssumption(smgState, assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption(), true);
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(smgState, functionCallEdge);
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case FunctionReturnEdge: {
                CFunctionReturnEdge functionReturnEdge = (CFunctionReturnEdge)cfaEdge;
                successor = this.handleFunctionReturn(smgState, functionReturnEdge);
                if (this.checkForMemLeaksAtEveryFrameDrop) {
                    successor.pruneUnreachable();
                }
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)cfaEdge;
                successor = this.handleExitFromFunction(smgState, returnEdge);
                if (returnEdge.getSuccessor().getNumLeavingEdges() == 0) {
                    if (this.handleNonFreedMemoryInMainAsMemLeak) {
                        successor.dropStackFrame();
                    }
                    successor.pruneUnreachable();
                }
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            default: {
                successor = smgState;
            }
        }
        if (successor == null) {
            result = Collections.emptySet();
        } else if (this.mallocFailState != null && this.enableMallocFailure) {
            result = ImmutableSet.of((Object)successor, (Object)this.mallocFailState);
            this.mallocFailState = null;
        } else {
            result = Collections.singleton(successor);
        }
        for (SMGState smg : result) {
            this.plotWhenConfigured("every", null, smg, cfaEdge.getDescription());
        }
        return result;
    }

    private void setInfo(SMGState pOldState) {
        this.missingInformationList = new ArrayList<MissingInformation>(5);
        this.oldState = pOldState;
        this.expressionEvaluator.reset();
    }

    private SMGState handleExitFromFunction(SMGState smgState, CReturnStatementEdge returnEdge) throws CPATransferException {
        CExpression returnExp = (CExpression)returnEdge.getExpression().or((Object)CIntegerLiteralExpression.ZERO);
        this.logger.log(Level.FINEST, new Object[]{"Handling return Statement: ", returnExp});
        CType expType = this.expressionEvaluator.getRealExpressionType(returnExp);
        SMGObject tmpFieldMemory = smgState.getFunctionReturnObject();
        if (tmpFieldMemory != null) {
            return this.handleAssignmentToField(smgState, returnEdge, tmpFieldMemory, 0, expType, returnExp);
        }
        return smgState;
    }

    private SMGState handleFunctionReturn(SMGState smgState, CFunctionReturnEdge functionReturnEdge) throws CPATransferException {
        this.logger.log(Level.FINEST, new Object[]{"Handling function return"});
        CFunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
        CFunctionCall exprOnSummary = summaryEdge.getExpression();
        SMGState newState = new SMGState(smgState);
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CLeftHandSide lValue = ((CFunctionCallAssignmentStatement)exprOnSummary).getLeftHandSide();
            CType lValueType = this.expressionEvaluator.getRealExpressionType(lValue);
            CType rValueType = this.expressionEvaluator.getRealExpressionType(((CFunctionCallAssignmentStatement)exprOnSummary).getRightHandSide());
            SMGSymbolicValue rValue = this.getFunctionReturnValue(newState, rValueType, functionReturnEdge);
            SMGAddress address = null;
            newState.dropStackFrame();
            SMGExpressionEvaluator.LValueAssignmentVisitor visitor = this.expressionEvaluator.getLValueAssignmentVisitor(functionReturnEdge, newState);
            SMGExpressionEvaluator.SMGAddressAndState addressAndValue = lValue.accept(visitor);
            address = addressAndValue.getAddress();
            newState = addressAndValue.getSmgState();
            if (!address.isUnknown()) {
                if (rValue.isUnknown()) {
                    rValue = SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
                }
                SMGObject object = address.getObject();
                int offset = address.getOffset().getAsInt();
                return this.assignFieldToState(newState, functionReturnEdge, object, offset, lValueType, rValue, rValueType);
            }
            return newState;
        }
        newState.dropStackFrame();
        return newState;
    }

    private SMGSymbolicValue getFunctionReturnValue(SMGState smgState, CType type, CFAEdge pCFAEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        SMGObject tmpMemory = smgState.getFunctionReturnObject();
        return this.expressionEvaluator.readValue(smgState, tmpMemory, SMGKnownExpValue.ZERO, type, pCFAEdge).getValue();
    }

    private SMGState handleFunctionCall(SMGState smgState, CFunctionCallEdge callEdge) throws CPATransferException, SMGInconsistentException {
        CType cType;
        String varName;
        CExpression exp;
        int i;
        CFunctionEntryNode functionEntryNode = callEdge.getSuccessor();
        this.logger.log(Level.FINEST, new Object[]{"Handling function call: ", functionEntryNode.getFunctionName()});
        SMGState newState = new SMGState(smgState);
        CFunctionDeclaration functionDeclaration = functionEntryNode.getFunctionDefinition();
        List<CParameterDeclaration> paramDecl = functionEntryNode.getFunctionParameters();
        List<CExpression> arguments = callEdge.getArguments();
        if (!callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) assert (paramDecl.size() == arguments.size());
        ArrayList<Pair> values = new ArrayList<Pair>(paramDecl.size());
        for (i = 0; i < paramDecl.size(); ++i) {
            SMGRegion paramObj;
            int size;
            exp = arguments.get(i);
            varName = paramDecl.get(i).getName();
            cType = this.expressionEvaluator.getRealExpressionType(paramDecl.get(i));
            if (cType instanceof CArrayType) {
                size = this.machineModel.getSizeofPtr();
                paramObj = new SMGRegion(size, varName);
            } else {
                size = this.machineModel.getSizeof(cType);
                paramObj = new SMGRegion(size, varName);
            }
            SMGExpressionEvaluator.SMGValueAndState stateValue = this.readValueToBeAssiged(newState, callEdge, paramObj, 0, exp);
            newState = stateValue.getSmgState();
            SMGSymbolicValue value = stateValue.getValue();
            newState = this.assignExplicitValueToSymbolicValue(newState, callEdge, value, exp);
            values.add(i, Pair.of((Object)paramObj, (Object)value));
        }
        newState.addStackFrame(functionDeclaration);
        for (i = 0; i < paramDecl.size(); ++i) {
            exp = arguments.get(i);
            varName = paramDecl.get(i).getName();
            cType = this.expressionEvaluator.getRealExpressionType(paramDecl.get(i));
            CType rValueType = this.expressionEvaluator.getRealExpressionType(exp.getExpressionType());
            SMGRegion newObject = (SMGRegion)((Pair)values.get(i)).getFirst();
            SMGSymbolicValue symbolicValue = (SMGSymbolicValue)((Pair)values.get(i)).getSecond();
            newState.addLocalVariable(cType, varName, newObject);
            newState = this.assignFieldToState(newState, callEdge, newObject, 0, cType, symbolicValue, rValueType);
        }
        return newState;
    }

    private SMGState handleAssumption(SMGState pSmgState, CExpression expression, CFAEdge cfaEdge, boolean truthValue, boolean createNewStateIfNecessary) throws CPATransferException {
        SMGSymbolicValue val2ImpliesOn;
        SMGSymbolicValue val1ImpliesOn;
        SMGState smgState = pSmgState;
        SMGExpressionEvaluator.AssumeVisitor visitor = this.expressionEvaluator.getAssumeVisitor(cfaEdge, smgState);
        SMGExpressionEvaluator.SMGValueAndState valueAndState = expression.accept(visitor);
        SMGSymbolicValue value = valueAndState.getValue();
        smgState = valueAndState.getSmgState();
        if (!value.isUnknown()) {
            if (truthValue && value.equals(SMGKnownSymValue.TRUE) || !truthValue && value.equals(SMGKnownSymValue.FALSE)) {
                return smgState;
            }
            return null;
        }
        boolean impliesEqOn = visitor.impliesEqOn(truthValue);
        boolean impliesNeqOn = visitor.impliesNeqOn(truthValue);
        if (impliesEqOn || impliesNeqOn) {
            val1ImpliesOn = visitor.impliesVal1();
            val2ImpliesOn = visitor.impliesVal2();
        } else {
            val1ImpliesOn = SMGUnknownValue.getInstance();
            val2ImpliesOn = SMGUnknownValue.getInstance();
        }
        SMGExpressionEvaluator.SMGExplicitValueAndState explicitValueAndState = this.expressionEvaluator.evaluateExplicitValue(smgState, cfaEdge, expression);
        SMGExplicitValue explicitValue = explicitValueAndState.getValue();
        smgState = explicitValueAndState.getSmgState();
        if (this.expressionEvaluator.isMissingExplicitInformation()) {
            this.missingInformationList.add(new MissingInformation(truthValue, expression));
            this.expressionEvaluator.reset();
        }
        if (explicitValue.isUnknown()) {
            SMGState newState = createNewStateIfNecessary ? new SMGState(smgState) : smgState;
            if (!val1ImpliesOn.isUnknown() && !val2ImpliesOn.isUnknown()) {
                if (impliesEqOn) {
                    newState.identifyEqualValues((SMGKnownSymValue)val1ImpliesOn, (SMGKnownSymValue)val2ImpliesOn);
                } else if (impliesNeqOn) {
                    newState.identifyNonEqualValues((SMGKnownSymValue)val1ImpliesOn, (SMGKnownSymValue)val2ImpliesOn);
                }
            }
            newState = this.expressionEvaluator.deriveFurtherInformation(newState, truthValue, cfaEdge, expression);
            return newState;
        }
        if (truthValue && explicitValue.equals(SMGKnownExpValue.ONE) || !truthValue && explicitValue.equals(SMGKnownExpValue.ZERO)) {
            return smgState;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SMGState handleStatement(SMGState pState, CStatementEdge pCfaEdge) throws CPATransferException {
        SMGState newState;
        this.logger.log(Level.FINEST, new Object[]{">>> Handling statement"});
        CStatement cStmt = pCfaEdge.getStatement();
        if (cStmt instanceof CAssignment) {
            CAssignment cAssignment = (CAssignment)cStmt;
            CLeftHandSide lValue = cAssignment.getLeftHandSide();
            CRightHandSide rValue = cAssignment.getRightHandSide();
            return this.handleAssignment(pState, pCfaEdge, lValue, rValue);
        }
        if (!(cStmt instanceof CFunctionCallStatement)) return pState;
        CFunctionCallStatement cFCall = (CFunctionCallStatement)cStmt;
        CFunctionCallExpression cFCExpression = cFCall.getFunctionCallExpression();
        CExpression fileNameExpression = cFCExpression.getFunctionNameExpression();
        boolean isRequiered = false;
        String functionName = fileNameExpression.toASTString();
        if (this.builtins.isABuiltIn(functionName)) {
            newState = new SMGState(pState);
            switch (functionName) {
                case "__VERIFIER_BUILTIN_PLOT": {
                    this.builtins.evaluateVBPlot(cFCExpression, newState);
                    this.expressionEvaluator.reset();
                    this.missingInformationList.add(new MissingInformation(cFCExpression, false));
                    break;
                }
                case "free": {
                    newState = this.builtins.evaluateFree(cFCExpression, newState, pCfaEdge);
                    break;
                }
                case "malloc": {
                    this.logger.log(Level.WARNING, new Object[]{pCfaEdge.getFileLocation() + ":", "Calling malloc and not using the result, resulting in memory leak."});
                    newState.setMemLeak();
                    isRequiered = true;
                    break;
                }
                case "__builtin_alloca": {
                    this.logger.log(Level.WARNING, new Object[]{pCfaEdge.getFileLocation() + ":", "Calling alloc and not using the result."});
                    newState = this.builtins.evaluateAlloc(cFCExpression, newState, pCfaEdge).getSmgState();
                    break;
                }
                case "calloc": {
                    this.logger.log(Level.WARNING, new Object[]{pCfaEdge.getFileLocation() + ":", "Calling calloc and not using the result, resulting in memory leak."});
                    newState.setMemLeak();
                    isRequiered = true;
                    break;
                }
                case "memset": {
                    SMGEdgePointsToAndState result = this.builtins.evaluateMemset(cFCExpression, newState, pCfaEdge);
                    newState = result.getSmgState();
                    break;
                }
                case "printf": {
                    return new SMGState(pState);
                }
            }
        } else {
            switch (this.handleUnknownFunctions) {
                case "strict": {
                    throw new CPATransferException("Unknown function '" + functionName + "' may be unsafe. See the cpa.smg.handleUnknownFunction option.");
                }
                case "assume_safe": {
                    return pState;
                }
            }
            throw new AssertionError();
        }
        if (!this.expressionEvaluator.missingExplicitInformation) return newState;
        this.missingInformationList.add(new MissingInformation(cFCExpression, isRequiered));
        this.expressionEvaluator.reset();
        return newState;
    }

    private SMGState handleAssignment(SMGState pState, CFAEdge cfaEdge, CExpression lValue, CRightHandSide rValue) throws CPATransferException {
        SMGState state = pState;
        this.logger.log(Level.FINEST, new Object[]{"Handling assignment:", lValue, "=", rValue});
        SMGExpressionEvaluator.LValueAssignmentVisitor visitor = this.expressionEvaluator.getLValueAssignmentVisitor(cfaEdge, state);
        SMGExpressionEvaluator.SMGAddressAndState addressOfFieldAndState = lValue.accept(visitor);
        SMGAddress addressOfField = addressOfFieldAndState.getAddress();
        state = addressOfFieldAndState.getSmgState();
        CType fieldType = this.expressionEvaluator.getRealExpressionType(lValue);
        if (addressOfField.isUnknown()) {
            this.addMissingInformation(lValue, rValue);
            return new SMGState(state);
        }
        SMGState newState = this.handleAssignmentToField(state, cfaEdge, addressOfField.getObject(), addressOfField.getOffset().getAsInt(), fieldType, rValue);
        return newState;
    }

    private void addMissingInformation(CExpression pLValue, CRightHandSide pRValue) {
        this.missingInformationList.add(new MissingInformation(pLValue, pRValue, false));
    }

    private SMGExpressionEvaluator.SMGValueAndState readValueToBeAssiged(SMGState pNewState, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CRightHandSide rValue) throws CPATransferException {
        SMGExpressionEvaluator.SMGValueAndState valueAndState = this.expressionEvaluator.evaluateExpressionValue(pNewState, cfaEdge, rValue);
        SMGSymbolicValue value = valueAndState.getValue();
        if (value.isUnknown()) {
            if (this.expressionEvaluator.isMissingExplicitInformation()) {
                this.addMissingInformation(memoryOfField, fieldOffset, rValue, this.expressionEvaluator.isRequiered());
                this.expressionEvaluator.reset();
            }
            value = SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
            valueAndState = SMGExpressionEvaluator.SMGValueAndState.of(valueAndState.getSmgState(), value);
        }
        return valueAndState;
    }

    private SMGState assignFieldToState(SMGState pNewState, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, CRightHandSide rValue) throws CPATransferException {
        CType rValueType = this.expressionEvaluator.getRealExpressionType(rValue);
        SMGExpressionEvaluator.SMGValueAndState valueAndState = this.readValueToBeAssiged(pNewState, cfaEdge, memoryOfField, fieldOffset, rValue);
        SMGSymbolicValue value = valueAndState.getValue();
        SMGState newState = valueAndState.getSmgState();
        rValueType = pFieldType;
        newState = this.assignExplicitValueToSymbolicValue(newState, cfaEdge, value, rValue);
        newState = this.assignFieldToState(newState, cfaEdge, memoryOfField, fieldOffset, pFieldType, value, rValueType);
        return newState;
    }

    private SMGState assignExplicitValueToSymbolicValue(SMGState pNewState, CFAEdge pCfaEdge, SMGSymbolicValue value, CRightHandSide pRValue) throws CPATransferException {
        SMGExpressionEvaluator expEvaluator = new SMGExpressionEvaluator(this.logger, this.machineModel);
        SMGExpressionEvaluator.SMGExplicitValueAndState expValueAndState = expEvaluator.evaluateExplicitValue(pNewState, pCfaEdge, pRValue);
        SMGExplicitValue expValue = expValueAndState.getValue();
        SMGState newState = expValueAndState.getSmgState();
        if (!expValue.isUnknown()) {
            newState.putExplicit((SMGKnownSymValue)value, (SMGKnownExpValue)expValue);
        }
        return newState;
    }

    private void addMissingInformation(SMGObject pMemoryOfField, int pFieldOffset, CRightHandSide pRValue, boolean isRequiered) {
        SMGAddress address = SMGAddress.valueOf(pMemoryOfField, SMGKnownExpValue.valueOf(pFieldOffset));
        this.missingInformationList.add(new MissingInformation(address, pRValue, isRequiered));
    }

    private SMGState assignFieldToState(SMGState newState, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, SMGSymbolicValue value, CType rValueType) throws UnrecognizedCCodeException, SMGInconsistentException {
        if (memoryOfField.getSize() < this.expressionEvaluator.getSizeof(cfaEdge, rValueType)) {
            this.logger.log(Level.WARNING, new Object[]{cfaEdge.getFileLocation() + ":", "Attempting to write " + this.expressionEvaluator.getSizeof(cfaEdge, rValueType) + " bytes into a field with size " + memoryOfField.getSize() + "bytes:", cfaEdge.getRawStatement()});
        }
        if (this.expressionEvaluator.isStructOrUnionType(rValueType)) {
            return this.assignStruct(newState, memoryOfField, fieldOffset, rValueType, value, cfaEdge);
        }
        return this.writeValue(newState, memoryOfField, fieldOffset, rValueType, value, cfaEdge);
    }

    private SMGState assignStruct(SMGState pNewState, SMGObject pMemoryOfField, int pFieldOffset, CType pRValueType, SMGSymbolicValue pValue, CFAEdge pCfaEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        if (pValue instanceof SMGKnownAddVal) {
            SMGKnownAddVal structAddress = (SMGKnownAddVal)pValue;
            SMGObject source = structAddress.getObject();
            int structOffset = structAddress.getOffset().getAsInt();
            int structSize = structOffset + this.expressionEvaluator.getSizeof(pCfaEdge, pRValueType);
            return pNewState.copy(source, pMemoryOfField, structOffset, structSize, pFieldOffset);
        }
        return pNewState;
    }

    private SMGState writeValue(SMGState pNewState, SMGObject pMemoryOfField, int pFieldOffset, long pSizeType, SMGSymbolicValue pValue, CFAEdge pEdge) throws UnrecognizedCCodeException, SMGInconsistentException {
        return this.writeValue(pNewState, pMemoryOfField, pFieldOffset, AnonymousTypes.createTypeWithLength(pSizeType), pValue, pEdge);
    }

    private SMGState writeValue(SMGState pNewState, SMGObject pMemoryOfField, int pFieldOffset, CType pRValueType, SMGSymbolicValue pValue, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        boolean doesNotFitIntoObject;
        boolean bl = doesNotFitIntoObject = pFieldOffset < 0 || pFieldOffset + this.expressionEvaluator.getSizeof(pEdge, pRValueType) > pMemoryOfField.getSize();
        if (doesNotFitIntoObject) {
            this.logger.log(Level.WARNING, new Object[]{pEdge.getFileLocation() + ":", "Field (" + pFieldOffset + ", " + pRValueType.toASTString("") + ")" + " does not fit object " + pMemoryOfField.toString() + "."});
            return pNewState.setInvalidWrite();
        }
        if (pValue.isUnknown()) {
            return pNewState;
        }
        return pNewState.writeValue(pMemoryOfField, pFieldOffset, pRValueType, pValue).getState();
    }

    private SMGState handleAssignmentToField(SMGState state, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, CRightHandSide rValue) throws CPATransferException {
        SMGState newState = new SMGState(state);
        newState = this.assignFieldToState(newState, cfaEdge, memoryOfField, fieldOffset, pFieldType, rValue);
        if (this.possibleMallocFail && this.enableMallocFailure) {
            this.possibleMallocFail = false;
            SMGState otherState = new SMGState(state);
            CType rValueType = this.expressionEvaluator.getRealExpressionType(rValue);
            this.mallocFailState = this.writeValue(otherState, memoryOfField, fieldOffset, rValueType, (SMGSymbolicValue)SMGKnownSymValue.ZERO, cfaEdge);
        }
        return newState;
    }

    private SMGState handleVariableDeclaration(SMGState pState, CVariableDeclaration pVarDecl, CDeclarationEdge pEdge) throws CPATransferException {
        SMGObject newObject;
        this.logger.log(Level.FINEST, new Object[]{"Handling variable declaration:", pVarDecl});
        String varName = pVarDecl.getName();
        CType cType = this.expressionEvaluator.getRealExpressionType(pVarDecl);
        if (pVarDecl.isGlobal()) {
            newObject = pState.addGlobalVariable(cType, varName);
        } else {
            newObject = pState.getObjectForVisibleVariable(varName);
            if (newObject == null) {
                newObject = pState.addLocalVariable(cType, varName);
            }
        }
        pState = this.handleInitializerForDeclaration(pState, newObject, pVarDecl, pEdge);
        return pState;
    }

    private SMGState handleDeclaration(SMGState smgState, CDeclarationEdge edge) throws CPATransferException {
        this.logger.log(Level.FINEST, new Object[]{">>> Handling declaration"});
        CDeclaration cDecl = edge.getDeclaration();
        if (!(cDecl instanceof CVariableDeclaration)) {
            return smgState;
        }
        SMGState newState = new SMGState(smgState);
        newState = this.handleVariableDeclaration(newState, (CVariableDeclaration)cDecl, edge);
        return newState;
    }

    private SMGState handleInitializerForDeclaration(SMGState pState, SMGObject pObject, CVariableDeclaration pVarDecl, CDeclarationEdge pEdge) throws CPATransferException {
        CInitializer newInitializer = pVarDecl.getInitializer();
        CType cType = this.expressionEvaluator.getRealExpressionType(pVarDecl);
        if (newInitializer != null) {
            this.logger.log(Level.FINEST, new Object[]{"Handling variable declaration: handling initializer"});
            return this.handleInitializer(pState, pVarDecl, pEdge, pObject, 0, cType, newInitializer);
        }
        if (pVarDecl.isGlobal()) {
            pState = this.writeValue(pState, pObject, 0, cType, (SMGSymbolicValue)SMGKnownSymValue.ZERO, (CFAEdge)pEdge);
        }
        return pState;
    }

    private SMGState handleInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CType pLValueType, CInitializer pInitializer) throws UnrecognizedCCodeException, CPATransferException {
        if (pInitializer instanceof CInitializerExpression) {
            return this.assignFieldToState(pNewState, pEdge, pNewObject, pOffset, pLValueType, ((CInitializerExpression)pInitializer).getExpression());
        }
        if (pInitializer instanceof CInitializerList) {
            return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, pLValueType, (CInitializerList)pInitializer);
        }
        if (pInitializer instanceof CDesignatedInitializer) {
            return pNewState;
        }
        throw new UnrecognizedCCodeException("Did not recognize Initializer", pInitializer);
    }

    private SMGState handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CType pLValueType, CInitializerList pNewInitializer) throws UnrecognizedCCodeException, CPATransferException {
        CType realCType = pLValueType.getCanonicalType();
        if (realCType instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)realCType;
            return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, arrayType, pNewInitializer);
        }
        if (realCType instanceof CCompositeType) {
            CCompositeType structType = (CCompositeType)realCType;
            return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, structType, pNewInitializer);
        }
        this.logger.log(Level.WARNING, new Object[]{"Type " + realCType.toASTString("") + "cannot be resolved sufficiently to handle initializer " + pNewInitializer.toASTString()});
        return pNewState;
    }

    private SMGState handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CCompositeType pLValueType, CInitializerList pNewInitializer) throws UnrecognizedCCodeException, CPATransferException {
        int sizeOfType;
        int listCounter = 0;
        List<CCompositeType.CCompositeTypeMemberDeclaration> memberTypes = pLValueType.getMembers();
        int offset = pOffset;
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            if (listCounter >= memberTypes.size()) {
                throw new UnrecognizedCCodeException("More Initializer in initializer list " + pNewInitializer.toASTString() + " than fit in type " + pLValueType.toASTString(""), pEdge);
            }
            CType memberType = memberTypes.get(listCounter).getType();
            pNewState = this.handleInitializer(pNewState, pVarDecl, pEdge, pNewObject, offset, memberType, initializer);
            offset += this.expressionEvaluator.getSizeof(pEdge, memberType);
            ++listCounter;
        }
        if (pVarDecl.isGlobal() && offset < (sizeOfType = this.expressionEvaluator.getSizeof(pEdge, pLValueType))) {
            pNewState = this.writeValue(pNewState, pNewObject, offset, AnonymousTypes.createTypeWithLength(sizeOfType), (SMGSymbolicValue)SMGKnownSymValue.ZERO, pEdge);
        }
        return pNewState;
    }

    private SMGState handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CArrayType pLValueType, CInitializerList pNewInitializer) throws UnrecognizedCCodeException, CPATransferException {
        int sizeOfType;
        int offset;
        int listCounter = 0;
        CType elementType = pLValueType.getType();
        int sizeOfElementType = this.expressionEvaluator.getSizeof(pEdge, elementType);
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            int offset2 = pOffset + listCounter * sizeOfElementType;
            pNewState = this.handleInitializer(pNewState, pVarDecl, pEdge, pNewObject, offset2, pLValueType.getType(), initializer);
            ++listCounter;
        }
        if (pVarDecl.isGlobal() && (offset = pOffset + listCounter * sizeOfElementType) < (sizeOfType = this.expressionEvaluator.getSizeof(pEdge, pLValueType))) {
            pNewState = this.writeValue(pNewState, pNewObject, offset, AnonymousTypes.createTypeWithLength(sizeOfType - offset), (SMGSymbolicValue)SMGKnownSymValue.ZERO, pEdge);
        }
        return pNewState;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> elements, CFAEdge cfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> retVal = null;
        for (AbstractState ae : elements) {
            if (ae instanceof AutomatonState && (retVal = this.strengthen((AutomatonState)ae, (SMGState)element, cfaEdge)).size() == 0) break;
        }
        this.missingInformationList.clear();
        this.possibleMallocFail = false;
        this.hasChanged = false;
        this.oldState = null;
        return retVal;
    }

    private Collection<? extends AbstractState> strengthen(AutomatonState pAutomatonState, SMGState pElement, CFAEdge pCfaEdge) throws CPATransferException {
        List<AssumeEdge> assumptions = pAutomatonState.getAsAssumeEdges(pCfaEdge.getPredecessor().getFunctionName());
        if (assumptions.isEmpty()) {
            return Collections.singleton(pElement);
        }
        StringBuilder assumeDesc = new StringBuilder();
        SMGState newElement = pElement;
        for (AssumeEdge assume : assumptions) {
            if (!(assume instanceof CAssumeEdge)) continue;
            assumeDesc.append(assume.getDescription());
            if ((newElement = this.handleAssumption(newElement, ((CAssumeEdge)assume).getExpression(), pCfaEdge, assume.getTruthAssumption(), pElement == newElement)) != null) continue;
            break;
        }
        if (newElement == null) {
            return Collections.emptyList();
        }
        this.plotWhenConfigured("every", null, newElement, assumeDesc.toString());
        return Collections.singleton(newElement);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private Collection<? extends AbstractState> strengthen(ValueAnalysisState explicitState, SMGState pSMGState, CFAEdge cfaEdge) throws CPATransferException {
        SMGState newElement = new SMGState(pSMGState);
        for (MissingInformation missingInformation : this.missingInformationList) {
            if (missingInformation.isMissingAssumption()) continue;
            if (missingInformation.isMissingAssignment()) {
                if (!this.isRelevant(missingInformation)) continue;
                newElement = this.resolvingAssignment(newElement, explicitState, missingInformation, cfaEdge);
                continue;
            }
            if (!missingInformation.isFunctionCall()) continue;
            this.resolveRValue(pSMGState, newElement, explicitState, missingInformation.getMissingCExpressionInformation(), cfaEdge);
        }
        return this.hasChanged ? Collections.singleton(newElement) : null;
    }

    private boolean isRelevant(MissingInformation missingInformation) {
        CRightHandSide value;
        if (missingInformation.hasUnknownMemoryLocation()) {
            value = missingInformation.getMissingCLeftMemoryLocation();
        } else if (missingInformation.hasUnknownValue()) {
            value = missingInformation.getMissingCExpressionInformation();
        } else {
            return false;
        }
        CType type = this.expressionEvaluator.getRealExpressionType(value);
        boolean result = type instanceof CPointerType;
        return result;
    }

    private SMGState resolvingAssignment(SMGState pSmgState, ValueAnalysisState explicitState, MissingInformation pMissingInformation, CFAEdge edge) throws CPATransferException {
        SMGAddress memoryLocation = null;
        if (pMissingInformation.hasKnownMemoryLocation()) {
            memoryLocation = pMissingInformation.getcLeftMemoryLocation();
        } else if (pMissingInformation.hasUnknownMemoryLocation()) {
            memoryLocation = this.resolveMemoryLocation(this.oldState, explicitState, pMissingInformation.getMissingCLeftMemoryLocation(), edge);
        }
        if (memoryLocation == null || memoryLocation.isUnknown()) {
            if (pMissingInformation.isRequieredInformation()) {
                throw new UnrecognizedCCodeException("Not able to compute allocation size", edge);
            }
            return pSmgState;
        }
        SMGSymbolicValue symbolicValue = null;
        if (pMissingInformation.hasUnknownValue()) {
            CRightHandSide rValue = pMissingInformation.getMissingCExpressionInformation();
            symbolicValue = this.resolveRValue(this.oldState, pSmgState, explicitState, pMissingInformation.getMissingCExpressionInformation(), edge);
            if (symbolicValue == null || symbolicValue.isUnknown()) {
                if (pMissingInformation.isRequieredInformation()) {
                    throw new UnrecognizedCCodeException("Not able to compute allocation size", edge);
                }
                return pSmgState;
            }
            this.hasChanged = true;
            pSmgState = this.writeValue(pSmgState, memoryLocation.getObject(), memoryLocation.getOffset().getAsInt(), this.expressionEvaluator.getRealExpressionType(rValue), symbolicValue, edge);
        }
        return pSmgState;
    }

    private SMGSymbolicValue resolveRValue(SMGState oldState, SMGState newSmgState, ValueAnalysisState pExplicitState, CRightHandSide rValue, CFAEdge pEdge) throws CPATransferException {
        if (rValue instanceof CFunctionCallExpression) {
            return this.resolveFunctionCall(newSmgState, pExplicitState, (CFunctionCallExpression)rValue, pEdge).getValue();
        }
        String functionName = pEdge.getPredecessor().getFunctionName();
        ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(pExplicitState, functionName, oldState, this.machineModel, this.logger, pEdge);
        return cc.evaluateSMGExpression(rValue);
    }

    private SMGExpressionEvaluator.SMGValueAndState resolveFunctionCall(SMGState pSmgState, ValueAnalysisState pExplicitState, CFunctionCallExpression pIastFunctionCallExpression, CFAEdge pEdge) throws CPATransferException {
        SMGExplicitBuiltIns builtins = new SMGExplicitBuiltIns(pExplicitState);
        CExpression fileNameExpression = pIastFunctionCallExpression.getFunctionNameExpression();
        String functionName = fileNameExpression.toASTString();
        if (builtins.isABuiltIn(functionName)) {
            switch (functionName) {
                case "__VERIFIER_BUILTIN_PLOT": {
                    builtins.evaluateVBPlot(pIastFunctionCallExpression, pSmgState);
                    return SMGExpressionEvaluator.SMGValueAndState.of(pSmgState);
                }
                case "malloc": {
                    SMGEdgePointsToAndState mallocEdge = builtins.evaluateMalloc(pIastFunctionCallExpression, pSmgState, pEdge);
                    return this.createAddress(mallocEdge);
                }
                case "__builtin_alloca": {
                    SMGEdgePointsToAndState allocEdge = builtins.evaluateAlloc(pIastFunctionCallExpression, pSmgState, pEdge);
                    return this.createAddress(allocEdge);
                }
                case "calloc": {
                    SMGEdgePointsToAndState callocEdge = builtins.evaluateCalloc(pIastFunctionCallExpression, pSmgState, pEdge);
                    return this.createAddress(callocEdge);
                }
                case "memset": {
                    SMGEdgePointsToAndState memsetTargetEdge = builtins.evaluateMemset(pIastFunctionCallExpression, pSmgState, pEdge);
                    return this.createAddress(memsetTargetEdge);
                }
                case "free": {
                    SMGState newState = builtins.evaluateFree(pIastFunctionCallExpression, pSmgState, pEdge);
                    return SMGExpressionEvaluator.SMGValueAndState.of(newState);
                }
            }
            throw new AssertionError();
        }
        return SMGExpressionEvaluator.SMGValueAndState.of(pSmgState);
    }

    private SMGExpressionEvaluator.SMGAddressValueAndState createAddress(SMGEdgePointsToAndState pMallocEdge) {
        return this.expressionEvaluator.createAddress(pMallocEdge);
    }

    private SMGAddress resolveMemoryLocation(SMGState pSmgState, ValueAnalysisState pExplicitState, CExpression lValue, CFAEdge edge) throws UnrecognizedCCodeException {
        String functionName = edge.getPredecessor().getFunctionName();
        ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(pExplicitState, functionName, pSmgState, this.machineModel, this.logger, edge);
        return cc.evaluateSMGLeftHandSide(lValue);
    }

    private SMGState resolvingAssumption(SMGState pSmgState, ValueAnalysisState pExplicitState, MissingInformation pMissingInformation, CFAEdge edge) throws UnrecognizedCCodeException {
        long truthValue = pMissingInformation.getTruthAssumption() != false ? 1L : 0L;
        Long value = this.resolveAssumptionValue(this.oldState, pExplicitState, pMissingInformation.getMissingCExpressionInformation(), edge);
        if (value != null && value != truthValue) {
            return null;
        }
        this.hasChanged = true;
        return pSmgState;
    }

    private Long resolveAssumptionValue(SMGState pSmgState, ValueAnalysisState pExplicitState, CRightHandSide rValue, CFAEdge edge) throws UnrecognizedCCodeException {
        String functionName = edge.getPredecessor().getFunctionName();
        ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(pExplicitState, functionName, pSmgState, this.machineModel, this.logger, edge);
        Value value = cc.evaluateExpression(rValue);
        if (value.isExplicitlyKnown() && value.isNumericValue()) {
            return value.asNumericValue().longValue();
        }
        return null;
    }

    private void checkForMissingRequiredInformation(CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        for (MissingInformation missingInformation : this.missingInformationList) {
            if (!missingInformation.isRequieredInformation()) continue;
            throw new UnrecognizedCCodeException("Not able to compute allocation size", cfaEdge);
        }
    }

    public static class SMGEdgePointsToAndState {
        private final SMGState smgState;
        private final SMGEdgePointsTo value;

        private SMGEdgePointsToAndState(SMGState pState, SMGEdgePointsTo pValue) {
            this.smgState = pState;
            this.value = pValue;
        }

        public SMGEdgePointsToAndState(SMGState pState) {
            this.smgState = pState;
            this.value = null;
        }

        public SMGEdgePointsTo getValue() {
            return this.value;
        }

        public static SMGExpressionEvaluator.SMGValueAndState of(SMGState pState) {
            return new SMGExpressionEvaluator.SMGValueAndState(pState);
        }

        public SMGState getSmgState() {
            return this.smgState;
        }

        public static SMGEdgePointsToAndState of(SMGState pState, SMGEdgePointsTo pValue) {
            return new SMGEdgePointsToAndState(pState, pValue);
        }
    }

    public static class SMGAddress {
        public static final SMGAddress UNKNOWN = new SMGAddress();
        private final SMGObject object;
        private final SMGExplicitValue offset;

        private SMGAddress(SMGObject pObject, SMGExplicitValue pOffset) {
            Preconditions.checkNotNull((Object)pOffset);
            this.object = pObject;
            this.offset = pOffset;
        }

        private SMGAddress() {
            this.object = null;
            this.offset = SMGUnknownValue.getInstance();
        }

        public final boolean isUnknown() {
            return this.object == null || this.offset.isUnknown();
        }

        public final SMGAddress add(SMGExplicitValue pAddedOffset) {
            if (this.object == null || this.offset.isUnknown() || pAddedOffset.isUnknown()) {
                return UNKNOWN;
            }
            return SMGAddress.valueOf(this.object, this.offset.add(pAddedOffset));
        }

        public SMGExplicitValue getOffset() {
            return this.offset;
        }

        public SMGObject getObject() {
            return this.object;
        }

        public static final SMGAddress valueOf(SMGObject object, SMGExplicitValue offset) {
            return new SMGAddress(object, offset);
        }

        public final String toString() {
            if (this.isUnknown()) {
                return "Unkown";
            }
            return "Object: " + this.object.toString() + " Offset: " + this.offset.toString();
        }

        public static SMGAddress valueOf(SMGObject pObj, int pOffset) {
            return new SMGAddress(pObj, SMGKnownExpValue.valueOf(pOffset));
        }

        public static SMGAddress getUnknownInstance() {
            return UNKNOWN;
        }
    }

    public static final class SMGKnownAddVal
    extends SMGKnownSymValue
    implements SMGAddressValue {
        private final SMGKnownAddress address;

        private SMGKnownAddVal(BigInteger pValue, SMGKnownAddress pAddress) {
            super(pValue);
            Preconditions.checkNotNull((Object)pAddress);
            this.address = pAddress;
        }

        public static SMGKnownAddVal valueOf(SMGObject pObject, SMGKnownExpValue pOffset, SMGKnownSymValue pAddress) {
            return new SMGKnownAddVal(pAddress.getValue(), SMGKnownAddress.valueOf(pObject, pOffset));
        }

        @Override
        public SMGKnownAddress getAddress() {
            return this.address;
        }

        public static SMGKnownAddVal valueOf(BigInteger pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(pValue, pAddress);
        }

        public static SMGKnownAddVal valueOf(SMGKnownSymValue pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(pValue.getValue(), pAddress);
        }

        public static SMGKnownAddVal valueOf(int pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), pAddress);
        }

        public static SMGKnownAddVal valueOf(long pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), pAddress);
        }

        public static SMGKnownAddVal valueOf(int pValue, SMGObject object, int offset) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), SMGKnownAddress.valueOf(object, offset));
        }

        @Override
        public String toString() {
            return "Value: " + super.toString() + " " + this.address.toString();
        }

        @Override
        public SMGKnownExpValue getOffset() {
            return this.address.getOffset();
        }

        @Override
        public SMGObject getObject() {
            return this.address.getObject();
        }

        private static class SMGKnownAddress
        extends SMGAddress {
            private SMGKnownAddress(SMGObject pObject, SMGKnownExpValue pOffset) {
                super(pObject, pOffset);
            }

            public static SMGKnownAddress valueOf(SMGObject pObject, int pOffset) {
                return new SMGKnownAddress(pObject, SMGKnownExpValue.valueOf(pOffset));
            }

            public static final SMGKnownAddress valueOf(SMGObject object, SMGKnownExpValue offset) {
                return new SMGKnownAddress(object, offset);
            }

            @Override
            public SMGKnownExpValue getOffset() {
                return (SMGKnownExpValue)super.getOffset();
            }

            @Override
            public SMGObject getObject() {
                return super.getObject();
            }
        }
    }

    public static final class SMGField {
        private static final SMGField UNKNOWN = new SMGField(SMGUnknownValue.getInstance(), new CProblemType("unknown"));
        private final SMGExplicitValue offset;
        private final CType type;

        public SMGField(SMGExplicitValue pOffset, CType pType) {
            Preconditions.checkNotNull((Object)pOffset);
            Preconditions.checkNotNull((Object)pType);
            this.offset = pOffset;
            this.type = pType;
        }

        public SMGExplicitValue getOffset() {
            return this.offset;
        }

        public CType getType() {
            return this.type;
        }

        public boolean isUnknown() {
            return this.offset.isUnknown() || this.type instanceof CProblemType;
        }

        public String toString() {
            return "offset: " + this.offset + "Type:" + this.type.toASTString("");
        }

        public static SMGField getUnknownInstance() {
            return UNKNOWN;
        }
    }

    public static final class SMGUnknownValue
    implements SMGSymbolicValue,
    SMGExplicitValue,
    SMGAddressValue {
        private static final SMGUnknownValue instance = new SMGUnknownValue();

        public String toString() {
            return "UNKNOWN";
        }

        public static SMGUnknownValue getInstance() {
            return instance;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public SMGAddress getAddress() {
            return SMGAddress.UNKNOWN;
        }

        @Override
        public BigInteger getValue() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public int getAsInt() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public long getAsLong() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public SMGExplicitValue negate() {
            return instance;
        }

        @Override
        public SMGExplicitValue xor(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue or(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue and(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue divide(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue add(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue getOffset() {
            return instance;
        }

        @Override
        public SMGObject getObject() {
            return null;
        }
    }

    public static final class SMGKnownExpValue
    extends SMGKnownValue
    implements SMGExplicitValue {
        public static final SMGKnownExpValue ONE = new SMGKnownExpValue(BigInteger.ONE);
        public static final SMGKnownExpValue ZERO = new SMGKnownExpValue(BigInteger.ZERO);

        private SMGKnownExpValue(BigInteger pValue) {
            super(pValue);
        }

        @Override
        public boolean equals(Object pObj) {
            if (!(pObj instanceof SMGKnownExpValue)) {
                return false;
            }
            return super.equals(pObj);
        }

        @Override
        public int hashCode() {
            int result = 5;
            result = 31 * result + super.hashCode();
            return result;
        }

        @Override
        public SMGExplicitValue negate() {
            return SMGKnownExpValue.valueOf(this.getValue().negate());
        }

        @Override
        public SMGExplicitValue xor(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().xor(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue or(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().or(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue and(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().and(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().shiftLeft(pRVal.getAsInt()));
        }

        @Override
        public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().multiply(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue divide(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().divide(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().subtract(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue add(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().add(pRVal.getValue()));
        }

        public static final SMGKnownExpValue valueOf(int pValue) {
            if (pValue == 0) {
                return ZERO;
            }
            if (pValue == 1) {
                return ONE;
            }
            return new SMGKnownExpValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownExpValue valueOf(long pValue) {
            if (pValue == 0L) {
                return ZERO;
            }
            if (pValue == 1L) {
                return ONE;
            }
            return new SMGKnownExpValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownExpValue valueOf(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            if (pValue.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (pValue.equals(BigInteger.ONE)) {
                return ONE;
            }
            return new SMGKnownExpValue(pValue);
        }
    }

    public static class SMGKnownSymValue
    extends SMGKnownValue
    implements SMGSymbolicValue {
        public static final SMGKnownSymValue ZERO = new SMGKnownSymValue(BigInteger.ZERO);
        public static final SMGKnownSymValue ONE = new SMGKnownSymValue(BigInteger.ONE);
        public static final SMGKnownSymValue TRUE = new SMGKnownSymValue(BigInteger.valueOf(-1L));
        public static final SMGKnownSymValue FALSE = ZERO;

        private SMGKnownSymValue(BigInteger pValue) {
            super(pValue);
        }

        public static final SMGKnownSymValue valueOf(int pValue) {
            if (pValue == 0) {
                return ZERO;
            }
            if (pValue == 1) {
                return ONE;
            }
            return new SMGKnownSymValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownSymValue valueOf(long pValue) {
            if (pValue == 0L) {
                return ZERO;
            }
            if (pValue == 1L) {
                return ONE;
            }
            return new SMGKnownSymValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownSymValue valueOf(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            if (pValue.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (pValue.equals(BigInteger.ONE)) {
                return ONE;
            }
            return new SMGKnownSymValue(pValue);
        }

        @Override
        public final boolean equals(Object pObj) {
            if (!(pObj instanceof SMGKnownSymValue)) {
                return false;
            }
            return super.equals(pObj);
        }

        @Override
        public final int hashCode() {
            int result = 17;
            result = 31 * result + super.hashCode();
            return result;
        }
    }

    public static abstract class SMGKnownValue {
        private final BigInteger value;

        private SMGKnownValue(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = pValue;
        }

        private SMGKnownValue(long pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = BigInteger.valueOf(pValue);
        }

        private SMGKnownValue(int pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = BigInteger.valueOf(pValue);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof SMGKnownValue)) {
                return false;
            }
            SMGKnownValue otherValue = (SMGKnownValue)pObj;
            return this.value.equals(otherValue.value);
        }

        public int hashCode() {
            int result = 5;
            int c = this.value.hashCode();
            return result * 31 + c;
        }

        public final BigInteger getValue() {
            return this.value;
        }

        public final int getAsInt() {
            return this.value.intValue();
        }

        public final long getAsLong() {
            return this.value.longValue();
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean isUnknown() {
            return false;
        }
    }

    public static interface SMGExplicitValue
    extends SMGValue {
        public SMGExplicitValue negate();

        public SMGExplicitValue xor(SMGExplicitValue var1);

        public SMGExplicitValue or(SMGExplicitValue var1);

        public SMGExplicitValue and(SMGExplicitValue var1);

        public SMGExplicitValue shiftLeft(SMGExplicitValue var1);

        public SMGExplicitValue multiply(SMGExplicitValue var1);

        public SMGExplicitValue divide(SMGExplicitValue var1);

        public SMGExplicitValue subtract(SMGExplicitValue var1);

        public SMGExplicitValue add(SMGExplicitValue var1);
    }

    public static interface SMGAddressValue
    extends SMGSymbolicValue {
        @Override
        public boolean isUnknown();

        public SMGAddress getAddress();

        public SMGExplicitValue getOffset();

        public SMGObject getObject();
    }

    public static interface SMGValue {
        public boolean isUnknown();

        public BigInteger getValue();

        public int getAsInt();

        public long getAsLong();
    }

    public static interface SMGSymbolicValue
    extends SMGValue {
    }

    private static class MissingInformation {
        private final CExpression missingCLeftMemoryLocation;
        private final SMGAddress cLeftMemoryLocation;
        private final CRightHandSide missingCExpressionInformation;
        private final SMGSymbolicValue cExpressionValue;
        private final Boolean truthAssumption;
        private final boolean requieredInformation;

        public MissingInformation(CExpression pMissingCLeftMemoryLocation, CRightHandSide pMissingCExpressionInformation, boolean pRequieredInformation) {
            this.missingCExpressionInformation = pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = pMissingCLeftMemoryLocation;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = null;
            this.requieredInformation = pRequieredInformation;
        }

        public boolean hasUnknownValue() {
            return this.missingCExpressionInformation != null;
        }

        public boolean hasKnownValue() {
            return this.cExpressionValue != null;
        }

        public boolean hasUnknownMemoryLocation() {
            return this.missingCLeftMemoryLocation != null;
        }

        public boolean isFunctionCall() {
            return this.missingCLeftMemoryLocation == null && this.cLeftMemoryLocation == null && this.missingCExpressionInformation instanceof CFunctionCallExpression;
        }

        public boolean hasKnownMemoryLocation() {
            return this.cLeftMemoryLocation != null;
        }

        public boolean isMissingAssignment() {
            return !(this.missingCExpressionInformation == null && this.missingCLeftMemoryLocation == null || this.truthAssumption != null || this.missingCLeftMemoryLocation == null && this.cLeftMemoryLocation == null);
        }

        public boolean isMissingAssumption() {
            return this.truthAssumption != null && this.missingCExpressionInformation != null;
        }

        public MissingInformation(CExpression pMissingCLeftMemoryLocation, SMGSymbolicValue pCExpressionValue, boolean pRequieredInformation) {
            this.missingCExpressionInformation = null;
            this.missingCLeftMemoryLocation = pMissingCLeftMemoryLocation;
            this.cExpressionValue = pCExpressionValue;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = null;
            this.requieredInformation = pRequieredInformation;
        }

        public MissingInformation(SMGAddress pCLeftMemoryLocation, CRightHandSide pMissingCExpressionInformation, boolean pRequieredInformation) {
            this.missingCExpressionInformation = pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = null;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = pCLeftMemoryLocation;
            this.truthAssumption = null;
            this.requieredInformation = pRequieredInformation;
        }

        public MissingInformation(boolean pTruthAssumption, ARightHandSide pMissingCExpressionInformation) {
            this.missingCExpressionInformation = (CExpression)pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = null;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = pTruthAssumption;
            this.requieredInformation = false;
        }

        public MissingInformation(CFunctionCallExpression pCFCExpression, boolean pIsRequiered) {
            this.missingCExpressionInformation = pCFCExpression;
            this.requieredInformation = pIsRequiered;
            this.cExpressionValue = null;
            this.truthAssumption = null;
            this.missingCLeftMemoryLocation = null;
            this.cLeftMemoryLocation = null;
        }

        public SMGSymbolicValue getcExpressionValue() {
            Preconditions.checkNotNull((Object)this.cExpressionValue);
            return this.cExpressionValue;
        }

        public SMGAddress getcLeftMemoryLocation() {
            Preconditions.checkNotNull((Object)this.cLeftMemoryLocation);
            return this.cLeftMemoryLocation;
        }

        public CRightHandSide getMissingCExpressionInformation() {
            Preconditions.checkNotNull((Object)this.missingCExpressionInformation);
            return this.missingCExpressionInformation;
        }

        public CExpression getMissingCLeftMemoryLocation() {
            Preconditions.checkNotNull((Object)this.missingCLeftMemoryLocation);
            return this.missingCLeftMemoryLocation;
        }

        public Boolean getTruthAssumption() {
            Preconditions.checkNotNull((Object)this.truthAssumption);
            return this.truthAssumption;
        }

        public boolean isRequieredInformation() {
            return this.requieredInformation;
        }
    }

    private class SMGExplicitBuiltIns
    extends SMGBuiltins {
        private final ValueAnalysisState explicitState;

        public SMGExplicitBuiltIns(ValueAnalysisState pExplicitState) {
            this.explicitState = pExplicitState;
        }

        @Override
        protected SMGExpressionEvaluator.SMGAddressValueAndState evaluateAddress(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRvalue) throws CPATransferException {
            String functionName = pCfaEdge.getPredecessor().getFunctionName();
            ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(this.explicitState, functionName, pState, SMGTransferRelation.this.machineModel, SMGTransferRelation.this.logger, pCfaEdge);
            return SMGExpressionEvaluator.SMGAddressValueAndState.of(pState, cc.evaluateSMGAddressExpression(pRvalue));
        }

        @Override
        protected SMGExpressionEvaluator.SMGValueAndState evaluateExpressionValue(SMGState pSmgState, CFAEdge pCfaEdge, CExpression pRValue) throws CPATransferException {
            return SMGExpressionEvaluator.SMGValueAndState.of(pSmgState, SMGTransferRelation.this.resolveRValue(SMGTransferRelation.this.oldState, pSmgState, this.explicitState, pRValue, pCfaEdge));
        }

        @Override
        protected String getDot(SMGState pCurrentState, String pName, String pLocation) {
            return pCurrentState.toDot(pName, pLocation, this.explicitState);
        }

        @Override
        protected Path getOutputFile(PathTemplate pExportSMGFilePattern, String pName) {
            return SMGTransferRelation.this.exportSMGFilePattern.getPath(new Object[]{"Explicit_" + pName});
        }

        @Override
        protected SMGExpressionEvaluator.SMGExplicitValueAndState evaluateExplicitValue(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
            String functionName = pCfaEdge.getPredecessor().getFunctionName();
            ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(this.explicitState, functionName, pState, SMGTransferRelation.this.machineModel, SMGTransferRelation.this.logger, pCfaEdge);
            Value valueV = cc.evaluateExpression(pRValue);
            if (!valueV.isExplicitlyKnown() || !valueV.isNumericValue()) {
                return SMGExpressionEvaluator.SMGExplicitValueAndState.of(pState);
            }
            return SMGExpressionEvaluator.SMGExplicitValueAndState.of(pState, SMGKnownExpValue.valueOf(valueV.asNumericValue().longValue()));
        }
    }

    private class SMGRightHandSideEvaluator
    extends SMGExpressionEvaluator {
        private boolean missingExplicitInformation;
        private boolean isRequiered;

        public SMGRightHandSideEvaluator(LogManagerWithoutDuplicates pLogger, MachineModel pMachineModel) {
            super(pLogger, pMachineModel);
        }

        public SMGExpressionEvaluator.SMGExplicitValueAndState forceExplicitValue(SMGState smgState, CFAEdge pCfaEdge, CRightHandSide rVal) throws UnrecognizedCCodeException {
            ForceExplicitValueVisitor v = new ForceExplicitValueVisitor(smgState, null, SMGTransferRelation.this.machineModel, SMGTransferRelation.this.logger, pCfaEdge);
            Value val = rVal.accept(v);
            if (val.isUnknown()) {
                return SMGExpressionEvaluator.SMGExplicitValueAndState.of(v.getNewState());
            }
            return SMGExpressionEvaluator.SMGExplicitValueAndState.of(v.getNewState(), SMGKnownExpValue.valueOf(val.asNumericValue().longValue()));
        }

        public SMGState deriveFurtherInformation(SMGState pNewState, boolean pTruthValue, CFAEdge pCfaEdge, CExpression rValue) throws CPATransferException {
            AssigningValueVisitor v = new AssigningValueVisitor(pNewState, pTruthValue, pCfaEdge);
            rValue.accept(v);
            return v.getAssignedState();
        }

        @Override
        public SMGExpressionEvaluator.SMGValueAndState readValue(SMGState pSmgState, SMGObject pObject, SMGExplicitValue pOffset, CType pType, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
            boolean doesNotFitIntoObject;
            if (pOffset.isUnknown() || pObject == null) {
                return SMGExpressionEvaluator.SMGValueAndState.of(pSmgState);
            }
            int fieldOffset = pOffset.getAsInt();
            boolean bl = doesNotFitIntoObject = fieldOffset < 0 || fieldOffset + this.getSizeof(pEdge, pType) > pObject.getSize();
            if (doesNotFitIntoObject) {
                SMGTransferRelation.this.logger.log(Level.WARNING, new Object[]{pEdge.getFileLocation() + ":", "Field (" + fieldOffset + ", " + pType.toASTString("") + ")" + " does not fit object " + pObject.toString() + "."});
                return SMGExpressionEvaluator.SMGValueAndState.of(pSmgState.setInvalidRead());
            }
            return pSmgState.forceReadValue(pObject, fieldOffset, pType);
        }

        @Override
        protected SMGExpressionEvaluator.PointerVisitor getPointerVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            return new PointerAddressVisitor(pCfaEdge, pNewState);
        }

        @Override
        protected SMGExpressionEvaluator.ExpressionValueVisitor getExpressionValueVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            return new ExpressionValueVisitor(pCfaEdge, pNewState);
        }

        @Override
        public SMGExpressionEvaluator.LValueAssignmentVisitor getLValueAssignmentVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            return new LValueAssignmentVisitor(pCfaEdge, pNewState);
        }

        @Override
        public SMGExpressionEvaluator.SMGExplicitValueAndState evaluateExplicitValue(SMGState pSmgState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
            SMGExpressionEvaluator.SMGExplicitValueAndState explicitValue = super.evaluateExplicitValue(pSmgState, pCfaEdge, pRValue);
            if (explicitValue.getValue().isUnknown()) {
                this.missingExplicitInformation = true;
            }
            return explicitValue;
        }

        public boolean isMissingExplicitInformation() {
            return this.missingExplicitInformation;
        }

        public boolean isRequiered() {
            return this.isRequiered;
        }

        @Override
        protected SMGExpressionEvaluator.SMGValueAndState handleUnknownDereference(SMGState pSmgState, CFAEdge pEdge) {
            SMGState newState = pSmgState.setUnknownDereference();
            return super.handleUnknownDereference(newState, pEdge);
        }

        public void reset() {
            this.isRequiered = false;
            this.missingExplicitInformation = false;
        }

        private class PointerAddressVisitor
        extends SMGExpressionEvaluator.PointerVisitor {
            public PointerAddressVisitor(CFAEdge pEdge, SMGState pSmgState) {
                super(pEdge, pSmgState);
            }

            @Override
            public SMGExpressionEvaluator.SMGAddressValueAndState visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
                CExpression fileNameExpression = pIastFunctionCallExpression.getFunctionNameExpression();
                String functionName = fileNameExpression.toASTString();
                if (SMGTransferRelation.this.builtins.isABuiltIn(functionName)) {
                    switch (functionName) {
                        case "malloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsToAndState mallocEdge = SMGTransferRelation.this.builtins.evaluateMalloc(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(mallocEdge);
                        }
                        case "__builtin_alloca": {
                            SMGEdgePointsToAndState allocEdge = SMGTransferRelation.this.builtins.evaluateAlloc(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(allocEdge);
                        }
                        case "calloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsToAndState callocEdge = SMGTransferRelation.this.builtins.evaluateCalloc(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(callocEdge);
                        }
                        case "memset": {
                            SMGEdgePointsToAndState memsetTargetEdge = SMGTransferRelation.this.builtins.evaluateMemset(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(memsetTargetEdge);
                        }
                        case "printf": {
                            return SMGExpressionEvaluator.SMGAddressValueAndState.of(this.getInitialSmgState());
                        }
                    }
                    if (SMGTransferRelation.this.builtins.isNondetBuiltin(functionName)) {
                        return SMGExpressionEvaluator.SMGAddressValueAndState.of(this.getInitialSmgState());
                    }
                    throw new AssertionError((Object)("Unexpected function handled as a builtin: " + functionName));
                }
                switch (SMGTransferRelation.this.handleUnknownFunctions) {
                    case "strict": {
                        throw new CPATransferException("Unknown function '" + functionName + "' may be unsafe. See the cpa.smg.handleUnknownFunction option.");
                    }
                    case "assume_safe": {
                        return SMGExpressionEvaluator.SMGAddressValueAndState.of(this.getInitialSmgState());
                    }
                }
                throw new AssertionError();
            }
        }

        private class ForceExplicitValueVisitor
        extends SMGExpressionEvaluator.ExplicitValueVisitor {
            private final SMGKnownExpValue GUESS;

            public ForceExplicitValueVisitor(SMGState pSmgState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, CFAEdge pEdge) {
                super(pSmgState, pFunctionName, pMachineModel, pLogger, pEdge);
                this.GUESS = SMGKnownExpValue.valueOf(2);
            }

            @Override
            protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCCodeException {
                Value result = super.evaluateCArraySubscriptExpression(pLValue);
                if (result.isUnknown()) {
                    return this.guessLHS(pLValue);
                }
                return result;
            }

            @Override
            protected Value evaluateCIdExpression(CIdExpression pCIdExpression) throws UnrecognizedCCodeException {
                Value result = super.evaluateCIdExpression(pCIdExpression);
                if (result.isUnknown()) {
                    return this.guessLHS(pCIdExpression);
                }
                return result;
            }

            private Value guessLHS(CLeftHandSide exp) throws UnrecognizedCCodeException {
                SMGExpressionEvaluator.SMGValueAndState symbolicValueAndState;
                try {
                    symbolicValueAndState = SMGRightHandSideEvaluator.this.evaluateExpressionValue(this.getNewState(), this.getEdge(), exp);
                }
                catch (CPATransferException e) {
                    UnrecognizedCCodeException e2 = new UnrecognizedCCodeException("SMG cannot get symbolic value of : " + exp.toASTString(), exp);
                    e2.initCause(e);
                    throw e2;
                }
                SMGSymbolicValue value = symbolicValueAndState.getValue();
                this.setSmgState(symbolicValueAndState.getSmgState());
                if (value.isUnknown()) {
                    return Value.UnknownValue.getInstance();
                }
                this.getNewState().putExplicit((SMGKnownSymValue)value, this.GUESS);
                return new NumericValue(this.GUESS.getValue());
            }

            @Override
            protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCCodeException {
                Value result = super.evaluateCFieldReference(pLValue);
                if (result.isUnknown()) {
                    return this.guessLHS(pLValue);
                }
                return result;
            }

            @Override
            protected Value evaluateCPointerExpression(CPointerExpression pCPointerExpression) throws UnrecognizedCCodeException {
                Value result = super.evaluateCPointerExpression(pCPointerExpression);
                if (result.isUnknown()) {
                    return this.guessLHS(pCPointerExpression);
                }
                return result;
            }
        }

        private class ExpressionValueVisitor
        extends SMGExpressionEvaluator.ExpressionValueVisitor {
            public ExpressionValueVisitor(CFAEdge pEdge, SMGState pSmgState) {
                super(pEdge, pSmgState);
            }

            @Override
            public SMGExpressionEvaluator.SMGValueAndState visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
                CExpression fileNameExpression = pIastFunctionCallExpression.getFunctionNameExpression();
                String functionName = fileNameExpression.toASTString();
                if (SMGTransferRelation.this.builtins.isABuiltIn(functionName)) {
                    switch (functionName) {
                        case "__VERIFIER_BUILTIN_PLOT": {
                            SMGTransferRelation.this.builtins.evaluateVBPlot(pIastFunctionCallExpression, this.getInitialSmgState());
                            break;
                        }
                        case "malloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsToAndState mallocEdge = SMGTransferRelation.this.builtins.evaluateMalloc(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(mallocEdge);
                        }
                        case "__builtin_alloca": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsToAndState allocEdge = SMGTransferRelation.this.builtins.evaluateAlloc(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(allocEdge);
                        }
                        case "calloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsToAndState callocEdge = SMGTransferRelation.this.builtins.evaluateCalloc(pIastFunctionCallExpression, this.getInitialSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(callocEdge);
                        }
                        case "printf": {
                            return SMGExpressionEvaluator.SMGValueAndState.of(this.getInitialSmgState());
                        }
                        default: {
                            if (SMGTransferRelation.this.builtins.isNondetBuiltin(functionName)) {
                                return SMGExpressionEvaluator.SMGValueAndState.of(this.getInitialSmgState());
                            }
                            throw new AssertionError((Object)("Unexpected function handled as a builtin: " + functionName));
                        }
                    }
                } else {
                    switch (SMGTransferRelation.this.handleUnknownFunctions) {
                        case "strict": {
                            throw new CPATransferException("Unknown function '" + functionName + "' may be unsafe. See the cpa.smg.handleUnknownFunction option.");
                        }
                        case "assume_safe": {
                            return SMGExpressionEvaluator.SMGValueAndState.of(this.getInitialSmgState());
                        }
                    }
                    throw new AssertionError();
                }
                return SMGExpressionEvaluator.SMGValueAndState.of(this.getInitialSmgState());
            }
        }

        private class LValueAssignmentVisitor
        extends SMGExpressionEvaluator.LValueAssignmentVisitor {
            public LValueAssignmentVisitor(CFAEdge pEdge, SMGState pSmgState) {
                super(pEdge, pSmgState);
            }

            @Override
            public SMGExpressionEvaluator.SMGAddressAndState visit(CIdExpression variableName) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: variable assignment"});
                return super.visit(variableName);
            }

            @Override
            public SMGExpressionEvaluator.SMGAddressAndState visit(CPointerExpression pLValue) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: assignment to dereferenced pointer"});
                SMGExpressionEvaluator.SMGAddressAndState address = super.visit(pLValue);
                if (address.getAddress().isUnknown()) {
                    return SMGExpressionEvaluator.SMGAddressAndState.of(address.getSmgState().setUnknownDereference(), address.getAddress());
                }
                return address;
            }

            @Override
            public SMGExpressionEvaluator.SMGAddressAndState visit(CFieldReference lValue) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: assignment to field reference"});
                return super.visit(lValue);
            }

            @Override
            public SMGExpressionEvaluator.SMGAddressAndState visit(CArraySubscriptExpression lValue) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: assignment to array Cell"});
                return super.visit(lValue);
            }
        }

        private class AssigningValueVisitor
        extends DefaultCExpressionVisitor<Void, CPATransferException> {
            private SMGState assignableState;
            private boolean truthValue = false;
            private CFAEdge edge;

            public AssigningValueVisitor(SMGState pSMGState, boolean pTruthvalue, CFAEdge pEdge) {
                this.assignableState = pSMGState;
                this.truthValue = pTruthvalue;
                this.edge = pEdge;
            }

            public SMGState getAssignedState() {
                return this.assignableState;
            }

            @Override
            protected Void visitDefault(CExpression pExp) throws CPATransferException {
                return null;
            }

            @Override
            public Void visit(CPointerExpression pointerExpression) throws CPATransferException {
                this.deriveFurtherInformation(pointerExpression);
                return null;
            }

            @Override
            public Void visit(CIdExpression pExp) throws CPATransferException {
                this.deriveFurtherInformation(pExp);
                return null;
            }

            @Override
            public Void visit(CArraySubscriptExpression pExp) throws CPATransferException {
                this.deriveFurtherInformation(pExp);
                return null;
            }

            @Override
            public Void visit(CFieldReference pExp) throws CPATransferException {
                this.deriveFurtherInformation(pExp);
                return null;
            }

            @Override
            public Void visit(CCastExpression pE) throws CPATransferException {
                return pE.getOperand().accept(this);
            }

            @Override
            public Void visit(CCharLiteralExpression pE) throws CPATransferException {
                assert (false);
                return null;
            }

            @Override
            public Void visit(CFloatLiteralExpression pE) throws CPATransferException {
                assert (false);
                return null;
            }

            @Override
            public Void visit(CIntegerLiteralExpression pE) throws CPATransferException {
                assert (false);
                return null;
            }

            @Override
            public Void visit(CBinaryExpression binExp) throws CPATransferException {
                CExpression operand1 = this.unwrap(binExp.getOperand1());
                CExpression operand2 = this.unwrap(binExp.getOperand2());
                CBinaryExpression.BinaryOperator op = binExp.getOperator();
                if (operand1 instanceof CLeftHandSide) {
                    this.deriveFurtherInformation((CLeftHandSide)operand1, operand2, op);
                }
                if (operand2 instanceof CLeftHandSide) {
                    this.deriveFurtherInformation((CLeftHandSide)operand2, operand1, op);
                }
                return null;
            }

            private void deriveFurtherInformation(CLeftHandSide lValue, CExpression exp, CBinaryExpression.BinaryOperator op) throws CPATransferException {
                SMGExplicitValue rValue = SMGRightHandSideEvaluator.this.evaluateExplicitValue(this.assignableState, this.edge, exp).getValue();
                if (rValue.isUnknown()) {
                    return;
                }
                SMGSymbolicValue rSymValue = SMGRightHandSideEvaluator.this.evaluateExpressionValue(this.assignableState, this.edge, lValue).getValue();
                if (rSymValue.isUnknown()) {
                    rSymValue = SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
                    SMGExpressionEvaluator.LValueAssignmentVisitor visitor = SMGRightHandSideEvaluator.this.getLValueAssignmentVisitor(this.edge, this.assignableState);
                    SMGAddress addressOfField = lValue.accept(visitor).getAddress();
                    if (addressOfField.isUnknown()) {
                        return;
                    }
                    this.assignableState = SMGTransferRelation.this.writeValue(this.assignableState, addressOfField.getObject(), addressOfField.getOffset().getAsInt(), SMGRightHandSideEvaluator.this.getRealExpressionType(exp), rSymValue, this.edge);
                }
                if (this.truthValue) {
                    if (op == CBinaryExpression.BinaryOperator.EQUALS) {
                        this.assignableState.putExplicit((SMGKnownSymValue)rSymValue, (SMGKnownExpValue)rValue);
                    }
                } else if (op == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    this.assignableState.putExplicit((SMGKnownSymValue)rSymValue, (SMGKnownExpValue)rValue);
                }
            }

            @Override
            public Void visit(CUnaryExpression pE) throws CPATransferException {
                CUnaryExpression.UnaryOperator op = pE.getOperator();
                CExpression operand = pE.getOperand();
                switch (op) {
                    case AMPER: {
                        assert (false) : "In this case, the assume should be able to be calculated";
                        return null;
                    }
                    case MINUS: 
                    case TILDE: {
                        return operand.accept(this);
                    }
                    case SIZEOF: {
                        assert (false) : "At the moment, this cae should be able to be calculated";
                        break;
                    }
                }
                return null;
            }

            private void deriveFurtherInformation(CLeftHandSide lValue) throws CPATransferException {
                if (this.truthValue) {
                    return;
                }
                SMGExpressionEvaluator.LValueAssignmentVisitor visitor = SMGRightHandSideEvaluator.this.getLValueAssignmentVisitor(this.edge, this.assignableState);
                SMGAddress addressOfField = lValue.accept(visitor).getAddress();
                if (addressOfField.isUnknown()) {
                    return;
                }
                assert (SMGRightHandSideEvaluator.this.evaluateExplicitValue(this.assignableState, this.edge, lValue).getValue().isUnknown());
                SMGSymbolicValue value = SMGRightHandSideEvaluator.this.evaluateExpressionValue(this.assignableState, this.edge, lValue).getValue();
                assert (!value.isUnknown());
                this.assignableState.putExplicit((SMGKnownSymValue)value, SMGKnownExpValue.ZERO);
            }

            private CExpression unwrap(CExpression expression) {
                if (expression instanceof CCastExpression) {
                    CCastExpression exp = (CCastExpression)expression;
                    expression = exp.getOperand();
                    expression = this.unwrap(expression);
                }
                return expression;
            }
        }
    }

    private class SMGBuiltins {
        private static final int MEMSET_BUFFER_PARAMETER = 0;
        private static final int MEMSET_CHAR_PARAMETER = 1;
        private static final int MEMSET_COUNT_PARAMETER = 2;
        private static final int CALLOC_NUM_PARAMETER = 0;
        private static final int CALLOC_SIZE_PARAMETER = 1;
        private static final int MALLOC_PARAMETER = 0;
        private final Set<String> BUILTINS = new HashSet<String>(Arrays.asList("__VERIFIER_BUILTIN_PLOT", "malloc", "free", "memset", "calloc", "__builtin_alloca", "printf"));
        private static final String NONDET_PREFIX = "__VERIFIER_nondet_";

        private SMGBuiltins() {
        }

        private void dumpSMGPlot(String name, SMGState currentState, String location) {
            if (SMGTransferRelation.this.exportSMGFilePattern != null && currentState != null) {
                if (name == null) {
                    name = currentState.getPredecessorId() == 0 ? String.format("initial-%03d", currentState.getId()) : String.format("%03d-%03d-%03d", currentState.getPredecessorId(), currentState.getId(), SMGTransferRelation.this.id_counter.getAndIncrement());
                }
                name = name.replace("\"", "");
                Path outputFile = this.getOutputFile(SMGTransferRelation.this.exportSMGFilePattern, name);
                try {
                    String dot = this.getDot(currentState, name, location);
                    Files.writeFile((Path)outputFile, (Object)dot);
                }
                catch (IOException e) {
                    SMGTransferRelation.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write SMG " + name + " to file");
                }
            }
        }

        protected Path getOutputFile(PathTemplate pExportSMGFilePattern, String pName) {
            return pExportSMGFilePattern.getPath(new Object[]{pName});
        }

        protected String getDot(SMGState pCurrentState, String pName, String pLocation) {
            return pCurrentState.toDot(pName, pLocation);
        }

        public final void evaluateVBPlot(CFunctionCallExpression functionCall, SMGState currentState) {
            String name = functionCall.getParameterExpressions().get(0).toASTString();
            this.dumpSMGPlot(name, currentState, functionCall.toString());
        }

        public final SMGEdgePointsToAndState evaluateMalloc(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
            CRightHandSide sizeExpr;
            SMGState currentState = pState;
            try {
                sizeExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Malloc argument not found.", cfaEdge, functionCall);
            }
            SMGExpressionEvaluator.SMGExplicitValueAndState valueAndState = this.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
            SMGExplicitValue value = valueAndState.getValue();
            currentState = valueAndState.getSmgState();
            if (value.isUnknown()) {
                if (SMGTransferRelation.this.guessSizeOfUnknownMemorySize) {
                    SMGExpressionEvaluator.SMGExplicitValueAndState forcedValueAndState = SMGTransferRelation.this.expressionEvaluator.forceExplicitValue(currentState, cfaEdge, sizeExpr);
                    currentState = forcedValueAndState.getSmgState();
                    valueAndState = this.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
                    value = valueAndState.getValue();
                    currentState = valueAndState.getSmgState();
                    if (value.isUnknown()) {
                        throw new UnrecognizedCCodeException("Not able to compute allocation size", cfaEdge);
                    }
                } else {
                    throw new UnrecognizedCCodeException("Not able to compute allocation size", cfaEdge);
                }
            }
            String allocation_label = "malloc_ID" + SMGValueFactory.getNewValue() + "_Line:" + functionCall.getFileLocation().getStartingLineNumber();
            SMGEdgePointsTo new_pointer = currentState.addNewHeapAllocation(value.getAsInt(), allocation_label);
            SMGTransferRelation.this.possibleMallocFail = true;
            return SMGEdgePointsToAndState.of(currentState, new_pointer);
        }

        public final SMGEdgePointsToAndState evaluateMemset(CFunctionCallExpression functionCall, SMGState pSMGState, CFAEdge cfaEdge) throws CPATransferException {
            CExpression countExpr;
            CExpression chExpr;
            CExpression bufferExpr;
            try {
                bufferExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Memset buffer argument not found.", cfaEdge, functionCall);
            }
            try {
                chExpr = functionCall.getParameterExpressions().get(1);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Memset ch argument not found.", cfaEdge, functionCall);
            }
            try {
                countExpr = functionCall.getParameterExpressions().get(2);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Memset count argument not found.", cfaEdge, functionCall);
            }
            SMGExpressionEvaluator.SMGAddressValueAndState bufferAddressAndState = this.evaluateAddress(pSMGState, cfaEdge, bufferExpr);
            SMGAddressValue bufferAddress = bufferAddressAndState.getValue();
            SMGState currentState = bufferAddressAndState.getSmgState();
            SMGExpressionEvaluator.SMGExplicitValueAndState countValueAndState = this.evaluateExplicitValue(currentState, cfaEdge, countExpr);
            SMGExplicitValue countValue = countValueAndState.getValue();
            currentState = bufferAddressAndState.getSmgState();
            if (bufferAddress.isUnknown() || countValue.isUnknown()) {
                return SMGEdgePointsToAndState.of(currentState, null);
            }
            SMGEdgePointsTo pointer = currentState.getPointerFromValue(bufferAddress.getAsInt());
            long count = countValue.getAsLong();
            SMGObject bufferMemory = bufferAddress.getObject();
            int offset = bufferAddress.getOffset().getAsInt();
            SMGExpressionEvaluator.SMGValueAndState chAndState = this.evaluateExpressionValue(currentState, cfaEdge, chExpr);
            SMGSymbolicValue ch = chAndState.getValue();
            currentState = chAndState.getSmgState();
            if (ch.isUnknown()) {
                throw new UnrecognizedCCodeException("Can't simulate memset", cfaEdge, functionCall);
            }
            SMGExpressionEvaluator expEvaluator = new SMGExpressionEvaluator(SMGTransferRelation.this.logger, SMGTransferRelation.this.machineModel);
            SMGExpressionEvaluator.SMGExplicitValueAndState expValueAndState = expEvaluator.evaluateExplicitValue(currentState, cfaEdge, chExpr);
            SMGExplicitValue expValue = expValueAndState.getValue();
            currentState = expValueAndState.getSmgState();
            if (ch.equals(SMGKnownSymValue.ZERO)) {
                currentState = SMGTransferRelation.this.writeValue(currentState, bufferMemory, offset, count, ch, cfaEdge);
            } else {
                int c = 0;
                while ((long)c < count) {
                    currentState = SMGTransferRelation.this.writeValue(currentState, bufferMemory, offset + c, CNumericTypes.SIGNED_CHAR, ch, cfaEdge);
                    ++c;
                }
                if (!expValue.isUnknown()) {
                    currentState.putExplicit((SMGKnownSymValue)ch, (SMGKnownExpValue)expValue);
                }
            }
            return SMGEdgePointsToAndState.of(currentState, pointer);
        }

        protected SMGExpressionEvaluator.SMGValueAndState evaluateExpressionValue(SMGState smgState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
            return SMGTransferRelation.this.expressionEvaluator.evaluateExpressionValue(smgState, cfaEdge, rValue);
        }

        protected SMGExpressionEvaluator.SMGExplicitValueAndState evaluateExplicitValue(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
            return SMGTransferRelation.this.expressionEvaluator.evaluateExplicitValue(pState, pCfaEdge, pRValue);
        }

        protected SMGExpressionEvaluator.SMGAddressValueAndState evaluateAddress(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRvalue) throws CPATransferException {
            return SMGTransferRelation.this.expressionEvaluator.evaluateAddress(pState, pCfaEdge, pRvalue);
        }

        public final SMGEdgePointsToAndState evaluateAlloc(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
            CRightHandSide sizeExpr;
            SMGState currentState = pState;
            try {
                sizeExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("alloca argument not found.", cfaEdge, functionCall);
            }
            SMGExpressionEvaluator.SMGExplicitValueAndState valueAndState = this.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
            SMGExplicitValue value = valueAndState.getValue();
            currentState = valueAndState.getSmgState();
            if (value.isUnknown()) {
                if (SMGTransferRelation.this.guessSizeOfUnknownMemorySize) {
                    SMGExpressionEvaluator.SMGExplicitValueAndState forcedValueAndState = SMGTransferRelation.this.expressionEvaluator.forceExplicitValue(currentState, cfaEdge, sizeExpr);
                    currentState = forcedValueAndState.getSmgState();
                    valueAndState = this.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
                    value = valueAndState.getValue();
                    currentState = valueAndState.getSmgState();
                    if (value.isUnknown()) {
                        throw new UnrecognizedCCodeException("Not able to compute allocation size", cfaEdge);
                    }
                } else {
                    throw new UnrecognizedCCodeException("Not able to compute allocation size", cfaEdge);
                }
            }
            String allocation_label = "alloc_ID" + SMGValueFactory.getNewValue();
            SMGEdgePointsTo new_pointer = currentState.addNewAllocAllocation(value.getAsInt(), allocation_label);
            SMGTransferRelation.this.possibleMallocFail = true;
            return SMGEdgePointsToAndState.of(currentState, new_pointer);
        }

        public final SMGEdgePointsToAndState evaluateCalloc(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
            CExpression sizeExpr;
            CExpression numExpr;
            try {
                numExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Calloc num argument not found.", cfaEdge, functionCall);
            }
            try {
                sizeExpr = functionCall.getParameterExpressions().get(1);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Calloc size argument not found.", cfaEdge, functionCall);
            }
            SMGExpressionEvaluator.SMGExplicitValueAndState numValueAndState = SMGTransferRelation.this.expressionEvaluator.evaluateExplicitValue(pState, cfaEdge, numExpr);
            SMGExplicitValue numValue = numValueAndState.getValue();
            SMGState currentState = numValueAndState.getSmgState();
            SMGExpressionEvaluator.SMGExplicitValueAndState sizeValueAndState = SMGTransferRelation.this.expressionEvaluator.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
            SMGExplicitValue sizeValue = sizeValueAndState.getValue();
            currentState = sizeValueAndState.getSmgState();
            if (numValue.isUnknown() || sizeValue.isUnknown()) {
                throw new UnrecognizedCCodeException("Not able to compute allocation size", cfaEdge);
            }
            int num = numValue.getAsInt();
            int size = sizeValue.getAsInt();
            String allocation_label = "Calloc_ID" + SMGValueFactory.getNewValue() + "_Line:" + functionCall.getFileLocation().getStartingLineNumber();
            SMGEdgePointsTo new_pointer = currentState.addNewHeapAllocation(num * size, allocation_label);
            currentState = SMGTransferRelation.this.writeValue(currentState, new_pointer.getObject(), 0, AnonymousTypes.createTypeWithLength(size), SMGKnownSymValue.ZERO, cfaEdge);
            SMGTransferRelation.this.possibleMallocFail = true;
            return SMGEdgePointsToAndState.of(currentState, new_pointer);
        }

        public final SMGState evaluateFree(CFunctionCallExpression pFunctionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
            CExpression pointerExp;
            try {
                pointerExp = pFunctionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Built-in free(): No parameter passed", cfaEdge, pFunctionCall);
            }
            SMGExpressionEvaluator.SMGAddressValueAndState addressAndState = SMGTransferRelation.this.expressionEvaluator.evaluateAddress(pState, cfaEdge, pointerExp);
            SMGAddressValue address = addressAndState.getValue();
            SMGState currentState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                return currentState.setInvalidFree();
            }
            SMGEdgePointsTo pointer = currentState.isPointer(address.getAsInt()) ? currentState.getPointerFromValue(address.getAsInt()) : new SMGEdgePointsTo(address.getAsInt(), address.getObject(), address.getOffset().getAsInt());
            if (address.getAsInt() == 0) {
                SMGTransferRelation.this.logger.log(Level.WARNING, new Object[]{pFunctionCall.getFileLocation() + ":", "The argument of a free invocation:", cfaEdge.getRawStatement(), "is 0"});
            } else {
                currentState = currentState.free(pointer.getValue(), pointer.getOffset(), pointer.getObject());
            }
            return currentState;
        }

        public final boolean isABuiltIn(String functionName) {
            return this.BUILTINS.contains(functionName) || this.isNondetBuiltin(functionName);
        }

        private boolean isNondetBuiltin(String pFunctionName) {
            return pFunctionName.startsWith(NONDET_PREFIX) || pFunctionName.equals("nondet_int");
        }
    }
}

