/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class SMGIsLessOrEqual {
    private SMGIsLessOrEqual() {
    }

    public static boolean isLessOrEqual(CLangSMG pSMG1, CLangSMG pSMG2) {
        if (pSMG1 == pSMG2) {
            return true;
        }
        if (pSMG1.getHeapObjects().size() != pSMG2.getHeapObjects().size()) {
            return false;
        }
        if (pSMG1.getStackFrames().size() != pSMG2.getStackFrames().size()) {
            return false;
        }
        Map<String, SMGRegion> globals_in_smg1 = pSMG1.getGlobalObjects();
        Map<String, SMGRegion> globals_in_smg2 = pSMG2.getGlobalObjects();
        if (globals_in_smg1.size() > globals_in_smg2.size()) {
            return false;
        }
        for (Map.Entry<String, SMGRegion> entry : globals_in_smg1.entrySet()) {
            SMGObject globalInSMG1 = entry.getValue();
            String globalVar = entry.getKey();
            if (!globals_in_smg2.containsKey(globalVar)) {
                return false;
            }
            SMGObject globalInSMG2 = globals_in_smg2.get(entry.getKey());
            if (SMGIsLessOrEqual.isLessOrEqualFields(pSMG1, pSMG2, globalInSMG1, globalInSMG2)) continue;
            return false;
        }
        ArrayDeque<CLangStackFrame> stack_in_smg1 = pSMG1.getStackFrames();
        ArrayDeque<CLangStackFrame> stack_in_smg2 = pSMG2.getStackFrames();
        Iterator<CLangStackFrame> smg1stackIterator = stack_in_smg1.descendingIterator();
        Iterator<CLangStackFrame> smg2stackIterator = stack_in_smg2.descendingIterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            CLangStackFrame frameInSMG1 = smg1stackIterator.next();
            CLangStackFrame frameInSMG2 = smg2stackIterator.next();
            if (frameInSMG1.getAllObjects().size() > frameInSMG2.getAllObjects().size()) {
                return false;
            }
            HashSet<String> localVars = new HashSet<String>();
            localVars.addAll(frameInSMG1.getVariables().keySet());
            for (String localVar : localVars) {
                SMGRegion localInSMG2;
                if (!frameInSMG2.containsVariable(localVar)) {
                    return false;
                }
                SMGRegion localInSMG1 = frameInSMG1.getVariable(localVar);
                if (SMGIsLessOrEqual.isLessOrEqualFields(pSMG1, pSMG2, localInSMG1, localInSMG2 = frameInSMG2.getVariable(localVar))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isLessOrEqualFields(CLangSMG pSMG1, CLangSMG pSMG2, SMGObject pSMGObject1, SMGObject pSMGObject2) {
        if (pSMGObject1.getSize() != pSMGObject2.getSize()) {
            throw new IllegalArgumentException("SMGJoinFields object arguments need to have identical size");
        }
        if (!pSMG1.getObjects().contains(pSMGObject1) || !pSMG2.getObjects().contains(pSMGObject2)) {
            throw new IllegalArgumentException("SMGJoinFields object arguments need to be included in parameter SMGs");
        }
        SMGEdgeHasValueFilter filterForSMG1 = SMGEdgeHasValueFilter.objectFilter(pSMGObject1);
        SMGEdgeHasValueFilter filterForSMG2 = SMGEdgeHasValueFilter.objectFilter(pSMGObject2);
        Set<SMGEdgeHasValue> HVE1 = filterForSMG1.filterSet(pSMG1.getHVEdges());
        Set<SMGEdgeHasValue> HVE2 = filterForSMG2.filterSet(pSMG2.getHVEdges());
        for (SMGEdgeHasValue edge1 : HVE1) {
            Integer offset2;
            filterForSMG2.filterAtOffset(edge1.getOffset()).filterByType(edge1.getType()).filterHavingValue(edge1.getValue());
            if (!filterForSMG2.edgeContainedIn(HVE2)) {
                return false;
            }
            Integer value = edge1.getValue();
            if (!pSMG1.isPointer(value)) continue;
            if (!pSMG2.isPointer(value)) {
                return false;
            }
            SMGEdgePointsTo ptE1 = pSMG1.getPointer(value);
            SMGEdgePointsTo ptE2 = pSMG2.getPointer(value);
            String label1 = ptE1.getObject().getLabel();
            String label2 = ptE2.getObject().getLabel();
            Integer offset1 = ptE1.getOffset();
            if (offset1.equals(offset2 = Integer.valueOf(ptE2.getOffset())) && label1.equals(label2)) continue;
            return false;
        }
        return true;
    }
}

