/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smg.SMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinFields;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class SMGJoinFieldsTest {
    private static final CType mockType4b = AnonymousTypes.createTypeWithLength(4L);
    private static final CType mockType8b = AnonymousTypes.createTypeWithLength(8L);
    private SMG smg1;
    private SMG smg2;
    private final Integer value1 = SMGValueFactory.getNewValue();
    private final Integer value2 = SMGValueFactory.getNewValue();

    @Before
    public void setUp() {
        this.smg1 = new SMG(MachineModel.LINUX64);
        this.smg2 = new SMG(MachineModel.LINUX64);
    }

    @Test
    public void getHVSetWithoutNullValuesOnObjectTest() {
        SMGRegion obj1 = new SMGRegion(8, "1");
        SMGRegion obj2 = new SMGRegion(8, "1");
        SMGEdgeHasValue obj1hv1at0 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, (int)this.value1);
        SMGEdgeHasValue obj1hv0at4 = new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj1, this.smg1.getNullValue());
        SMGEdgeHasValue obj2hv2at0 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj2, (int)this.value2);
        SMGEdgeHasValue obj2hv0at4 = new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj2, this.smg1.getNullValue());
        this.smg1.addObject(obj1);
        this.smg1.addObject(obj2);
        this.smg1.addValue(this.value1);
        this.smg1.addValue(this.value2);
        this.smg1.addHasValueEdge(obj1hv0at4);
        this.smg1.addHasValueEdge(obj1hv1at0);
        this.smg1.addHasValueEdge(obj2hv0at4);
        this.smg1.addHasValueEdge(obj2hv2at0);
        Set<SMGEdgeHasValue> hvSet = SMGJoinFields.getHVSetWithoutNullValuesOnObject(this.smg1, obj1);
        Assert.assertTrue((boolean)hvSet.contains(obj1hv1at0));
        Assert.assertTrue((boolean)hvSet.contains(obj2hv2at0));
        Assert.assertTrue((boolean)hvSet.contains(obj2hv0at4));
        Assert.assertEquals((long)3L, (long)hvSet.size());
    }

    @Test
    public void getHVSetOfMissingNullValuesTest() {
        SMGRegion obj1 = new SMGRegion(8, "1");
        SMGRegion obj2 = new SMGRegion(8, "2");
        this.smg1.addObject(obj1);
        this.smg2.addObject(obj2);
        this.smg2.addValue(this.value2);
        SMGEdgeHasValue nullifyObj1 = new SMGEdgeHasValue(8, 0, (SMGObject)obj1, this.smg1.getNullValue());
        SMGEdgeHasValue nonPointer = new SMGEdgeHasValue(mockType4b, 2, (SMGObject)obj2, (int)this.value2);
        this.smg1.addHasValueEdge(nullifyObj1);
        this.smg2.addHasValueEdge(nonPointer);
        Set<SMGEdgeHasValue> hvSet = SMGJoinFields.getHVSetOfMissingNullValues(this.smg1, this.smg2, obj1, obj2);
        Assert.assertEquals((long)0L, (long)hvSet.size());
        this.smg2.addPointsToEdge(new SMGEdgePointsTo(this.value2, obj2, 0));
        hvSet = SMGJoinFields.getHVSetOfMissingNullValues(this.smg1, this.smg2, obj1, obj2);
        Assert.assertEquals((long)1L, (long)hvSet.size());
        SMGEdgeHasValue newHv = (SMGEdgeHasValue)Iterables.getOnlyElement(hvSet);
        Assert.assertEquals((long)this.smg1.getNullValue(), (long)newHv.getValue());
        Assert.assertSame((Object)obj1, (Object)newHv.getObject());
        Assert.assertEquals((long)4L, (long)newHv.getSizeInBytes(MachineModel.LINUX64));
        Assert.assertEquals((long)2L, (long)newHv.getOffset());
        Assert.assertTrue((boolean)newHv.isCompatibleField(nonPointer, MachineModel.LINUX64));
    }

    @Test
    public void getHVSetOfCommonNullValuesTest() {
        SMGRegion obj1 = new SMGRegion(22, "1");
        SMGEdgeHasValue smg1at4 = new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj1, this.smg1.getNullValue());
        SMGEdgeHasValue smg2at8 = new SMGEdgeHasValue(mockType4b, 8, (SMGObject)obj1, this.smg2.getNullValue());
        SMGEdgeHasValue smg1at14 = new SMGEdgeHasValue(mockType4b, 14, (SMGObject)obj1, this.smg1.getNullValue());
        SMGEdgeHasValue smg2at12 = new SMGEdgeHasValue(mockType4b, 12, (SMGObject)obj1, this.smg2.getNullValue());
        SMGEdgeHasValue smg1at18 = new SMGEdgeHasValue(mockType4b, 18, (SMGObject)obj1, this.smg1.getNullValue());
        SMGEdgeHasValue smg2at18 = new SMGEdgeHasValue(mockType4b, 18, (SMGObject)obj1, this.smg2.getNullValue());
        this.smg1.addHasValueEdge(smg1at18);
        this.smg1.addHasValueEdge(smg1at14);
        this.smg1.addHasValueEdge(smg1at4);
        this.smg2.addHasValueEdge(smg2at18);
        this.smg2.addHasValueEdge(smg2at12);
        this.smg2.addHasValueEdge(smg2at8);
        Set<SMGEdgeHasValue> hvSet = SMGJoinFields.getHVSetOfCommonNullValues(this.smg1, this.smg2, obj1, obj1);
        Assert.assertEquals((long)2L, (long)hvSet.size());
        for (SMGEdgeHasValue hv : hvSet) {
            Assert.assertEquals((long)hv.getValue(), (long)this.smg1.getNullValue());
            Assert.assertSame((Object)hv.getObject(), (Object)obj1);
            Assert.assertTrue((hv.getOffset() == 14 || hv.getOffset() == 18 ? 1 : 0) != 0);
            if (hv.getOffset() == 14) {
                Assert.assertTrue((hv.getSizeInBytes(MachineModel.LINUX64) == 2 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((hv.getSizeInBytes(MachineModel.LINUX64) == 4 ? 1 : 0) != 0);
        }
    }

    @Test
    public void getCompatibleHVEdgeSetTest() {
        SMGRegion obj = new SMGRegion(32, "Object");
        SMGRegion differentObject = new SMGRegion(16, "Different object");
        this.smg1.addObject(obj);
        this.smg2.addObject(obj);
        this.smg1.addObject(differentObject);
        this.smg2.addValue(this.value1);
        SMGEdgeHasValue hv0for4at0in1 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj, this.smg1.getNullValue());
        SMGEdgeHasValue hv0for4at0in2 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj, this.smg2.getNullValue());
        SMGEdgeHasValue hv0for4at5in1 = new SMGEdgeHasValue(mockType4b, 5, (SMGObject)obj, this.smg1.getNullValue());
        SMGEdgeHasValue hv0for4at7in2 = new SMGEdgeHasValue(mockType4b, 7, (SMGObject)obj, this.smg2.getNullValue());
        SMGEdgeHasValue hv0for4at12in1 = new SMGEdgeHasValue(mockType4b, 12, (SMGObject)obj, this.smg1.getNullValue());
        SMGEdgeHasValue hv0for4at16in2 = new SMGEdgeHasValue(mockType4b, 16, (SMGObject)obj, this.smg2.getNullValue());
        SMGEdgeHasValue hv0for4at20in1 = new SMGEdgeHasValue(mockType4b, 20, (SMGObject)obj, this.smg1.getNullValue());
        SMGEdgeHasValue hv666for4at20in2 = new SMGEdgeHasValue(mockType4b, 20, (SMGObject)obj, (int)this.value1);
        SMGEdgeHasValue hv666for4at28in2 = new SMGEdgeHasValue(mockType4b, 28, (SMGObject)obj, (int)this.value1);
        SMGEdgeHasValue diffObjectNullValue = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)differentObject, this.smg1.getNullValue());
        this.smg1.addHasValueEdge(hv0for4at0in1);
        this.smg1.addHasValueEdge(hv0for4at5in1);
        this.smg1.addHasValueEdge(hv0for4at12in1);
        this.smg1.addHasValueEdge(hv0for4at20in1);
        this.smg1.addHasValueEdge(diffObjectNullValue);
        this.smg2.addHasValueEdge(hv0for4at0in2);
        this.smg2.addHasValueEdge(hv0for4at7in2);
        this.smg2.addHasValueEdge(hv0for4at16in2);
        this.smg2.addHasValueEdge(hv666for4at20in2);
        this.smg2.addPointsToEdge(new SMGEdgePointsTo(this.value1, obj, 20));
        this.smg2.addHasValueEdge(hv666for4at28in2);
        Set<SMGEdgeHasValue> compSet1 = SMGJoinFields.getCompatibleHVEdgeSet(this.smg1, this.smg2, obj, obj);
        Assert.assertEquals((long)4L, (long)compSet1.size());
        Set<SMGEdgeHasValue> compSet2 = SMGJoinFields.getCompatibleHVEdgeSet(this.smg2, this.smg1, obj, obj);
        Assert.assertEquals((long)4L, (long)compSet2.size());
    }

    @Test
    public void mergeNonNullHVEdgesTest() {
        HashSet<Integer> values = new HashSet<Integer>();
        values.add(this.value1);
        values.add(this.value2);
        SMGRegion object = new SMGRegion(16, "Object");
        SMGEdgeHasValue smg1_4bFrom0ToV1 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)object, (int)this.value1);
        SMGEdgeHasValue smg1_4bFrom2ToV2 = new SMGEdgeHasValue(mockType4b, 2, (SMGObject)object, (int)this.value2);
        SMGEdgeHasValue smg1_4bFrom4ToNull = new SMGEdgeHasValue(mockType4b, 4, (SMGObject)object, this.smg1.getNullValue());
        this.smg1.addObject(object);
        this.smg1.addValue(this.value1);
        this.smg1.addValue(this.value2);
        this.smg1.addHasValueEdge(smg1_4bFrom4ToNull);
        this.smg1.addHasValueEdge(smg1_4bFrom2ToV2);
        this.smg1.addHasValueEdge(smg1_4bFrom0ToV1);
        this.smg2.addObject(object);
        Set<SMGEdgeHasValue> hvSet = SMGJoinFields.mergeNonNullHasValueEdges(this.smg1, this.smg2, object, object);
        Assert.assertEquals((long)2L, (long)hvSet.size());
        boolean seenZero = false;
        boolean seenTwo = false;
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(object);
        for (SMGEdgeHasValue edge : filter.filterSet(hvSet)) {
            if (edge.getOffset() == 0) {
                seenZero = true;
            } else if (edge.getOffset() == 2) {
                seenTwo = true;
            }
            Assert.assertTrue((edge.getOffset() == 0 || edge.getOffset() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mockType4b.equals(edge.getType()));
            Assert.assertFalse((boolean)values.contains(edge.getValue()));
            values.add(edge.getValue());
        }
        Assert.assertTrue((boolean)seenZero);
        Assert.assertTrue((boolean)seenTwo);
        this.smg2.addValue(this.value1);
        this.smg2.addHasValueEdge(smg1_4bFrom0ToV1);
        hvSet = SMGJoinFields.mergeNonNullHasValueEdges(this.smg1, this.smg2, object, object);
        Assert.assertEquals((long)1L, (long)hvSet.size());
    }

    @Test
    public void mergeNonNullAplliedTest() {
        SMGRegion obj1 = new SMGRegion(8, "Object 1");
        SMGRegion obj2 = new SMGRegion(8, "Object 2");
        this.smg1.addObject(obj1);
        this.smg2.addObject(obj2);
        Integer value1 = SMGValueFactory.getNewValue();
        this.smg1.addValue(value1);
        this.smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, (int)value1));
        SMGJoinFields jf = new SMGJoinFields(new SMG(this.smg1), new SMG(this.smg2), obj1, obj2);
        SMG resultSMG = jf.getSMG2();
        Set<SMGEdgeHasValue> edges = resultSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2));
        Assert.assertTrue((edges.size() > 0 ? 1 : 0) != 0);
        jf = new SMGJoinFields(new SMG(this.smg2), new SMG(this.smg1), obj2, obj1);
        resultSMG = jf.getSMG1();
        edges = resultSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2));
        Assert.assertTrue((edges.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void joinFieldsRelaxStatusTest() {
        SMGRegion object = new SMGRegion(8, "Object");
        this.smg1.addObject(object);
        SMG smg04 = new SMG(this.smg1);
        SMG smg48 = new SMG(this.smg1);
        SMG smg26 = new SMG(this.smg1);
        SMG smg08 = new SMG(this.smg1);
        smg04.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)object, smg04.getNullValue()));
        smg48.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 4, (SMGObject)object, smg48.getNullValue()));
        smg26.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 2, (SMGObject)object, smg26.getNullValue()));
        smg08.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)object, smg08.getNullValue()));
        smg08.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 4, (SMGObject)object, smg08.getNullValue()));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg04, smg48, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg04, smg26, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg04, smg08, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg48, smg04, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg48, smg26, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg48, smg08, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg26, smg04, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg26, smg48, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg26, smg08, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg08, smg04, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg08, smg48, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinFields.joinFieldsRelaxStatus(smg08, smg26, SMGJoinStatus.EQUAL, SMGJoinStatus.INCOMPARABLE, object)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void differentSizeCheckTest() {
        SMGRegion obj1 = new SMGRegion(8, "Object 1");
        SMGRegion obj2 = new SMGRegion(12, "Object 2");
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX64);
        smg1.addObject(obj1);
        smg2.addObject(obj2);
        SMGJoinFields jf = new SMGJoinFields(smg1, smg2, obj1, obj2);
        jf.getStatus();
    }

    @Test
    public void consistencyCheckTest() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        Integer value1 = SMGValueFactory.getNewValue();
        Integer value2 = SMGValueFactory.getNewValue();
        smg1.addObject(obj1);
        smg2.addObject(obj2);
        smg1.addValue(value1);
        smg2.addValue(value2);
        SMGEdgeHasValue hvAt0in1 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, (int)value1);
        SMGEdgeHasValue hvAt0in2 = new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj2, (int)value2);
        smg1.addHasValueEdge(hvAt0in1);
        smg2.addHasValueEdge(hvAt0in2);
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj1, smg1.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj2, smg2.getNullValue()));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 8, (SMGObject)obj1, smg1.getNullValue()));
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 12, (SMGObject)obj1, smg1.getNullValue()));
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType8b, 8, (SMGObject)obj1, smg1.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 8, (SMGObject)obj2, smg2.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 12, (SMGObject)obj2, smg2.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType8b, 8, (SMGObject)obj2, smg2.getNullValue()));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 16, (SMGObject)obj1, (int)value1));
        smg1.addPointsToEdge(new SMGEdgePointsTo(value1, obj1, 0));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 16, (SMGObject)obj2, smg2.getNullValue()));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest1() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        Integer value1 = SMGValueFactory.getNewValue();
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, (int)value1));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest2() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, smg1.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType8b, 0, (SMGObject)obj2, smg2.getNullValue()));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest3() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, smg1.getNullValue()));
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj1, smg1.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType8b, 0, (SMGObject)obj2, smg2.getNullValue()));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest4() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, smg1.getNullValue()));
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 4, (SMGObject)obj1, smg1.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType8b, 0, (SMGObject)obj2, smg2.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 8, (SMGObject)obj2, smg2.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 12, (SMGObject)obj2, smg2.getNullValue()));
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType8b, 8, (SMGObject)obj1, smg1.getNullValue()));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest5() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        Integer value2 = SMGValueFactory.getNewValue();
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, smg1.getNullValue()));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj2, (int)value2));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test
    public void consistencyCheckPositiveTest1() throws SMGInconsistentException {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        SMGRegion obj3 = new SMGRegion(32, "Object 3");
        Integer value1 = SMGValueFactory.getNewValue();
        Integer value2 = SMGValueFactory.getNewValue();
        smg1.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj1, (int)value1));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj2, (int)value2));
        smg2.addHasValueEdge(new SMGEdgeHasValue(mockType4b, 0, (SMGObject)obj3, (int)value2));
        SMGJoinFields.checkResultConsistency(smg1, smg2, obj1, obj2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectTest1() {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        smg2.addObject(obj2);
        SMGJoinFields jf = new SMGJoinFields(smg1, smg2, obj1, obj2);
        jf.getStatus();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectTest2() {
        SMG smg1 = new SMG(MachineModel.LINUX64);
        SMG smg2 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32, "Object 1");
        SMGRegion obj2 = new SMGRegion(32, "Object 2");
        smg1.addObject(obj1);
        SMGJoinFields jf = new SMGJoinFields(smg1, smg2, obj1, obj2);
        jf.getStatus();
    }
}

