/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import java.util.Collection;
import org.sosy_lab.cpachecker.cpa.smg.SMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;

final class SMGJoinMapTargetAddress {
    private SMG smg;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private Integer value;

    public SMGJoinMapTargetAddress(SMG pSMG1, SMG pSMG2, SMG destSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, Integer pAddress1, Integer pAddress2) {
        this.smg = destSMG;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        SMGObject target = destSMG.getNullObject();
        SMGEdgePointsTo pt = pSMG1.getPointer(pAddress1);
        if (pt.getObject().notNull()) {
            target = pMapping1.get(pt.getObject());
        }
        Collection<SMGEdgePointsTo> edges = this.smg.getPTEdges().values();
        for (SMGEdgePointsTo edge : edges) {
            if (edge.getObject() != target || edge.getOffset() != pt.getOffset()) continue;
            this.value = edge.getValue();
            return;
        }
        this.value = SMGValueFactory.getNewValue();
        this.smg.addValue(this.value);
        this.smg.addPointsToEdge(new SMGEdgePointsTo(this.value, target, pt.getOffset()));
        this.mapping1.map(pAddress1, this.value);
        this.mapping2.map(pAddress2, this.value);
    }

    public SMG getSMG() {
        return this.smg;
    }

    public SMGNodeMapping getMapping1() {
        return this.mapping1;
    }

    public SMGNodeMapping getMapping2() {
        return this.mapping2;
    }

    public Integer getValue() {
        return this.value;
    }
}

