/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoin;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public class SMGJoinTest {
    private static final CFunctionType functionType = CFunctionType.functionTypeWithReturnType(CNumericTypes.UNSIGNED_LONG_INT);
    private static final CFunctionDeclaration functionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "foo", (List<CParameterDeclaration>)ImmutableList.of());
    private CLangSMG smg1;
    private CLangSMG smg2;

    @Before
    public void setUp() {
        this.smg1 = new CLangSMG(MachineModel.LINUX64);
        this.smg2 = new CLangSMG(MachineModel.LINUX64);
    }

    private void addGlobalWithoutValueToBoth(String pVarName) {
        SMGRegion global1 = new SMGRegion(8, pVarName);
        SMGRegion global2 = new SMGRegion(8, pVarName);
        this.smg1.addGlobalObject(global1);
        this.smg2.addGlobalObject(global2);
    }

    private void addLocalWithoutValueToBoth(String pVarName) {
        SMGRegion local1 = new SMGRegion(8, pVarName);
        SMGRegion local2 = new SMGRegion(8, pVarName);
        this.smg1.addStackObject(local1);
        this.smg2.addStackObject(local2);
    }

    private void addGlobalWithValueToBoth(String pVarName) {
        SMGRegion global1 = new SMGRegion(8, pVarName);
        SMGRegion global2 = new SMGRegion(8, pVarName);
        Integer value1 = SMGValueFactory.getNewValue();
        Integer value2 = SMGValueFactory.getNewValue();
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(4, 0, (SMGObject)global1, (int)value1);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(4, 0, (SMGObject)global2, (int)value2);
        this.smg1.addGlobalObject(global1);
        this.smg2.addGlobalObject(global2);
        this.smg1.addValue(value1);
        this.smg2.addValue(value2);
        this.smg1.addHasValueEdge(hv1);
        this.smg2.addHasValueEdge(hv2);
    }

    private void addLocalWithValueToBoth(String pVarName) {
        SMGRegion local1 = new SMGRegion(8, pVarName);
        SMGRegion local2 = new SMGRegion(8, pVarName);
        Integer value1 = SMGValueFactory.getNewValue();
        Integer value2 = SMGValueFactory.getNewValue();
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(4, 0, (SMGObject)local1, (int)value1);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(4, 0, (SMGObject)local2, (int)value2);
        this.smg1.addStackObject(local1);
        this.smg2.addStackObject(local2);
        this.smg1.addValue(value1);
        this.smg2.addValue(value2);
        this.smg1.addHasValueEdge(hv1);
        this.smg2.addHasValueEdge(hv2);
    }

    private void assertObjectCounts(CLangSMG pSMG, int pGlobals, int pHeap, int pFrames) {
        Assert.assertEquals((long)pSMG.getGlobalObjects().size(), (long)pGlobals);
        Assert.assertEquals((long)pSMG.getHeapObjects().size(), (long)pHeap);
        Assert.assertEquals((long)pSMG.getStackFrames().size(), (long)pFrames);
    }

    @Test
    public void simpleGlobalVarJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.addGlobalWithoutValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2);
        Assert.assertTrue((boolean)join.isDefined());
        Assert.assertEquals((Object)((Object)join.getStatus()), (Object)((Object)SMGJoinStatus.EQUAL));
        CLangSMG resultSMG = join.getJointSMG();
        Assert.assertTrue((boolean)resultSMG.getGlobalObjects().containsKey(varName));
        this.assertObjectCounts(resultSMG, 1, 1, 0);
    }

    @Test
    public void simpleLocalVarJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.smg1.addStackFrame(functionDeclaration);
        this.smg2.addStackFrame(functionDeclaration);
        this.addLocalWithoutValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2);
        Assert.assertTrue((boolean)join.isDefined());
        Assert.assertEquals((Object)((Object)join.getStatus()), (Object)((Object)SMGJoinStatus.EQUAL));
        CLangSMG resultSMG = join.getJointSMG();
        Assert.assertTrue((boolean)resultSMG.getStackFrames().getFirst().containsVariable(varName));
        this.assertObjectCounts(resultSMG, 0, 1, 1);
    }

    @Test
    public void globalVarWithValueJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.addGlobalWithValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2);
        Assert.assertTrue((boolean)join.isDefined());
        Assert.assertEquals((Object)((Object)join.getStatus()), (Object)((Object)SMGJoinStatus.EQUAL));
        CLangSMG resultSMG = join.getJointSMG();
        Assert.assertTrue((boolean)resultSMG.getGlobalObjects().containsKey(varName));
        this.assertObjectCounts(resultSMG, 1, 1, 0);
        SMGObject global = resultSMG.getGlobalObjects().get(varName);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(global).filterAtOffset(0);
        Set<SMGEdgeHasValue> edges = resultSMG.getHVEdges(filter);
        SMGEdgeHasValue edge = (SMGEdgeHasValue)Iterables.getOnlyElement(edges);
        Assert.assertTrue((boolean)resultSMG.getValues().contains(edge.getValue()));
    }

    @Test
    public void localVarWithValueJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.smg1.addStackFrame(functionDeclaration);
        this.smg2.addStackFrame(functionDeclaration);
        this.addLocalWithValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2);
        Assert.assertTrue((boolean)join.isDefined());
        Assert.assertEquals((Object)((Object)join.getStatus()), (Object)((Object)SMGJoinStatus.EQUAL));
        CLangSMG resultSMG = join.getJointSMG();
        Assert.assertTrue((boolean)resultSMG.getStackFrames().getFirst().containsVariable(varName));
        this.assertObjectCounts(resultSMG, 0, 1, 1);
        SMGRegion global = resultSMG.getStackFrames().getFirst().getVariable(varName);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(global).filterAtOffset(0);
        Set<SMGEdgeHasValue> edges = resultSMG.getHVEdges(filter);
        SMGEdgeHasValue edge = (SMGEdgeHasValue)Iterables.getOnlyElement(edges);
        Assert.assertTrue((boolean)resultSMG.getValues().contains(edge.getValue()));
    }

    private void joinUpdateUnit(SMGJoinStatus firstOperand, SMGJoinStatus forLe, SMGJoinStatus forRe) {
        Assert.assertEquals((Object)((Object)firstOperand), (Object)((Object)SMGJoinStatus.updateStatus(firstOperand, SMGJoinStatus.EQUAL)));
        Assert.assertEquals((Object)((Object)forLe), (Object)((Object)SMGJoinStatus.updateStatus(firstOperand, SMGJoinStatus.LEFT_ENTAIL)));
        Assert.assertEquals((Object)((Object)forRe), (Object)((Object)SMGJoinStatus.updateStatus(firstOperand, SMGJoinStatus.RIGHT_ENTAIL)));
        Assert.assertEquals((Object)((Object)SMGJoinStatus.INCOMPARABLE), (Object)((Object)SMGJoinStatus.updateStatus(firstOperand, SMGJoinStatus.INCOMPARABLE)));
    }

    @Test
    public void joinUpdateTest() {
        this.joinUpdateUnit(SMGJoinStatus.EQUAL, SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.RIGHT_ENTAIL);
        this.joinUpdateUnit(SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.INCOMPARABLE);
        this.joinUpdateUnit(SMGJoinStatus.RIGHT_ENTAIL, SMGJoinStatus.INCOMPARABLE, SMGJoinStatus.RIGHT_ENTAIL);
        this.joinUpdateUnit(SMGJoinStatus.INCOMPARABLE, SMGJoinStatus.INCOMPARABLE, SMGJoinStatus.INCOMPARABLE);
    }
}

