/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import org.sosy_lab.cpachecker.cpa.smg.SMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinTargetObjects;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

final class SMGJoinValues {
    private SMGJoinStatus status;
    private SMG inputSMG1;
    private SMG inputSMG2;
    private SMG destSMG;
    private Integer value;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private boolean defined = false;

    private static boolean joinValuesIdentical(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        if (pV1 == pV2) {
            pJV.value = pV1;
            pJV.defined = true;
        }
        return pV1.equals(pV2);
    }

    private static boolean joinValuesAlreadyJoined(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        if (pJV.mapping1.containsKey(pV1) && pJV.mapping2.containsKey(pV2) && pJV.mapping1.get(pV1).equals(pJV.mapping2.get(pV2))) {
            pJV.value = pJV.mapping1.get(pV1);
            pJV.defined = true;
            return true;
        }
        return false;
    }

    private static boolean joinValuesNonPointers(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        if (!pJV.inputSMG1.isPointer(pV1) && !pJV.inputSMG2.isPointer(pV2)) {
            if (pJV.mapping1.containsKey(pV1) || pJV.mapping2.containsKey(pV2)) {
                return true;
            }
            Integer newValue = SMGValueFactory.getNewValue();
            pJV.destSMG.addValue(newValue);
            pJV.mapping1.map(pV1, newValue);
            pJV.mapping2.map(pV2, newValue);
            pJV.defined = true;
            pJV.value = newValue;
            return true;
        }
        return false;
    }

    private static boolean joinValuesMixedPointers(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        return !pJV.inputSMG1.isPointer(pV1) || !pJV.inputSMG2.isPointer(pV2);
    }

    private static boolean joinValuesPointers(SMGJoinValues pJV, Integer pV1, Integer pV2) throws SMGInconsistentException {
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(pJV.status, pJV.inputSMG1, pJV.inputSMG2, pJV.destSMG, pJV.mapping1, pJV.mapping2, pV1, pV2);
        if (jto.isDefined()) {
            pJV.status = jto.getStatus();
            pJV.inputSMG1 = jto.getInputSMG1();
            pJV.inputSMG2 = jto.getInputSMG2();
            pJV.destSMG = jto.getDestinationSMG();
            pJV.mapping1 = jto.getMapping1();
            pJV.mapping2 = jto.getMapping2();
            pJV.value = jto.getValue();
            pJV.defined = true;
            return true;
        }
        if (jto.isRecoverable()) {
            return false;
        }
        pJV.defined = false;
        return true;
    }

    public SMGJoinValues(SMGJoinStatus pStatus, SMG pSMG1, SMG pSMG2, SMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, Integer pValue1, Integer pValue2) throws SMGInconsistentException {
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        this.status = pStatus;
        this.inputSMG1 = pSMG1;
        this.inputSMG2 = pSMG2;
        this.destSMG = pDestSMG;
        if (SMGJoinValues.joinValuesAlreadyJoined(this, pValue1, pValue2)) {
            return;
        }
        if (SMGJoinValues.joinValuesNonPointers(this, pValue1, pValue2)) {
            return;
        }
        if (SMGJoinValues.joinValuesMixedPointers(this, pValue1, pValue2)) {
            return;
        }
        if (SMGJoinValues.joinValuesPointers(this, pValue1, pValue2)) {
            return;
        }
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public SMG getInputSMG1() {
        return this.inputSMG1;
    }

    public SMG getInputSMG2() {
        return this.inputSMG2;
    }

    public SMG getDestinationSMG() {
        return this.destSMG;
    }

    public Integer getValue() {
        return this.value;
    }

    public SMGNodeMapping getMapping1() {
        return this.mapping1;
    }

    public SMGNodeMapping getMapping2() {
        return this.mapping2;
    }

    public boolean isDefined() {
        return this.defined;
    }
}

