/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;

class SMGNodeMapping {
    private final Map<SMGObject, SMGObject> object_map = new HashMap<SMGObject, SMGObject>();
    private final Map<Integer, Integer> value_map = new HashMap<Integer, Integer>();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.object_map == null ? 0 : this.object_map.hashCode());
        result = 31 * result + (this.value_map == null ? 0 : this.value_map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SMGNodeMapping other = (SMGNodeMapping)obj;
        if (this.object_map == null ? other.object_map != null : !this.object_map.equals(other.object_map)) {
            return false;
        }
        return !(this.value_map == null ? other.value_map != null : !this.value_map.equals(other.value_map));
    }

    public SMGNodeMapping() {
    }

    public SMGNodeMapping(SMGNodeMapping origin) {
        this.object_map.putAll(origin.object_map);
        this.value_map.putAll(origin.value_map);
    }

    public Integer get(Integer i) {
        return this.value_map.get(i);
    }

    public SMGObject get(SMGObject o) {
        return this.object_map.get(o);
    }

    public void map(SMGObject key, SMGObject value) {
        this.object_map.put(key, value);
    }

    public void map(Integer key, Integer value) {
        this.value_map.put(key, value);
    }

    public boolean containsKey(Integer key) {
        return this.value_map.containsKey(key);
    }

    public boolean containsKey(SMGObject key) {
        return this.object_map.containsKey(key);
    }

    public boolean containsValue(SMGObject value) {
        return this.object_map.containsValue(value);
    }
}

