/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.objects.sll;

import org.sosy_lab.cpachecker.cpa.smg.objects.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObjectVisitor;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;

public final class SMGSingleLinkedList
extends SMGObject
implements SMGAbstractObject {
    private int length;
    private int bindingOffset;

    public SMGSingleLinkedList(SMGRegion pPrototype, int pOffset, int pLength) {
        super(pPrototype.getSize(), "SLL");
        this.bindingOffset = pOffset;
        this.length = pLength;
    }

    public SMGSingleLinkedList(SMGSingleLinkedList pOriginal) {
        super(pOriginal);
        this.bindingOffset = pOriginal.bindingOffset;
        this.length = pOriginal.length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    public int getOffset() {
        return this.bindingOffset;
    }

    public String toString() {
        return "SLL(size=" + this.getSize() + ", bindingOffset=" + this.bindingOffset + ", len=" + this.length + ")";
    }

    @Override
    public void accept(SMGObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean matchGenericShape(SMGAbstractObject pOther) {
        return pOther instanceof SMGSingleLinkedList;
    }

    @Override
    public boolean matchSpecificShape(SMGAbstractObject pOther) {
        if (!this.matchGenericShape(pOther)) {
            return false;
        }
        return this.bindingOffset == ((SMGSingleLinkedList)pOther).bindingOffset;
    }

    @Override
    public boolean isMoreGeneral(SMGObject pOther) {
        super.isMoreGeneral(pOther);
        if (!pOther.isAbstract()) {
            return true;
        }
        if (!this.matchSpecificShape((SMGAbstractObject)((Object)pOther))) {
            throw new IllegalArgumentException("isMoreGeneral called on incompatible abstract objects");
        }
        return this.length < ((SMGSingleLinkedList)pOther).length;
    }

    @Override
    public SMGObject join(SMGObject pOther) {
        if (!pOther.isAbstract()) {
            return new SMGSingleLinkedList(this);
        }
        if (this.matchSpecificShape((SMGAbstractObject)((Object)pOther))) {
            SMGSingleLinkedList otherSll = (SMGSingleLinkedList)pOther;
            if (this.getLength() < otherSll.getLength()) {
                return new SMGSingleLinkedList(this);
            }
            return new SMGSingleLinkedList(otherSll);
        }
        throw new UnsupportedOperationException("join() called on incompatible abstract objects");
    }
}

