/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.objects.sll;

import java.util.Set;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.objects.sll.SMGSingleLinkedList;

public class SMGSingleLinkedListCandidate
implements SMGAbstractionCandidate {
    private final SMGObject start;
    private final int offset;
    private int length;

    public SMGSingleLinkedListCandidate(SMGObject pStart, int pOffset, int pLength) {
        this.start = pStart;
        this.offset = pOffset;
        this.length = pLength;
    }

    @Override
    public int getScore() {
        return 0;
    }

    @Override
    public CLangSMG execute(CLangSMG pSMG) {
        CLangSMG newSMG = new CLangSMG(pSMG);
        SMGSingleLinkedList sll = new SMGSingleLinkedList((SMGRegion)this.start, this.offset, this.length);
        newSMG.addHeapObject(sll);
        for (SMGEdgePointsTo pt : newSMG.getPTEdges().values()) {
            if (!pt.getObject().equals(this.start)) continue;
            SMGEdgePointsTo newPt = new SMGEdgePointsTo(pt.getValue(), sll, pt.getOffset());
            newSMG.removePointsToEdge(pt.getValue());
            newSMG.addPointsToEdge(newPt);
        }
        SMGObject node = this.start;
        Integer value = null;
        SMGEdgeHasValue edgeToFollow = null;
        for (int i = 0; i < this.length; ++i) {
            if (value != null) {
                newSMG.removeValue(value);
                newSMG.removePointsToEdge(value);
            }
            Set<SMGEdgeHasValue> outboundEdges = newSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(node).filterAtOffset(this.offset));
            edgeToFollow = null;
            for (SMGEdgeHasValue outbound : outboundEdges) {
                CType fieldType = outbound.getType();
                if (!(fieldType instanceof CPointerType)) continue;
                edgeToFollow = outbound;
                break;
            }
            if (edgeToFollow == null) {
                edgeToFollow = new SMGEdgeHasValue(CPointerType.POINTER_TO_VOID, this.offset, node, newSMG.getNullValue());
            }
            value = edgeToFollow.getValue();
            newSMG.removeHeapObjectAndEdges(node);
            node = newSMG.getPointer(value).getObject();
        }
        SMGEdgeHasValue newOutbound = new SMGEdgeHasValue(edgeToFollow.getType(), this.offset, (SMGObject)sll, (int)value);
        newSMG.addHasValueEdge(newOutbound);
        return newSMG;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void addLength(int pLength) {
        this.length += pLength;
    }

    public boolean isCompatibleWith(SMGSingleLinkedListCandidate pOther) {
        return this.offset == pOther.offset && this.start.getSize() == pOther.start.getSize();
    }

    public SMGObject getStart() {
        return this.start;
    }

    public String toString() {
        return "SLL CANDIDATE(start=" + this.start + ", offset=" + this.offset + ", length=" + this.length + ")";
    }
}

